//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//  2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	avifile.h
//  avi file reader and writer
//---------------------------------------------------------------------------

#ifndef _AVIFILE_H
#define _AVIFILE_H

#include "avfile.h"
#include <windows.h>
#include <mmsystem.h>
#include <vfw.h>

class TAVIFile: public TAVFile {
private:
 	unsigned int ScanLineWidth, AlignedScanLineWidth;

  PAVIFILE AVIFile;
  PAVISTREAM VideoStream, CompressedVideoStream, AudioStream;

  BITMAPINFOHEADER bmp;
  PGETFRAME pget;
  AVIFILEINFO ai;

  HACMSTREAM has;
  ACMSTREAMHEADER ash;
  DWORD ainbs, aoutbs;
  DWORD ascale;
  AVISTREAMINFO AudioStreamInfo;
  BYTE *FrameBuffer;

  void GetCompressorAlign(DWORD fccHandler, int &x, int &y);
protected:
	void OpenA(const char *FileName, int Mode, int Type, bool ThrowExceptions);
  BYTE* GetFrameA();
  void GetFrameA2(BYTE *Buffer);
  BITMAPINFO* DIBGetFrameA();
public:
 	TAVIFile();
  ~TAVIFile();

  void Close();
  void Seek(unsigned int Frame);

  void PutFrame(BYTE *Buffer);
  unsigned int GetVideoLength();

  BYTE* GetAudio(unsigned int &Size);
  void PutAudio(BYTE *Buffer, unsigned int Size);
  unsigned int GetAudioLength();
};
#endif

