/*****************************************************************************/
/*                       Image processing functions                          */
/*  Source file : color conversion functions                                 */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/
#ifndef _GaussColor_H_
#define _GaussColor_H_

#include <list.h>
#include "Image.h"
#include "background.h"

struct s_ColorRGB
{
   unsigned char r,g,b;
};

typedef std::list<s_ColorRGB> t_ColorRGBList;

//------------------------------------------------------------------------------
// CLASS GAUSSIAN COLOR
//------------------------------------------------------------------------------
class c_ColorDetect
{
   TBackground *Background;
   long Count;
   public:
   double avg1;                 // stredni hodnota slozka 1
   double avg2;                 // stredni hodnota slozka 2
   double kov11,kov12,kov21,kov22;      // prvky kovariancni matice
   double inv11,inv12,inv21,inv22;      // prvky inverzni matice
   double det;                          // determinant
   t_ColorRGBList ColorRGBList;
   // functions
   c_ColorDetect() {
     ColorRGBList.clear();
     Background = NULL;
   };
   ~c_ColorDetect() { delete Background; };
   void InitBackground(ImageStruct *Input);
   int SaveColors(char *FileName);
   int LoadColors(char *FileName);
   int SkinDetect(ImageStruct *Input,ImageStruct *Output, double Tres);
   int SkinBackDetect(ImageStruct *Input,ImageStruct *Output, double Tres);
   void AddColor(unsigned char r,unsigned char g,unsigned char b);
   void ConverColor(unsigned char r,unsigned char g,unsigned char b, int &c1, int &c2);
   void ConvertColor(unsigned char r,unsigned char g,unsigned char b, float &c1, float &c2);
   double IsSkin(unsigned char r,unsigned char g,unsigned char b);
   void Compute();
   void ClearList() { ColorRGBList.clear();  }
   int GetSize() { ColorRGBList.size(); }
};

//------------------------------------------------------------------------------
// CLASS COLOR HISTROGRAM
//------------------------------------------------------------------------------
class c_ColorHistogram
{
   public:
   int XSize, YSize;                    // size of histogram
   float *Histogram;                    // pointer to the histogram
   int   *Map;
   long Count;                          // number of colors in histogram
   int ProminentColor;
   // constructor & destructor
   c_ColorHistogram()  { Histogram=NULL; Map=NULL; Count=0; }
   ~c_ColorHistogram() {
     if (Histogram!=NULL) delete [] Histogram;
     if (Map!=NULL) delete [] Map;
   }
   // functions
   void InitHistogram(int XAxis, int YAxis);
   bool AddColor(unsigned char r,unsigned char g,unsigned char b);
   void SetMapPoint(int a, int b);
   bool IsMapSkin(unsigned char r,unsigned char g,unsigned char b);
#ifdef DIGILIB
   long Drawhistogram(ImageStruct *Image);
   void SkinDetection(ImageStruct *Input, ImageStruct *Output);
#endif
};


class c_ColorDetectRG:public c_ColorDetect
{
   void ConverColor(unsigned char r,unsigned char g,unsigned char b, int &c1, int &c2);
};

class nc_ColorDetectHSV:public c_ColorDetect
{
   void ConverColor(unsigned char r,unsigned char g,unsigned char b, int &c1, int &c2);
};

#endif
