/*****************************************************************************/
/*                       Image processing functions                          */
/*  Source file : hough transform for ellipse detection                      */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/
#include "Image.h"
#include <mem>

class pdCircleDetect
{
   public:
   int *Array;
   int r;                       // radius
   float Ratio;                 // ellipsoid ratio
   int XSize, YSize;            // Size of the hough space and also image size
   float XRatio, YRatio;        // size ratio of height and width image and hough space
   int out;                     // surroundings to erase
   pdCircleDetect()  { Array = NULL; }
   ~pdCircleDetect()
   {
      if (Array!=NULL)
        delete [] Array;
   }
   void Init(int xsize, int ysize, int Width, int Height, int Radius, float ratio);
   void AddPoint(int x, int y, int ax, int ay);
   int FindMax(int &x, int &y);
   void ArrayBlur();
   #ifdef DIGILIB
   // function give the weight of the skin probability into the array
   void AddPointSkin(int x, int y, int ax, int ay, ImageStruct *Skin);
   void ProcessImageSkin(ImageStruct *Image, ImageStruct *Skin);
   void ProcessImage(ImageStruct *Image);
   long DrawArray(ImageStruct *Image);
   void DrawEllipse(ImageStruct *Image, int x0, int y0, float ratio);
   float FindRatio(ImageStruct *Image, float minRatio, float maxRatio);
   #endif
};

class SkinHeadDetect
{
   public:
   int *Array;
   float Ratio;                 // ellipsoid ratio
   int XSize, YSize;            // Size of the hough space and also image size
   float XRatio, YRatio;        // size ratio of height and width image and hough space
   int out;                     // surroundings to erase
   int MinRadius, Step, Radiuses;
   SkinHeadDetect()  { Array = NULL; }
   ~SkinHeadDetect()
   {
      if (Array!=NULL)
        delete [] Array;
   }
   void Init(int xsize, int ysize, int Width, int Height, int MinR, int RStep, int NrSteps, float ratio);
   int FindMax(int &x, int &y, int &r);
   #ifdef DIGILIB
   // function give the weight of the skin probability into the array
   void AddPoint(int x, int y, int ax, int ay, ImageStruct *Skin);
   void ProcessImage(ImageStruct *Image, ImageStruct *Skin);
   long DrawArray(ImageStruct *Image);
   void DrawEllipse(ImageStruct *Image, int x0, int y0, float ratio);
   #endif
};

