/*****************************************************************************/
/*                       Image processing functions                          */
/*  Source file : color conversion and histogram functions                   */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/
#include <list>
#ifdef DIGILIB
  #include "Image.h"
#endif

// limitiation of colors in HSV model

// define minimal value of saturation part -> hardly defined color
extern const int MIN_SATURATION;
// define minimal value of intensity part -> dark hardly defined colors
extern const int MIN_VALUE;

// count of bins in histogram for each part - altogether BINS_COUNT x BINS_COUNT
extern const int BINS_COUNT;

struct s_ColorHSV
{
   int a,b,c;
};

struct s_ColorBGR
{
   int r,g,b;
};

// conversion from RGB color space to HSV
void rgb_to_hsv(s_ColorBGR *rgb, s_ColorHSV &hsv);

// conversion from RGB color space to rg
void rgb_to_rg(struct s_ColorBGR *rgb, struct s_ColorHSV &rg);

//------------------------------------------------------------------------------
// CLASS for creating histogram from given area
//------------------------------------------------------------------------------
class c_ColorDetectHSV
{
   public:
   int XSize, YSize;                    // size of histogram
   float *Histogram;                    // pointer to the histogram
   int   *Map;
   long Count;                          // number of colors in histogram
   int ProminentColor;
   // constructor & destructor
   c_ColorDetectHSV()  { Histogram=NULL; Map=NULL; Count=0; }
   ~c_ColorDetectHSV() {
     if (Histogram!=NULL) delete [] Histogram;
     if (Map!=NULL) delete [] Map;     
   }
   // functions
   void InitHistogram(int XAxis, int YAxis);
   bool AddColor(unsigned char r,unsigned char g,unsigned char b);
   void AddIntoMap(int a, int b);
   bool IsSkin(unsigned char r,unsigned char g,unsigned char b);
   bool IsMapSkin(unsigned char r,unsigned char g,unsigned char b); 
   float GetHistogramValue(int a, int b);
   int FindProminentColor();
#ifdef DIGILIB
   long Drawhistogram(ImageStruct *Image);
   void MapSkinDetection(ImageStruct *Input, ImageStruct *Output);
   void SkinDetection(ImageStruct *Input, ImageStruct *Output);
#endif
};


//------------------------------------------------------------------------------
// CLASS for filtering of given data
//------------------------------------------------------------------------------

class c_Smoothing
{  // store last n values for smoothing
   int Size;
   int Actual;
   float Arr[100];
   public:
   ~c_Smoothing()
   {
      Size=0;
   }
   void Init(int Nr, float Value);
   float Compute(float Value);
   float Get();
};

