#pragma hdrstop

#include <math.h>
#include <stdlib.h>
#include "background.h"
//#include "Tools.h"

TBackground::TBackground(int w, int h, int s)
{  // scale 1/4 -> s = 4
  width = w;
  height = h;
  scale = s;
  // Alloc images
  modelR = NewImage32(w/s, h/s);
  modelG = NewImage32(w/s, h/s);
  modelB = NewImage32(w/s, h/s);
  bg_time = NewImage32(w/s, h/s);
  bg = NewImage8(w/s, h/s);

  // Clear imgs
  for (int y = 0; y < bg->YSize; y++)
  for (int x = 0; x < bg->XSize; x++)
  {
    Image32LinearPixel(modelR, x, y) = 0;
    Image32LinearPixel(modelG, x, y) = 0;
    Image32LinearPixel(modelB, x, y) = 0;
    Image32LinearPixel(bg_time, x, y) = 0;
    Image8LinearPixel(bg, x, y) = 0;
  }

   backgroundTreshold = 80;
}

void TBackground::operator()(ImageStruct * img)
{
  // Check image dimensions
  if (img->XSize != width) return;
  if (img->YSize != height) return;

  for (int y = 0; y < img->YSize; y+=scale)
    for (int x = 0; x < img->XSize; x+=scale)
    {
      int m = x / scale;
      int n = y / scale;
      if (Image8LinearPixel(bg, m, n) == 0)
      {
        Image32LinearPixel(modelR, m, n) += ImageRGBLinearPixelR(img, x, y);
        Image32LinearPixel(modelG, m, n) += ImageRGBLinearPixelG(img, x, y);
        Image32LinearPixel(modelB, m, n) += ImageRGBLinearPixelB(img, x, y);
        Image32LinearPixel(bg_time, m, n)++;
      } // if
    } // for x
} // operator()

void TBackground::solveBackground(ImageStruct * img)
{
  for (int y = 0; y < img->YSize; y+=scale)
    for (int x = 0; x < img->XSize; x+=scale)
    {
      int m = x / scale;
      int n = y / scale;
      // Update pozadi
      int N = Image32LinearPixel(bg_time, m, n);
      if (N < 1) N = 1;
      if (N > 2)
      {
        int r = abs((Image32LinearPixel(modelR, m, n) / N) - ImageRGBLinearPixelR(img, x, y));
        int g = abs((Image32LinearPixel(modelG, m, n) / N) - ImageRGBLinearPixelG(img, x, y));
        int b = abs((Image32LinearPixel(modelB, m, n) / N) - ImageRGBLinearPixelB(img, x, y));
        SetImage8LinearPixel(bg, m, n, ((r+g+b)<backgroundTreshold) ? 0 : 255);
      }
      else
        SetImage8LinearPixel(bg, m, n, 0);
    } // for x
}

// x, y dotaz na pozadi v originalnich souradnicich!!!
int TBackground::isBackground(int x, int y)
{
  return Image8LinearPixel(bg, x/scale, y/scale);
}

#pragma package(smart_init)
