/*****************************************************************************/
/*                       Function for Image processing                       */
/*  Source file : MyImageFun.cpp                                             */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/
#include "../../DigiLib/Image.h"

#include <math.h>
#include <list>

void ResizeImageRGB(ImageStruct** Image, int XSize, int YSize)
{
   if (*Image!=NULL)
      DeleteImage(*Image);
   *Image = NULL;
   *Image=NewImageRGB(XSize,YSize);
}

void ResizeImageFloat(ImageStruct** Image, int XSize, int YSize)
{
   if (*Image!=NULL)
      DeleteImage(*Image);
   *Image = NULL;
   *Image=NewImageFloat(XSize,YSize);
}

void ResizeImage8(ImageStruct ** Image, int XSize, int YSize)
{
   if (*Image!=NULL)
      DeleteImage(*Image);
   *Image = NULL;
   *Image=NewImage8(XSize,YSize);
}

void DownSampleRGB(const ImageStruct *Input, ImageStruct *Output)
{ // twice smaller resolution
  int SXStep = ImageXOffset(Input);
  int DXStep = ImageXOffset(Output);
  for (int j=0; j<Output->YSize; j++)
  {
    unsigned char *Src1 = &ImageRGBPixelR(Input,0,j*2);
    unsigned char *Src2 = &ImageRGBPixelR(Input,0,j*2+1);
    unsigned char *Dst = &ImageRGBPixelR(Output,0,j);
    for (int i=0; i<Output->XSize; i++)
    {
        int r = *(Src1)+*(Src1+SXStep)+*(Src2)+*(Src2+SXStep);
        int g = *(Src1+1)+*(Src1+SXStep+1)+*(Src2+1)+*(Src2+SXStep+1);
        int b = *(Src1+2)+*(Src1+SXStep+2)+*(Src2+2)+*(Src2+SXStep+2);
        *Dst     = r/4;
        *(Dst+1) = g/4;
        *(Dst+2) = b/4;
        Dst+=DXStep;
        Src1+=2*SXStep;
        Src2+=2*SXStep;
    }
  }
}

void DownSample(const ImageStruct *Input, ImageStruct *Output)
{ // twice smaller resolution
  int SXStep = ImageXOffset(Input);
  int DXStep = ImageXOffset(Output);
  for (int j=0; j<Output->YSize; j++)
  {
    unsigned char *Src1 = &ImageRGBPixelR(Input,0,j*2);
    unsigned char *Src2 = &ImageRGBPixelR(Input,0,j*2+1);
    unsigned char *Dst = &ImageRGBPixelR(Output,0,j);
    for (int i=0; i<Output->XSize; i++)
    {
        int c = *(Src1)+*(Src1+SXStep)+*(Src2)+*(Src2+SXStep);
        *Dst  = c/4;
        Dst+=DXStep;
        Src1+=2*SXStep;
        Src2+=2*SXStep;
    }
  }
}

/////////////////////////// RGB Bilinear Interpolation /////////////////////////
void bilinear(const ImageStruct *Input, float X, float Y, int &r, int &g, int &b)
{ // pozor !! osetrit meze, protoze bereme i barvu 4 okolnich pixelu
  int divYY, divXX, divYX, divXY,x1,x2,y1,y2;
  if (X<1) X=1; if (Y<1) Y=1;
  if (Y>(int)ImageYSize(Input) - 2) Y=ImageYSize(Input) - 2;
  if (X>(int)ImageXSize(Input) - 2) X=ImageXSize(Input) - 2;

    int x=X*256;
    int y=Y*256;
    int centX=(((int)X)<<8)+(128);   // x + 0.5
    int centY=(((int)Y)<<8)+(128);   // y + 0.5
    x1=centX-(x-(128));
    x2=x+(128)-centX;
    y1=centY-(y-(128));
    y2=y+(128)-centY;
    divXX=x1*y1;
    divYY=x2*y2;
    divYX=x1*y2;
    divXY=x2*y1;

    r=(ImageRGBPixelR(Input,(int)(X),(int)(Y)))*divXX+(ImageRGBPixelR(Input,(int)(X+1),(int)(Y+1)))*divYY
    +(ImageRGBPixelR(Input,(int)(X+1),(int)(Y)))*divXY+(ImageRGBPixelR(Input,(int)(X),(int)(Y+1)))*divYX;
    g=(ImageRGBPixelG(Input,(int)(X),(int)(Y)))*divXX+(ImageRGBPixelG(Input,(int)(X+1),(int)(Y+1)))*divYY
    +(ImageRGBPixelG(Input,(int)(X+1),(int)(Y)))*divXY+(ImageRGBPixelG(Input,(int)(X),(int)(Y+1)))*divYX;
    b=(ImageRGBPixelB(Input,(int)(X),(int)(Y)))*divXX+(ImageRGBPixelB(Input,(int)(X+1),(int)(Y+1)))*divYY
    +(ImageRGBPixelB(Input,(int)(X+1),(int)(Y)))*divXY+(ImageRGBPixelB(Input,(int)(X),(int)(Y+1)))*divYX;
    r=r>>16; g=g>>16; b=b>>16;
}

/////////////////////////////// Bilinear Interpolation /////////////////////////
int bilinear8(const ImageStruct *Input, float X, float Y)
{ // pozor !! osetrit meze, protoze bereme i barvu 4 okolnich pixelu
  int divYY, divXX, divYX, divXY,x1,x2,y1,y2;
  if (X<1) X=1; if (Y<1) Y=1;
  if (Y>(int)ImageYSize(Input) - 2) Y=ImageYSize(Input) - 2;
  if (X>(int)ImageXSize(Input) - 2) X=ImageXSize(Input) - 2;

    int x=X*256;
    int y=Y*256;
    int centX=(((int)X)<<8)+(128);   // x + 0.5
    int centY=(((int)Y)<<8)+(128);   // y + 0.5
    x1=centX-(x-(128));
    x2=x+(128)-centX;
    y1=centY-(y-(128));
    y2=y+(128)-centY;
    divXX=x1*y1;
    divYY=x2*y2;
    divYX=x1*y2;
    divXY=x2*y1;

    int val=(ImageRGBPixelR(Input,(int)(X),(int)(Y)))*divXX+(ImageRGBPixelR(Input,(int)(X+1),(int)(Y+1)))*divYY
    +(ImageRGBPixelR(Input,(int)(X+1),(int)(Y)))*divXY+(ImageRGBPixelR(Input,(int)(X),(int)(Y+1)))*divYX;
    val=val>>16;
    return val;
}

////////////////////// GreyScale IMAGE /////////////////////////////////////////
void GreyScale(ImageStruct *Input, ImageStruct *Output)
{
  for (int i=0; i<Input->XSize; i++)
    for (int j=0; j<Input->YSize; j++)
    {
        unsigned char red=ImageRGBPixelR(Input,i,j);
        unsigned char blue=ImageRGBPixelB(Input,i,j);
        unsigned char green=ImageRGBPixelG(Input,i,j);
        unsigned char color=int(0.299*red+0.587*green+0.114*blue);
        SetImage8Pixel(Output,i,j,color);
    }
}

void GaussianMask(ImageStruct *Input, ImageStruct *Output)
{
  int         MASK[5][5];
  int         c ,r , I, J;
  float       SUM;
  /* 5x5 Gaussian mask.  Ref: http://www.cee.hw.ac.uk/hipr/html/gsmooth.html */
  MASK[0][0] = 2; MASK[0][1] =  4; MASK[0][2] =  5; MASK[0][3] =  4; MASK[0][4] = 2;
  MASK[1][0] = 4; MASK[1][1] =  9; MASK[1][2] = 12; MASK[1][3] =  9; MASK[1][4] = 4;
  MASK[2][0] = 5; MASK[2][1] = 12; MASK[2][2] = 15; MASK[2][3] = 12; MASK[2][4] = 5;
  MASK[3][0] = 4; MASK[3][1] =  9; MASK[3][2] = 12; MASK[3][3] =  9; MASK[3][4] = 4;
  MASK[4][0] = 2; MASK[4][1] =  4; MASK[4][2] =  5; MASK[4][3] =  4; MASK[4][4] = 2;

   /**********************************************
   *   GAUSSIAN MASK ALGORITHM STARTS HERE
   ***********************************************/

   for(r=0; r<Input->YSize; r++)  {
   for(c=0; c<Input->XSize; c++)  {
        SUM = 0;
         int MinI=0; if (c>=2) MinI=-2; if (c==1) MinI=-1;
         int MaxI=0; if (c<=Input->XSize-3) MaxI=2; if (c==Input->XSize-2) MaxI=1;
         int MinJ=0; if (r>=2) MinJ=-2; if (r==1) MinJ=-1;
         int MaxJ=0; if (r<=Input->YSize-3) MaxJ=2; if (r==Input->YSize-2) MaxJ=1;
         float Div = 0;
         for(I=MinI; I<=MaxI; I++)
           for(J=MinJ; J<=MaxJ; J++)
           {
            SUM = SUM + (int)( Image8Pixel(Input,c+I,r+J)*MASK[I+2][J+2]);
            Div+=MASK[I+2][J+2];
           }
         SUM=SUM/Div;
        if(SUM>255)  SUM=255;
        if(SUM<0)    SUM=0;
        SetImage8Pixel(Output,c,r,(unsigned char)(SUM));
   }
   }
}

//////////////////////// Sobel Edge Detection //////////////////////////////////
int Sobel(ImageStruct *Inp, ImageStruct *Outp)
{
   int         GX[3][3];
   int         GY[3][3];
   int         I, J;
   long         sumX, sumY;
   int         SUM;
   /* 3x3 GX Sobel mask.  Ref: www.cee.hw.ac.uk/hipr/html/sobel.html */
   GX[0][0] = -1; GX[0][1] = 0; GX[0][2] = 1;
   GX[1][0] = -2; GX[1][1] = 0; GX[1][2] = 2;
   GX[2][0] = -1; GX[2][1] = 0; GX[2][2] = 1;

   /* 3x3 GY Sobel mask.  Ref: www.cee.hw.ac.uk/hipr/html/sobel.html */
   GY[0][0] =  1; GY[0][1] =  2; GY[0][2] =  1;
   GY[1][0] =  0; GY[1][1] =  0; GY[1][2] =  0;
   GY[2][0] = -1; GY[2][1] = -2; GY[2][2] = -1;

   for(int Y=0; Y<Inp->YSize; Y++)  {
   for(int X=0; X<Inp->XSize; X++)  {
        sumX = 0;
        sumY = 0;

             /* image boundaries */
        if(Y==0 || Y==Inp->YSize-1)
        SUM = 0;
        else if(X==0 || X==Inp->XSize-1)
        SUM = 0;

        /* Convolution starts here */
        else   {

          /*-------X GRADIENT APPROXIMATION------*/
          for(I=-1; I<=1; I++)  {
         for(J=-1; J<=1; J++)  {
            sumX = sumX + (int)( Image8Pixel(Inp,X+I,Y+J) * GX[I+1][J+1]);
         }
          }
          /*-------Y GRADIENT APPROXIMATION-------*/
          for(I=-1; I<=1; I++)  {
         for(J=-1; J<=1; J++)  {
             sumY = sumY + (int)( Image8Pixel(Inp,X+I,Y+J) * GY[I+1][J+1]);
         }
          }
          SUM = abs(sumX) + abs(sumY);
             }
             // SetImage8Pixel(Outp,X,Y,255 - (unsigned char)(SUM));  /* make edges black and background white */
             SetImage8Pixel(Outp,X,Y,(unsigned char)(SUM));
   }
   }
   return 0;
}


