//---------------------------------------------------------------------------
//	AVFile - library for reading audio and video files
//  2002 - 2004 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	dsfile.h
//  DV Camera input
//---------------------------------------------------------------------------

#ifndef _VCFILE_H
#define _VCFILE_H

#include <atl/atlbase.h>
#include <strmif.h>
#include <qedit.h>

#include "avfile.h"

//---------------------------------------------------------------------------
class TVCFile: public TAVFile {
private:
  bool CoInitialized;

  unsigned int ScanLineWidth, AlignedScanLineWidth, BitmapDataSize;
  unsigned int Length, FrameInBuffer;
  DWORD g_dwGraphRegister;

  BITMAPINFO *Bitmap;
  unsigned char *BitmapData, *FrameBuffer, *FrameBufferLastLine;

  CComPtr<IGraphBuilder> pGraph;
  CComPtr<ICaptureGraphBuilder2> pCaptureGraph;
  CComPtr<ISampleGrabber> pGrabber;

  HRESULT GetPin(IBaseFilter *pFilter, PIN_DIRECTION dirrequired, int iNum, IPin **ppPin);
  IPin* GetInPin(IBaseFilter *pFilter, int Num);
  IPin* GetOutPin(IBaseFilter *pFilter, int Num);

  HRESULT AddGraphToRot(IUnknown *pUnkGraph, DWORD *pdwRegister);
  void RemoveGraphFromRot(DWORD pdwRegister);
public:
  TVCFile();
  ~TVCFile();

  void Open(const char *FileName, int Mode, int Type = otVideo);
  void Close();

  TFrame* GetFrame();
  unsigned int GetVideoLength();

  BITMAPINFO* DIBGetFrame();
};
#endif

