//---------------------------------------------------------------------------
//	AVFile - library for reading audio and video files
//  2002 - 2004 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	dvfile.cpp
//  DV Camera input 
//
//  10.2.2004 - first release
//---------------------------------------------------------------------------

#pragma option -VF -VM

#define _MSC_VER 800
#define _USE_OLD_RW_STL

#include <dshow.h>
#undef _X86_
#include <streams.h>
#include <stdio.h>

#include <initguid.h>
#include <uuids.h>

#include <mtype.cpp>
#include <wxutil.cpp>

#include "vcfile.h"

//---------------------------------------------------------------------------
const GUID CLSID_SampleGrabber = {0xC1F400A0, 0x3F08, 0x11D3,{ 0x9F, 0x0B, 0x00,0x60, 0x08, 0x03,0x9E, 0x37}};
const GUID IID_ISampleGrabber = {0x6B652FFF, 0x11FE, 0x4FCE,{ 0x92, 0xAD, 0x02,0x66, 0xB5, 0xD7,0xC7, 0x8F}};
const GUID IID_ISampleGrabberCB = {0x0579154A, 0x2B53, 0x4994,{ 0xB0, 0xD0, 0xE7,0x73, 0x14, 0x8E,0xFF, 0x85}};
const GUID CLSID_NullRenderer = {0xC1F400A4, 0x3F08, 0x11D3,{ 0x9F, 0x0B, 0x00,0x60, 0x08, 0x03,0x9E, 0x37}};

//---------------------------------------------------------------------------
HRESULT TVCFile::GetPin(IBaseFilter *pFilter, PIN_DIRECTION dirrequired, int iNum, IPin **ppPin) {
  CComPtr< IEnumPins > pEnum;
  *ppPin = NULL;

  HRESULT hr = pFilter->EnumPins(&pEnum);
  if(FAILED(hr))
      return hr;

  ULONG ulFound;
  IPin *pPin;
  hr = E_FAIL;

  while(S_OK == pEnum->Next(1, &pPin, &ulFound)) {
      PIN_DIRECTION pindir = (PIN_DIRECTION)3;

      pPin->QueryDirection(&pindir);
      if(pindir == dirrequired) {
          if(iNum == 0) {
              *ppPin = pPin;  // Return the pin's interface
              hr = S_OK;      // Found requested pin, so clear error
              break;
          }
          iNum--;
      }

      pPin->Release();
  }
  return hr;
}

//---------------------------------------------------------------------------
IPin* TVCFile::GetInPin(IBaseFilter *pFilter, int nPin) {
  CComPtr<IPin> pComPin=0;
  GetPin(pFilter, PINDIR_INPUT, nPin, &pComPin);
  return pComPin;
}

//---------------------------------------------------------------------------
IPin* TVCFile::GetOutPin(IBaseFilter *pFilter, int nPin) {
  CComPtr<IPin> pComPin=0;
  GetPin(pFilter, PINDIR_OUTPUT, nPin, &pComPin);
  return pComPin;
}

//---------------------------------------------------------------------------
HRESULT TVCFile::AddGraphToRot(IUnknown *pUnkGraph, DWORD *pdwRegister) {
  IMoniker * pMoniker;
  IRunningObjectTable *pROT;
  WCHAR wsz[128];
  HRESULT hr;

  if (!pUnkGraph || !pdwRegister)
    return E_POINTER;

  if (FAILED(GetRunningObjectTable(0, &pROT)))
    return E_FAIL;

  wsprintfW(wsz, L"FilterGraph %08x pid %08x\0", (DWORD_PTR)pUnkGraph,
            GetCurrentProcessId());

  hr = CreateItemMoniker(L"!", wsz, &pMoniker);
  if (SUCCEEDED(hr)) {
    // Use the ROTFLAGS_REGISTRATIONKEEPSALIVE to ensure a strong reference
    // to the object.  Using this flag will cause the object to remain
    // registered until it is explicitly revoked with the Revoke() method.
    //
    // Not using this flag means that if GraphEdit remotely connects
    // to this graph and then GraphEdit exits, this object registration
    // will be deleted, causing future attempts by GraphEdit to fail until
    // this application is restarted or until the graph is registered again.
    hr = pROT->Register(ROTFLAGS_REGISTRATIONKEEPSALIVE, pUnkGraph,
                        pMoniker, pdwRegister);
    pMoniker->Release();
  }

  pROT->Release();
  return hr;
}

//---------------------------------------------------------------------------
void TVCFile::RemoveGraphFromRot(DWORD pdwRegister) {
  IRunningObjectTable *pROT;

  if (SUCCEEDED(GetRunningObjectTable(0, &pROT))) {
    pROT->Revoke(pdwRegister);
    pROT->Release();
  }
}

//---------------------------------------------------------------------------
TVCFile::TVCFile() {
  CoInitialized = false;
  Bitmap = NULL;
  FrameBuffer = NULL;
  g_dwGraphRegister = 0;
}

//---------------------------------------------------------------------------
TVCFile::~TVCFile() {
  Close();
}

//---------------------------------------------------------------------------
void TVCFile::Open(const char *FileName, int Mode, int Type) {
  USES_CONVERSION;
	Close();

  if (Mode == omRead) {
    if (Type&otVideo) {
      HRESULT hr;

      if (!CoInitialized)
        if (FAILED(CoInitializeEx(NULL, COINIT_APARTMENTTHREADED))) {
          Close();
          throw AVFileErrorOpenVideo("Could not CoInitializeEx!");
        }
      CoInitialized = true;

      // Create the System Device Enumerator.
      ICreateDevEnum *pDevEnum = NULL;
      hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, (void**)(&pDevEnum));
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not create System Device Enumerator!");
      }

      // Create an enumerator for the video capture category.
      IEnumMoniker *pEnum = NULL;
      hr = pDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pEnum, 0);
      if (pEnum == NULL) {
        pDevEnum->Release();
        Close();
        throw AVFileErrorOpenVideo("Could not create an enumerator for the video capture category!");
      }

      CComPtr<IBaseFilter> pDVCapture;

      IMoniker *pMoniker = NULL;
      while (pEnum->Next(1, &pMoniker, NULL) == S_OK) {
        IPropertyBag *pPropBag = NULL;
        hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, (void**)(&pPropBag));
        if (FAILED(hr)) {
            pMoniker->Release();
            continue;  // Skip this one, maybe the next one will work.
        }

        hr = pMoniker->BindToObject(0, 0, IID_IBaseFilter, (void**)&pDVCapture);
        if (SUCCEEDED(hr))
          break;

        pPropBag->Release();
        pMoniker->Release();
      }

      pEnum->Release();
      pDevEnum->Release();

      if (!pDVCapture) {
        Close();
        throw AVFileErrorOpenVideo("Could not find DV device!");
      }

      pGrabber.CoCreateInstance(CLSID_SampleGrabber);
      if (!pGrabber) {
        Close();
        throw AVFileErrorOpenVideo("Could not create the file semple grabber!");
      }
      CComQIPtr<IBaseFilter, &IID_IBaseFilter> pGrabberBase(pGrabber);

      pGraph.CoCreateInstance(CLSID_FilterGraph);
      if (!pGraph) {
        Close();
        throw AVFileErrorOpenVideo("Could not create the graph!");
      }

      pCaptureGraph.CoCreateInstance(CLSID_CaptureGraphBuilder2);
      if (!pCaptureGraph) {
        Close();
        throw AVFileErrorOpenVideo("Could not create the capture graph!");
      }

      pCaptureGraph->SetFiltergraph(pGraph);


      g_dwGraphRegister = 0;
      AddGraphToRot(pGraph, &g_dwGraphRegister);

      hr = pGraph->AddFilter(pDVCapture, L"Source");
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not add filter!");
      }

      hr = pGraph->AddFilter(pGrabberBase, L"Grabber");
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not add filter!");
      }

#if 1
      IAMStreamConfig *pConfig = NULL;
      hr = pCaptureGraph->FindInterface(
    &PIN_CATEGORY_CAPTURE, // Preview pin.
    0,    // Any media type.
    pDVCapture, // Pointer to the capture filter.
    IID_IAMStreamConfig, (void**)&pConfig);
    if (SUCCEEDED(hr)) {

      int iCount = 0, iSize = 0;
      hr = pConfig->GetNumberOfCapabilities(&iCount, &iSize);

      // Check the size to make sure we pass in the correct structure.
      if (iSize == sizeof(VIDEO_STREAM_CONFIG_CAPS))
      {
        // Use the video capabilities structure.

        for (int iFormat = 0; iFormat < iCount; iFormat++)
        {
            VIDEO_STREAM_CONFIG_CAPS scc;
            AM_MEDIA_TYPE *pmtConfig;
            hr = pConfig->GetStreamCaps(iFormat, &pmtConfig, (BYTE*)&scc);
            if (SUCCEEDED(hr))
            {
                if ((pmtConfig->majortype == MEDIATYPE_Video) &&
                    (pmtConfig->subtype == MEDIASUBTYPE_RGB24) &&
                    (pmtConfig->formattype == FORMAT_VideoInfo) &&
                    (pmtConfig->cbFormat >= sizeof (VIDEOINFOHEADER)) &&
                    (pmtConfig->pbFormat != NULL)) {

                  VIDEOINFOHEADER *pVih = (VIDEOINFOHEADER*)pmtConfig->pbFormat;
                  pVih->bmiHeader.biWidth = 640;
                  pVih->bmiHeader.biHeight = 480;
                  pVih->bmiHeader.biSizeImage = DIBSIZE(pVih->bmiHeader);
//                  hr = pConfig->SetFormat(pmtConfig);
                  DeleteMediaType(pmtConfig);
                  break;
                }



                /* Examine the format, and possibly use it. */

                // Delete the media type when you are done.
                DeleteMediaType(pmtConfig);
            }
        }
      }



      pConfig->Release();

    }
#endif





      // Tell the grabber to grab 24-bit video. Must do this
      // before connecting it
      //
      CMediaType GrabType;
      GrabType.SetType(&MEDIATYPE_Video);
      GrabType.SetSubtype(&MEDIASUBTYPE_RGB24);
      hr = pGrabber->SetMediaType(&GrabType);
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not set media type!");
      }

      // Get the output pin and the input pin
      //
      CComPtr<IPin> pSourcePin = GetOutPin(pDVCapture, 0);
      CComPtr<IPin> pGrabPin = GetInPin( pGrabberBase, 0);

      // ... and connect them
      //
      hr = pGraph->Connect( pSourcePin, pGrabPin );
      if (FAILED(hr )) {
        Close();
        throw AVFileErrorOpenVideo("Could not connect source filter to grabber!");
      }

      AM_MEDIA_TYPE mt;
      hr = pGrabber->GetConnectedMediaType(&mt);
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not get media type!");
      }

      VIDEOINFOHEADER *vih = (VIDEOINFOHEADER*)mt.pbFormat;

      VideoInfo.Width = vih->bmiHeader.biWidth;
      VideoInfo.Height = vih->bmiHeader.biHeight;
      VideoInfo.FrameRate.Rate = 25;
      VideoInfo.FrameRate.Scale = 1;

      ScanLineWidth = VideoInfo.Width * 3;
      AlignedScanLineWidth = DIB_SCAN_LINE(ScanLineWidth);

      BitmapDataSize = VideoInfo.Height * AlignedScanLineWidth;
      Bitmap = (BITMAPINFO*)GlobalAlloc(GMEM_FIXED, sizeof(BITMAPINFOHEADER) + BitmapDataSize);
      BitmapData = (unsigned char *)Bitmap + sizeof(BITMAPINFOHEADER);

      FrameBuffer = new unsigned char[ScanLineWidth * VideoInfo.Height];
      FrameBufferLastLine = FrameBuffer + (VideoInfo.Height - 1) * ScanLineWidth;

      Bitmap->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
      Bitmap->bmiHeader.biWidth = VideoInfo.Width;
      Bitmap->bmiHeader.biHeight = VideoInfo.Height;

      Bitmap->bmiHeader.biPlanes = 1;
      Bitmap->bmiHeader.biBitCount = 24;
      Bitmap->bmiHeader.biCompression = BI_RGB;
      Bitmap->bmiHeader.biSizeImage = BitmapDataSize;
      Bitmap->bmiHeader.biXPelsPerMeter = 0;
      Bitmap->bmiHeader.biYPelsPerMeter = 0;
      Bitmap->bmiHeader.biClrUsed = 0;
      Bitmap->bmiHeader.biClrImportant = 0;

      FreeMediaType(mt);

      // Render the grabber output pin (to a video renderer)
      //
      CComPtr <IPin> pGrabOutPin = GetOutPin(pGrabberBase, 0);

      CComPtr<IBaseFilter> pNullRenderer;
      pNullRenderer.CoCreateInstance(CLSID_NullRenderer);
      hr = pGraph->AddFilter(pNullRenderer, L"NullRenderer");
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not add filter!");
      }

      CComPtr< IPin > pRendererInPin;
      pRendererInPin = GetInPin(pNullRenderer, 0);

      hr = pGraph->Connect(pGrabOutPin, pRendererInPin);
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not connect null renderer!");
      }

      hr = pGrabber->SetBufferSamples(TRUE);
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not setup grabber!");
      }
      hr = pGrabber->SetOneShot(FALSE);
      if (FAILED(hr)) {
        Close();
        throw AVFileErrorOpenVideo("Could not setup grabber!");
      }

      IAMCrossbar *pXBar1 = NULL;
      hr = pCaptureGraph->FindInterface(&LOOK_UPSTREAM_ONLY, NULL, pDVCapture, IID_IAMCrossbar, (void**)&pXBar1);
      if (SUCCEEDED(hr))
      {
        long cOutput = -1, cInput = -1;
        hr = pXBar1->get_PinCounts(&cOutput, &cInput);

        long OutPin;
        for (OutPin = 0; OutPin < cOutput; OutPin++) {
          long lRelated = -1, lType = -1, lRouted = -1;
          hr = pXBar1->get_CrossbarPinInfo(FALSE, OutPin, &lRelated, &lType);
          if (lType == PhysConn_Video_VideoDecoder)
            break;
        }

        long InPin;
        for (InPin = 0; InPin < cInput; InPin++) {
          long lRelated = -1, lType = -1;
          hr = pXBar1->get_CrossbarPinInfo(TRUE, InPin, &lRelated, &lType);
//          if (lType == PhysConn_Video_Composite)
          if (lType == PhysConn_Video_Tuner)
            break;
        }

        if (OutPin < cOutput && InPin < cInput)
          hr = pXBar1->Route(OutPin, InPin);


      /*
          int xxx = pXBar1->AddRef();
          xxx = pXBar1->Release();
      */
      /*
          // Found one crossbar. Get its IBaseFilter interface.
          IBaseFilter *pFilter = NULL;
          hr = pXBar1->QueryInterface(IID_IBaseFilter, (void**)&pFilter);
          if (SUCCEEDED(hr))
          {
            pFilter->Release();
          }
          */
          pXBar1->Release();
      }

      pCaptureGraph->RenderStream(&PIN_CATEGORY_PREVIEW, &MEDIATYPE_Video, pDVCapture, NULL, NULL);

      CComQIPtr<IMediaControl, &IID_IMediaControl> pControl(pGraph);
      hr = pControl->Run();
      if (hr == S_FALSE) {
        OAFilterState State;
        pControl->GetState(INFINITE, &State);
      }

      Length = 1;
      FrameInBuffer = 0;
      VideoPos = 0;
      OpenMode = Mode;
      OpenType |= otVideo;
    }
	} else if (Mode == omWrite) {
    throw AVFileErrorOpen("Not implemented!");
  } else
  	throw AVFileErrorOpenInvalidMode("Invalid open mode!");
}

//---------------------------------------------------------------------------
void TVCFile::Close() {
  OpenMode = omClosed;
  OpenType = otNone;

  if (pCaptureGraph)
    pCaptureGraph.Release();

  if (pGraph) {
    if (g_dwGraphRegister != 0)
    	RemoveGraphFromRot(g_dwGraphRegister);
    pGraph.Release();
  }

  if (pGrabber)
    pGrabber.Release();

  if (CoInitialized) {
    CoUninitialize();
    CoInitialized = false;
  }

  if (Bitmap != NULL) {
    GlobalFree(HGLOBAL(Bitmap));
    Bitmap = NULL;
  }

  if (FrameBuffer != NULL) {
  	delete[] FrameBuffer;
    FrameBuffer = NULL;
  }
}

//---------------------------------------------------------------------------
unsigned int TVCFile::GetVideoLength() {
  CheckOpened();
  CheckVideoStream();
  return Length;
}

//---------------------------------------------------------------------------
BITMAPINFO* TVCFile::DIBGetFrame() {
  CheckRead();
  CheckVideoStream();

  HRESULT hr;
  hr = pGrabber->GetCurrentBuffer((long*)&BitmapDataSize, (long*)BitmapData);
  if (FAILED(hr)) {
    throw AVFileErrorGetVideo("Could not get frame!");
  }
  VideoPos = 0;
  return Bitmap;
}

//---------------------------------------------------------------------------
TAVFile::TFrame* TVCFile::GetFrame() {
	BITMAPINFO *bmp = DIBGetFrame();

  unsigned char *s = (byte*)bmp + bmp->bmiHeader.biSize + bmp->bmiHeader.biClrUsed * sizeof(RGBQUAD);
  unsigned char *d = FrameBufferLastLine;

  for (int i = 0; i < VideoInfo.Height; i++) {
    memcpy(d, s, ScanLineWidth);
    d -= ScanLineWidth;
    s += AlignedScanLineWidth;
  }

  return FrameBuffer;
}

