/*****************************************************************************/
/*                            Tokens tracking                                */
/*  Header file : Tracking tokens in picture sequence                        */
/*  Designed by Igor Potucek                                                 */
/*  2002                                                                     */
/*  VUT Brno - Faculty of Information Technology                             */
/*****************************************************************************/

#include <math.h>
#include <deque.h>
#include <string.h>
#include <list.h>

#ifdef _WIN32
  #include <vcl.h>
  #include <stdio.h>
#endif
const float KOEF_SPEED=0.2;
const float KOEF_ACCEL=0.5;
const  int c_MIN_LENGTH=3;
using namespace std;
//typedef  std::basic_string<unsigned char> string;

struct s_Position
{  // structure for storage predicted position
   float x,y;
   bool operator==(const s_Position &Obj)
   {
      return ((Obj.x==x) && (Obj.y==y));
   }
};
class cClassifyGWN;
// list of predicted positions in tracked frames
typedef std::deque<s_Position> t_PositionList;

struct s_Object
{  // structure for storage information about object
   long Sum,MouthSum;
   int TemplateNr;
#ifdef _WIN32
   AnsiString Person;
   AnsiString Specific;
#else
  string Person;
  string Specific;
#endif
   s_Object *CorObject;         // correspondent object i.e. head, face
   int hands;
   bool hand, head; // left=true right=false
   double CentreX;
   double CentreY;
   float orientation;
   float axisA, axisB;
   double kov11, kov22, kov12, kov21;
   int MinX,MinY;
   int MaxX,MaxY;
   bool Eyes,Mouth,Face;
   int eye1x,eye2x,eye3x,eye4x,eye1y,eye2y,eye3y,eye4y;
   int face1x,face2x,face3x,face4x,face1y,face2y,face3y,face4y;
   int mouth1x,mouth2x,mouth3x,mouth4x,mouth1y,mouth2y,mouth3y,mouth4y;
   double AvgR,AvgB;
   t_PositionList PixelList;
   s_Object():Eyes(false),Mouth(false),Face(false), hand(false), head(false), hands(0), CorObject(NULL) {}
   bool operator==(const s_Object &Obj)
   {
      return ((Obj.CentreX==CentreX) && (Obj.CentreY==CentreY) && (Obj.Sum==Sum));
   }
   double GetPositionX()   {   return CentreX;  }
   double GetPositionY()   {   return CentreY;  }
   void PutPositionX(double Pos)   {   CentreX=Pos;  }
   void PutPositionY(double Pos)   {   CentreY=Pos;  }
};

// list of tracked tokens
typedef std::deque<s_Object> t_ObjectList;

// list of frames, which contains list of tokens
typedef std::deque<t_ObjectList> t_ObjectFrame;

// list of tokens pointers
typedef std::deque<s_Object *> t_PointObjectList;

void PushFrameObject(t_ObjectFrame *FrameObjects, t_ObjectList *ObjList);
// save objects from frame and delete list of object's pixels

class s_KalmanObject
{ // Object with tracked coordinates
  public:
   int EndFrame;
   int BeginFrame;
   int HeadOccur;               // count of a face occurance
   cClassifyGWN *TemplatePointer;       // pointer to recognizer
   t_PointObjectList PointLst;          // list of tracked objects
   float ActualX,ActualY;
   float SpeedX,SpeedY;
   float AccelX,AccelY;
   float PredictX,PredictY;
   void InitPrediction(s_Object *Object);
   void MakePrediction();
   void Update(s_Object *Object);
   float GetDeviation(s_Object *Object);
   s_KalmanObject()
   {
     PointLst.clear();
     HeadOccur=0;
   }
   ~s_KalmanObject() {}
   s_Object *GetLastObject();
   long GetLength() { return PointLst.size(); };
   bool GetObject(long Frame, s_Object &Object);
   s_Object *GetPreLastObject();
};

// list of Kalman objects
typedef std::deque<s_KalmanObject> t_KalmanList;

// list of pointers to Kalman objects
typedef std::deque<s_KalmanObject *> t_KalmanPointerList;

class c_Tracking
{
  public :
    // parameters
    double Divergence;                          // Divergence from correct trace
                                                // size of predicted area
    double Error;                               // Measurement error
    t_KalmanList ActiveKalmLst;                 // list of Actvite KF objects
    t_KalmanList StopedKalmLst;                 // list of stoped KF objects
    int ActiveLstSize();
    int StopLstSize();
    s_KalmanObject *GetActiveObject(int ObjectNr);
    s_KalmanObject *GetStopedObject(int ObjectNr);
    void InitTracing(t_ObjectFrame *ObjFrame);
    void TraceFrame(t_ObjectFrame *ObjFrame);
    void GetAllTracks(t_KalmanList *KalmLst, int Min);
  private :
   void InitTrace(t_KalmanList *KalmLst, t_ObjectList *ObjLst, int BeginFrame);
   void InitTrace(t_KalmanList *KalmLst, t_PointObjectList *ObjLst, int BeginFrame);
   void TraceObjects(t_KalmanList *KalmLst, t_ObjectList *ObjLst, int Frame);

};
