/*****************************************************************************/
/*                            Tokens tracking                                */
/*  Source file : Tracking tokens in picture sequence                        */
/*  Designed by Igor Potucek                                                 */
/*  2002                                                                     */
/*  VUT Brno - Faculty of Information Technology                             */
/*****************************************************************************/
#include "tracking.h"

   void s_KalmanObject::InitPrediction(s_Object *Object)
   {
      ActualX=Object->CentreX;
      ActualY=Object->CentreY;
      SpeedX=0; SpeedY=0;
      AccelX=0; AccelY=0;
      PointLst.push_back(Object);
   }
   void s_KalmanObject::MakePrediction()
   {
      PredictX=ActualX+SpeedX+AccelX/2;
      PredictY=ActualY+SpeedY+AccelY/2;
   }
   void s_KalmanObject::Update(s_Object *Object)
   {
     AccelX=((Object->CentreX-ActualX)-AccelX)*KOEF_ACCEL+(1-KOEF_ACCEL)*AccelX;
     AccelY=((Object->CentreY-ActualY)-AccelY)*KOEF_ACCEL+(1-KOEF_ACCEL)*AccelY;
     SpeedX=(Object->CentreX-ActualX)*KOEF_SPEED-(1-KOEF_SPEED)*SpeedX;
     SpeedY=(Object->CentreY-ActualY)*KOEF_SPEED-(1-KOEF_SPEED)*SpeedY;
     ActualX=Object->CentreX;
     ActualY=Object->CentreY;
   }
   float s_KalmanObject::GetDeviation(s_Object *Object)
   {
     return sqrt((Object->CentreX-PredictX)*(Object->CentreX-PredictX)+(Object->CentreY-PredictY)*(Object->CentreY-PredictY));
   }
   s_Object *s_KalmanObject::GetLastObject()
   {
      return PointLst.back();
   }
   bool s_KalmanObject::GetObject(long Frame, s_Object &Object)
   {

     long ObjPos=Frame-BeginFrame;
     // Test if object exists
     int j=PointLst.size();
     if ((ObjPos<0) || (j<=ObjPos))
       return false;
     else
     {
         Object=*PointLst[ObjPos];
         return true;
     }
   }
   s_Object *s_KalmanObject::GetPreLastObject()
   {
      if (PointLst.size()<2)
        return NULL;
      else
      {
        return PointLst[PointLst.size()-2];
      }
   }


void PushFrameObject(t_ObjectFrame *FrameObjects, t_ObjectList *ObjList)
// save objects from frame and delete list of object's pixels
{
   t_ObjectList::iterator bi = ObjList->begin(), ei = ObjList->end();
   for (; bi != ei; ++bi)
   {
     s_Object &Obj=*bi;
     Obj.PixelList.clear();
   }
   FrameObjects->push_back(*ObjList);
}


int c_Tracking::ActiveLstSize()  {  return ActiveKalmLst.size();      }

int c_Tracking::StopLstSize()    {  return StopedKalmLst.size();  }

s_KalmanObject *c_Tracking::GetActiveObject(int ObjectNr)
{ // get Kalman object from list of active tracking trajectories
  if ((ActiveKalmLst.size()>ObjectNr) && (ObjectNr>=0))
     return &(ActiveKalmLst[ObjectNr]);
  else
     return NULL;
}

s_KalmanObject *c_Tracking::GetStopedObject(int ObjectNr)
{ // get Kalman object from list of Stoped trajectories
  if ((StopedKalmLst.size()>ObjectNr) && (ObjectNr>=0))
     return &(StopedKalmLst[ObjectNr]);
  else
     return NULL;
}

void c_Tracking::InitTracing(t_ObjectFrame *ObjFrame)
{ // visible function
  ActiveKalmLst.clear();
  StopedKalmLst.clear();
  t_ObjectList &ObjLst=ObjFrame->back();
  InitTrace(&ActiveKalmLst,&ObjLst,0);
}

void c_Tracking::TraceFrame(t_ObjectFrame *ObjFrame)
{
  int Frame=ObjFrame->size()-1;
  t_ObjectList &ObjLst=ObjFrame->back();
  TraceObjects(&ActiveKalmLst, &ObjLst, Frame);
}

void c_Tracking::InitTrace(t_KalmanList *KalmLst, t_ObjectList *ObjLst, int BeginFrame)
// list of active tracked trajectories, list of next objects, Actual Frame
// creates KF from objects in actual frame
{
   t_ObjectList::iterator bi = ObjLst->begin(), ei = ObjLst->end();
   for (; bi != ei; ++bi)
   {
     s_Object &Obj=*bi;
     // creates new KF object
     s_KalmanObject KalmObj;
     // run prediction for an object
     KalmObj.InitPrediction(&Obj);
     KalmObj.BeginFrame=BeginFrame;
     KalmObj.EndFrame=BeginFrame;
     // insert first object with prediction
     KalmLst->push_back(KalmObj);
   }
}

void c_Tracking::InitTrace(t_KalmanList *KalmLst, t_PointObjectList *ObjLst, int BeginFrame)
// list of active tracked trajectories, list of next objects, Actual Frame
// creates KF from objects in actual frame
{
   t_PointObjectList::iterator bi = ObjLst->begin(), ei = ObjLst->end();
   for (; bi != ei; ++bi)
   {
     s_Object *Obj=*bi;
     // creates new KF object
     s_KalmanObject KalmObj;
     KalmObj.InitPrediction(Obj);
     KalmObj.BeginFrame=BeginFrame;
     KalmObj.EndFrame=BeginFrame;
     KalmLst->push_back(KalmObj);
   }
}

void c_Tracking::TraceObjects(t_KalmanList *KalmLst, t_ObjectList *ObjLst, int Frame)
{  // evaluate all KF in list and predict new positions
   t_KalmanList NewKalmLst;
   t_PointObjectList PointerObjectList;         // list of pointers to objects
   // makes list of pointers to objects
   t_ObjectList::iterator bi = ObjLst->begin(), ei = ObjLst->end();
   for (; bi != ei; ++bi)
   {
      PointerObjectList.push_back(&(*bi));
   }
   int Area1, Area2;
   // passes all KF objects and predict new position
   t_KalmanList::iterator bii = KalmLst->begin(), eii = KalmLst->end(), best, ver;
   for (; bii != eii; ++bii)
   {
     bool Insert=false;
     float Min=99999;
     s_KalmanObject KalmObj=*bii;
     KalmObj.MakePrediction();
     s_Object *ChoiceObject;
     Area1=(ChoiceObject->MaxX-ChoiceObject->MinX)*(ChoiceObject->MaxY-ChoiceObject->MinY);
     t_PointObjectList::iterator bil = PointerObjectList.begin(), eil = PointerObjectList.end(), Choice;
     for (; bil != eil; ++bil)
     {
        s_Object *Obj=*bil;
        float dev=KalmObj.GetDeviation(Obj);
        Area2=(Obj->MaxX-Obj->MinX)*(Obj->MaxY-Obj->MinY);
        // test whether pass object to predicted area
        if ((dev<Divergence) && (fabs((float)Area1/Area2-1)<0.3))
        {
           if (dev<Min)
           {
             Min=dev;
             ChoiceObject=Obj;
             Choice=bil;
           }
           Insert=true;
           // insert object pointer into trajectory list of Kalman object
        }
     }
     if (Insert)
     {
        KalmObj.EndFrame=Frame;
        KalmObj.PointLst.push_back(ChoiceObject);
        KalmObj.Update(ChoiceObject);
        NewKalmLst.push_back(KalmObj);                 // put the best trajectory to final list
        PointerObjectList.erase(Choice);          // erase used object
     }
     else
     {
        s_Object *Obj=KalmObj.PointLst.back();
        // aby jsme odecetli ruku jen jednou
        if (Obj->CorObject!=NULL)
        {
          Obj->CorObject->hands--;
          Obj->CorObject=NULL;
        }
        if ((KalmObj.EndFrame-KalmObj.BeginFrame)>c_MIN_LENGTH)
        {
             KalmObj.EndFrame=Frame-1;
             StopedKalmLst.push_back(KalmObj);
             s_Object *Obj=KalmObj.PointLst.back();
             // aby jsme odecetli ruku jen jednou
             if (Obj->CorObject!=NULL)
             {
               Obj->CorObject->hands--;
               Obj->CorObject=NULL;
             }
        }
     }
   }
   // we will track movement of new objects
   if (PointerObjectList.size()>0)           // are new objects ?
      InitTrace(&NewKalmLst, &PointerObjectList, Frame); // only add new track
   // Swap new list to old list
   NewKalmLst.swap(*KalmLst);
}

void c_Tracking::GetAllTracks(t_KalmanList *KalmLst, int Min)
{
  KalmLst->clear();
   t_KalmanList::iterator bii = ActiveKalmLst.begin(), eii = ActiveKalmLst.end();
   for (; bii != eii; ++bii)
   {

      if (bii->PointLst.size()>Min)
      {
        KalmLst->push_back(*bii);
      }
   }
   bii = StopedKalmLst.begin(), eii = StopedKalmLst.end();
   for (; bii != eii; ++bii)
   {

      if (bii->PointLst.size()>Min)
      {
        KalmLst->push_back(*bii);
      }
   }
 // copy(StopedKalmLst.begin(),StopedKalmLst.end(),inserter(KalmLst,KalmLst->end()));
 // copy(ActiveKalmLst.begin(),ActiveKalmLst.end(),inserter(KalmLst,KalmLst->end()));

}


