
#include "color.h"
#include "reclib.h"
#include <math.h>
#ifdef _WIN32
  #include <vcl.h>
  #include <stdio.h>
#endif
#include "../../AVFile/Include/bmpfile.h"

#define SAVEBMP
const int FACE_THRESHOLD=5;

extern TBMPFile bmp;

const float SLOPE_OFFSET = 0.15;
const float REC_THRES = 0.7;
const int HEAD_OCCUR_COUNT=5;
const bool PERSON_PARTS=false;
 int c_lowline=375; //IDIAP
// int c_lowline=520; //other

void ObjectClassify::ClassifyTwoPersons(t_KalmanList *KalmList)
{  // 28.10.2004 - dopsat kod pro rozpoznani obliceju
   t_KalmanList::iterator rbi = KalmList->begin(), rei = KalmList->end();
   for (; rbi != rei; ++rbi)
   {
     s_Object *Obj=rbi->GetPreLastObject();
   }
}                                                  

void ObjectClassify::NewObject(t_KalmanList *KalmList, ImageStruct *Image, s_KalmanObject *KalmObject)
{
  s_Object *Object=KalmObject->GetLastObject();
  // begin coordinates for detection of the face region
  cImageRegion iregion(image, new cRectangle(Object->MinX, Object->MinY, Object->MaxX, Object->MaxY), true);
  eABClass result = detector.detect(&iregion, FACE_THRESHOLD);

  // find matching
  if (result == AB_FACE)
  {
    cRectangle position = detector.get_face_region();
#ifdef SAVEBMP
    ImageStruct *face = detector.get_face();
    bmp.DLPutFrame(face);
#endif
    // store searched position
    Object->Face=true;
    Object->head=true;
    KalmObject->HeadOccur++;
    Object->face1x=position.corners[0].x;
    Object->face1y=position.corners[0].y;
    Object->face2x=position.corners[1].x;
    Object->face2y=position.corners[1].y;
    Object->face3x=position.corners[2].x;
    Object->face3y=position.corners[2].y;
    Object->face4x=position.corners[3].x;
    Object->face4y=position.corners[3].y;
  }//if
}

void ObjectClassify::InitClassify(t_KalmanList *KalmList, ImageStruct *Image)
{  // for each tracked object choose the best recognizer if the object is head
   t_PointObjectList SearchObjects;
   ImageStruct *image=ImageCopy(Image);
   t_KalmanList::iterator bii = KalmList->begin(), eii = KalmList->end();
   for (; bii != eii; ++bii)
   {
      s_KalmanObject *KalmObject=&(*bii);
      bool extrapol;
      s_Object *Object=KalmObject->GetLastObject();
      SearchObjects.push_back(Object);
          cImageRegion iregion(image, new cRectangle(Object->MinX, Object->MinY, Object->MaxX, Object->MaxY), true);

       //   bmp.DLPutFrame(Image);//iregion.get_image());   //!!!!!!!!!!!!!!!!!!!!!!!!
          eABClass result = detector.detect(&iregion, FACE_THRESHOLD);
          // find matching
          if (result == AB_FACE)
          {
            cRectangle position = detector.get_face_region();
#ifdef SAVEBMP
            ImageStruct *face = detector.get_face();
            bmp.DLPutFrame(face);
#endif
            // store searched position
            Object->Face=true;
            Object->head=true;
            KalmObject->HeadOccur++;
            Object->face1x=position.corners[0].x;
            Object->face1y=position.corners[0].y;
            Object->face2x=position.corners[1].x;
            Object->face2y=position.corners[1].y;
            Object->face3x=position.corners[2].x;
            Object->face3y=position.corners[2].y;
            Object->face4x=position.corners[3].x;
            Object->face4y=position.corners[3].y;
      }//if
   }//for
   DeleteImage(image);
}

void ObjectClassify::TrackClassify(t_KalmanList *KalmList, ImageStruct *Image)
{  // for each tracked object choose the best recognizer if the object is head
   t_PointObjectList SearchObjects;
   image=Image;
   t_KalmanList::iterator bii = KalmList->begin(), eii = KalmList->end();
   for (; bii != eii; ++bii)
   {
      s_KalmanObject *KalmObject=&(*bii);
      s_Object *Object=KalmObject->GetLastObject();
      SearchObjects.push_back(Object);
      s_Object *PreObject=KalmObject->GetPreLastObject();
        //////////////////////////////////////////////////////////////////////////
        // new object - first occurance
        if (PreObject==NULL)
        { // new object, it must be compared with rest template
          NewObject(KalmList,Image,KalmObject);
        }
        //////////////////////////////////////////////////////////////////////////
        // continuos occurance
        else if (PreObject!=NULL)
        {
          if (true)//KalmObject->HeadOccur<HEAD_OCCUR_COUNT)
          {
            cImageRegion iregion(image, new cRectangle(Object->MinX, Object->MinY, Object->MaxX, Object->MaxY), true);
            eABClass result = detector.detect(&iregion, FACE_THRESHOLD);
            // find matching
            if (result == AB_FACE)
            {
              cRectangle position = detector.get_face_region();
#ifdef SAVEBMP
              ImageStruct *face = detector.get_face();
              bmp.DLPutFrame(face);
#endif
              // store searched position
              Object->Face=true;
              Object->head=true;
              KalmObject->HeadOccur++;
              Object->face1x=position.corners[0].x;
              Object->face1y=position.corners[0].y;
              Object->face2x=position.corners[1].x;
              Object->face2y=position.corners[1].y;
              Object->face3x=position.corners[2].x;
              Object->face3y=position.corners[2].y;
              Object->face4x=position.corners[3].x;
              Object->face4y=position.corners[3].y;
              printf("Face detected on %d \n", Object->face1x);
            }//if
            else
            {
              Object->Face=false;
              Object->head=false;
              Object->hand=true;
            }
          }
        }
   }
}

bool HeadPose(s_Object *Object, float &angle, float &direction, float &slope)
{
   if (!Object->Face) return false;
   float val=abs(Object->face1x-Object->face4x)/(float)abs(Object->face1y-Object->face4y);
   angle=atan2((double)Object->face1x-Object->face4x,(double)Object->face1y-Object->face4y)*360/(2*M_PI)-180;
   int a=(Object->face1x+Object->face4x)/2-Object->MinX;
   int b=Object->MaxX-(Object->face2x+Object->face3x)/2;
   int c=(Object->face1y+Object->face2y)/2-Object->MinY;
   int d=Object->MaxY-(Object->face3y+Object->face4y)/2;
   // left -1, right 1
   direction=float(a-b)/(Object->MaxX-Object->MinX);
   // up -1 down 1

   slope=float(c-d)/(Object->MaxY-Object->MinY)-SLOPE_OFFSET;
   return true;
}

void ExtractPathFileName(char *file, char *outfile)
{
   char *pch;
   pch = strrchr(file, '/');
   if (pch==NULL)
      pch = strrchr(file, '\\');
   *(pch)='\0';
   strcpy(outfile, (pch+1));
}

void ExtractFileName(char *file,char *outfile)
{
   char *pch;
   pch = strrchr(file, '/');
   if (pch==NULL)
      pch = strrchr(file, '\\');
   strcpy(outfile, (pch+1));
}

void ObjectClassify::RecognizeTwoPerson(c_SearchObjects *SearchObjects, int Width, int Height)
{  // two persons in room sitting behind the table - IDIAP data
   // use object position in image to recognize hands and faces

   s_Object Object;
   Object.MinY=9999;                       // max value
   s_Object *FaceL=&Object;
   s_Object *FaceR=&Object;
   int i=0;
   s_Object *Obj=SearchObjects->GetFirst();
   while (SearchObjects->GetSize()>i)
   {
     if (Obj->MaxX<(Width/2))
     {
       Obj->Person="A";
       if (Obj->MinY<FaceL->MinY)
       {
          FaceL->hand=true;
          FaceL=Obj;
       }
       else
          Obj->hand=true;
     }
     else
     {
       Obj->Person="B";
       if (Obj->MinY<FaceR->MinY)
       {
          FaceR->hand=true;
          FaceR=Obj;
       }
       else
          Obj->hand=true;
     }
     i++;
     Obj=SearchObjects->GetNext();
   }
   FaceL->head=true;
   FaceR->head=true;
}
void ObjectClassify::EndClassify(t_KalmanList *KalmList)
{   // at the end sumarize all detected faces and hands
    t_KalmanList::iterator bii = KalmList->begin(), eii = KalmList->end();
    for (; bii != eii; ++bii)
    {
       float f;
       if (bii->HeadOccur==0)
         f=0;
       else
         f=(float)bii->HeadOccur/bii->GetLength();
       bool head=(f>0.05)?true:false;
       t_PointObjectList::iterator bi = bii->PointLst.begin(), ei = bii->PointLst.end();
       for (; bi != ei; ++bi)
       {
         s_Object *Obj=(*bi);
         Obj->head=head;
         Obj->hand=!head;
         //if (!head) Obj->Face=false;
       }
    }
}
