//---------------------------------------------------------------------------
#include <stdlib.h>
#include "imageproc.h"
//---------------------------------------------------------------------------
void Dilate(ImageStruct *Input, ImageStruct *Output)
{
  int i,j;
  for (j = 0;j<Input->YSize;++j)
  {
    int XOffset=Input->XOffset;
    unsigned char * dst = &Image8Pixel(Output,0,j);
    unsigned char * src0 = NULL; if (j>0) src0=&Image8Pixel(Input,0,j-1);
    unsigned char * src1 = &Image8Pixel(Input,0,j);
    unsigned char * src2 = NULL; if (j<Input->YSize-1) src2=&Image8Pixel(Input,0,j+1);
    for (i = 0;i<Input->XSize;++i)
    {
      if ((*src1)==0)
      {
        int c0=0; if (i>0)                      c0=*(src1-XOffset);
        int c1=0; if ((i>0) && (j>0))           c1=*(src0-XOffset);
        int c2=0; if (j>0)                      c2=*(src0);
        int c3=0; if ((i<Input->XSize-1)&&(j>0))       c3=*(src0+XOffset);
        int c4=0; if (i<Input->XSize-1)                c4=*(src1+XOffset);
        int c5=0; if ((j<Input->YSize-1) && (i<Input->XSize-1)) c5=*(src2+XOffset);
        int c6=0; if (j<Input->YSize-1)                c6=*(src2);
        int c7=0; if ((j<Input->YSize-1) && (i>0))     c7=*(src2-XOffset);
        if ((c0!=0) || (c1!=0) || (c2!=0) || (c3!=0) || (c4!=0) || (c5!=0) || (c6!=0) || (c7!=0))
        {
           (*dst)=255;
        }
        else
        {
           (*dst)=0;
        }
      }
      else
        (*dst)=255;
      src0 += XOffset; src1 += XOffset; src2 += XOffset; dst += Output->XOffset;       // jump to next pixel
    }
  }
}

void Erode(ImageStruct *Input, ImageStruct *Output)
{
  int i,j;
  for (j = 0;j<Input->YSize;++j)
  {
    int XOffset=Input->XOffset;
    unsigned char * dst = &Image8Pixel(Output,0,j);
    unsigned char * src0 = NULL; if (j>0) src0=&Image8Pixel(Input,0,j-1);
    unsigned char * src1 = &Image8Pixel(Input,0,j);
    unsigned char * src2 = NULL; if (j<Input->YSize-1) src2=&Image8Pixel(Input,0,j+1);
    for (i = 0;i<Input->XSize;++i)
    {
      if ((*src1)>0)
      {
        int c0=0; if (i>0)                      c0=*(src1-XOffset);
        int c1=0; if ((i>0) && (j>0))           c1=*(src0-XOffset);
        int c2=0; if (j>0)                      c2=*(src0);
        int c3=0; if ((i<Input->XSize-1)&&(j>0))       c3=*(src0+XOffset);
        int c4=0; if (i<Input->XSize-1)                c4=*(src1+XOffset);
        int c5=0; if ((j<Input->YSize-1) && (i<Input->XSize-1)) c5=*(src2+XOffset);
        int c6=0; if (j<Input->YSize-1)                c6=*(src2);
        int c7=0; if ((j<Input->YSize-1) && (i>0))     c7=*(src2-XOffset);
        if ((c0==0) || (c1==0) || (c2==0) || (c3==0) || (c4==0) || (c5==0) || (c6==0) || (c7==0))
        {
           (*dst)=0;
        }
        else
        {
           (*dst)=255;
        }
      }
      else
        (*dst)=0;
      src0 += XOffset; src1 += XOffset; src2 += XOffset; dst += Output->XOffset;       // jump to next pixel
    }
  }
}


void Equalizer(ImageStruct *Image, unsigned char r, unsigned char g, unsigned char b)
// equalize colors in the Image; r,g,b variables are white color elements
{
 unsigned char Min=min(min(r,g),b);
 r=r-Min;
 g=g-Min;
 b=b-Min;
 int w = ImageXSize(Image);
 int h = ImageYSize(Image);
   for (int j = 0; j < h; j++) {
    for (int i = 0; i < w; i++) {
      if ((ImageRGBPixelB(Image,i,j) - b)<0)
        ImageRGBPixelB(Image,i,j)=0;
      else
        ImageRGBPixelB(Image,i,j) = ImageRGBPixelB(Image,i,j) - b;
      if ((ImageRGBPixelG(Image,i,j) - g)<0)
        ImageRGBPixelG(Image,i,j)=0;
      else
        ImageRGBPixelG(Image,i,j) = ImageRGBPixelG(Image,i,j) - g;
      if ((ImageRGBPixelR(Image,i,j) - r)<0)
        ImageRGBPixelR(Image,i,j)=0;
      else
        ImageRGBPixelR(Image,i,j) = ImageRGBPixelR(Image,i,j) - r;
    }
  }
}

#define radius  3.4
int     mask[7][7] = { {0,0,1,1,1,0,0},
                       {0,1,1,1,1,1,0},
                       {1,1,1,1,1,1,1},
                       {1,1,1,1,1,1,1},
                       {1,1,1,1,1,1,1},
                       {0,1,1,1,1,1,0},
                       {0,0,1,1,1,0,0} };
int     size = 37;          // n == number of 1 in mask
float   g    = 3*size/4;    // g == geometric threshold

//---------------------------------------------------------------------------
// Desc: applies susan filter on src image, returns in dst image
//       both images must be allocated, radius sets nucleus size
//       for usan computation
//---------------------------------------------------------------------------
int LineSharp( ImageStruct * dst, ImageStruct * src, int thrash )
{
    // test initalised pointers
    if ( ( dst == NULL ) || ( src == NULL ) ) return SUSAN_NODATA;

    ImageStruct * usan = NewImageFloat( src->XSize, src->YSize );

    for ( int x = 0; x < dst->XSize; x++ )
    {
        for ( int y = 0; y < dst->YSize; y++ )
        {
            int minx = ( ( x - radius ) < 0 ) ? radius -x : 0;
            int maxx = ( ( x + radius ) >= src->XSize ) ? src->XSize-x-1+radius : radius*2;
            int miny = ( ( y - radius ) < 0 ) ? radius-y : 0;
            int maxy = ( ( y + radius ) >= src->YSize ) ? src->YSize-y-1+radius : radius*2;

            ImageFloatPixel( usan, x, y ) = 0;

            for ( int mx = minx; mx <= maxx; mx++ )
            {
                for ( int my = miny; my <= maxy; my++ )
                {
                    if ( mask[mx][my] == 1 )
                    {
                        ImageFloatPixel( usan, x, y ) +=
                       /*     exp( -( ( ( Image8Pixel ( src, x+mx-int(radius), y+my-int(radius) ) - Image8Pixel ( src, x, y ) ) / thrash ) *
                                    ( ( Image8Pixel ( src, x+mx-int(radius), y+my-int(radius) ) - Image8Pixel ( src, x, y ) ) / thrash ) *
                                    ( ( Image8Pixel ( src, x+mx-int(radius), y+my-int(radius) ) - Image8Pixel ( src, x, y ) ) / thrash ) *
                                    ( ( Image8Pixel ( src, x+mx-int(radius), y+my-int(radius) ) - Image8Pixel ( src, x, y ) ) / thrash ) *
                                    ( ( Image8Pixel ( src, x+mx-int(radius), y+my-int(radius) ) - Image8Pixel ( src, x, y ) ) / thrash ) *
                                    ( ( Image8Pixel ( src, x+mx-int(radius), y+my-int(radius) ) - Image8Pixel ( src, x, y ) ) / thrash )
                                  )

                               );
                        */
                            Image8Pixel ( src, x+mx-int(radius), y+my-int(radius) ) - Image8Pixel ( src, x, y ) <= thrash  ? 1 : 0 ;
                    }
                }
            }

            ImageFloatPixel( usan, x, y ) = g - ImageFloatPixel( usan, x, y );
        }
    }

    for ( int x = 0; x < dst->XSize; x++ )
    {
        for ( int y = 0; y < dst->YSize; y++ )
        {
            Image8Pixel ( dst, x, y ) = 255-int( ImageFloatPixel( usan, x, y ) );
        }
    }

    delete usan;

    return SUSAN_OK;
}

int Sobel(ImageStruct *Inp, ImageStruct *Outp)
{
   int			GX[3][3];
   int			GY[3][3];
   int			I, J;
   long			sumX, sumY;
   int			SUM;
   /* 3x3 GX Sobel mask.  Ref: www.cee.hw.ac.uk/hipr/html/sobel.html */
   GX[0][0] = -1; GX[0][1] = 0; GX[0][2] = 1;
   GX[1][0] = -2; GX[1][1] = 0; GX[1][2] = 2;
   GX[2][0] = -1; GX[2][1] = 0; GX[2][2] = 1;

   /* 3x3 GY Sobel mask.  Ref: www.cee.hw.ac.uk/hipr/html/sobel.html */
   GY[0][0] =  1; GY[0][1] =  2; GY[0][2] =  1;
   GY[1][0] =  0; GY[1][1] =  0; GY[1][2] =  0;
   GY[2][0] = -1; GY[2][1] = -2; GY[2][2] = -1;

   for(int Y=0; Y<Inp->YSize; Y++)  {
	for(int X=0; X<Inp->XSize; X++)  {
	     sumX = 0;
	     sumY = 0;

             /* image boundaries */
	     if(Y==0 || Y==Inp->XSize-1)
		  SUM = 0;
	     else if(X==0 || X==Inp->YSize-1)
		  SUM = 0;

	     /* Convolution starts here */
	     else   {

	       /*-------X GRADIENT APPROXIMATION------*/
	       for(I=-1; I<=1; I++)  {
		   for(J=-1; J<=1; J++)  {
		      sumX = sumX + (int)( Image8Pixel(Inp,X+I,Y+J) * GX[I+1][J+1]);
		   }
	       }
	       if(sumX>255)  sumX=255;
	       if(sumX<0)    sumX=0;

	       /*-------Y GRADIENT APPROXIMATION-------*/
	       for(I=-1; I<=1; I++)  {
		   for(J=-1; J<=1; J++)  {
		       sumY = sumY + (int)( Image8Pixel(Inp,X+I,Y+J) * GY[I+1][J+1]);
		   }
	       }
	       if(sumY>255)   sumY=255;
	       if(sumY<0)     sumY=0;

	       SUM = abs(sumX) + abs(sumY); /*---GRADIENT MAGNITUDE APPROXIMATION (Myler p.218)----*/
             }
//             SetImage8Pixel(Outp,X,Y,255 - (unsigned char)(SUM));  /* make edges black and background white */
             SetImage8Pixel(Outp,X,Y,(unsigned char)(SUM));  /* make edges white */
	}
   }
   return 0;
}

