
#include "ellipse.h"
#include "tracking.h"
#include "mPCA.h"

void EllipseFit::Compute(s_Object *Object)
{
   int ok=0;
   xcent=Object->CentreX;
   ycent=Object->CentreY;
   Kov->m[0+0]=Object->kov11;
   Kov->m[0+1]=Object->kov21;
   Kov->m[2+0]=Object->kov12;
   Kov->m[2+1]=Object->kov22;
   // calculate eigenvalue and eigenvector
   ok=PCA(Kov,Result,Vec);
   // computing the axes
   float a=Vec->v[0];
   float b=Vec->v[1];
   float c=Result->m[0];
   float d=Result->m[1];
   major=sqrt(sqrt(a))*2;
   minor=sqrt(sqrt(b))*2;
   orientation=atan2(d,c);
   Object->orientation=orientation;
   Object->axisA=major;
   Object->axisB=minor;
}

void EllipseFit::Draw(ImageStruct *Image)
{
  // draw around the 360 degrees
  for(float ang=0; ang<2*M_PI; ang=ang+2*M_PI/500.0)
  {
    float xp=major*cos(ang);
    float yp=minor*sin(ang);
    float xp1=(major+1)*cos(ang);
    float yp1=(minor+1)*sin(ang);

    float x=xcent+xp*cos(orientation)-yp*sin(orientation);
    float y=ycent+xp*sin(orientation)+yp*cos(orientation);
    float x1=xcent+xp1*cos(orientation)-yp1*sin(orientation);
    float y1=ycent+xp1*sin(orientation)+yp1*cos(orientation);

    if ((x1>=0) && (y1>=0) && (y1<Image->YSize) &&(x1<Image->XSize))
    if ((x>=0) && (y>=0) && (y<Image->YSize) &&(x<Image->XSize))
    {
      SetImageRGBPixelRGB(Image,(int)x,(int)y,0xAA0000c);
      SetImageRGBPixelRGB(Image,(int)x1,(int)y1,0xFF0000c);
    }
  }
}








