/*****************************************************************************/
/*                            DATA storing functions                         */
/*  Source file : saving data to xml and txt files                           */
/*  Designed by Igor Potucek                                                 */
/*  2003                                                                     */
/*  VUT Brno - Faculty of Information Technology                             */
/*****************************************************************************/
#include "datasave.h"
#include "tracking.h"
#include "reclib.h"
extern t_KalmanList    SolutionKalmLst;  // result ov choosed trajectories

int SaveMouthStat(char *FileName, int from, int to)
{
  FILE *f;
  if ((f=fopen(FileName,"w"))!=NULL)
  {
    for (int i=from; i<to+1; i++)
    {
      t_KalmanList::iterator bii = SolutionKalmLst.begin(), eii = SolutionKalmLst.end();
      for (; bii != eii; ++bii)
      {
         s_Object Object;
         if (bii->GetObject(i, Object))
         {
           if (Object.Mouth)
              fprintf(f,"%d %f %f\n",Object.MouthSum,Object.AvgR,Object.AvgB);
           else
              fprintf(f,"%f %f %f\n",0,0,0);
         }
       }
     }
     fclose(f);
     return 1;
   }
   else
   return 0;
}

int SaveHeadsOrientation(char *FileName, int from, int to)
{
  FILE *f;
  if ((f=fopen(FileName,"w"))!=NULL)
  {
    for (int i=from; i<to+1; i++)
    {
      t_KalmanList::iterator bii = SolutionKalmLst.begin(), eii = SolutionKalmLst.end();
      for (; bii != eii; ++bii)
      {
         s_Object Object;
         float angle, direction, slope;
         if (bii->GetObject(i, Object))
         {
           bool is=HeadPose(&Object, angle, direction, slope);
           if (is)
              fprintf(f,"%f %f %f ",angle,direction,slope);
         }
       }
       fprintf(f,"\n");
     }
     fclose(f);
     return 1;
   }
   else
   return 0;
}
