/*****************************************************************************/
/*                       Image processing functions                          */
/*  Source file : color detection and image segmentation functions           */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2004                                                             */
/*  VUT Brno - Faculty of Information Technology                             */
/*****************************************************************************/
// Used DigIPrj2003 library for image structures
/*****************************************************************************/
#ifndef UnitColor
#define UnitColor

#include <list>
#include <math.h>

// Here is defined struct with object information
#include "tracking.h"

#include "Image.h"


int SkinLocusDetect(ImageStruct *Input,ImageStruct *Output);

// prevod z RGB do rg
void RGBtoRG(unsigned char r,unsigned char g,unsigned char b, int &c1, int &c2);

class c_SearchObjects
{
  double Min;              // !! limit pro zanedbani objemu objektu !!
  t_ObjectList::iterator bi;
  void SearchSeed(ImageStruct *Image, s_Object *Object, int x, int y);
  public:
  t_ObjectList ObjectList;
  c_SearchObjects()
  {
     Min=0.001;
  }
  int Search(ImageStruct *Image, int Size);
  s_Object *GetNext()
  {
     if (bi!=ObjectList.end()) bi++;
     return &(*bi);
  }
  int GetSize()
  {
     return ObjectList.size();
  }
  s_Object *GetPrev()
  {
     if (bi!=ObjectList.begin()) bi--;
     return &(*bi);
  }
  s_Object *GetObject(int Nr)
  {
     if ((Nr>=0) && (Nr<ObjectList.size()))
       return &ObjectList[Nr];
     else
       return NULL;
  }

  s_Object *GetFirst()
  {
     bi=ObjectList.begin();
     return &(*bi);
  }
  s_Object *GetActual()
  {
     return &(*bi);
  }
  void Clear()
  {
     ObjectList.clear();
  }
};

#endif
