/*---------------------------------------------------------------------------
   VS - Views
   $Id: StampText.c,v 1.1 2002/05/29 16:22:09 herout Exp $
*/

#include <stdio.h>
#include "StampText.h"

#pragma package(smart_init)

#include "StampFont.c"

void StampText(ImageStruct *img, int x, int y, char *s, int wide)
{
  unsigned char *c;
  int i,j;
  if ((x < 0) || (y < 0) || (y + StampFont.height > img->YSize)) return;
  for (c = s; (*c); c++) {
    if (*c < StampFont.first || *c > StampFont.last) continue;
    if (x + ((wide)?2:1)*StampFont.chars[*c-StampFont.first].width > img->XSize) return;
    for (i = 0; i < StampFont.height; i++) {
      int bit = 1;
      for (j = 0; j <= StampFont.chars[*c-StampFont.first].width; j++) {
        if (StampFont.chars[*c-StampFont.first].data[i].w & bit) {
          if (wide) {
            SetImageRGBPixelRGB(img, x+2*j, y+i, 0x80a0a0);
            SetImageRGBPixelRGB(img, x+2*j+1, y+i, 0x80a0a0);
          } else SetImageRGBPixelRGB(img, x+j, y+i, 0x80a0a0);
        } else if (StampFont.chars[*c-StampFont.first].data[i].b & bit) {
          if (wide) {
            SetImageRGBPixelRGB(img, x+2*j, y+i, 0xaaaaaa);
            SetImageRGBPixelRGB(img, x+2*j+1, y+i, 0xaaaaaa);
          } else SetImageRGBPixelRGB(img, x+j, y+i, 0xaaaaaa);
        }
        bit <<= 1;
      }
    }
    if (wide) {
      x += 2*(StampFont.chars[*c-StampFont.first].width-2);
    } else x += (StampFont.chars[*c-StampFont.first].width-2);
  }
}

