/*****************************************************************************/
/*                       Image processing functions                          */
/*  Source file : color detection and image segmentation functions           */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2004                                                             */
/*  VUT Brno - Faculty of Information Technology                             */
/*****************************************************************************/
// Used DigIPrj2003 library for image structures
// 19.9.2004 skin locus detection
/*****************************************************************************/
 #include "color.h"
 #include "Unit1.h"
 // Soriano skin color locus - parameters for 2 quadratic border equations
 const float c_Aup=-1.8423;
 const float c_Bup= 1.5294;
 const float c_Cup= 0.0422;
 const float c_Adown=-0.7279;
 const float c_Bdown=0.6066;
 const float c_Cdown=0.1766;
 const int c_Step=2;
extern const int BINS_COUNT;

void RGBtoRG(unsigned char r,unsigned char g,unsigned char b, int &c1, int &c2)
{
   int sum = r+g+b;
   if (sum>0)
   {
     c1=(BINS_COUNT*r)/sum + 0.5;
     c2=(BINS_COUNT*g)/sum + 0.5;
   }
   else
   {
     c1=0;
     c2=0;
   }
}

int SkinLocusDetect(ImageStruct *Input,ImageStruct *Output)
{ // skin color detection using skin locus developed by Soriano
  int XSize,YSize,SXStep,DXStep;
  int i,j,c,R,G;

  XSize = ImageXSize(Input);
  YSize = ImageYSize(Input);
  SXStep = ImageXOffset(Input);
  DXStep = ImageXOffset(Output);

  for (j = 0;j<YSize;++j)
  {
    unsigned char * Src = &ImageRGBPixelB(Input,0,j);
    unsigned char * Dst = &Image8Pixel(Output,0,j);

    for (i = 0;i<XSize;++i)
    {
    //  unsigned char r=ImageRGBPixelR(Input,i,j);
    //  unsigned char g=ImageRGBPixelG(Input,i,j);
    //  unsigned char b=ImageRGBPixelB(Input,i,j);
      // ulozeno BGR
      unsigned char b=*(Src+0);
      unsigned char g=*(Src+1);
      unsigned char r=*(Src+2);
      Src+=SXStep;
      RGBtoRG(r,g,b,R,G);
      float rr=R*R*0.0001;
      float up=c_Aup*rr+c_Bup*R*0.01+c_Cup;
      float down=c_Adown*rr+c_Bdown*R*0.01+c_Cdown;
      float Wr=(R-33)*(R-33)+(G-33)*(G-33);
      if ((G<up*100)&(G>down*100)&(Wr>40))
        *Dst = (unsigned char)255;
      else
        *Dst = (unsigned char)0;
      Dst += DXStep;
    }
  }
  return 1;
}

  int c_SearchObjects::Search(ImageStruct *Image, int Size)
  {
     t_PositionList *List;
     ObjectList.clear();
     int x,y,Sum;
     for (x=0; x<Image->XSize; x++)
       for (y=0; y<Image->YSize; y++)
       {
         if (Image8Pixel(Image,x,y)>0)
         {
            // seminko najde objekt a vlozi ho do seznamu
            s_Object TrackObj;
            SearchSeed(Image,&TrackObj,x,y);
            // vlozi do seznamu jen objekty vetsi nez Min*100 procent obsahu obrazu
            if (TrackObj.Sum>(Size/10))
            {
               ObjectList.push_back(TrackObj);
            }
         }
       }
     bi=ObjectList.begin();
     return ObjectList.size();
  }

  void c_SearchObjects::SearchSeed(ImageStruct *Image, s_Object *Object, int x, int y)
  {
     s_Position Point;             // bod
     Object->Sum=0;
     Object->CentreX=0;
     Object->CentreY=0;
     Object->MaxX=0;
     Object->MaxY=0;
     Object->MinX=x;
     Object->MinY=y;
     t_PositionList PomList;
     Point.x=x;
     Point.y=y;
     SetImage8Pixel(Image,x,y,0);
     PomList.push_back(Point);
     while (PomList.size()>0)
     {
        Point=PomList.back();
        PomList.pop_back();
        Object->PixelList.push_back(Point);
        Object->CentreX=Object->CentreX+x;
        Object->CentreY=Object->CentreY+y;
        if (Object->MaxX<x) Object->MaxX=x;
        if (Object->MaxY<y) Object->MaxY=y;
        if (Object->MinX>x) Object->MinX=x;
        if (Object->MinY>y) Object->MinY=y;
        x=Point.x;
        y=Point.y;
        if ((x<Image->XSize-1) && (y<Image->YSize-1) && (Image8Pixel(Image,x+1,y+1)>0))
        {
          SetImage8Pixel(Image,x+1,y+1,0);
          Point.x=x+1;  Point.y=y+1;
          PomList.push_back(Point);
        }
        if ((x>0) && (y>0) & (Image8Pixel(Image,x-1,y-1)>0))
        {
          SetImage8Pixel(Image,x-1,y-1,0);
          Point.x=x-1;  Point.y=y-1;
          PomList.push_back(Point);
        }
        if ((x>0) && (y<Image->YSize-1) && (Image8Pixel(Image,x-1,y+1)>0))
        {
          SetImage8Pixel(Image,x-1,y+1,0);
          Point.x=x-1;  Point.y=y+1;
          PomList.push_back(Point);
        }
        if ((x<Image->XSize-1) && (y<Image->YSize-1) && (Image8Pixel(Image,x+1,y+1)>0))
        {
          SetImage8Pixel(Image,x+1,y-1,0);
          Point.x=x+1;  Point.y=y-1;
          PomList.push_back(Point);
        }
        //-----------------------------------------------------------------
        if ((y<Image->YSize-1) && (Image8Pixel(Image,x,y+1)>0))
        {
          SetImage8Pixel(Image,x,y+1,0);
          Point.x=x;  Point.y=y+1;
          PomList.push_back(Point);
        }
        if ((y>0) & (Image8Pixel(Image,x,y-1)>0))
        {
          SetImage8Pixel(Image,x,y-1,0);
          Point.x=x;  Point.y=y-1;
          PomList.push_back(Point);
        }
        if ((x>0) && (Image8Pixel(Image,x-1,y)>0))
        {
          SetImage8Pixel(Image,x-1,y,0);
          Point.x=x-1;  Point.y=y;
          PomList.push_back(Point);
        }
        if ((x<Image->XSize-1) && (Image8Pixel(Image,x+1,y)>0))
        {
          SetImage8Pixel(Image,x+1,y,0);
          Point.x=x+1;  Point.y=y;
          PomList.push_back(Point);
        }
     }
     Object->CentreX=Object->CentreX/Object->PixelList.size();
     Object->CentreY=Object->CentreY/Object->PixelList.size();
     Object->Sum=Object->PixelList.size();
     // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     // compute the values of the covariance matrix
     double kov11=0;
     double kov12=0;
     double kov21=0;
     double kov22=0;
     float sx=(Object->MaxX-Object->MinX)/2.0;
     float sy=(Object->MaxY-Object->MinY)/2.0;
   t_PositionList::iterator bi=Object->PixelList.begin(), ei=Object->PixelList.end();
   if ((sx>0) && (sy>0))
   for (; bi != ei; ++bi)
   {
      // first we must normalize the point position 0-1
      float x=(bi->x-Object->CentreX);
      float y=(bi->y-Object->CentreY);
      kov11=kov11+x*x;
      kov12=kov12+x*y;
      kov22=kov22+y*y;
   }
      Object->kov11=kov11/(float)Object->PixelList.size();
      Object->kov12=kov12/(float)Object->PixelList.size();
      Object->kov21=Object->kov12;
      Object->kov22=kov22/(float)Object->PixelList.size();
   //  Object->PixelList.clear();
  }
