//---------------------------------------------------------------------------

#pragma hdrstop                               
#include <inifiles.hpp>

#include "Unit1.h"
#include "ImageFil.h"
#include <string.h>
#include "lib\reclib.h"
#include "lib\ellipse.h"
#include "..\AVFile\Include\dsfile.h"
#include "..\libxml\tree.h"
#include "..\AVFile\Include\avifile.h"
#include "..\AVFile\Include\bmpfile.h"
#include "lib\StampText.h"
#include "lib\imageproc.h"
#include "src\colorhsv.h"
#include "directioncircle.h"
#include "MyImageFun.cpp"
#include "gausscolor.h"
#include "background.h"



//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ImageControl"
#pragma link "GraphicsListControl"

#pragma link "ZoomPanel"
#pragma resource "*.dfm"
TForm1 *Form1;
TDSFile av1;
//TAVIFile av1;
TAVIFile av2;              // files with AVI sequence
TBMPFile bmp;
int Xr1, Yr1, Xr2, Yr2;         // window for face coordinate

c_ColorDetect   ColClass;
c_SearchObjects SearchObjects;
c_Tracking      Track;           // Class for tracking service
t_ObjectFrame   FrameObjects;    // Storage class for objects
t_KalmanList    SolutionKalmLst;  // result of choosed trajectories
long Tick;
int FromFrame;                  // first frame of the tracking
ObjectClassify     Classifier; // list of recognizers for each person
bool Stoped;                    // variable for determine stop of tracking
EllipseFit      *FitEllipse;     // class for ellipse fitting
c_ColorDetectHSV HSVmodel;
bool ImVid;
long timedur;                   // time duration of the computation
pdCircleDetect HeadDet;            // ellipse head detector
TBackground *Background;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}

void TForm1::ResizeRGBImage(TImageControl * Image, int XSize, int YSize)
{
   DeleteImage(Image->Image);
   Image->Image=NewImageRGB(XSize,YSize);
}

void TForm1::ResizeImage8(TImageControl * Image, int XSize, int YSize)
{
   DeleteImage(Image->Image);
   Image->Image=NewImage8(XSize,YSize);
}


void MouthDetection(ImageStruct *Input, s_Object *Object, double Tres)
{
  if (Object->Mouth)
  {
    int XSize,YSize,SXStep,DXStep;
    int i,j;
    c_ColorDetect CDet;
    int minx = (int)(Object->eye1x+Object->eye4x)/2;
    int maxx = (int)(Object->eye2x+Object->eye3x)/2;
    int miny = (int)(Object->eye1y+Object->eye2y)/2;
    int maxy = (int)(Object->eye4y+Object->eye3y)/2;

    for (j = miny;j<maxy;++j)
    {
      for (i = minx;i<maxx;++i)
      {
        unsigned char r=ImageRGBPixelR(Input,i,j);
        unsigned char g=ImageRGBPixelG(Input,i,j);
        unsigned char b=ImageRGBPixelB(Input,i,j);

        double prob=ColClass.IsSkin(r,g,b);
        // if not skin color
        if (prob<Tres)
          CDet.AddColor(r,g,b);
      }
    }
    CDet.Compute();
//    Object->MouthSum=CDet.GetSize();
    Object->AvgR=CDet.avg1;
    Object->AvgB=CDet.avg2;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
   ColClass.Compute();
  // ColClass.ComputeMatrix();
   Label22->Caption=FloatToStrF(ColClass.avg1,ffNumber,5,3);
   Label23->Caption=FloatToStrF(ColClass.avg2,ffNumber,5,3);

   Label30->Caption=FloatToStrF(sqrt(ColClass.kov11),ffNumber,5,3);
   Label31->Caption=FloatToStrF(sqrt(ColClass.kov22),ffNumber,5,3);


   StringGrid1->Cells[0][0]=FloatToStrF(ColClass.kov11,ffNumber,7,5);
   StringGrid1->Cells[0][1]=FloatToStrF(ColClass.kov12,ffNumber,7,5);
   StringGrid1->Cells[1][0]=FloatToStrF(ColClass.kov12,ffNumber,7,5);
   StringGrid1->Cells[1][1]=FloatToStrF(ColClass.kov22,ffNumber,7,5);

   RadioButton2->Checked=True;        
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button4Click(TObject *Sender)
{
   // Delete all skin pixels
   Label22->Caption="0";
   Label23->Caption="0";
   Edit2->Text="";
   Label5->Caption="0";
   RadioButton1->Checked=True;
   ColClass.ClearList();
}
//---------------------------------------------------------------------------


void TForm1::DrawColor(unsigned long Color)
{   // draw rectangle with picked color
    int i,j;
    for (i=0; i<Image3->Width; i++)
       for (j=0; j<Image3->Height; j++)
       {
          SetImageRGBPixelRGB(Image3->Image,i,j,Color);
       }
    Image3->Invalidate();
}

void __fastcall TForm1::Button5Click(TObject *Sender)
{
   if (!ImVid)
      GetFrame(TrackBar1->Position);
   else
     ImageInput->AutoLoad = OpenDialog2->FileName;  ImageOutput->Visible=true;
  ImageDemo->Visible=false;
  if (RadioButton5->Checked)
    ColClass.SkinBackDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  if (RadioButton6->Checked)
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);
  if (RadioButton7->Checked)
    HSVmodel.SkinDetection(ImageInput->Image,ImageOutput->Image);
  ImageOutput->Invalidate();
}
//---------------------------------------------------------------------------



void __fastcall TForm1::ScrollBar1Change(TObject *Sender)
{
  Label6->Caption=ScrollBar1->Position/10.0;
}
//---------------------------------------------------------------------------


void ResizeImage(TImageControl * Image, int XSize, int YSize)
{
   if (Image->Image!=NULL)
      DeleteImage(Image->Image);
   Image->Image = NULL;
   Image->Image=NewImageRGB(XSize,YSize);
}

void ResizeImage8(TImageControl * Image, int XSize, int YSize)
{
   if (Image->Image!=NULL)
      DeleteImage(Image->Image);
   Image->Image = NULL;
   Image->Image=NewImage8(XSize,YSize);
}

void __fastcall TForm1::OpenImage1Click(TObject *Sender)
{
   if (OpenDialog2->Execute())
   {
      ImVid=true;
      ImageInput->Image = CreateImageFile(OpenDialog2->FileName.c_str(),0,NULL,NULL);
//      ResizeImage(ImageInput, ImageXSize(ImageInput->Image), ImageYSize(ImageInput->Image));
      Edit1->Text=OpenDialog2->FileName;
      // set size object treshold
     ResizeImage8(ImageOutput, ImageInput->Image->XSize, ImageInput->Image->YSize);
     ResizeImage(ImageDemo, ImageInput->Image->XSize, ImageInput->Image->YSize);

      Edit4->Text=IntToStr(int(ImageInput->Image->XSize*ImageInput->Image->YSize*(TrackBar2->Position/1000.0)));
     ZoomInput->ClientRatio = (double)ImageXSize(ImageInput->Image)/ImageYSize(ImageInput->Image);
     ZoomInput->Reset();
     ZoomOutput->ClientRatio = (double)ImageXSize(ImageOutput->Image)/ImageYSize(ImageOutput->Image);
     ZoomOutput->Reset();

   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Exit1Click(TObject *Sender)
{
   Application->Terminate();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Load1Click(TObject *Sender)
{
   if (OpenDialog1->Execute())
   {
     if (ColClass.LoadColors(OpenDialog1->FileName.c_str())!=NULL)
     {
        Label5->Caption=IntToStr(ColClass.GetSize());
        Button3Click(Sender);
        Edit2->Text=ExtractFileName(OpenDialog1->FileName);
        StatusBar1->SimpleText="Color data "+OpenDialog1->FileName+" is loaded.";
        // Application->MessageBox("Color data is loaded !","Load skin color pixels", MB_OK);
     }
     else
       Application->MessageBox("Error while loading color data !","Error", MB_OK);
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Save1Click(TObject *Sender)
{
   if (SaveDialog1->Execute())
   {
     if (ColClass.SaveColors(ChangeFileExt(SaveDialog1->FileName,".col").c_str())!=NULL)
     {
        Edit2->Text=ExtractFileName(SaveDialog1->FileName);
        Application->MessageBox("Color data was saved !","Save skin color pixels", MB_OK);
     }
     else
       Application->MessageBox("Error while saving color data !","Error", MB_OK);
   }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Extraction1Click(TObject *Sender)
{ // extract skin color from white background
  int XSize = ImageXSize(ImageInput->Image);
  int YSize = ImageYSize(ImageInput->Image);
  ColClass.ClearList();
  for (int j = 0;j<YSize;++j)
  {
    unsigned long * Src = &ImageRGBPixelRGB(ImageInput->Image,0,j);
    for (int i = 0;i<XSize;++i)
    {
      unsigned char r=ImageRGBPixelR(ImageInput->Image,i,j);
      unsigned char g=ImageRGBPixelG(ImageInput->Image,i,j);
      unsigned char b=ImageRGBPixelB(ImageInput->Image,i,j);
      if ((r<250) && (g<250) && (b<250))
      if ((r>0) && (g>0) && (b>0))      
        ColClass.AddColor(r,g,b);
    }
  }
  Label5->Caption=IntToStr(ColClass.GetSize());
}
//---------------------------------------------------------------------------

void TForm1::GetFrame(unsigned int frame)
{
    av1.Seek(frame);
    av1.DLGetFrame(ImageInput->Image);
    ImageInput->Invalidate();
}

void __fastcall TForm1::OpenVideo1Click(TObject *Sender)
{
   if (OpenDialog3->Execute())
   {

     av1.Open(OpenDialog3->FileName.c_str(), TAVFile::omRead, TAVFile::otVideo);
     TAVFile::TFrameInfo FrameInfo = av1.GetFrameInfo();
     TrackBar1->Max=av1.GetVideoLength()-1;
     Label14->Caption=av1.GetVideoLength()-1;
     // pro ukladani obrazku
     bmp.Close();
     TAVFile::TFrameInfo FrameInfoBMP;
     FrameInfoBMP.Width=64;
     FrameInfoBMP.Height=64;
     bmp.SetFrameInfo(FrameInfoBMP);
     bmp.Open(OpenDialog3->FileName.c_str(), TAVFile::omWrite, TAVFile::otVideo);
     Edit1->Text=OpenDialog3->FileName;
     ResizeImage(ImageInput, FrameInfo.Width, FrameInfo.Height);
     ResizeImage8(ImageOutput, FrameInfo.Width, FrameInfo.Height);
     ResizeImage(ImageDemo, FrameInfo.Width, FrameInfo.Height);

     // set size object treshold
     Edit4->Text=IntToStr(int(ImageInput->Image->XSize*ImageInput->Image->YSize*(TrackBar2->Position/1000.0)));
     GetFrame(TrackBar1->Position);
     StatusBar1->SimpleText="Video file "+OpenDialog3->FileName+" is open.";
     ZoomInput->ClientRatio = (double)ImageXSize(ImageInput->Image)/ImageYSize(ImageInput->Image);
     ZoomInput->Reset();
     ZoomOutput->ClientRatio = (double)ImageXSize(ImageOutput->Image)/ImageYSize(ImageOutput->Image);
     ZoomOutput->Reset();
     ImVid=false;
     ColClass.InitBackground(ImageInput->Image);
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
   if (!OpenDialog3->FileName.IsEmpty())
      GetFrame(TrackBar1->Position);
   TrackBar1->Hint=IntToStr(TrackBar1->Position);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBar2Change(TObject *Sender)
{
   Edit4->Text=IntToStr(int(ImageInput->Image->XSize*ImageInput->Image->YSize*(TrackBar2->Position/1000.0)));
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  Screen->Cursor=crHourGlass;
  ImageOutput->Visible=false;
  ImageDemo->Visible=true;
   if (!ImVid)
      GetFrame(TrackBar1->Position);
   else
     ImageInput->AutoLoad = OpenDialog2->FileName;
  if (RadioButton5->Checked)
    ColClass.SkinDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  if (RadioButton6->Checked)
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);
  if (RadioButton7->Checked)
    HSVmodel.SkinDetection(ImageInput->Image,ImageOutput->Image);
  ImageStruct *Image=NewImage8(ImageOutput->Image->XSize,ImageOutput->Image->YSize);
  for (int i=0; i<ScrollBar2->Position; i++)
  { Dilate(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  for (int i=0; i<ScrollBar2->Position; i++)
  { Erode(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  DeleteImage(Image);
   Edit3->Text=IntToStr(SearchObjects.Search(ImageOutput->Image,Edit4->Text.ToInt()));
   s_Object *Object=SearchObjects.GetFirst();
   ComboBox4->Clear();
   ImageFill(ImageDemo->Image,0);
   for (int i=0; i<SearchObjects.GetSize(); i++)
   {
      DrawObject(&Object->PixelList);
      DrawInfoObject(Object, clWhite);
      ComboBox4->Items->Add(IntToStr(i));
      Object=SearchObjects.GetNext();
   }
   ComboBox4->ItemIndex=0;
   Screen->Cursor=crDefault;

}
//---------------------------------------------------------------------------



void TForm1::DDALine(ImageStruct *Image, int sx, int sy, int ex, int ey)
{
  if ((sx<Image->XSize) && (sx>=0) && (sy>=0) && (sy<Image->YSize))
  if ((ex<Image->XSize) && (ex>=0) && (ey>=0) && (ey<Image->YSize))
  {
          int bx, by, pocet_bodu;
          double kx, ky, x, y;
          bx = ex - sx;
    by = ey - sy;
    pocet_bodu = (abs(bx) > abs(by))?abs(bx):abs(by);

    kx = double(bx) / pocet_bodu;
    ky = double(by) / pocet_bodu;
    x = sx;
    y = sy;

    for (int i = 0; i < pocet_bodu; i++) {
          SetImageRGBPixelRGB(Image,(int)x,(int)y,clYellow);
          x += kx;
      y += ky;
    }
  }
}

void TForm1::DrawObject(t_PositionList *List)
{
   t_PositionList::iterator bi = List->begin(), ei = List->end();
   for (; bi != ei; ++bi)
   {
      SetImageRGBPixelRGB(ImageDemo->Image,int(bi->x),int(bi->y),ImageRGBPixelRGB(ImageInput->Image,int(bi->x),int(bi->y)));
   }
   ImageDemo->Visible=true;
   ImageOutput->Visible=false;

   ImageDemo->Invalidate();
}

void TForm1::DrawRectangle(int a, int b, int c, int d, long Color, int Nr)
{
   for (int i=a; i<c; i++)
   {
     SetImageRGBPixelRGB(ImageInput->Image,i,b,Color);
     SetImageRGBPixelRGB(ImageInput->Image,i,d,Color);
     // twice bordered rect
     SetImageRGBPixelRGB(ImageInput->Image,i,b+1,Color-0x222222);
     SetImageRGBPixelRGB(ImageInput->Image,i,d-1,Color-0x222222);

   }

   for (int j=b; j<d; j++)
   {
     SetImageRGBPixelRGB(ImageInput->Image,a,j,Color);
     SetImageRGBPixelRGB(ImageInput->Image,c,j,Color);
     // twice bordered rect
     SetImageRGBPixelRGB(ImageInput->Image,a+1,j,Color-0x222222);
     SetImageRGBPixelRGB(ImageInput->Image,c-1,j,Color-0x222222);

   }

   AnsiString Text="Object "+IntToStr(Nr);
   StampText(ImageInput->Image,a,b-30, Text.c_str(),0);
   ImageInput->Invalidate();
}

AnsiString TForm1::GetInfoText(s_Object *Object)
{
   AnsiString Text;
   if (Object->head)
     Text="Head";
   if (Object->Face)
     Text="Face";
   else
   if (Object->hand)
     Text="Hand";
   return Text;
}

AnsiString TForm1::GetPersonText(s_Object *Object)
{
   AnsiString Person;
#ifdef _WIN32
   Person=Object->Person;
#else
   if (Object->Person.length()>0)
      Person=AnsiString(Object->Person.c_str(),Object->Person.length());
#endif
   return Person;
}

AnsiString TForm1::GetFaceText(s_Object *Object)
{
   AnsiString Person;
#ifdef _WIN32
   Person=Object->Specific+" ";
#else
   if (Object->Face)
      Person=AnsiString(Object->Specific.c_str(),Object->Specific.length())+" ";
#endif
   return Person;
}


void TForm1::DrawInfoObject(s_Object *Object, long Color)
{
   int a=Object->MinX;
   int b=Object->MinY;
   int c=Object->MaxX;
   int d=Object->MaxY;
   FitEllipse->Compute(Object);
   FitEllipse->Draw(ImageInput->Image);
   if (Object->Face) {
      DDALine(ImageInput->Image,Object->face1x,Object->face1y,Object->face2x,Object->face2y);
      DDALine(ImageInput->Image,Object->face2x,Object->face2y,Object->face3x,Object->face3y);
      DDALine(ImageInput->Image,Object->face3x,Object->face3y,Object->face4x,Object->face4y);
      DDALine(ImageInput->Image,Object->face4x,Object->face4y,Object->face1x,Object->face1y);
   }
   if (Object->Eyes) {
      DDALine(ImageInput->Image,Object->eye1x,Object->eye1y,Object->eye2x,Object->eye2y);
      DDALine(ImageInput->Image,Object->eye2x,Object->eye2y,Object->eye3x,Object->eye3y);
      DDALine(ImageInput->Image,Object->eye3x,Object->eye3y,Object->eye4x,Object->eye4y);
      DDALine(ImageInput->Image,Object->eye4x,Object->eye4y,Object->eye1x,Object->eye1y);
   }
   if (Object->Mouth) {
      DDALine(ImageInput->Image,Object->mouth1x,Object->mouth1y,Object->mouth2x,Object->mouth2y);
      DDALine(ImageInput->Image,Object->mouth2x,Object->mouth2y,Object->mouth3x,Object->mouth3y);
      DDALine(ImageInput->Image,Object->mouth3x,Object->mouth3y,Object->mouth4x,Object->mouth4y);
      DDALine(ImageInput->Image,Object->mouth4x,Object->mouth4y,Object->mouth1x,Object->mouth1y);
   }
   if (Rec_Check->Checked)
   for (int i=a; i<c; i++)
   {
     SetImageRGBPixelRGB(ImageInput->Image,i,b,Color);
     SetImageRGBPixelRGB(ImageInput->Image,i,d,Color);
     // twice bordered rect
     SetImageRGBPixelRGB(ImageInput->Image,i,b+1,Color-0x222222);
     SetImageRGBPixelRGB(ImageInput->Image,i,d-1,Color-0x222222);
   }
   if (Rec_Check->Checked)
   for (int j=b; j<d; j++)
   {
     SetImageRGBPixelRGB(ImageInput->Image,a,j,Color);
     SetImageRGBPixelRGB(ImageInput->Image,c,j,Color);
     // twice bordered rect
     SetImageRGBPixelRGB(ImageInput->Image,a+1,j,Color-0x222222);
     SetImageRGBPixelRGB(ImageInput->Image,c-1,j,Color-0x222222);

   }
   AnsiString Text=GetPersonText(Object)+" - "+GetFaceText(Object)+GetInfoText(Object);
   StampText(ImageInput->Image,a-Text.Length(),b-30, Text.c_str(),0);
   ImageInput->Invalidate();
}


void TForm1::FillObjectList()
{
   int i=0;
   ComboBox3->Clear();
   t_KalmanList::iterator bi = Track.ActiveKalmLst.begin(), ei = Track.ActiveKalmLst.end();
   for (; bi != ei; bi++)
   {
       s_KalmanObject *KalmObject=&(*bi);
       s_Object *Object=KalmObject->GetLastObject();
       if (!Object->Person.IsEmpty())
         ComboBox3->Items->Add(AnsiString(Object->Person.c_str(),Object->Person.Length()));
       else
         if (Object->hand)
           ComboBox3->Items->Add("Hand "+IntToStr(i));
         else
           ComboBox3->Items->Add("Object "+IntToStr(i));
       i++;
   }
}
//---------------------------------------------------------------------------


void TForm1::InitTrack(int frame, double Error, double Diver)
{
   // load picture
  Screen->Cursor=crHourGlass;
   TrackBar1->Position=frame;
   // skin detection
  if (RadioButton5->Checked)
    ColClass.SkinDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  if (RadioButton6->Checked)
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);
  if (RadioButton7->Checked)
    HSVmodel.SkinDetection(ImageInput->Image,ImageOutput->Image);
  ImageStruct *Image=NewImage8(ImageOutput->Image->XSize,ImageOutput->Image->YSize);
  for (int i=0; i<ScrollBar2->Position; i++)
  { Dilate(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  for (int i=0; i<ScrollBar2->Position; i++)
  { Erode(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  DeleteImage(Image);
   // search skin tracked objects
   Edit3->Text=IntToStr(SearchObjects.Search(ImageOutput->Image,Edit4->Text.ToInt()));
//   if (!CheckBox2->Checked)
      Classifier.RecognizeTwoPerson(&SearchObjects,ImageInput->XSize,ImageInput->YSize);
   Track.Error=Error;               // odchylka v pixelech
   Track.Divergence=Diver;
   FrameObjects.clear();
   // IDIAP procedure for determination hands and faces
   PushFrameObject(&FrameObjects,&SearchObjects.ObjectList);
   Track.InitTracing(&FrameObjects);
   FillComboBox(Track.ActiveLstSize(),ComboBox1,Edit9);
   FillComboBox(Track.StopLstSize(),ComboBox2,Edit10);
   SolutionKalmLst.clear();
   // all object are classified for mouth and eyes
   GetFloatFrame(TrackBar1->Position);
   // choose the best recognizer and determine position of eyes and mouth
  // if (CheckBox2->Checked)
      Classifier.InitClassify(&Track.ActiveKalmLst,ImageFlt->Image);
   // draw info rectangles around searched areas
   t_KalmanList::iterator bi = Track.ActiveKalmLst.begin(), ei = Track.ActiveKalmLst.end();
   for (; bi != ei; bi++)
   {
      bool extrapol;
      s_KalmanObject *KalmObject=&(*bi);
      DrawInfoObject(KalmObject->GetLastObject(), clWhite);
   }
   Screen->Cursor=crDefault;
   FromFrame=TrackBar1->Position;
}

void TForm1::TrackFrame(int frame)
{
  Screen->Cursor=crHourGlass;
   // get frame from avi
   TrackBar1->Position=frame;
   // skin detection
  if (RadioButton5->Checked)
    ColClass.SkinDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  if (RadioButton6->Checked)
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);
  if (RadioButton7->Checked)
    HSVmodel.SkinDetection(ImageInput->Image,ImageOutput->Image);
  ImageStruct *Image=NewImage8(ImageOutput->Image->XSize,ImageOutput->Image->YSize);
  for (int i=0; i<ScrollBar2->Position; i++)
  { Dilate(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  for (int i=0; i<ScrollBar2->Position; i++)
  { Erode(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  DeleteImage(Image);
   // search skin tracked objects
   Edit3->Text=IntToStr(SearchObjects.Search(ImageOutput->Image,Edit4->Text.ToInt()));
//   if (!CheckBox2->Checked)
      Classifier.RecognizeTwoPerson(&SearchObjects,ImageInput->XSize,ImageInput->YSize);
   // save finded objects
   PushFrameObject(&FrameObjects,&SearchObjects.ObjectList);
   Track.TraceFrame(&FrameObjects);
   FillComboBox(Track.ActiveLstSize(),ComboBox1,Edit9);
   FillComboBox(Track.StopLstSize(),ComboBox2,Edit10);
   // all object are classified for mouth and eyes
   GetFloatFrame(TrackBar1->Position);
//   if (CheckBox2->Checked)
         Classifier.TrackClassify(&Track.ActiveKalmLst,ImageFlt->Image);
   t_KalmanList::iterator bi = Track.ActiveKalmLst.begin(), ei = Track.ActiveKalmLst.end();
   for (; bi != ei; bi++)
   {
      s_KalmanObject *KalmObject=&(*bi);
    //  Classifier.RecognizeFace(KalmObject, ImageFlt->Image);
    //  MouthDetection(ImageInput->Image, KalmObject->GetLastObject(), (double)ScrollBar1->Position/1000.0);
      s_Object *Object=KalmObject->GetLastObject();
      DrawInfoObject(Object, clWhite);
   }
  Screen->Cursor=crDefault;
}

void TForm1::FillComboBox(int size,TComboBox *ComboBox,TEdit *Edit)
{
    int i=0,pos=ComboBox->ItemIndex;
    ComboBox->Clear();
    for (i=1; i < size+1; i++)
    {
      ComboBox->Items->Add(IntToStr(i));
    }
    if (pos<0)
       ComboBox->ItemIndex=0;
    else
       ComboBox->ItemIndex=pos;
    if (pos>size-1)
       ComboBox->ItemIndex=size-1;
    Edit->Text=IntToStr(size);
}

void __fastcall TForm1::Button9Click(TObject *Sender)
{
  Edit5->Text="0";
  Edit6->Text="0";
  Edit9->Text="0";
  Edit10->Text="0";
  Edit13->Text="0";
  Edit14->Text="0";
  Edit15->Text="0";
  Edit16->Text="0";
  ListBox3->Clear();
  ListBox4->Clear();
  ListBox5->Clear();
  ListBox6->Clear();
  FromFrame=TrackBar1->Position;
  InitTrack(TrackBar1->Position, Edit8->Text.ToDouble(), Edit7->Text.ToDouble());
  FillObjectList();
  
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button8Click(TObject *Sender)
{
   // demonstrate choosen active trajectory
   s_KalmanObject *KalmObj=Track.GetActiveObject(ComboBox1->ItemIndex);
   bool Extrapol;
   for (int i=KalmObj->BeginFrame+FromFrame; i<=KalmObj->EndFrame+FromFrame; i++)
   {
      s_Object Object;
      KalmObj->GetObject(i, Object);
      TrackBar1->Position=i;
      if (Extrapol)
        DrawInfoObject(&Object, clRed);
      else
        DrawInfoObject(&Object, clWhite);
      Application->ProcessMessages();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button7Click(TObject *Sender)
{
   // demonstrate choosen stoped trajectory
   s_KalmanObject *KalmObj=Track.GetStopedObject(ComboBox2->ItemIndex);
   bool Extrapol;                                                          
   for (int i=KalmObj->BeginFrame+FromFrame; i<=KalmObj->EndFrame+FromFrame; i++)
   {
      s_Object Object;
      KalmObj->GetObject(i, Object);
      TrackBar1->Position=i;
      if (Extrapol)
        DrawInfoObject(&Object, clRed);
//        DrawRectangle(Object.MinX,Object.MinY,Object.MaxX,Object.MaxY,clBlue, ComboBox2->ItemIndex);
      else
        DrawInfoObject(&Object, clWhite);
//        DrawRectangle(Object.MinX,Object.MinY,Object.MaxX,Object.MaxY,clWhite, ComboBox2->ItemIndex);
      Application->ProcessMessages();
   }

}
//---------------------------------------------------------------------------
void TForm1::FillTrajectory(s_KalmanObject *KalmObj)
{
   ListBox3->Clear();
   ListBox4->Clear();
   t_PointObjectList::iterator bi = KalmObj->PointLst.begin(), ei = KalmObj->PointLst.end();
   for (; bi != ei; ++bi)
   {
      s_Object *Obj=*bi;
        ListBox3->Items->AddObject(FloatToStr(Obj->CentreX),(TObject*)Obj);
        ListBox4->Items->AddObject(FloatToStr(Obj->CentreY),(TObject*)Obj);
   }
    int pos=ComboBox1->ItemIndex;
    if (Track.ActiveLstSize()<pos+1)
        pos=Track.ActiveLstSize();
   TrackBar1->Position=KalmObj->BeginFrame;
   Edit5->Text=IntToStr(KalmObj->EndFrame-KalmObj->BeginFrame+1);
   Edit13->Text=IntToStr(KalmObj->BeginFrame);
   Edit14->Text=IntToStr(KalmObj->EndFrame);
   int i=KalmObj->BeginFrame;
    s_Object Object;
    KalmObj->GetObject(i, Object);
    TrackBar1->Position=i;
    DrawInfoObject(&Object, clWhite);
   Application->ProcessMessages();
}

void TForm1::FillTrajectoryStoped(s_KalmanObject *StopKalmObj)
{
   ListBox5->Clear();
   ListBox6->Clear();
   t_PointObjectList::iterator bi = StopKalmObj->PointLst.begin(), ei = StopKalmObj->PointLst.end();

   for (; bi != ei; ++bi)
   {
      s_Object *Obj=*bi;
        ListBox5->Items->AddObject(FloatToStr(Obj->CentreX),(TObject*)Obj);
        ListBox6->Items->AddObject(FloatToStr(Obj->CentreY),(TObject*)Obj);
   }
   TrackBar1->Position=StopKalmObj->BeginFrame;
   Edit6->Text=IntToStr(StopKalmObj->EndFrame-StopKalmObj->BeginFrame+1);
   Edit15->Text=IntToStr(StopKalmObj->BeginFrame);
   Edit16->Text=IntToStr(StopKalmObj->EndFrame);
   bool Extrapol;
   int i=StopKalmObj->BeginFrame;
    s_Object Object;
    StopKalmObj->GetObject(i, Object);
    TrackBar1->Position=i;
    DrawInfoObject(&Object, clWhite);
   Application->ProcessMessages();
}

void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
   if (ComboBox1->ItemIndex>=0)
   {
     FillTrajectory(Track.GetActiveObject(ComboBox1->ItemIndex));
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox2Change(TObject *Sender)
{
   if (ComboBox2->ItemIndex>=0)
   {
     FillTrajectoryStoped(Track.GetStopedObject(ComboBox2->ItemIndex));
   }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button10Click(TObject *Sender)
{
   TrackBar1->Position++;
   TrackFrame(TrackBar1->Position);
   FillObjectList();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox1Enter(TObject *Sender)
{
   if (ComboBox1->ItemIndex>=0)
   {
     FillTrajectory(Track.GetActiveObject(ComboBox1->ItemIndex));
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button11Click(TObject *Sender)
{
   Edit12->Text="0";
   Stoped=!Stoped;
   if (Stoped)
   {
     Button11->Caption="Tracking";
     Screen->Cursor=crDefault;
     return;
   }else
   {
     Button11->Caption="STOP";
   }
   FromFrame=TrackBar1->Position;
   InitTrack(TrackBar1->Position, Edit8->Text.ToDouble(), Edit7->Text.ToDouble());

   int i=0, kl=0;
   long array[10],msec, start, t=GetTickCount();
   memset(array,0,sizeof(array));
   int point=0;
   start=t;
   while ((!Stoped) && (TrackBar1->Position<TrackBar1->Max))
   {
      TrackBar1->Position++;
      i++;
      TrackFrame(TrackBar1->Position);
      Tick=t;
      t=GetTickCount();
      array[point]=(t-Tick);
      if (point==9)
      {
        point=0;
      }
      else
        point++;
      if (kl<10) kl++;
      msec=0;
      for (int k=0; k<10; k++)
         msec=msec+array[k];
      msec=msec/kl;
      float fps=1000.0/(t-Tick);
      msec=msec*(TrackBar1->Max-TrackBar1->Position);
      int hour=msec/3600000;
      int min=(msec-hour*3600000)/60000;
      Form1->Caption="Actual Frame "+IntToStr(i)+" - FPS "+FloatToStrF(fps,ffFixed,5,2)+" - Remain Time "+IntToStr(hour)+":"+((min<10)?"0":"")+IntToStr(min);
      Application->ProcessMessages();
   }
   timedur=GetTickCount()-start;        // msec
   if (TrackBar1->Position==TrackBar1->Max)
      Stoped=true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button20Click(TObject *Sender)
{
  if (SaveDialog2->Execute())
  {
    SaveAVIXML(SaveDialog2->FileName, timedur);
//    SaveMouthStat("Mouth.sta", FromFrame, TrackBar1->Position);
//    SaveHeadsOrientation("headpose.sta", FromFrame, TrackBar1->Position);
  }
}

void TForm1::SaveAVIXML(AnsiString FileName, long CompTime)
{   // saving tracked data from objects   - IDIAP
    av2.Close();
    xmlDocPtr doc = xmlNewDoc("1.0");
    if (doc == NULL)
    {
       MessageBox (HWND_DESKTOP, "Couldn't create xml document", "Error", MB_OK | MB_ICONEXCLAMATION);
       return ;
    }
    xmlNodePtr root = xmlNewDocNode(doc, NULL, "AVEvents", NULL);
    if (root == NULL)
    {
       xmlFreeDoc(doc);
       MessageBox (HWND_DESKTOP, "Couldn't create xml document", "Error", MB_OK | MB_ICONEXCLAMATION);
       return ;
    }
    xmlDocSetRootElement(doc, root);
    if (CheckBox1->Checked)
    {
      av2.SetFrameInfo(av1.GetFrameInfo());
      av2.Open(ChangeFileExt(FileName,".avi").c_str(),TAVFile::omWrite, TAVFile::otVideo);
    }

    xmlNodePtr events = xmlNewChild(root, NULL, "Events", NULL);
    int i=0;
    // description several tracked parts
    xmlNodePtr event = xmlNewChild(events, NULL, "Name", "Head");
    xmlSetProp(event, "ID", "0");
    event = xmlNewChild(events, NULL, "Name", "Hand");
    xmlSetProp(event, "ID", "1");
    event = xmlNewChild(events, NULL, "Name", "Eye");
    xmlSetProp(event, "ID", "2");
    event = xmlNewChild(events, NULL, "Name", "Mouth");
    xmlSetProp(event, "ID", "3");
    event = xmlNewChild(events, NULL, "Name", "Face");
    xmlSetProp(event, "ID", "4");
    event = xmlNewChild(events, NULL, "Name", "Nonspecified");
    xmlSetProp(event, "ID", "5");
    xmlNodePtr times = xmlNewChild(root, NULL, "File", NULL);
    xmlNodePtr copyright = xmlNewChild(times, NULL, "Process", "Tracking system [Potucek, Spanel] 2003-2004 BUT, Czech Republic");
    xmlSetProp(copyright, "Date", DateToStr(Date()).c_str());
    xmlSetProp(copyright, "Time", TimeToStr(Time()).c_str());
    char s[255];
    int sec=CompTime/1000.0;
    int hour=sec/3600000;
    int min=(sec-hour*3600000)/60.0;
    sec=sec-hour*3600000-min*60;
    sprintf(s,"%2d:%2d:%2d",hour,min,sec);
    xmlSetProp(copyright, "Duration", s);
    // write list of recognizers with number of detected frames
    xmlNodePtr statistic = xmlNewChild(times, NULL, "Statistic", "");
    AnsiString cam=ExtractFileName(Edit1->Text).SubString(4,1);
    xmlNodePtr videosrc = xmlNewChild(times, NULL, "Source", ExtractFileName(Edit1->Text).c_str());
    xmlSetProp(videosrc, "Camera", cam.c_str());
    xmlNodePtr format = xmlNewChild(times, NULL, "TimeFormat", "Frames");
    Classifier.EndClassify(&SolutionKalmLst);
    // save positions of objects
    for (int i=FromFrame; i<TrackBar1->Max+1; i++)
    {
      int ID=0;
      if (CheckBox1->Checked)
        TrackBar1->Position=i;
      t_KalmanList::iterator bii = SolutionKalmLst.begin(), eii = SolutionKalmLst.end();
      for (; bii != eii; ++bii)
      {
         s_Object Object;
        if (bii->GetObject(i, Object))
         {
           xmlNodePtr event = xmlNewChild(times, NULL, "Event", NULL);
           xmlNodePtr eid;
           if (Object.head)
              eid = xmlNewChild(event, NULL, "ID", "0");
           else
           if (Object.hand)
              eid = xmlNewChild(event, NULL, "ID", "1");
           else
              eid = xmlNewChild(event, NULL, "ID", "5");
           xmlNodePtr etime = xmlNewChild(event, NULL, "Time", IntToStr(i).c_str());
           xmlNodePtr param = xmlNewChild(event, NULL, "Parameters", NULL);

           xmlSetProp(param, "Camera", cam.c_str());
           xmlSetProp(param, "Object", IntToStr(ID).c_str());
           xmlSetProp(param, "CenterX", FloatToStr(Object.CentreX).c_str());
           xmlSetProp(param, "CenterY", FloatToStr(Object.CentreY).c_str());
           xmlSetProp(param, "MinX", FloatToStr(Object.MinX).c_str());
           xmlSetProp(param, "MinY", FloatToStr(Object.MinY).c_str());
           xmlSetProp(param, "MaxX", FloatToStr(Object.MaxX).c_str());
           xmlSetProp(param, "MaxY", FloatToStr(Object.MaxY).c_str());
           xmlSetProp(param, "AxisA", FloatToStr(Object.axisA).c_str());
           xmlSetProp(param, "AxisB", FloatToStr(Object.axisB).c_str());
           xmlSetProp(param, "orientation", FloatToStr(Object.orientation).c_str());
           AnsiString Person=GetPersonText(&Object);
           xmlSetProp(param, "Person", Person.c_str());
           if (Object.Eyes)
           {
             xmlNodePtr eyes = xmlNewChild(times, NULL, "Event", NULL);
             xmlNewChild(eyes, NULL, "ID", "2");
             xmlNewChild(eyes, NULL, "Time", IntToStr(i).c_str());
             xmlNodePtr parameyes = xmlNewChild(eyes, NULL, "Parameters", NULL);
             xmlSetProp(parameyes, "Camera", cam.c_str());
             xmlSetProp(parameyes, "Object", IntToStr(ID).c_str());
             xmlSetProp(parameyes, "X1", FloatToStr(Object.eye1x).c_str());
             xmlSetProp(parameyes, "Y1", FloatToStr(Object.eye1y).c_str());
             xmlSetProp(parameyes, "X2", FloatToStr(Object.eye2x).c_str());
             xmlSetProp(parameyes, "Y2", FloatToStr(Object.eye2y).c_str());
             xmlSetProp(parameyes, "X3", FloatToStr(Object.eye3x).c_str());
             xmlSetProp(parameyes, "Y3", FloatToStr(Object.eye3y).c_str());
             xmlSetProp(parameyes, "X4", FloatToStr(Object.eye4x).c_str());
             xmlSetProp(parameyes, "Y4", FloatToStr(Object.eye4y).c_str());
             xmlSetProp(parameyes, "Person", Person.c_str());
           }
           if (Object.Mouth)
           {
             xmlNodePtr mouth = xmlNewChild(times, NULL, "Event", NULL);
             xmlNewChild(mouth, NULL, "ID", "3");
             xmlNewChild(mouth, NULL, "Time", IntToStr(i).c_str());
             xmlNodePtr parammouth = xmlNewChild(mouth, NULL, "Parameters", NULL);
             xmlSetProp(parammouth, "Camera", cam.c_str());
             xmlSetProp(parammouth, "Object", IntToStr(ID).c_str());
             xmlSetProp(parammouth, "X1", FloatToStr(Object.mouth1x).c_str());
             xmlSetProp(parammouth, "Y1", FloatToStr(Object.mouth1y).c_str());
             xmlSetProp(parammouth, "X2", FloatToStr(Object.mouth2x).c_str());
             xmlSetProp(parammouth, "Y2", FloatToStr(Object.mouth2y).c_str());
             xmlSetProp(parammouth, "X3", FloatToStr(Object.mouth3x).c_str());
             xmlSetProp(parammouth, "Y3", FloatToStr(Object.mouth3y).c_str());
             xmlSetProp(parammouth, "X4", FloatToStr(Object.mouth4x).c_str());
             xmlSetProp(parammouth, "Y4", FloatToStr(Object.mouth4y).c_str());
             xmlSetProp(parammouth, "Person", Person.c_str());
           }
           if (Object.Face)
           {
             xmlNodePtr face = xmlNewChild(times, NULL, "Event", NULL);
             xmlNewChild(face, NULL, "ID", "4");
             xmlNewChild(face, NULL, "Time", IntToStr(i).c_str());
             xmlNodePtr paramface = xmlNewChild(face, NULL, "Parameters", NULL);
             xmlSetProp(paramface, "Camera", cam.c_str());
             xmlSetProp(paramface, "Object", IntToStr(ID).c_str());
             xmlSetProp(paramface, "X1", FloatToStr(Object.face1x).c_str());
             xmlSetProp(paramface, "Y1", FloatToStr(Object.face1y).c_str());
             xmlSetProp(paramface, "X2", FloatToStr(Object.face2x).c_str());
             xmlSetProp(paramface, "Y2", FloatToStr(Object.face2y).c_str());
             xmlSetProp(paramface, "X3", FloatToStr(Object.face3x).c_str());
             xmlSetProp(paramface, "Y3", FloatToStr(Object.face3y).c_str());
             xmlSetProp(paramface, "X4", FloatToStr(Object.face4x).c_str());
             xmlSetProp(paramface, "Y4", FloatToStr(Object.face4y).c_str());
             float angle, direction, slope;
             bool is=HeadPose(&Object, angle, direction, slope);
             xmlSetProp(paramface, "angle", FloatToStr(angle).c_str());
             xmlSetProp(paramface, "direction", FloatToStr(direction).c_str());
             xmlSetProp(paramface, "slope", FloatToStr(slope).c_str());
             xmlSetProp(paramface, "Person", Person.c_str());
             xmlSetProp(paramface, "Specification", Object.Specific.c_str());
           }
           if (CheckBox1->Checked)
             DrawInfoObject(&Object, clWhite);
         }
         ID++;
      }
      if (CheckBox1->Checked)
        av2.DLPutFrame(ImageInput->Image);
      Application->ProcessMessages();
    }
    if (!xmlSaveFormatFile(ChangeFileExt(FileName,".xml").c_str(), doc,1)) {
       xmlFreeDoc(doc);
       MessageBox (HWND_DESKTOP, "Couldn't save xml document", "Error", MB_OK | MB_ICONEXCLAMATION);
    }
    else
      StatusBar1->SimpleText="File "+FileName+" was saved.";
    xmlFreeDoc(doc);
    if (CheckBox1->Checked)
      av2.Close();
}

void TForm1::SaveAVIXMLother(AnsiString FileName, long CompTime)
{
    av2.Close();
    xmlDocPtr doc = xmlNewDoc("1.0");
    if (doc == NULL)
    {
       MessageBox (HWND_DESKTOP, "Couldn't create xml document", "Error", MB_OK | MB_ICONEXCLAMATION);
       return ;
    }
    xmlNodePtr root = xmlNewDocNode(doc, NULL, "AVEvents", NULL);
    if (root == NULL)
    {
       xmlFreeDoc(doc);
       MessageBox (HWND_DESKTOP, "Couldn't create xml document", "Error", MB_OK | MB_ICONEXCLAMATION);
       return ;
    }
    xmlDocSetRootElement(doc, root);
    if (CheckBox1->Checked)
    {
      av2.SetFrameInfo(av1.GetFrameInfo());
      av2.Open(ChangeFileExt(FileName,".avi").c_str(),TAVFile::omWrite, TAVFile::otVideo);
    }

    xmlNodePtr events = xmlNewChild(root, NULL, "Events", NULL);
    int i=0;
    // save information about objects
    t_KalmanList::iterator bii = SolutionKalmLst.begin(), eii = SolutionKalmLst.end();
    for (; bii != eii; ++bii)
    {
       xmlNodePtr event = xmlNewChild(events, NULL, "Name", ("Object "+IntToStr(i)).c_str());
       xmlSetProp(event, "ID", IntToStr(i).c_str());
       i++;
    }
    xmlNodePtr times = xmlNewChild(root, NULL, "File", NULL);
    xmlNodePtr copyright = xmlNewChild(times, NULL, "Process", "Tracking system [Potucek, Spanel] 2003-2004 BUT, Czech Republic");
    xmlSetProp(copyright, "Date", DateToStr(Date()).c_str());
    xmlSetProp(copyright, "Time", TimeToStr(Time()).c_str());
    char s[255];
    int sec=CompTime/1000.0;
    int hour=sec/3600000;
    int min=(sec-hour*3600000)/60.0;
    sec=sec-hour*3600000-min*60;
    sprintf(s,"%2d:%2d:%2d",hour,min,sec);
    xmlSetProp(copyright, "Duration", s);
    xmlNodePtr videosrc = xmlNewChild(times, NULL, "Source", ExtractFileName(Edit1->Text).c_str());
    xmlSetProp(videosrc, "Camera", "1");
    xmlNodePtr format = xmlNewChild(times, NULL, "TimeFormat", "Frames");
    // save positions of objects
    for (int i=FromFrame; i<TrackBar1->Max+1; i++)
    {
      int ID=0;
      if (CheckBox1->Checked)
        TrackBar1->Position=i;
      t_KalmanList::iterator bii = SolutionKalmLst.begin(), eii = SolutionKalmLst.end();
      for (; bii != eii; ++bii)
      {
         s_Object Object;
         if (bii->GetObject(i, Object))
         {
           xmlNodePtr event = xmlNewChild(times, NULL, "Event", NULL);
           xmlNodePtr eid = xmlNewChild(event, NULL, "ID", IntToStr(ID).c_str());
           xmlNodePtr etime = xmlNewChild(event, NULL, "Time", IntToStr(i).c_str());
           xmlNodePtr param = xmlNewChild(event, NULL, "Parameters", NULL);
           xmlSetProp(param, "Camera", "1");
           xmlSetProp(param, "CenterX", FloatToStr(Object.CentreX).c_str());
           xmlSetProp(param, "CenterY", FloatToStr(Object.CentreY).c_str());
           xmlSetProp(param, "MinX", FloatToStr(Object.MinX).c_str());
           xmlSetProp(param, "MinY", FloatToStr(Object.MinY).c_str());
           xmlSetProp(param, "MaxX", FloatToStr(Object.MaxX).c_str());
           xmlSetProp(param, "MaxY", FloatToStr(Object.MaxY).c_str());
           xmlSetProp(param, "AxisA", FloatToStr(Object.axisA).c_str());
           xmlSetProp(param, "AxisB", FloatToStr(Object.axisB).c_str());
           xmlSetProp(param, "orientation", FloatToStr(Object.orientation).c_str());
           if (Object.Eyes)
           {
             xmlNodePtr eyes = xmlNewChild(times, NULL, "Event", NULL);
             xmlNewChild(eyes, NULL, "ID", "2");
             xmlNewChild(eyes, NULL, "Time", IntToStr(i).c_str());
             xmlNodePtr parameyes = xmlNewChild(eyes, NULL, "Parameters", NULL);
             xmlSetProp(parameyes, "Camera", "1");
             xmlSetProp(parameyes, "Object", IntToStr(ID).c_str());
             xmlSetProp(parameyes, "X1", FloatToStr(Object.eye1x).c_str());
             xmlSetProp(parameyes, "Y1", FloatToStr(Object.eye1y).c_str());
             xmlSetProp(parameyes, "X2", FloatToStr(Object.eye2x).c_str());
             xmlSetProp(parameyes, "Y2", FloatToStr(Object.eye2y).c_str());
             xmlSetProp(parameyes, "X3", FloatToStr(Object.eye3x).c_str());
             xmlSetProp(parameyes, "Y3", FloatToStr(Object.eye3y).c_str());
             xmlSetProp(parameyes, "X4", FloatToStr(Object.eye4x).c_str());
             xmlSetProp(parameyes, "Y4", FloatToStr(Object.eye4y).c_str());

           }
           if (Object.Mouth)
           {
             xmlNodePtr mouth = xmlNewChild(times, NULL, "Event", NULL);
             xmlNewChild(mouth, NULL, "ID", "3");
             xmlNewChild(mouth, NULL, "Time", IntToStr(i).c_str());
             xmlNodePtr parammouth = xmlNewChild(mouth, NULL, "Parameters", NULL);
             xmlSetProp(parammouth, "Camera", "1");
             xmlSetProp(parammouth, "Object", IntToStr(ID).c_str());
             xmlSetProp(parammouth, "X1", FloatToStr(Object.mouth1x).c_str());
             xmlSetProp(parammouth, "Y1", FloatToStr(Object.mouth1y).c_str());
             xmlSetProp(parammouth, "X2", FloatToStr(Object.mouth2x).c_str());
             xmlSetProp(parammouth, "Y2", FloatToStr(Object.mouth2y).c_str());
             xmlSetProp(parammouth, "X3", FloatToStr(Object.mouth3x).c_str());
             xmlSetProp(parammouth, "Y3", FloatToStr(Object.mouth3y).c_str());
             xmlSetProp(parammouth, "X4", FloatToStr(Object.mouth4x).c_str());
             xmlSetProp(parammouth, "Y4", FloatToStr(Object.mouth4y).c_str());
           }
           if (Object.Face)
           {
             xmlNodePtr face = xmlNewChild(times, NULL, "Event", NULL);
             xmlNewChild(face, NULL, "ID", "4");
             xmlNewChild(face, NULL, "Time", IntToStr(i).c_str());
             xmlNodePtr paramface = xmlNewChild(face, NULL, "Parameters", NULL);
             xmlSetProp(paramface, "Camera", "1");
             xmlSetProp(paramface, "Object", IntToStr(ID).c_str());
             xmlSetProp(paramface, "X1", FloatToStr(Object.face1x).c_str());
             xmlSetProp(paramface, "Y1", FloatToStr(Object.face1y).c_str());
             xmlSetProp(paramface, "X2", FloatToStr(Object.face2x).c_str());
             xmlSetProp(paramface, "Y2", FloatToStr(Object.face2y).c_str());
             xmlSetProp(paramface, "X3", FloatToStr(Object.face3x).c_str());
             xmlSetProp(paramface, "Y3", FloatToStr(Object.face3y).c_str());
             xmlSetProp(paramface, "X4", FloatToStr(Object.face4x).c_str());
             xmlSetProp(paramface, "Y4", FloatToStr(Object.face4y).c_str());
             float angle, direction, slope;
             bool is=HeadPose(&Object, angle, direction, slope);
             xmlSetProp(paramface, "angle", FloatToStr(angle).c_str());
             xmlSetProp(paramface, "direction", FloatToStr(direction).c_str());
             xmlSetProp(paramface, "slope", FloatToStr(slope).c_str());
           }
           if (CheckBox1->Checked)
           {
             FitEllipse->Compute(&Object);
             FitEllipse->Draw(ImageInput->Image);
           }
         }
         ID++;
      }
      if (CheckBox1->Checked)
        av2.DLPutFrame(ImageInput->Image);
      Application->ProcessMessages();
    }
    if (!xmlSaveFormatFile(ChangeFileExt(FileName,".xml").c_str(), doc,1)) {
       xmlFreeDoc(doc);
       MessageBox (HWND_DESKTOP, "Couldn't save xml document", "Error", MB_OK | MB_ICONEXCLAMATION);
    }
    xmlFreeDoc(doc);
    if (CheckBox1->Checked)
      av2.Close();
}


//---------------------------------------------------------------------------

void __fastcall TForm1::ListBox3DrawItem(TWinControl *Control, int Index,
      TRect &Rect, TOwnerDrawState State)
{
  // note that we draw on the listboxs canvas, not on the form
  TCanvas *pCanvas = ((TListBox *)Control)->Canvas;
  pCanvas->FillRect(Rect); // clear the rectangle
  // display the text
  if (((TListBox *)Control)->Items->Objects[Index] == NULL)
     pCanvas->Font->Color = clRed;
  else
     pCanvas->Font->Color = clBlack;

  pCanvas->TextOut(Rect.Left, Rect.Top, ((TListBox *)Control)->Items->Strings[Index]);

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Load2Click(TObject *Sender)
{
    if (SaveDialog2->Execute())
    {
       Edit12->Text="0";
       InitTrack(0, Edit8->Text.ToDouble(), Edit7->Text.ToDouble());
       Application->ProcessMessages();
       for (TrackBar1->Position=1; TrackBar1->Position<TrackBar1->Max; TrackBar1->Position++)
         TrackFrame(TrackBar1->Position);
       Track.GetAllTracks(&SolutionKalmLst, Edit18->Text.ToInt());
       Edit12->Text=IntToStr(SolutionKalmLst.size());
       Application->ProcessMessages();
       SaveAVIXML(SaveDialog2->FileName,timedur);
    }
}
//---------------------------------------------------------------------------

void TForm1::GetFloatFrame(unsigned int frame)
{
   // load frame from avi
   if (!OpenDialog3->FileName.IsEmpty())
   {
      av1.Seek(frame);
      av1.DLGetFrame(ImageFlt->Image);
   }
}

void __fastcall TForm1::Button12Click(TObject *Sender)
{
  if (Background!=NULL) delete Background;
  Background = new TBackground(ImageInput->Image->XSize, ImageInput->Image->YSize, 2);
  Background->update(ImageInput->Image);
  Background->update(ImageInput->Image);
  Background->update(ImageInput->Image);
  Background->update(ImageInput->Image);
  Background->update(ImageInput->Image);
}
//---------------------------------------------------------------------------



void __fastcall TForm1::Button14Click(TObject *Sender)
{
   s_KalmanObject *KalmObj=Track.GetActiveObject(ComboBox1->ItemIndex);
   SolutionKalmLst.push_back(*KalmObj);
   Edit12->Text=IntToStr(SolutionKalmLst.size());        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button15Click(TObject *Sender)
{
   s_KalmanObject *KalmObj=Track.GetStopedObject(ComboBox2->ItemIndex);
   SolutionKalmLst.push_back(*KalmObj);
   Edit12->Text=IntToStr(SolutionKalmLst.size());
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button16Click(TObject *Sender)
{
  ImageStruct *Image=ImageCopy(ImageOutput->Image);
  Dilate(Image, ImageOutput->Image);
  DeleteImage(Image);
  ImageOutput->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button17Click(TObject *Sender)
{
  ImageStruct *Image=ImageCopy(ImageOutput->Image);
  Erode(Image, ImageOutput->Image);
  DeleteImage(Image);
  ImageOutput->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ScrollBar2Change(TObject *Sender)
{
   ScrollBar2->Hint=IntToStr(ScrollBar2->Position);
}
//---------------------------------------------------------------------------



void __fastcall TForm1::Button18Click(TObject *Sender)
{
   Track.GetAllTracks(&SolutionKalmLst, Edit18->Text.ToInt());

   Edit12->Text=IntToStr(SolutionKalmLst.size());
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Load3Click(TObject *Sender)
{
   OpenDialog4->Title="Open data for EYES";
   if (OpenDialog4->Execute())
   {
      Classifier.detector.load(OpenDialog4->FileName.c_str());
      StatusBar1->SimpleText="Classifier data "+OpenDialog4->FileName+" is loaded.";
   }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button19Click(TObject *Sender)
{
  if (ImageSave->Execute())
  {
/*    TBMPFile f;
    f.Open(ImageSave->FileName.c_str(), TAVFile::omWrite, TAVFile::otVideo);
    TFrameInfo fi;
    fi.Width = ImageOutput->Image->XSize;
    fi.Height = ImageOutput->Image->YSize;
    f.SetFrameInfo(fi);
    f.PutFrame(ImageOutput->Image);
 */
    for (int i=0; i<TrackBar1->Max; i=i+10)
    {
      TrackBar1->Position = i;
      AnsiString a = ImageSave->FileName + IntToStr(i) + ".jpg";
      if (RadioButton4->Checked)
        SaveImageFile(a.c_str(),0,ImageOutput->Image,NULL,NULL);
      if (RadioButton3->Checked)
        SaveImageFile(a.c_str(),0,ImageInput->Image,NULL,NULL);
    }
  }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button21Click(TObject *Sender)
{
  if (SaveDialog2->Execute())
  {
    SaveAVIXMLother(SaveDialog2->FileName, timedur);
//    SaveMouthStat("Mouth.sta", FromFrame, TrackBar1->Position);
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button22Click(TObject *Sender)
{
   s_Object *Object=SearchObjects.GetActual();
   TrackBar1Change(Sender); // reload image
    Object->Eyes=true;
//    int miny = (int)(Object->MinY + Edit19->Text.ToDouble() * (Object->MaxY - Object->MinY));
//    int maxy = (int)(Object->MinY + Edit20->Text.ToDouble() * (Object->MaxY - Object->MinY));
//    int minx = (int)(Object->MinX + Edit21->Text.ToDouble() * (Object->MaxX - Object->MinX));
//    int maxx = (int)(Object->MinX + Edit22->Text.ToDouble() * (Object->MaxX - Object->MinX));
          int minx,miny,maxx,maxy;
//          GetFacePosition(Object,minx,miny,maxx,maxy,0.5,0.9);
    Object->eye1x=minx;
    Object->eye1y=miny;
    Object->eye2x=maxx;
    Object->eye2y=miny;
    Object->eye3x=maxx;
    Object->eye3y=maxy;
    Object->eye4x=minx;
    Object->eye4y=maxy;
    DrawInfoObject(Object, clRed);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Load4Click(TObject *Sender)
{
  if (OpenDialog5->Execute())
  {

     int Nr=Classifier.detector.load(OpenDialog5->FileName.c_str());

     StatusBar1->SimpleText=IntToStr(Nr)+" template(s) was loaded from "+OpenDialog5->FileName;
     CheckBox2->Checked=true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Save2Click(TObject *Sender)
{
  if (SaveDialog3->Execute())
  {
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button26Click(TObject *Sender)
{
  Screen->Cursor=crHourGlass;
  TrackBar1Change(Sender);
   s_Object *Object=SearchObjects.GetActual();
   GetFloatFrame(TrackBar1->Position);
 //  Classifier.RecognizeFace(Object, ImageFlt->Image);
 //  MouthDetection(ImageInput->Image, Object, (double)ScrollBar1->Position/1000.0);
   Label54->Caption=Object->MouthSum;
   Label55->Caption=Object->AvgR;
   Label56->Caption=Object->AvgB;
   DrawInfoObject(Object, clWhite);
  Screen->Cursor=crDefault;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormShow(TObject *Sender)
{
 //  Edit4->Text=IntToStr(int(ImageInput->Image->XSize*ImageInput->Image->YSize*(TrackBar2->Position/1000.0)));

}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  Stoped=true;
  FitEllipse=new EllipseFit;
  RectangleStruct rect;
  SetRectangleColor(&rect, 1, 1, 1, 1, clRed);
  InitListSize(GraphicsListControlHSV->List,20);
  AddRectangleToList(GraphicsListControlHSV->List, &rect);
  AddRectangleToList(GraphicsListControl->List, &rect);
  Background = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox3Change(TObject *Sender)
{
   if (ComboBox3->ItemIndex>=0)
   {
     s_KalmanObject KalmObject=Track.ActiveKalmLst[ComboBox3->ItemIndex];
     bool extrapol;
     s_Object *Object=KalmObject.GetLastObject();
     AnsiString Text=GetPersonText(Object)+" - "+GetInfoText(Object);
     float angle, direction, slope;
     bool is=HeadPose(Object, angle, direction, slope);
     if (is)
     {
       Edit27->Text=FloatToStr(angle);
       Edit28->Text=FloatToStr(direction);
       Edit29->Text=FloatToStr(slope);
     } else
     {
       Edit27->Text="none";
       Edit28->Text="none";
       Edit29->Text="none";
     }
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
  if (SaveDialog2->Execute())
  {
    av2.Close();
    av2.SetFrameInfo(av1.GetFrameInfo());
    av2.Open(ChangeFileExt(SaveDialog2->FileName,".avi").c_str(),TAVFile::omWrite, TAVFile::otVideo);
    for (int i=TrackBar1->Position; i<TrackBar1->Max+1; i++)
    {
       TrackBar1->Position=i;
  if (RadioButton5->Checked)
    ColClass.SkinDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  else
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);      Application->ProcessMessages();
  ImageStruct *Image=NewImage8(ImageOutput->Image->XSize,ImageOutput->Image->YSize);
  for (int i=0; i<ScrollBar2->Position; i++)
  { Dilate(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  for (int i=0; i<ScrollBar2->Position; i++)
  { Erode(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  DeleteImage(Image);
   Edit3->Text=IntToStr(SearchObjects.Search(ImageOutput->Image,Edit4->Text.ToInt()));
   s_Object *Object=SearchObjects.GetFirst();
   for (int i=0; i<SearchObjects.GetSize(); i++)
   {
      DrawInfoObject(Object, clWhite);
      Object=SearchObjects.GetNext();
   }
    av2.DLPutFrame(ImageInput->Image);
    }
    av2.Close();
  }
}
//---------------------------------------------------------------------------




void __fastcall TForm1::Button6Click(TObject *Sender)
{
   if (OpenDialog3->Execute())
   {
     ListBox1->Items->Add(OpenDialog3->FileName);
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button13Click(TObject *Sender)
{
   ListBox1->Items->Delete(ListBox1->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button23Click(TObject *Sender)
{
  if (OpenDialog1->Execute())
  {
     ListBox2->Items->Add(OpenDialog1->FileName);
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button24Click(TObject *Sender)
{
   ListBox2->Items->Delete(ListBox2->ItemIndex);        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button25Click(TObject *Sender)
{
  int fnr=0;
  AnsiString FileSkin;
  AnsiString FileRecognizer;
  while (fnr<ListBox1->Items->Count)
  {
     // video file
     AnsiString FileVideo=ListBox1->Items->Strings[fnr];
     // skin file
     if (fnr<ListBox2->Items->Count)
        FileSkin=ListBox2->Items->Strings[fnr];
     // recognizer file
     if (fnr<ListBox3->Items->Count)
        FileRecognizer=ListBox7->Items->Strings[fnr];
     ///////////////////////////////////// open video ///////////////////////////

     av1.Open(FileVideo.c_str(), TAVFile::omRead, TAVFile::otVideo);
     TAVFile::TFrameInfo FrameInfo = av1.GetFrameInfo();
     Edit1->Text=FileVideo;

     ImageInput->YSize=FrameInfo.Height;
     ImageInput->XSize=FrameInfo.Width;

     ImageOutput->YSize=FrameInfo.Height;
     ImageOutput->XSize=FrameInfo.Width;
     ImageDemo->YSize=FrameInfo.Height;
     ImageDemo->XSize=FrameInfo.Width;

     TrackBar1->Max=av1.GetVideoLength()-1;
     Label14->Caption=av1.GetVideoLength()-1;
     // set size object treshold
     Edit4->Text=IntToStr(int(ImageInput->Image->XSize*ImageInput->Image->YSize*(TrackBar2->Position/1000.0)));
     GetFrame(TrackBar1->Position);
     StatusBar1->SimpleText="Video file "+FileVideo+" is open.";
     ////////////////////////////////// open skin set ///////////////////////////////
     if (fnr<ListBox2->Items->Count)
     {
       if (ColClass.LoadColors(FileSkin.c_str())!=NULL)
       {
          Label5->Caption=IntToStr(ColClass.GetSize());
          Button3Click(Sender);
          Edit2->Text=ExtractFileName(FileSkin);
          StatusBar1->SimpleText="Color data "+FileSkin+" is loaded.";
       }
       else
         Application->MessageBox("Error while loading color data !","Error", MB_OK);
     }
     ////////////////////////////////// Open recognizer /////////////////////////////////
     if (fnr<ListBox3->Items->Count)
     {
       int Nr=Classifier.detector.load(FileRecognizer.c_str());
     //  StatusBar1->SimpleText=IntToStr(Nr)+" template(s) was loaded from "+OpenDialog5->FileName;
       CheckBox2->Checked=true;
     }
     ////////////////////////////////// video processing //////////////////////////
     TrackBar1->Position=0;
     FromFrame=0;
     InitTrack(TrackBar1->Position, Edit8->Text.ToDouble(), Edit7->Text.ToDouble());
     Tick=GetTickCount();
     long start=GetTickCount();
     int i=0;
     while ((TrackBar1->Position<TrackBar1->Max))
     {
        TrackBar1->Position++;
        i++;
        TrackFrame(TrackBar1->Position);
        long t=GetTickCount();
        Form1->Caption="Processing "+IntToStr(100*i/TrackBar1->Max)+"% of video "+IntToStr(fnr+1)+" from "+IntToStr(ListBox1->Items->Count);
        Application->ProcessMessages();
     }
     Track.GetAllTracks(&SolutionKalmLst, Edit18->Text.ToInt());
     AnsiString FileN=ExtractFilePath(FileVideo)+DateToStr(Date())+".xml";
     timedur=GetTickCount()-start;
     SaveAVIXML(FileN,timedur);
     fnr++;

  }
}
//---------------------------------------------------------------------------



void __fastcall TForm1::EqualizeClick(TObject *Sender)
{
   unsigned char r=(unsigned char)Edit30->Text.ToInt();
   unsigned char g=(unsigned char)Edit31->Text.ToInt();
   unsigned char b=(unsigned char)Edit32->Text.ToInt();
   Equalizer(ImageInput->Image,r,g,b);
   ImageInput->Invalidate();

  if (RadioButton5->Checked)
  {
  //  ColClass.PreCompute(r,g,b);
    ColClass.SkinDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  }
  else
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);   ImageOutput->Invalidate();

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button27Click(TObject *Sender)
{
  LineSharp(ImageOutput->Image, ImageInput->Image, 5);
  ImageOutput->Visible=true;
  ImageDemo->Visible=false;
  ImageOutput->Invalidate();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::ComboBox4Change(TObject *Sender)
{
  ImageFill(ImageDemo->Image,0);
  SearchObjects.GetNext();
  s_Object *Object=SearchObjects.GetObject(ComboBox4->ItemIndex);
  DrawObject(&Object->PixelList);
   if (!ImVid)
      GetFrame(TrackBar1->Position);
   else
     ImageInput->AutoLoad = OpenDialog2->FileName;
   AnsiString Text=GetPersonText(Object)+" - "+GetInfoText(Object);
   float angle, direction, slope;
   bool is=HeadPose(Object, angle, direction, slope);
   DrawInfoObject(Object, clWhite);
   StringGrid1->Cells[0][0]=FloatToStrF(Object->kov11,ffNumber,7,5);
   StringGrid1->Cells[0][1]=FloatToStrF(Object->kov12,ffNumber,7,5);
   StringGrid1->Cells[1][0]=FloatToStrF(Object->kov12,ffNumber,7,5);
   StringGrid1->Cells[1][1]=FloatToStrF(Object->kov22,ffNumber,7,5);
   if (is)
   {
     Edit27->Text=FloatToStr(angle);
     Edit28->Text=FloatToStr(direction);
     Edit29->Text=FloatToStr(slope);
   }
   else {
     Edit27->Text=FloatToStrF(Object->orientation,ffNumber,7,5);
     Edit28->Text="none";
     Edit29->Text="none";
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button28Click(TObject *Sender)
{
  if (SaveDialog2->Execute())
  {
    av2.Close();
    av2.SetFrameInfo(av1.GetFrameInfo());
    av2.Open(ChangeFileExt(SaveDialog2->FileName,".avi").c_str(),TAVFile::omWrite, TAVFile::otVideo);
    for (int i=TrackBar1->Position; i<TrackBar1->Max+1; i++)
    {
       TrackBar1->Position=i;
  if (RadioButton5->Checked)
    ColClass.SkinDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  else
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);      Application->ProcessMessages();
  ImageStruct *Image=NewImage8(ImageOutput->Image->XSize,ImageOutput->Image->YSize);
  for (int i=0; i<ScrollBar2->Position; i++)
  { Dilate(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  for (int i=0; i<ScrollBar2->Position; i++)
  { Erode(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  DeleteImage(Image);
   Edit3->Text=IntToStr(SearchObjects.Search(ImageOutput->Image,Edit4->Text.ToInt()));
   s_Object *Object=SearchObjects.GetFirst();
   ImageFill(ImageDemo->Image,0);
   for (int i=0; i<SearchObjects.GetSize(); i++)
   {
      DrawObject(&Object->PixelList);
      DrawInfoObject(Object, clWhite);
      Object=SearchObjects.GetNext();
   }
    av2.DLPutFrame(ImageDemo->Image);
    }
    av2.Close();
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button29Click(TObject *Sender)
{
  if (OpenDialog5->Execute())
  {
     ListBox7->Items->Add(OpenDialog5->FileName);
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button30Click(TObject *Sender)
{
   ListBox7->Items->Delete(ListBox7->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edge_DetectClick(TObject *Sender)
{
   if (!ImVid)
      GetFrame(TrackBar1->Position);
   else
     ImageInput->AutoLoad = OpenDialog2->FileName;  ImageOutput->Visible=true;
  ImageDemo->Visible=false;
  Sobel(ImageInput->Image, ImageOutput->Image);
  ImageOutput->Invalidate();
}
//---------------------------------------------------------------------------





void __fastcall TForm1::GraphicsListControlMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  int x = max((X - ImageInput->XOffset) / ImageInput->XScale, 0.0f);
  int y = max((Y - ImageInput->YOffset) / ImageInput->YScale, 0.0f);
  Xr1=x; Yr1=y;
   int Red, Green;
   if ((ImageInput->XSize>x) && (ImageInput->YSize>y))
   {
     unsigned char r=ImageRGBPixelR(ImageInput->Image,x,y);
     unsigned char g=ImageRGBPixelG(ImageInput->Image,x,y);
     unsigned char b=ImageRGBPixelB(ImageInput->Image,x,y);
     Edit30->Text=IntToStr(r);
     Edit31->Text=IntToStr(g);
     Edit32->Text=IntToStr(b);

     if (RadioButton1->Checked)
     {
        if (Button==mbLeft)
        {
          ColClass.AddColor(r,g,b);
          Label5->Caption=IntToStr(ColClass.GetSize());

          RGBtoRG(r,g,b,Red,Green);
          PointStruct Point;
          Point.Shape=2;
          SetPointColor(&Point,Red*3,300-Green*3,clGreen);
          AddPointToList(GraphicsList->List,&Point);
          GraphicsList->Repaint();
        }
     }
     else
     {
        Label25->Caption=FloatToStrF(ColClass.IsSkin(r,g,b),ffNumber,7,5);
     }
     // pridavama do statistiky barev
     if (Button==mbRight)
     {
        int Red,Green;
        RGBtoRG(r,g,b,Red,Green);
        PointStruct Point;
        Point.Shape=2;
        SetPointType(&Point,Red*3,300-Green*3,clRed,2);
        AddPointToList(GraphicsList->List,&Point);
        GraphicsList->Repaint();
     }
   }
        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GraphicsListControlMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
  int x = max((X - ImageInput->XOffset) / ImageInput->XScale, 0.0f);
  int y = max((Y - ImageInput->YOffset) / ImageInput->YScale, 0.0f);
  XEdit->Text = x;
  YEdit->Text = y;
  if ((FileExists(OpenDialog2->FileName)) || (FileExists(OpenDialog3->FileName)))
  {
    unsigned long Color=ImageRGBPixelRGB(ImageInput->Image,x,y);
    Label33->Caption=IntToStr(ImageRGBPixelR(ImageInput->Image,x,y));
    Label34->Caption=IntToStr(ImageRGBPixelG(ImageInput->Image,x,y));
    Label35->Caption=IntToStr(ImageRGBPixelB(ImageInput->Image,x,y));
    DrawColor(Color);
    s_ColorBGR rgb; s_ColorHSV hsv;
    rgb.r=ImageRGBPixelR(ImageInput->Image,x,y);
    rgb.g=ImageRGBPixelG(ImageInput->Image,x,y);
    rgb.b=ImageRGBPixelB(ImageInput->Image,x,y);
    rgb_to_hsv(&rgb, hsv);
    int width=1;
    int height=1;
    RectangleStruct *Rect=GetRectangleFromList(GraphicsListControlHSV->List,0);
    SetRectangleColor(Rect,hsv.a*width,hsv.b*height,(hsv.a+1)*width,(hsv.b+1)*width,clRed);
    GraphicsListControlHSV->Invalidate();
  }

        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GraphicsListControlMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  Xr2 = max((X - ImageInput->XOffset) / ImageInput->XScale, 0.0f);
  Yr2 = max((Y - ImageInput->YOffset) / ImageInput->YScale, 0.0f);
  RectangleStruct *Rect=GetRectangleFromList(GraphicsListControl->List,GraphicsListControl->List->Count-1);
  SetRectangleColor(Rect,Xr1,Yr1,Xr2,Yr2,clRed);
  GraphicsListControl->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button31Click(TObject *Sender)
{
  HSVmodel.InitHistogram(BINS_COUNT,BINS_COUNT);
  ResizeImage8(ImageControlHistogram, BINS_COUNT, BINS_COUNT);
  // get color information
  for (int j=Yr1; j<Yr2; j++)
  {
     for (int i=Xr1; i<Xr2; i++)
     {
       unsigned char r=ImageRGBPixelR(ImageInput->Image,i,j);
       unsigned char g=ImageRGBPixelG(ImageInput->Image,i,j);
       unsigned char b=ImageRGBPixelB(ImageInput->Image,i,j);
       HSVmodel.AddColor(r,g,b);
     }
  }
  HSVmodel.Drawhistogram(ImageControlHistogram->Image);
  ImageControlHistogram->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button32Click(TObject *Sender)
{
  HSVmodel.MapSkinDetection(ImageInput->Image,ImageOutput->Image);
  ImageOutput->Invalidate();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::GraphicsListControlHSVMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  int x = max((X - ImageControlHistogram->XOffset) / ImageControlHistogram->XScale, 0.0f);
  int y = max((Y - ImageControlHistogram->YOffset) / ImageControlHistogram->YScale, 0.0f);

  HSVmodel.AddIntoMap(x,y);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonEllipseHeadClick(TObject *Sender)
{
  int XSize = ImageInput->Image->XSize;
  int YSize = ImageInput->Image->YSize;
  TrackBar1Change(Sender); // repaint imag
  ResizeImageRGB(&(ImageControlEllipse->Image), 50, 50);
  ImageControlEllipse->XSize = XSize;
  ImageControlEllipse->YSize = YSize;
  ImageStruct *Tmp =  NewImage8(XSize, YSize);
  ImageStruct *Grey = NewImage8(XSize, YSize);
  GreyScale(ImageInput->Image, Grey);
  GaussianMask(Grey, Tmp);
  float Ratio = TrackBarRatio->Position/50.0;
  Tick=GetTickCount();
  HeadDet.Init(XSize, YSize, 50, 50, TrackBarSize->Position, Ratio);
  HeadDet.ProcessImage(Tmp);
  long t=GetTickCount();
  Form1->Caption="  [Time "+IntToStr(t-Tick)+" ms]";

  int x,y;
  HeadDet.DrawArray(ImageControlEllipse->Image);
  long great = HeadDet.FindMax(x,y), size = great;;
  float rat=1;
  while (rat>TrackBarThreshold->Position/(float)TrackBarThreshold->Max)
  {
    HeadDet.DrawEllipse(ImageInput->Image, x, y, 1);
    AnsiString Text = IntToStr(size);
    StampText(ImageInput->Image,x-Text.Length(),y-30, Text.c_str(),0);
    size = HeadDet.FindMax(x,y);
    rat = (float)size/great;
  }
  ImageControlEllipse->Invalidate();
  ImageInput->Invalidate();
  ImageOutput->Invalidate();

  DeleteImage(Tmp);
  DeleteImage(Grey);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button34Click(TObject *Sender)
{
  if (SaveDialog2->Execute())
  {
    av2.Close();
    av2.SetFrameInfo(av1.GetFrameInfo());
    av2.Open(ChangeFileExt(SaveDialog2->FileName,".avi").c_str(),TAVFile::omWrite, TAVFile::otVideo);
    for (int i=TrackBar1->Position; i<TrackBar1->Max+1; i++)
    {
       TrackBar1->Position=i;
       ButtonEllipseHeadClick(Sender);
       av2.DLPutFrame(ImageInput->Image);
    }
    av2.Close();
  }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button33Click(TObject *Sender)
{
  int XSize = ImageInput->Image->XSize;
  int YSize = ImageInput->Image->YSize;
  TrackBar1Change(Sender); // repaint imag
  ResizeImageRGB(&(ImageControlEllipse->Image), 50, 50);
  ImageControlEllipse->XSize = XSize;
  ImageControlEllipse->YSize = YSize;
  ImageStruct *Tmp =  NewImage8(XSize, YSize);
  ImageStruct *Grey = NewImage8(XSize, YSize);
  GreyScale(ImageInput->Image, Grey);
  GaussianMask(Grey, Tmp);
  float Ratio = TrackBarRatio->Position/50.0;
  Tick=GetTickCount();
  int x,y;
  int MaxSize=TrackBarSize->Position+10, Max=0, size;
  for (TrackBarSize->Position-=10; TrackBarSize->Position<MaxSize; TrackBarSize->Position++)
  {
    HeadDet.Init(XSize, YSize, 50, 50, TrackBarSize->Position, Ratio);
    HeadDet.ProcessImage(Tmp);
    long great = HeadDet.FindMax(x,y);
    if (Max<great)
    {
       Max = great;
       size = TrackBarSize->Position;
    }
  }
    TrackBarSize->Position = size;
    HeadDet.Init(XSize, YSize, 50, 50, TrackBarSize->Position, Ratio);
    HeadDet.ProcessImage(Tmp);
    HeadDet.DrawArray(ImageControlEllipse->Image);
    long t=GetTickCount();
    Form1->Caption="  [Time "+IntToStr(t-Tick)+" ms]";
    long great = HeadDet.FindMax(x,y);
    size = great;
    float rat=1;
  while (rat>TrackBarThreshold->Position/(float)TrackBarThreshold->Max)
  {
    HeadDet.DrawEllipse(ImageInput->Image, x, y, 1);
    AnsiString Text = IntToStr(size);
    StampText(ImageInput->Image,x-Text.Length(),y-30, Text.c_str(),0);
    size = HeadDet.FindMax(x,y);
    rat = (float)size/great;
  }
  ImageControlEllipse->Invalidate();
  ImageInput->Invalidate();
  DeleteImage(Tmp);
  DeleteImage(Grey);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button35Click(TObject *Sender)
{
  int XSize = ImageInput->Image->XSize;
  int YSize = ImageInput->Image->YSize;
  TrackBar1Change(Sender); // repaint imag
  ResizeImageRGB(&(ImageControlEllipse->Image), 50, 50);
  ImageControlEllipse->XSize = XSize;
  ImageControlEllipse->YSize = YSize;
  ImageStruct *Tmp =  NewImage8(XSize, YSize);
  ImageStruct *Grey = NewImage8(XSize, YSize);
  GreyScale(ImageOutput->Image, Grey);
  GaussianMask(Grey, Tmp);
  float Ratio = TrackBarRatio->Position/50.0;
  Tick=GetTickCount();
  if (RadioButton5->Checked)
    ColClass.SkinDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  if (RadioButton6->Checked)
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);
  if (RadioButton7->Checked)
    HSVmodel.SkinDetection(ImageInput->Image,ImageOutput->Image);
  ImageStruct *Image=NewImage8(ImageOutput->Image->XSize,ImageOutput->Image->YSize);
  for (int i=0; i<ScrollBar2->Position; i++)
  { Dilate(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  for (int i=0; i<ScrollBar2->Position; i++)
  { Erode(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  DeleteImage(Image);
  HeadDet.Init(XSize, YSize, 50, 50, TrackBarSize->Position, Ratio);
  HeadDet.ProcessImageSkin(Tmp, ImageOutput->Image);
  long t=GetTickCount();
  Form1->Caption="  [Time "+IntToStr(t-Tick)+" ms]";

  int x,y;
  HeadDet.DrawArray(ImageControlEllipse->Image);
  long great = HeadDet.FindMax(x,y), size = great;
  float rat=1;
  while (rat>TrackBarThreshold->Position/(float)TrackBarThreshold->Max)
  {
    HeadDet.DrawEllipse(ImageInput->Image, x, y, 1);
    AnsiString Text = IntToStr(size);
    StampText(ImageInput->Image,x-Text.Length(),y-30, Text.c_str(),0);
    size = HeadDet.FindMax(x,y);
    rat = (float)size/great;
  }
  ImageControlEllipse->Invalidate();
  ImageInput->Invalidate();
  ImageOutput->Invalidate();
  DeleteImage(Tmp);
  DeleteImage(Grey);

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button36Click(TObject *Sender)
{
  int XSize = ImageInput->Image->XSize;
  int YSize = ImageInput->Image->YSize;
  TrackBar1Change(Sender); // repaint imag
  ResizeImageRGB(&(ImageControlEllipse->Image), 50, 50);
  ImageControlEllipse->XSize = XSize;
  ImageControlEllipse->YSize = YSize;
  ImageStruct *Tmp =  NewImage8(XSize, YSize);
  ImageStruct *Grey = NewImage8(XSize, YSize);
  GreyScale(ImageInput->Image, Grey);
  GaussianMask(Grey, Tmp);
  float Ratio = TrackBarRatio->Position/50.0;
  Tick=GetTickCount();
  if (RadioButton5->Checked)
    ColClass.SkinDetect(ImageInput->Image,ImageOutput->Image,(double)ScrollBar1->Position/1000.0);
  if (RadioButton6->Checked)
    SkinLocusDetect(ImageInput->Image,ImageOutput->Image);
  if (RadioButton7->Checked)
    HSVmodel.SkinDetection(ImageInput->Image,ImageOutput->Image);
  ImageStruct *Image=NewImage8(ImageOutput->Image->XSize,ImageOutput->Image->YSize);
  for (int i=0; i<ScrollBar2->Position; i++)
  { Dilate(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  for (int i=0; i<ScrollBar2->Position; i++)
  { Erode(ImageOutput->Image,Image);
    ImageTransfer(ImageOutput->Image, Image); }
  int x,y;
  int MaxSize=TrackBarSize->Position+50, Max=0, size;
  for (TrackBarSize->Position-=50; TrackBarSize->Position<MaxSize; TrackBarSize->Position+=2)
  {
    HeadDet.Init(XSize, YSize, 50, 50, TrackBarSize->Position, Ratio);
    HeadDet.ProcessImageSkin(Tmp, Image);
    long great = HeadDet.FindMax(x,y);
    if (Max<great)
    {
       Max = great;
       size = TrackBarSize->Position;
    }
  }
    TrackBarSize->Position = size;
    HeadDet.Init(XSize, YSize, 50, 50, TrackBarSize->Position, Ratio);
    HeadDet.ProcessImageSkin(Tmp, Image);
    HeadDet.DrawArray(ImageControlEllipse->Image);
    long t=GetTickCount();
    Form1->Caption="  [Time "+IntToStr(t-Tick)+" ms]";
    long great = HeadDet.FindMax(x,y);
    size = great;
    float rat=1;
  while (rat>TrackBarThreshold->Position/(float)TrackBarThreshold->Max)
  {
    HeadDet.DrawEllipse(ImageInput->Image, x, y, 1);
    AnsiString Text = IntToStr(size);
    StampText(ImageInput->Image,x-Text.Length(),y-30, Text.c_str(),0);
    size = HeadDet.FindMax(x,y);
    rat = (float)size/great;
  }
  ImageControlEllipse->Invalidate();
  ImageInput->Invalidate();
  DeleteImage(Tmp);
  DeleteImage(Grey);
  DeleteImage(Image);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button37Click(TObject *Sender)
{
  Background->solveBackground(ImageInput->Image);
  ImageStruct *bg=Background->getBackground();
  int i = ImageTransfer(ImageOutput->Image, bg);
  ImageOutput->Invalidate();
}
//---------------------------------------------------------------------------


