#include "Image.h"
// definition of ImageStruct

// converts RGB color to skin locus (c1, c2)
void ConverColor(unsigned char r,unsigned char g,unsigned char b, int &c1, int &c2)
{
   int sum = r+g+b;
   if (sum>0)
   {
     c1=(BINS_COUNT*r)/sum + 0.5;
     c2=(BINS_COUNT*g)/sum + 0.5;
   }
   else
   {
     c1=0;
     c2=0;
   }
}

double avg1, avg2;
double inv11, inv21,
       inv12, inv22;
// color model - average coordinates and a covariant matrix
// those might be filled with values from model.txt

// returns probability that given RGB is skin color
double IsSkin(unsigned char r,unsigned char g,unsigned char b)
{
   int c1, c2;
   ConverColor(r,g,b,c1,c2);
   float a1=c1-avg1;
   float a2=c2-avg2;
   float exponent;                     // exponent
   float prob;                         // pravdepodobnost
   // vypocet exponentu
   exponent=-(a1*(a1*inv11+a2*inv21)+a2*(a1*inv12+a2*inv22))/2;
   // vypocet pravdepodobnosti

   prob=exp(exponent);
   return prob;
}

// detects skin color in RGB image input, outputs 0 or 255 to grayscale image output
// Tres is skin probability threshold
int SkinDetect(ImageStruct *Input,ImageStruct *Output, double Tres)
{
  int XSize,YSize,SXStep,DXStep;
  int i,j;

  XSize = ImageXSize(Input);
  YSize = ImageYSize(Input);
  SXStep = ImageXOffset(Input);
  DXStep = ImageXOffset(Output);

  for (j = 0;j<YSize;++j)
  {
    unsigned char * Src = &ImageRGBPixelB(Input,0,j);
    unsigned char * Dst = &Image8Pixel(Output,0,j);

    for (i = 0;i<XSize;++i)
    {
      // ulozeno BGR
      unsigned char b=*(Src+0);
      unsigned char g=*(Src+1);
      unsigned char r=*(Src+2);
      Src+=SXStep;
      double prob=IsSkin(r,g,b);
      if (prob>Tres)
        *Dst = (unsigned char)255;
      else
        *Dst = (unsigned char)0;
      Dst += DXStep;
    }
  }
  return 1;
}
