/*****************************************************************************/
/*                       Function for circle detection                       */
/*  Using cubic edge detection and finding circle parameters                 */
/*  Header file : cubiccircle.h                                              */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/

#ifndef _cubiccircle_h
#define _cubiccircle_h

#include "Image.h"
#include "StFastCircleFitter.h"

// Number of tested points in the circle
#define c_WIDTH  2000

// Tested distance around the circle border
#define c_DISTANCE  30

// Window for filtering values of 1st derivation
#define c_Window  50

class c_CubicCircle
{
   int Value[c_WIDTH];                  // array with 1st derivation value
   int CompValue[c_WIDTH];
   float XVal[c_WIDTH];
   float YVal[c_WIDTH];
   float Radius[c_WIDTH];

   StFastCircleFitter FastDetection;
   public:
   int Distance;
   void SpecialCubicDetect(ImageStruct *Input, float &x, float &y, float &r, int TestCount);
   void CubicDetect(ImageStruct *Input, float &x, float &y, float &r, int TestCount);
   void CubicDetectOld(ImageStruct *Input, float &x, float &y, float &r, int TestCount);
   void AllCubicDetect(ImageStruct *Input, float &x, float &y, float &r);

};
#endif