#ifndef _CIRCLEDETECT
#define _CIRCLEDETECT

//---------------------------------------------------------------------------
#include "Image.h"
#include <stdio.h>

#include "StFastCircleFitter.h"
#include "definitions.h"

extern const int c_DIVIDE;   // divide radius of the circle - number of tested pixel areas
extern const int C_RANGE;     // half distance from border at first pass
extern const float C_TRES;  // max distance from circle in second pass
extern const int EDGE_TRES;

// Modified Canny for horizontal line detection
int  MaskHorizontalEdge(ImageStruct *Inp, ImageStruct *Outp);
int  CannyHorizontalEdge(ImageStruct *Inp, ImageStruct *Outp, int low, int high);

class Maneuver
{  // trida pro obsluhu spousteci hrany manevrovaciho sumu
   // pocita prumernou hodnotu z poslednich Size zadanych hodnot
   int Size;
   int Actual;
   double Arr[20];
   public:
   Maneuver(int Nr)
   {  // nastavi velikost pole a vyhradi misto v pameti
      Size=Nr;
      Actual=0;
    //  Arr = new double[Size];
      for (int i=0; i<Nr; i++)
        Arr[i]=0;
   }
   ~Maneuver()
   {
      Size=0;
      // delete[] Arr;
   }
   double Compute(double Innovation);
   double Get();
};

int sign(int nr);

class cdetection
{
   FILE *out;
   public:
   float window[100];
   StFastCircleFitter FastDetection;
   ImageStruct *ImageGrey, *ImageEdge;
   Maneuver *ManX, *ManY, *ManR;

   float xcent,ycent,radius;
   int range;
   void ImageConvolution(ImageStruct *Input, ImageStruct *Output);
   void NewDetect(ImageStruct *Input, float &x, float &y, float &r);
   void Init(int Width, int Height);
   ~cdetection()
   {
      if (ImageGrey!=NULL)
        DeleteImage(ImageGrey);
      if (ImageEdge!=NULL)
        DeleteImage(ImageEdge);
//      fclose(out);
      delete ManX;
      delete ManY;
      delete ManR;
   }
  cdetection()
  {
       ManX=new Maneuver(6);
       ManY=new Maneuver(6);
       ManR=new Maneuver(6);
       ImageGrey=NULL;
       ImageEdge=NULL;
       char name[20];
       int nr=0;
       /*
       do
       {
         sprintf(name,"out%d.log",nr);
         nr++;
       } while ((fopen(name, "rt")) != NULL);
     if ((out = fopen(name, "wt")) == NULL)
     {
        printf("Cannot open output log file!\n");
     }
      */
  }
  void PrintFile(float &x, float &y, float &r)
  {
    if (out!=NULL) fprintf(out,"%f %f %f\n",x,y,r);
  }
  void PrintNumber(float &x)
  {
    if (out!=NULL) fprintf(out,"%f  ",x);
  }

};
#endif //_CIRCLEDETECT
