#include <math.h>
#include <stdlib.h>
#include <list.h>
#include "Hyper.h"
#include "cubicedge.h"
#include "MyImageFun.h"

#ifdef _WIN32
/*
  #include "..\..\AVFile\avfile.h"
  #include "..\..\AVFile\bmpfile.h"
  -*/
  #include <ImageFil.h>
  #include "ImageFun.h"
  /*
  extern FILE* out;
  TBMPFile bmp;           // storing bmp pictures
  */
  #endif

#include "circledetect.h"
const int C_MIN_RANGE=5;        // minimal half distance from border - searching area
const int c_DIVIDE = 6;   // divide radius of the circle - number of tested pixel areas
const int C_RANGE=40;      // half distance from border at first pass
const float C_TRES=3.0;    // max distance from circle in second pass
const int EDGE_TRES = 15;
const int C_CYCLES = 6;         // number of cycles for circle finding


//---------------------------------------------------------------------------
void cdetection::Init(int Width, int Height)
{  // initialize with creating images
   radius=Height/2-10;
   ycent=Height/2;
   xcent=Width/2;
   range=C_RANGE;
}

void GetMax(ImageStruct *ImageEdge, int x, int& pos, float& max)
{
   max=0;
   pos=-1;
   // hleda odezvu na hranu ve vertikalnim sloupci
   for (int j=ImageEdge->YSize-2; j>=1; j--)
   {
      int value=Image8Pixel(ImageEdge,x,j);
      int leftpixel=Image8Pixel(ImageEdge,x,j-1);
      int rightpixel=Image8Pixel(ImageEdge,x,j+1);
      if ((value > leftpixel) && (value > rightpixel) && (value >15))
      {
         max=value; pos=j; break;// hledame prvni maximum
      }
   }
}

void cdetection::NewDetect(ImageStruct *Input, float &x, float &y, float &r)
{

  int high=40, low=20;
  float divide = pow((float)range/C_MIN_RANGE,1.0/(C_CYCLES-1));
  t_PointList ResultList;
  s_Point Point;
  float max=0;
  int pos=0, old=0;
  // prevedeme na velikost ktera odpovida testovane oblasti ve vzdalenosti C_RANGE od polomeru
  x=xcent; y=ycent; r=radius; float dev=range;
  int cnt, w;
  ImageStruct *ImageGauss=NULL;
 for (w=0; w<C_CYCLES; w++)
 {
  xcent=x; ycent=y;
  int xsize=(int)(M_PI*radius/c_DIVIDE);
  ResizeImage8(&ImageGrey, xsize, dev*2);
  ResizeImage8(&ImageEdge, xsize, dev*2);
  ResizeImage8(&ImageGauss, (int)(M_PI*radius/c_DIVIDE), dev*2);
  FastDetection.clear();
  ResultList.clear();
  // transformuje cast obrazu, ktera obsahuje hranu do urovni sede
  PartTransform(ImageGrey,Input, x, y,radius-dev,radius+dev);
  GaussianMask(ImageGrey, ImageGauss);
  CannyHorizontalEdge(ImageGauss,ImageEdge, low, high);
/*
#ifdef _WIN32
   char s[20]; sprintf(s,"grey%d.bmp",w);
   SaveImageFile(s,0,ImageGauss,NULL,NULL);
   sprintf(s,"edge%d.bmp",w);
   SaveImageFile(s,0,ImageEdge,NULL,NULL);
#endif
*/
  // prochazi obrazem a detekuje maximalni odezvu u svisle cary
  old= cnt; cnt=0;
  for (int i=0; i<ImageEdge->XSize; i++)
  {

     // hleda odezvu na hranu ve vertikalnim sloupci
     GetMax(ImageEdge, i, pos, max);
     if (pos>=0)
     {
       float ang=(float)i*2*M_PI/ImageEdge->XSize;
       float x=(float)(radius-dev+pos)*cos(ang)+xcent;
       float y=(float)(radius-dev+pos)*sin(ang)+ycent;
       Point.radius=radius-dev+pos;
       FastDetection.addPoint(x,y);
       Point.x=x; Point.y=y; Point.angle=ang;
       ResultList.push_back(Point);
       cnt++;
     }
  }
     if (M_PI*radius/c_DIVIDE/4>cnt)    // mene jak 25%
     {
       printf("Malo bodu pro vypocet : %d, v %d iteraci, odchylka %f \n", cnt,w+1,dev);
       if (w<2) { dev=dev*3; } else break;
     }
     else
     {
       FastDetection.Blockfit();
       if (fabs(1-FastDetection.radius()/radius)<0.5)
       {
         x=FastDetection.xcenter();
         y=FastDetection.ycenter();
         radius=FastDetection.radius();
       }
       dev=dev/divide;
     }
 }

  r=radius; xcent=x; ycent=y;
  if (w<2) range=range*2;
  DeleteImage(ImageGauss);

}

double Maneuver::Compute(double Innovation)
{ // uklada hodnoty odchylek od predikce a vraci prumernou hodnotu
  int i;
  double pom=0;
  if (Actual>(Size-1))
    Actual=0;
  Arr[Actual]=Innovation;
  Actual=Actual+1;

  for (i=0; i<Size; i++)
     pom=pom+Arr[i];
  pom=pom / Size;              // vypocita prumernou hodnotu odchylek
  return pom;
}

double Maneuver::Get()
{ // vraci prumernou hodnotu odchylek od predikce
  double pom=0;
  int i;
  for (i=0; i<Size; i++)
     pom=pom+Arr[i];
  pom=pom / Size;              // vypocita prumernou hodnotu odchylek
  return pom;
}

int sign(int nr)
{
// urci znamenko cisla vraci 1 kladne -1 zaporne
   if (nr==0)
     return 0;
   if ((abs(nr)-nr)==0)
     return 1;
   else
     return -1;
}

//---------------------------------------------------------------------------

//////////////////////// Mask Horizontal Edge  /////////////////////////////////
int MaskHorizontalEdge(ImageStruct *Inp, ImageStruct *Outp)
{
   int                  K[3];
   int         sumY;
   K[0]=1; K[1]=0; K[2]=-1;
   for(int Y=0; Y<Inp->YSize; Y++)  {
   for(int X=0; X<Inp->XSize; X++)  {
        sumY = 0;
             if ((Y>0) && (Y<(Inp->YSize-1)))
        {
          /*-------Y GRADIENT APPROXIMATION-------*/
               for(int J=-1; J<=1; J++) sumY = sumY + Image8Pixel(Inp,X,Y+J) * K[J+1];
             }
             SetImage8Pixel(Outp,X,Y,(unsigned char)abs(sumY));  /* make edges white */
   }
   }
   return 0;
}

struct s_Pix
{
  int x,y;
};
typedef std::list<s_Pix> t_PixList;

void TestPix(ImageStruct *Image, t_PixList *List, int x, int y, int low)
{
  s_Pix P;
  if ((x>=0) && (y>=0 )&& (y<Image->YSize) && (x<Image->XSize))
  if (Image8Pixel(Image, x, y)>low)
  {
     SetImage8Pixel(Image, x, y, 0);
     P.x=x; P.y=y; List->push_back(P);
  }
}

//////////////////////// Canny Horizontal Edge  ////////////////////////////////
int CannyHorizontalEdge(ImageStruct *Inp, ImageStruct *Outp, int low, int high)
{
   int                  K[3];
   int         sumY;
   int         leftPixel, rightPixel;
   t_PixList            Stack;
   ImageStruct *Mag=NULL, *NonMax=NULL;
   ResizeImage8(&Mag,Inp->XSize,Inp->YSize);
   ResizeImage8(&NonMax,Inp->XSize,Inp->YSize);
   K[0]=2; K[1]=0; K[2]=-2;
   for(int Y=0; Y<Inp->YSize; Y++)  {
   for(int X=0; X<Inp->XSize; X++)  {
        sumY = 0;
             if ((Y>0) && (Y<(Inp->YSize-1)))
        {
          /*-------Y GRADIENT APPROXIMATION-------*/
               for(int J=-1; J<=1; J++) sumY = sumY + Image8Pixel(Inp,X,Y+J) * K[J+1];
             }
             SetImage8Pixel(Mag,X,Y,(unsigned char)abs(sumY));  /* make edges white */
   }
   }
   //----------------------- NON-MAXIMA SUPRESSION -----------------------------
   #ifdef _WIN32
     ImageFill(NonMax, 0);
   #else
   for(int j=0; j<NonMax->YSize; j++)
     for(int i=0; i<NonMax->XSize; i++)  SetImage8Pixel(NonMax,i,j,0);
   #endif
   for(int j=1; j<(Inp->YSize-1); j++)  {
     for(int i=1; i<(Inp->XSize-1); i++)  {
        leftPixel = Image8Pixel(Mag,i,j+1);
        rightPixel = Image8Pixel(Mag,i,j-1);
        if ((Image8Pixel(Mag, i, j) > leftPixel) && (Image8Pixel(Mag, i, j) > rightPixel))
          SetImage8Pixel(NonMax,i,j,Image8Pixel(Mag, i, j))
        else
          SetImage8Pixel(NonMax, i, j, 0);
     }
   }
   //----------------------- THRESHOLD HYSTERESIS ------------------------------
   #ifdef _WIN32
     ImageFill(Outp, 0);
   #else
   for(int j=0; j<Outp->YSize; j++)
     for(int i=0; i<Outp->XSize; i++)  SetImage8Pixel(Outp,i,j,0);
   #endif

   Stack.clear();
   for(int j=0; j<Inp->YSize; j++)  {
     for(int i=0; i<Inp->XSize; i++)  {
        if (Image8Pixel(NonMax, i, j)>high)
        {  s_Pix P; P.x=i; P.y=j;
           Stack.push_back(P);
           while (!Stack.empty())
           {
              P=Stack.back(); Stack.pop_back();
              TestPix(NonMax, &Stack, P.x+1, P.y,low);
              TestPix(NonMax, &Stack, P.x-1, P.y,low);
              TestPix(NonMax, &Stack, P.x, P.y-1,low);
              TestPix(NonMax, &Stack, P.x, P.y+1,low);
              TestPix(NonMax, &Stack, P.x+1, P.y+1,low);
              TestPix(NonMax, &Stack, P.x-1, P.y-1,low);
              TestPix(NonMax, &Stack, P.x-1, P.y+1,low);
              TestPix(NonMax, &Stack, P.x+1, P.y-1,low);
              if (!Stack.empty()) SetImage8Pixel(Outp,P.x,P.y,255);
           }
        }
     }
   }
   DeleteImage(Mag);
   DeleteImage(NonMax);
   return 0;
}




