#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "Hyper.h"
#include "MyImageFun.h"
FILE *f;
// velikost horniho okraje obrazu ze ktereho se nebude pocitat kruznice
// z duvodu chyby, ktera vznika pri nataceni
const int C_SIDE=8;
double Caliber[100];
const float C_PRATIO=59/(float)54;
const float C_NRATIO=54/(float)59;

const float C_PRATIOHD=4/3.0;
const float C_NRATIOHD=3/4.0;

// ratio between width and height sides of video
float RATIO=C_NRATIOHD;

#define ROUND(x) (int((x)+0.5))
// Spline parametr <-1..0> pro bikubickou interpolaci
const double BI_A   = -0.75;

// Odvozene parametry
const double BI_A2   = BI_A + 2.0;
const double BI_A3   = BI_A + 3.0;
const double BI_2A   = BI_A * 2.0;
const double BI_2A3   = BI_A * 2.0 + 3.0;


void GetPixel(ImageStruct *Image, int x, int y, int &r, int &g, int &b)
{ // original image has 720x576
  // normalized image has 720x527
  // from image 720x576 to normalized image 720x527 with 1x1 pixel ratio

  float X=x;
  float Y=y*C_PRATIO;
  bilinear(Image, X, Y, r, g, b);
}


void NormalizeImage(ImageStruct *Input, ImageStruct *Output)
{ // original image has 720x576
  // normalized image has 720x527
  // from image 720x576 to normalized image 720x527 with 1x1 pixel ratio
  int r,g,b;
  float Y;

  for (int j = 0;j<Output->YSize;++j)
  {
    Y=j*C_PRATIO;
    for (int i = 0;i<Output->XSize;++i)
    {
      bilinear(Input, i, Y, r, g, b);
      SetImageRGBPixel(Output,i,j,r,g,b)
    }
  }
}

int ChangeImageSize(int Xsize, float R0,float R, int OverLap)
{
   int YSize=(int)Xsize/(2*M_PI+OverLap/360.0*2*M_PI);
   YSize=(int)YSize*((R-R0)/(float)R);
   return YSize;
}

void SimplePartTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0,float R0,float R, int Width, int Position, bool invert)
// simple transforms part of the image in degrees into panoramic view
// Position is value in degrees from begin of the image
// Width is value in pixels - means width of 360 unroled image
{
  int i;
  int j;
  unsigned Value;
  int r,g,b;
  float offset=Position/360.0*(2*M_PI);
  for (i = 0;i<Output->XSize;++i) for (j = 0;j<Output->YSize;++j)
  {
    float X = X0+RATIO*cos(2*M_PI*(float)i/(Width)+offset)*(R-(R-R0)*(float)j/Output->YSize);
    float Y = Y0+sin(2*M_PI*(float)i/(Width)+offset)*(R-(R-R0)*(float)j/Output->YSize);
    bilinear(Input, X, Y, r, g, b);
    if (invert)
      SetImageRGBPixel(Output,i,Output->YSize-j-1,r,g,b)
    else
      SetImageRGBPixel(Output,i,j,r,g,b);
  }
}

void SimplePartTransformHalf(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0,float R0,float R, int Width, int Position, bool invert, bool half)
// simple transforms part of the image in degrees into panoramic view
// Position is value in degrees from begin of the image
// Width is value in pixels - means width of 360 unroled image
{
  int i;
  int j;
  int h=half?2:1;
  unsigned Value;
  int r,g,b;
  float offset=Position/360.0*(2*M_PI);
  for (i = 0;i<Output->XSize;++i) for (j = 0;j<Output->YSize;++j)
  {
    float X = X0+RATIO*cos(2*M_PI*(float)i/(Width)+offset)*(R-(R-R0)*(float)j/Output->YSize);
    float Y = Y0*h+sin(2*M_PI*(float)i/(Width)+offset)*(R-(R-R0)*(float)j/Output->YSize);

//    if (X<0) X = 0; else if (X>=Input->XSize) X = Input->XSize-1;
//    if (Y<0) Y = 0; else if (Y>=Input->YSize*h) Y = Input->YSize*h-1;
    bilinear(Input, X, Y/h, r, g, b);
    if (invert)
      SetImageRGBPixel(Output,i,Output->YSize-j-1,r,g,b)
    else
      SetImageRGBPixel(Output,i,j,r,g,b);
  }
}

void PartTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0,float R0,float R)
// GRAY LEVEL OUTPUT IMAGE
// simple transforms part of the image in degrees into panoramic view
// Position is value in degrees from begin of the image
// Width is value in pixels - means width of 360 unroled image
{
  int i;
  int j;
  unsigned Value;
  int r,g,b;
  unsigned char color;
  for (i = 0;i<Output->XSize;++i) for (j = 0;j<Output->YSize;++j)
  {
    double X = X0+RATIO*cos(2*M_PI*(float)i/Output->XSize)*(R0+j);
    double Y = Y0+sin(2*M_PI*(float)i/Output->XSize)*(R0+j);
    if ((X<1) || (Y<1) || (X>Input->XSize-2) || (Y>Input->YSize-2))
    {
      if (j>0)
        SetImage8Pixel(Output,i,j,Image8Pixel(Output,i,j-1))
      else
      if (j<Output->YSize-1)
        SetImage8Pixel(Output,i,j,Image8Pixel(Output,i,j+1));

    }
    else
    {
      bilinear(Input, X, Y, r, g, b);
      color=int(0.299*r+0.587*g+0.114*b);
      SetImage8Pixel(Output,i,j,color);
    }
  }
}

int GetSimplePerspectiveHeight(int width, float alpha)
{
   float Distance = width/(2.0*tan(alpha/2.0));
   return (int)Distance;

}

void PerspectiveTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0,float R0,float R, float offset, float alpha, bool invert)
{
  int width  = Output->XSize;
  int height = Output->YSize;
  int r,g,b;
  float Distance = width/(2.0*tan(alpha/2.0));
  for (int i = 0;i<Output->XSize;++i) for (int j = 0;j<Output->YSize;++j)
  {
    // distance to the perspective projection plane from the focus
    float Dist = sqrt((width/2.0-i)*(width/2.0-i)+Distance*Distance);
    float vect = height/2.0 + Distance*(j/Dist - height/(2*Dist));

    float angle = offset + atan(width/(2.0*Distance)) + atan((width/2.0-i)/Distance);
    double X = X0+RATIO*cos(angle+M_PI)*(R-(R-R0)*vect/Output->YSize);
    double Y = Y0+sin(angle+M_PI)*(R-(R-R0)*vect/Output->YSize);

    if (X<0) X = 0; else if (X>=Input->XSize) X = Input->XSize-1;
    if (Y<0) Y = 0; else if (Y>=Input->YSize) Y = Input->YSize-1;
    bilinear(Input, X, Y, r, g, b);
    if (!invert)
      SetImageRGBPixel(Output,width-i-1,Output->YSize-j-1,r,g,b)
    else
      SetImageRGBPixel(Output,width-i-1,j,r,g,b);
  }
}

int LoadValues(char *FileName)
{
  FILE *f;
  if ((f=fopen(FileName,"r"))!=NULL)
   {
     double  v;
     int i=0;
     while (fscanf(f, "%f", &v)!=EOF)
     {
        Caliber[i]=v;
        i++;
     };
     fclose(f);
     return 1;
   }
   else
   return 0;
}
float GetPointY(circle *c, int x, int mult)
{  // get point on the circle
   double param=c->radius*c->radius-(x-c->center.xw)*(x-c->center.xw);
   // if it's out the circle
   if (param<0)
      return 0;
   float rem=sqrt(param)*mult+c->center.yw;
   return rem;
}

void ThreePointCircle(circle *c)
{
    vertex *v1 = &c->p1;
    vertex *v2 = &c->p2;
    vertex *v3 = &c->p3;
    float bx = v1->xw; float by = v1->yw;
    float cx = v2->xw; float cy = v2->yw;
    float dx = v3->xw; float dy = v3->yw;
    float temp = cx*cx+cy*cy;
    float bc = (bx*bx + by*by - temp)/2.0;
    float cd = (temp - dx*dx - dy*dy)/2.0;
    float det = (bx-cx)*(cy-dy)-(cx-dx)*(by-cy);
    if (fabs(det) < 1.0e-6) {
        c->center.xw = c->center.yw = 1.0;
        c->p1 = *v1;
        c->p2 = *v2;
        c->p3 = *v3;
        return;
        }
    det = 1/det;
    c->center.xw = (bc*(cy-dy)-cd*(by-cy))*det;
    c->center.yw = ((bx-cx)*cd-(cx-dx)*bc)*det;
    cx = c->center.xw; cy = c->center.yw;
    c->radius = sqrt((cx-bx)*(cx-bx)+(cy-by)*(cy-by));
}

int CircleIntersection(circle *c1, circle *c2,int down)
{ // computing intersection of two circles
  float d=sqrt((c1->center.xw-c2->center.xw)*(c1->center.xw-c2->center.xw)+(c1->center.yw-c2->center.yw)*(c1->center.yw-c2->center.yw));
  int y2=c2->center.yw;
  int y1=c1->center.yw;
  int x2=c2->center.xw;
  int x1=c1->center.xw;
  int r1=c1->radius;
  int r2=c2->radius;
  float sq=sqrt(((r1+r2)*(r1+r2)-d*d)*(d*d-(r2-r1)*(r2-r1)));
  float x=(x2+x1)/2+((x2-x1)*(r1*r1-r2*r2))/(2*d*d)-down*(y2-y1)/(2*d*d)*sq;
  float y=(y2+y1)/2+((y2-y1)*(r1*r1-r2*r2))/(2*d*d)+down*(x2-x1)/(2*d*d)*sq;

  return (int)x;

}

//////////////////////////////////////////////////////////////////////////////
// Functions for hyperbolic computations
//////////////////////////////////////////////////////////////////////////////

float Hyperbol::SetPerspectiveProjection(float AxA, float AxB, int Radius, int Inner, int MWidth, int PlaneWidth, float alphaBeg, float alphaEnd)
{  // inicialization and return of the perspective plane height
  //f=fopen("c:\\out.txt","w");
  AxisA = AxA;
  AxisB = AxB;
  // angle of the perspective horizontal view
  float alpha = fabs(alphaBeg-alphaEnd);
  if (alphaEnd < alphaBeg)
  {
    EndAngle   = alphaBeg;                  // greater
    BeginAngle = alphaEnd;                  // smaller
  }
  else
  {
    EndAngle   = alphaEnd;                // greater
    BeginAngle = alphaBeg;                // smaller
  }
  // perpendicular distance to the plane from the mirror focus - !! depends on the plane width !!
//  Distance = PlaneWidth/(2*sin(alpha/2));
  Distance = PlaneWidth/(2*tan(alpha/2));
  MirrorWidth = MWidth/2;               // half radius
  // computing hyperbola excentricity
  e = sqrt(AxA+AxB);
  y1 = 2*e + GetHyperY(MirrorWidth);
  // compute distance from camera focus to camera plane
  y2 = y1*Radius/(float)MirrorWidth;
  // the highest line on the outer border of the mirror
  // fprintf(f,"y2 %f\n",y2);
  float q1 = GetHyperY(MirrorWidth)/MirrorWidth;
  //fprintf(f,"q1 %f\n",q1);
  // x-coordinate of the lower point on the hyperbola
  float x1=Inner*(float)y1/y2;
  // fprintf(f,"x1 %f\n",x1);
  // the lower line in the inner part of the mirror
  float q2 = GetHyperY(x1)/x1;
  // fprintf(f,"q2 %f\n",q2);
  // maximal y-coordinate on the projection plane regarding to the mirror focus coordinate system
  Ymax = q1 * Distance;
  // mminimal y-coordinate on the projection plane regarding to the mirror focus coordinate system
  Ymin = q2 * Distance;

  float PlaneHeight = fabs(Ymax-Ymin);
  // fprintf(f,"ScaleY %f\n",ScaleY);
  return PlaneHeight;
}

float Hyperbol::SetCylinderProjection(float AxA, float AxB, int Radius, int Inner, int MWidth, int PlaneWidth)
{  // inicialization and return of the cylinder plane height
  AxisA = AxA;
  AxisB = AxB;
  // perpendicular distance to the plane from the mirror focus - !! depends on the plane width !!
  Distance = PlaneWidth/(2.0*M_PI);
  MirrorWidth = MWidth/2;               // half radius
  // computing hyperbola excentricity
  e = sqrt(AxA+AxB);
  y1 = 2*e + GetHyperY(MirrorWidth);
  // compute distance from camera focus to camera plane
  y2 = y1*Radius/(float)MirrorWidth;
  // the highest line on the outer border of the mirror
  // fprintf(f,"y2 %f\n",y2);
  float q1 = GetHyperY(MirrorWidth)/MirrorWidth;
  //fprintf(f,"q1 %f\n",q1);
  // x-coordinate of the lower point on the hyperbola
  float x1=Inner*(float)y1/y2;
  // fprintf(f,"x1 %f\n",x1);
  // the lower line in the inner part of the mirror
  float q2 = GetHyperY(x1)/x1;
  // fprintf(f,"q2 %f\n",q2);
  // maximal y-coordinate on the projection plane regarding to the mirror focus coordinate system
  Ymax = q1 * Distance;
  // mminimal y-coordinate on the projection plane regarding to the mirror focus coordinate system
  Ymin = q2 * Distance;
  float PlaneHeight = fabs(Ymax-Ymin);
  // fprintf(f,"ScaleY %f\n",ScaleY);
  return PlaneHeight;
}


float Hyperbol::GetHyperY(float x)
{  // return intersection point on the hyperbol
   return sqrt(AxisA+x*x*AxisA/AxisB)-e;
}

float Hyperbol::GetHyperX(float y)
{  // return intersection point on the hyperbol
   return sqrt((y+e)*(y+e)*AxisB/AxisA-AxisB);
}

float Hyperbol::InterSectX(float q)
{  // q - line direction through the pixel on the plane and the mirror focus
   // return X coordinate of the mirror point to compute projection through the projection center
   // computing kvadratic equation and their elements a,b,c and diskriminant D

   float a=AxisB*q*q-AxisA;
   float b=-2*AxisB*q*e;
   float c=AxisB*e*e-AxisA*AxisB;
   float D=b*b-4*a*c;
   float result=(-b+sqrt(D))/(2*a);
   return result;

}

void Hyperbol::RayPartTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0, bool invert)
// geometricaly transforms part of the image in degrees into panoramic view
// Position is value in degrees from begin of the image
// Width is value in pixels - means width of 360 unroled image
{
  int r,g,b;
  int Width = Output->XSize;
  for (int i = 0;i<Output->XSize;i++)
  {
    // projection plane distance in the x-plane
    float Dalpha = sqrt((Width/2-i)*(Width/2-i)+Distance*Distance);
    for (int j = 0;j<Output->YSize;j++)
    {
      // line direction through the pixel on the plane and the mirror focus
      float q = (Ymax-j)/Dalpha;
      // x-coordinate of the mirror point
      float Xm = InterSectX(q);
      // compute length of the vector on the camera plane - the input image
      float CamVect = Xm*y2/y1;
      // compute angle of the coincident plane with y-axis to determine angle in circle input image
      float ang = atan((Width-2*i)/(float)(2*Distance));
      float alpha = (EndAngle-BeginAngle)/2+BeginAngle+ang;
      float X = X0+RATIO*cos(alpha)*(CamVect);
      float Y = Y0+sin(alpha)*(CamVect);
      bilinear(Input, X, Y, r, g, b);
      if (invert)
        SetImageRGBPixel(Output,Width-i-1,Output->YSize-j-1,r,g,b)
      else
        SetImageRGBPixel(Output,Width-i-1,j,r,g,b);
    }
  }
}

void Hyperbol::RayTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0, bool invert, float Offset)
// geometricaly transforms whole image into the cylinder
// Position is value in degrees from begin of the image
// Width is value in pixels - means width of 360 unroled image
{
  int r,g,b;
  int Width = Output->XSize;
  for (int i = 0;i<Output->XSize;i++)
  {
    for (int j = 0;j<Output->YSize;j++)
    {
      // line direction through the pixel on the plane and the mirror focus
      float q = (Ymax-j)/Distance;
      // x-coordinate of the mirror point
      float Xm = InterSectX(q);
      // compute length of the vector on the camera plane - the input image
      float CamVect = Xm*y2/y1;
      float alpha = 2.0*M_PI*i/Width;
      float X = X0+RATIO*cos(alpha+Offset)*(CamVect);
      float Y = Y0+sin(alpha+Offset)*(CamVect);
      bilinear(Input, X, Y, r, g, b);
      if (invert)
        SetImageRGBPixel(Output,i,Output->YSize-j-1,r,g,b)
      else
        SetImageRGBPixel(Output,i,j,r,g,b);
    }
  }
}



void CircleTranslation(circle *c1, circle *c2, circle *c3, circle *c4, int Side)
{ // translate all circles in y direction
  if (Side==0)
  {
    /*
    c1->center.yw=c1->radius;
    c2->center.yw=c2->radius;
    c3->center.yw=c3->radius;
    c4->center.yw=c4->radius;
    */
    c1->center.yw-=20;
    c2->center.yw-=20;
    c3->center.yw-=20;
    c4->center.yw-=20;
  }
  else
  {
    c1->center.yw=Side - c1->radius;
    c2->center.yw=Side - c2->radius;
    c3->center.yw=Side - c3->radius;
    c4->center.yw=Side - c4->radius;
  }
}


