//---------------------------------------------------------------------------
#include "dshow_hack.h"
#include <vcl.h>
#include <ImageFun.h>
#pragma hdrstop
#include "UnitMainTest.h"
#include "UnitMain.h"
#include "TCPMessages.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ImageControl"
#pragma link "ZoomPanel"
#pragma resource "*.dfm"
TFormMainTest *FormMainTest;
//---------------------------------------------------------------------------

__fastcall TFormMainTest::TFormMainTest(TComponent* Owner): TForm(Owner) {
  SetEnable(true);
}
//---------------------------------------------------------------------------

int TFormMainTest::Results(int Time, unsigned int Length, char *Data) {
	AnsiString s = IntToStr(Time) + " ";
  for (unsigned i = 0; i < Length; i++)
  	s += Data[i];
	ListBoxResults->Items->Insert(0, s);
  return 0;
}
//---------------------------------------------------------------------------

int TFormMainTest::Results2(unsigned char Message, void *Data, unsigned int Length) {
  if (Message == CLN_SGM)
    ListBoxResults->Items->Insert(0, IntToStr(((ClnSgmMsg*)Data)->Time) + " Speaker: " + IntToStr(((ClnSgmMsg*)Data)->Channel));
  else if (Message == CLN_KWD)
    ListBoxResults->Items->Insert(0, IntToStr(((ClnKwdMsg*)Data)->Time) + " Keyword: " + AnsiString(((ClnKwdMsg*)Data)->Word));
}
//---------------------------------------------------------------------------

int TFormMainTest::Frames(int Time, ImageStruct *Image, unsigned int Dropped) {
/*
  if (FrameCount == 0)
    Caption = Time;
*/
	LabelDropped->Caption = IntToStr(FrameCount++) + " " + IntToStr(Dropped);

  if (CheckBox2->Checked) {
/*
    if (ImageControl->Image == NULL || ImageXSize(ImageControl->Image) != ImageXSize(Image) || ImageYSize(ImageControl->Image) != ImageYSize(Image)) {
      FREE_IMAGE(ImageControl->Image);
      ImageControl->Image = NewImageRGB(ImageXSize(Image), ImageYSize(Image));
    }
*/
    if (ImageControl->Image == NULL || ImageXSize(ImageControl->Image) != ImageXSize(Image) / 4 || ImageYSize(ImageControl->Image) != ImageYSize(Image) / 4) {
      FREE_IMAGE(ImageControl->Image);
      ImageControl->Image = NewImageRGB(ImageXSize(Image) / 4, ImageYSize(Image) / 4);
    }

    char *Src = Image->Raster;
    char *Dst = ImageControl->Image->Raster;

//    (ImageControl->Image->Raster + y * ImageControl->Image->YOffset);
    for (int y = 0; y < ImageYSize(ImageControl->Image); y++) {
      int *SrcLine = (int*)Src;
      int *DstLine = (int*)Dst;

      for (int x = 0; x < ImageXSize(ImageControl->Image); x++) {
        *DstLine = *SrcLine;
        DstLine++;
        SrcLine += 4;
      }
      Src += Image->YOffset * 4;
      Dst += ImageControl->Image->YOffset;
    }


//    ImageTransfer(ImageControl->Image, Image);
    ImageControl->Invalidate();
  }

  Sleep(TrackBar1->Position);
	return 0;
}
//---------------------------------------------------------------------------

void __fastcall TFormMainTest::Button1Click(TObject *Sender) {
	FormMain->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TFormMainTest::Button2Click(TObject *Sender) {
  FrameCount = 0;
  FormMain->Run();
  SetEnable(false);
}
//---------------------------------------------------------------------------

void __fastcall TFormMainTest::Button3Click(TObject *Sender) {
	FormMain->Stop();
  SetEnable(true);
}
//---------------------------------------------------------------------------

void __fastcall TFormMainTest::FormShow(TObject *Sender) {
	FormMain->pAudioServer->SetCallback(Results);
  FormMain->pAudioServer->SetCallback2(Results2);
  FormMain->pFrameServer->SetCallback(Frames);
}
//---------------------------------------------------------------------------

void __fastcall TFormMainTest::CheckBox1Click(TObject *Sender) {
	FormMain->pFrameServer->SetQuality(CheckBox1->Checked);
}
//---------------------------------------------------------------------------

void TFormMainTest::SetEnable(bool State) {
  Button1->Enabled = State;
  Button2->Enabled = State;
  Button3->Enabled = !State;
}
