//---------------------------------------------------------------------------
#ifndef UnitMain2H
#define UnitMain2H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <ActnList.hpp>
#include <AppEvnts.hpp>
#include <vector>
#include <deque>
#include "FrameQueue.h"
#include "ResultsQueue.h"
#include "TrackerThread.h"
#include "TransformThread.h"
#include "TrackerThreadSerialized.h"
#include "UnitDisp.h"

//---------------------------------------------------------------------------
class TFormMain2 : public TForm
{
__published:	// IDE-managed Components
  TButton *ButtonSetup;
  TButton *ButtonRun;
  TButton *ButtonStop;
	TListBox *ListBoxResults;
	TLabel *LabelDropped;
  TCheckBox *CheckBoxSS;
  TCheckBox *CheckBoxST;
  TPanel *PanelGL;
        TCheckBox *CheckBoxStabil;
  TTrackBar *TrackBarMA;
  TCheckBox *CheckBoxMirror;
  TCheckBox *CheckBoxTracking;
  TLabel *Label1;
  TLabel *Label2;
	TTrackBar *TrackBarP1;
	TLabel *Label3;
	TTrackBar *TrackBarP2;
	TLabel *Label4;
	TTrackBar *TrackBarP3;
	TLabel *Label5;
	TTrackBar *TrackBarP4;
	TTrackBar *TrackBarPW;
  TCheckBox *CheckBoxSP;
  TLabel *Label6;
  TLabel *Label7;
  TTrackBar *TrackBarMW;
  TButton *ButtonDisplay;
  TActionList *ActionList1;
  TAction *ActionFullscreen;
  TButton *ButtonFullscreen;
  TButton *ButtonSkinModel;
  TLabel *Label8;
  TTrackBar *TrackBarVQ;
  TLabel *LabelVQ;
  TLabel *Label9;
  TTrackBar *TrackBarAD;
  TLabel *LabelAD;
  TLabel *Label10;
  TApplicationEvents *ApplicationEvents1;
  TCheckBox *CheckBoxTR;
  TCheckBox *CheckBoxGL;
	TCheckBox *CheckBoxSI;
  TAction *ActionPrint;
  TButton *Button1;
  TAction *ActionClearTracks;
  TButton *Button2;
	void __fastcall ButtonSetupClick(TObject *Sender);
	void __fastcall ButtonRunClick(TObject *Sender);
	void __fastcall ButtonStopClick(TObject *Sender);
  void __fastcall ButtonDisplayClick(TObject *Sender);
  void __fastcall ActionFullscreenExecute(TObject *Sender);
  void __fastcall TrackBarMWChange(TObject *Sender);
  void __fastcall ButtonSkinModelClick(TObject *Sender);
  void __fastcall TrackBarVQChange(TObject *Sender);
  void __fastcall TrackBarADChange(TObject *Sender);
  void __fastcall ApplicationEvents1Message(tagMSG &Msg, bool &Handled);
	void __fastcall CheckBoxSIClick(TObject *Sender);
  void __fastcall ActionPrintExecute(TObject *Sender);
  void __fastcall ActionClearTracksExecute(TObject *Sender);
  void __fastcall Button2Click(TObject *Sender);
private:	// User declarations
  TMManager *MManager;
  TMManager *MManager2;

  TFrameQueue FrameQueue;
  std::deque<TCLNResult> ResultsQueue;
  std::deque<int> FrameHist;
  TFormDisp *Disp;

  int TracekerID;
  int LastDispLeft, LastDispTop, LastDispWidth, LastDispHeight;

  bool TrackerInit, TransformInit, Started;
  TTrackerThread *TrackerThread[PERSON_COUNT];
  TTrackerThreadSerialized *TrackerThreadSerialized;
  TTransformThread *TransformThread;

  bool SkinModel;
  AnsiString SkinModelFile, TrackerFile;

  int FrameCount, FrameDroppedCount;
  int Results(int Time, unsigned int Length, char *Data);
  int Results2(unsigned char Message, void *Data, unsigned int Length);
  int Frames2(int Time, TBuffer *Buffer, int Width, int Height, unsigned int Dropped);
  void SetEnable(bool State);
  void LoadINI(AnsiString FileName);
  void SaveINI(AnsiString FileName);
public:		// User declarations
	__fastcall TFormMain2(TComponent* Owner);
  __fastcall ~TFormMain2();
};
//---------------------------------------------------------------------------
extern PACKAGE TFormMain2 *FormMain2;
//---------------------------------------------------------------------------
#endif
