//---------------------------------------------------------------------------
#include "dshow_hack.h"
#include <vcl.h>
#include <math.h>
#include <IniFiles.hpp>
#pragma hdrstop
#include "UnitMain2.h"
#include "UnitMain.h"
#include "UnitDisp.h"
#include "TCPMessages.h"
#include "Logging.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain2 *FormMain2;

//---------------------------------------------------------------------------
const int FRWindow = 5000;

//---------------------------------------------------------------------------
const AnsiString SkinModelConfig = "model.txt";
const AnsiString TrackerConfig = "tracker.txt";

//---------------------------------------------------------------------------
const AnsiString SectionConfig = "Config";
const AnsiString ValueTransformation = "Transformation";
const AnsiString ValueUseOpenGL = "Use OpenGL";
const AnsiString ValueMainAngle = "Main angle";
const AnsiString ValueMainWidth = "Main width";
const AnsiString ValuePerson1 = "Person 1";
const AnsiString ValuePerson2 = "Person 2";
const AnsiString ValuePerson3 = "Person 3";
const AnsiString ValuePerson4 = "Person 4";
const AnsiString ValuePersonWidth = "Person width";
const AnsiString ValueVideoQueue = "Video queue";
const AnsiString ValueAudioDelay = "Audio delay";
const AnsiString ValueMirror = "Mirror";
const AnsiString ValueStabilization = "Stabilization";
const AnsiString ValueTracking = "Tracking";
const AnsiString ValueShowSource = "Show source";
const AnsiString ValueShowTransformed = "Show transformed";
const AnsiString ValueShowPersons = "Show persons";
const AnsiString ValueShowInfo = "Show info";

//---------------------------------------------------------------------------
__fastcall TFormMain2::TFormMain2(TComponent* Owner): TForm(Owner) {
  Started = false;
  InitLog();

  SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
  MManager = new TMManager();
  MManager2 = new TMManager();

  TFrameBuffer::MemoryManager = MManager;
  TBuffer::MemoryManager = MManager2;

  SkinModel = false;
  SkinModelFile = ExtractFilePath(Application->ExeName) + "\\" + SkinModelConfig;
  TrackerFile = ExtractFilePath(Application->ExeName) + "\\" + TrackerConfig;
#ifdef TRACKER_SERIALIZED
  TrackerThreadSerialized = new TTrackerThreadSerialized(true);
  TrackerThreadSerialized->SetModelFile(SkinModelFile);
  TrackerThreadSerialized->SetTrackerFile(TrackerFile);
	TrackerThreadSerialized->Priority = tpIdle;
  TrackerThreadSerialized->Resume();
#else
  for (int i = 0; i < PERSON_COUNT; i++) {
    TrackerThread[i] = new TTrackerThread(true);
    TrackerThread[i]->SetModelFile(SkinModelFile);
    TrackerThread[i]->SetTrackerFile(TrackerFile);
    TrackerThread[i]->Priority = tpIdle;
    TrackerThread[i]->Resume();
  }
#endif
  TransformThread = new TTransformThread(false, PanelGL->Handle);
  TransformThread->Priority = tpIdle;

  Disp = new TFormDisp(this);
  PostMessage(Handle, WM_USER, 0, 0);
}

//---------------------------------------------------------------------------
__fastcall TFormMain2::~TFormMain2() {
#ifdef TRACKER_SERIALIZED
	if (TrackerThreadSerialized) {
  	TrackerThreadSerialized->Priority = tpNormal;
    TrackerThreadSerialized->Terminate();
    TrackerThreadSerialized->WaitFor();
    delete TrackerThreadSerialized;
  }
#else
  for (int i = 0; i < PERSON_COUNT; i++) {
	 	if (TrackerThread[i]) {
    	TrackerThread[i]->Priority = tpNormal;
      TrackerThread[i]->Terminate();
      TrackerThread[i]->WaitFor();
      delete TrackerThread[i];
    }
  }
#endif
	if (TransformThread) {
  	TransformThread->Priority = tpNormal;
    TransformThread->Terminate();
    TransformThread->WaitFor();
    delete TransformThread;
  }

  if (Disp)
    delete Disp;

  ResultsQueue.clear();
  FrameQueue.clear();
  delete MManager;
  delete MManager2;
  SaveINI(ExtractFilePath(Application->ExeName) + "\\" + DefaultINI);
}

//---------------------------------------------------------------------------
void TFormMain2::LoadINI(AnsiString FileName) {
  TIniFile *ini = new TIniFile(FileName);
  try {
    TrackBarMA->Position = ini->ReadInteger(SectionConfig, ValueMainAngle, TrackBarMA->Position);
    TrackBarMW->Position = ini->ReadInteger(SectionConfig, ValueMainWidth, TrackBarMW->Position);

    TrackBarP1->Position = ini->ReadInteger(SectionConfig, ValuePerson1, TrackBarP1->Position);
    TrackBarP2->Position = ini->ReadInteger(SectionConfig, ValuePerson2, TrackBarP2->Position);
    TrackBarP3->Position = ini->ReadInteger(SectionConfig, ValuePerson3, TrackBarP3->Position);
    TrackBarP4->Position = ini->ReadInteger(SectionConfig, ValuePerson4, TrackBarP4->Position);
    TrackBarPW->Position = ini->ReadInteger(SectionConfig, ValuePersonWidth, TrackBarPW->Position);

    TrackBarVQ->Position = ini->ReadInteger(SectionConfig, ValueVideoQueue, TrackBarVQ->Position);
    TrackBarAD->Position = ini->ReadInteger(SectionConfig, ValueAudioDelay, TrackBarAD->Position);

    CheckBoxTR->Checked = ini->ReadBool(SectionConfig, ValueTransformation, CheckBoxTR->Checked);
    CheckBoxGL->Checked = ini->ReadBool(SectionConfig, ValueUseOpenGL, CheckBoxGL->Checked);

    CheckBoxMirror->Checked = ini->ReadBool(SectionConfig, ValueMirror, CheckBoxMirror->Checked);
    CheckBoxStabil->Checked = ini->ReadBool(SectionConfig, ValueStabilization, CheckBoxStabil->Checked);
    CheckBoxTracking->Checked = ini->ReadBool(SectionConfig, ValueTracking, CheckBoxTracking->Checked);

    CheckBoxSS->Checked = ini->ReadBool(SectionConfig, ValueShowSource, CheckBoxSS->Checked);
    CheckBoxST->Checked = ini->ReadBool(SectionConfig, ValueShowTransformed, CheckBoxST->Checked);
    CheckBoxSP->Checked = ini->ReadBool(SectionConfig, ValueShowPersons, CheckBoxSP->Checked);
    CheckBoxSI->Checked = ini->ReadBool(SectionConfig, ValueShowInfo, CheckBoxSI->Checked);
  }
  __finally {
    delete ini;
  }
}

//---------------------------------------------------------------------------
void TFormMain2::SaveINI(AnsiString FileName) {
  TIniFile *ini = new TIniFile(FileName);
  try {
    ini->WriteInteger(SectionConfig, ValueMainAngle, TrackBarMA->Position);
    ini->WriteInteger(SectionConfig, ValueMainWidth, TrackBarMW->Position);

    ini->WriteInteger(SectionConfig, ValuePerson1, TrackBarP1->Position);
    ini->WriteInteger(SectionConfig, ValuePerson2, TrackBarP2->Position);
    ini->WriteInteger(SectionConfig, ValuePerson3, TrackBarP3->Position);
    ini->WriteInteger(SectionConfig, ValuePerson4, TrackBarP4->Position);
    ini->WriteInteger(SectionConfig, ValuePersonWidth, TrackBarPW->Position);

    ini->WriteInteger(SectionConfig, ValueVideoQueue, TrackBarVQ->Position);
    ini->WriteInteger(SectionConfig, ValueAudioDelay, TrackBarAD->Position);

    ini->WriteBool(SectionConfig, ValueTransformation, CheckBoxTR->Checked);
    ini->WriteBool(SectionConfig, ValueUseOpenGL, CheckBoxGL->Checked);

    ini->WriteBool(SectionConfig, ValueMirror, CheckBoxMirror->Checked);
    ini->WriteBool(SectionConfig, ValueStabilization, CheckBoxStabil->Checked);
    ini->WriteBool(SectionConfig, ValueTracking, CheckBoxTracking->Checked);

    ini->WriteBool(SectionConfig, ValueShowSource, CheckBoxSS->Checked);
    ini->WriteBool(SectionConfig, ValueShowTransformed, CheckBoxST->Checked);
    ini->WriteBool(SectionConfig, ValueShowPersons, CheckBoxSP->Checked);
    ini->WriteBool(SectionConfig, ValueShowInfo, CheckBoxSI->Checked);
  }
  __finally {
    delete ini;
  }
}

//---------------------------------------------------------------------------
int TFormMain2::Results(int Time, unsigned int Length, char *Data) {
	AnsiString s = IntToStr(Time) + " ";
  for (unsigned i = 0; i < Length; i++)
  	s += Data[i];
	ListBoxResults->Items->Insert(0, s);
  return 0;
}

//---------------------------------------------------------------------------
int TFormMain2::Results2(unsigned char Message, void *Data, unsigned int Length) {
  if (Message == CLN_SGM)
    ListBoxResults->Items->Insert(0, IntToStr(((ClnSgmMsg*)Data)->Time) + " " + IntToStr(((ClnSgmMsg*)Data)->Channel));
  else if (Message == CLN_KWD)
    ListBoxResults->Items->Insert(0, IntToStr(((ClnKwdMsg*)Data)->Time) + " " + AnsiString(((ClnKwdMsg*)Data)->Word));

  if (Message == CLN_SGM || Message == CLN_KWD) {
    TCLNResult r;
    r.Message = Message;
    if (Message == CLN_SGM) {
      r.Time = ((ClnSgmMsg*)Data)->Time + TrackBarAD->Position;
      r.Channel = ((ClnSgmMsg*)Data)->Channel;
    } else {
      r.Time = ((ClnKwdMsg*)Data)->Time + TrackBarAD->Position;
      r.Keyword = ((ClnKwdMsg*)Data)->Word;
    }

    std::deque<TCLNResult>::iterator i = ResultsQueue.end();
    while (i != ResultsQueue.begin() && (i-1)->Time > r.Time)
      i--;
    ResultsQueue.insert(i, r);
//    ResultsQueue.push_back(r);
  }
  return 0;
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ButtonSetupClick(TObject *Sender) {
	FormMain->ShowModal();
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ButtonRunClick(TObject *Sender) {
  SetEnable(false);
  TransformThread->Wait();
#ifdef TRACKER_SERIALIZED
  TrackerThreadSerialized->Wait();
#else
  for (int i = 0; i < PERSON_COUNT; i++)
    TrackerThread[i]->Wait();
#endif
  FrameQueue.clear();
  FrameCount = 0;
  FrameDroppedCount = 0;
  TracekerID = -1;
  TrackerInit = false;
  TransformInit = false;
  FrameHist.clear();
  ResultsQueue.clear();
  MManager->GC();
  MManager2->GC();
  if (Disp)
    Disp->ClearStatus();
  InitLog();
  FormMain->Run();
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ButtonStopClick(TObject *Sender) {
	FormMain->Stop();
  SkinModel = false;
  SetEnable(true);
}

//---------------------------------------------------------------------------
int TFormMain2::Frames2(int Time, TBuffer *Buffer, int Width, int Height, unsigned int Dropped) {
  Log(AnsiString(this->ClassName()).c_str(), "Time: %d Timestamp: %d", int(1000.0 * clock() / CLK_TCK), Time);

  FrameCount++;
  FrameDroppedCount += Dropped;
  LabelDropped->Caption = IntToStr(FrameCount) + " " + IntToStr(Dropped);
//  Caption = IntToStr(Time) + " " + IntToStr(Time - FormMain->pAudioServer->GetLastTime());

  TFrameBuffer *FrameBuffer = new TFrameBuffer(Buffer, Width, Height, Time);
  FrameQueue.push_back(FrameBuffer);

  // transformation
  TransformThread->Wait();
  if (FrameQueue.size() > 0) {
    TFrameBuffer *FrameBuffer2 = FrameQueue.at(FrameQueue.size() - 1);
  	float PersonAngle[PERSON_COUNT];
    PersonAngle[0] = (float)TrackBarP1->Position / TrackBarP1->Max;
    PersonAngle[1] = (float)TrackBarP2->Position / TrackBarP2->Max;
    PersonAngle[2] = (float)TrackBarP3->Position / TrackBarP3->Max;
    PersonAngle[3] = (float)TrackBarP4->Position / TrackBarP4->Max;
    TransformThread->Process(FrameBuffer2, CheckBoxMirror->Checked, CheckBoxStabil->Checked, TrackBarMA->Position / 180.0 * M_PI, PersonAngle, (float)TrackBarPW->Position / TrackBarPW->Max, TrackBarMW->Position, !TransformInit, (CheckBoxTR->Checked ? TTX_ENABLED : 0) + (CheckBoxGL->Checked ? TTX_OPENGL : 0));
    TransformInit = true;
  }

  // tracking
#ifdef TRACKER_SERIALIZED
  TrackerThreadSerialized->Wait();
  if (FrameQueue.size() > 1) {
    if (CheckBoxTracking->Checked) {
      TFrameBuffer *FrameBuffer2 = FrameQueue.at(FrameQueue.size() - 2);
      TrackerThreadSerialized->Process(FrameBuffer2, !TrackerInit);
      TrackerInit = true;
    }
  }
#else
  for (int i = 0; i < PERSON_COUNT; i++)
    TrackerThread[i]->Wait();
  if (FrameQueue.size() > 1) {
    if (CheckBoxTracking->Checked) {
      TFrameBuffer *FrameBuffer2 = FrameQueue.at(FrameQueue.size() - 2);
      for (int i = 0; i < PERSON_COUNT; i++) {
        ImageStruct *Trans = FrameBuffer2->Persons[i];
        TrackerThread[i]->Process(Trans, FrameBuffer2->Time, !TrackerInit, FrameBuffer2->TrackerObjects[i], TRACKER_OBJECT_COUNT, &FrameBuffer2->TrackerObjectsCount[i]);
      }
      TrackerInit = true;
    }
  }
#endif

  // display
  while (FrameQueue.size() > (TrackBarVQ->Position + 2)) {
    TFrameBuffer *FrameBuffer2 = FrameQueue.pop_front();
    FrameHist.push_back(FrameBuffer2->Time);
    while (FrameHist.front() < (FrameHist.back() - FRWindow))
      FrameHist.pop_front();

    if (Disp) {
      Disp->Display(FrameBuffer2, CheckBoxSS->Checked, CheckBoxST->Checked, CheckBoxSP->Checked);
      while (!ResultsQueue.empty() && ResultsQueue.front().Time <= FrameBuffer2->Time) {
        TCLNResult Result = ResultsQueue.front();
        if (Result.Message == CLN_SGM)
          Disp->SetChannel(Result.Channel);
        else
          Disp->ShowKeyword(Result.Keyword);
        ResultsQueue.pop_front();
      }
      AnsiString s;
      s.printf("FPS: %.1f Processed frames: %d Dropped frames: %d AV: %d", 1000.0 * (FrameHist.size() - 1) / (float)FRWindow, FrameCount, FrameDroppedCount, Time - FormMain->pAudioServer->GetLastTime());
      Disp->StatusBar->Panels->Items[0]->Text = s;
    } else {
      delete FrameBuffer2;
      ResultsQueue.clear();
    }
    if (SkinModel) {
      ButtonStop->Click();
      ShowMessage("Select skin color pixels.");
      Disp->SkinModel.clearSamples();
      SkinModel = true;
      break;
    }
  }
  return 0;
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ButtonDisplayClick(TObject *Sender) {
  if (Disp)
    Disp->Visible = !Disp->Visible;
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ActionFullscreenExecute(TObject *Sender) {
  if (Disp) {
    if (Disp->BorderStyle == bsNone) {
      Disp->BorderStyle = bsSizeable;
      TBorderIcons bi = Disp->BorderIcons;
      bi<<biSystemMenu;
      bi<<biMinimize;
      bi<<biMaximize;
      Disp->BorderIcons = bi;
      Disp->Show();
      Disp->WindowState = wsNormal;
      Disp->Width = LastDispWidth;
      Disp->Height = LastDispHeight;
      Disp->Left = LastDispLeft;
      Disp->Top = LastDispTop;
      FormStyle = fsStayOnTop;
    } else {
      FormStyle = fsNormal;
      LastDispLeft = Disp->Left;
      LastDispTop = Disp->Top;
      LastDispWidth = Disp->Width;
      LastDispHeight = Disp->Height;
      Disp->BorderStyle = bsNone;
      Disp->BorderIcons.Clear();
      Disp->Show();
      Disp->WindowState = wsMaximized;
    }
    Disp->OnResize(Disp);
  }
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::TrackBarMWChange(TObject *Sender) {
  MManager->GC();
  MManager2->GC();
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ButtonSkinModelClick(TObject *Sender) {
  if (SkinModel) {
    SkinModel = false;
    if (Disp)
      Disp->SkinModel.saveModel(SkinModelFile.c_str());
    TrackerInit = true;
    ShowMessage("New skin model was stored.");
  } else {
    ButtonStop->Click();
    SkinModel = true;
    ButtonRun->Click();
  }
}

//---------------------------------------------------------------------------
void TFormMain2::SetEnable(bool State) {
  ButtonSetup->Enabled = State;
  ButtonRun->Enabled = State;
  ButtonStop->Enabled = !State;
  ButtonSkinModel->Enabled = State;
  ActionFullscreen->Enabled = true;
  ButtonDisplay->Enabled = true;
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::TrackBarVQChange(TObject *Sender) {
  LabelVQ->Caption = IntToStr(TrackBarVQ->Position + 2) + " frames";
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::TrackBarADChange(TObject *Sender) {
  LabelAD->Caption = IntToStr(TrackBarAD->Position) + " ms";
  FormMain->SetAudioDelay(TrackBarAD->Position);
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ApplicationEvents1Message(tagMSG &Msg, bool &Handled) {
  if (Msg.message == WM_CHAR) {
    if (Msg.wParam == 27 && Disp && Disp->BorderStyle == bsNone) {
      ActionFullscreen->Execute();
      Handled = true;
    } else if (Msg.wParam == 32 && !FormMain->Visible && Disp && Disp->BorderStyle == bsNone) {

    }
  } else if (Msg.message == WM_KEYDOWN) {
    if (Msg.wParam == VK_F11 && !FormMain->Visible && Disp && Disp->BorderStyle == bsNone) {
      Handled = true;
      if (ButtonRun->Enabled)
        ButtonRun->Click();
      else
        ButtonStop->Click();
    } else if (Msg.wParam == VK_F12) {
      Handled = true;
      ActionPrint->Execute();
    }
  } else if (!Started && Msg.hwnd == Handle && Msg.message == WM_USER) {
    Handled = true;
    Started = true;
    LoadINI(ExtractFilePath(Application->ExeName) + "\\" + DefaultINI);
    FormMain->pAudioServer->SetCallback(Results);
    FormMain->pAudioServer->SetCallback2(Results2);
    FormMain->pFrameServer->SetCallback2(Frames2);
    Disp->Show();
    TrackBarVQ->OnChange(TrackBarVQ);
    TrackBarAD->OnChange(TrackBarAD);
    CheckBoxSI->OnClick(CheckBoxSI);
    SetEnable(true);
  }
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::CheckBoxSIClick(TObject *Sender) {
	if (Disp)
		Disp->SetShowInfo(CheckBoxSI->Checked);
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ActionPrintExecute(TObject *Sender) {
  if (Disp)
    Disp->Print();
}

//---------------------------------------------------------------------------
void __fastcall TFormMain2::ActionClearTracksExecute(TObject *Sender) {
  TrackerInit = false;
}

void __fastcall TFormMain2::Button2Click(TObject *Sender)
{
  float f = 123;
  for (int i = 0; i < 1000000; i++)
    for (int j = 0; j < 50; j++)
      f = sin(f);
}
//---------------------------------------------------------------------------

