//---------------------------------------------------------------------------
#include <vcl.h>
#include <IniFiles.hpp>
#include <jpeg.hpp>
#include <math.h>
#include <algorithm>
#pragma hdrstop
#include "UnitDisp.h"
#include "ImageFun2.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ImageControl"
#pragma link "ZoomPanel"
#pragma link "DDImageControl"
#pragma resource "*.dfm"

//---------------------------------------------------------------------------
const AnsiString ImagesINI = "Images.ini";
const AnsiString SectionImages = "Images";
const TColor InactiveSpeakerColor = clBtnFace;
const TColor ActiveSpeakerColor = clYellow;
const int KeywordTimeout = 1500;
const float PersonRatio = 3.0 / 4;

//---------------------------------------------------------------------------
__fastcall TFormDisp::TFormDisp(TComponent* Owner): TForm(Owner) {
	Buffer = NULL;
  Channel = -1;
  KWComps[0].Panel = PanelW1;
  KWComps[0].Label = LabelW1;
  KWComps[0].Image = ImageW1;
  KWComps[1].Panel = PanelW2;
  KWComps[1].Label = LabelW2;
  KWComps[1].Image = ImageW2;
  KWComps[2].Panel = PanelW3;
  KWComps[2].Label = LabelW3;
  KWComps[2].Image = ImageW3;
  KWComps[3].Panel = PanelW4;
  KWComps[3].Label = LabelW4;
  KWComps[3].Image = ImageW4;
  for (int i = 0; i < PERSON_COUNT; i++)
    KWComps[i].Last = -(KeywordTimeout * CLK_TCK) / 1000;
  UpdateKeywords();

  AnsiString Path = ExtractFilePath(Application->ExeName);
  TIniFile *Ini = new TIniFile(Path + "\\" + ImagesINI);
  try {
    TStringList *Keywords = new TStringList();
    try {
      Ini->ReadSection(SectionImages, Keywords);
      for (int i = 0; i < Keywords->Count; i++) {
        AnsiString File = Ini->ReadString(SectionImages, Keywords->Strings[i], "");
        if (Keywords->Strings[i] != "" && File != "")
          ImageFiles[Keywords->Strings[i]] = Path + "\\" + File;
      }
    }
    __finally {
      delete Keywords;
    }
  }
  __finally {
    delete Ini;
  }
}

//---------------------------------------------------------------------------
__fastcall TFormDisp::~TFormDisp() {
	if (Buffer)
  	delete Buffer;
}

//---------------------------------------------------------------------------
void __fastcall TFormDisp::CreateParams(Controls::TCreateParams &Params) {
  TForm::CreateParams(Params);
  Params.ExStyle |= WS_EX_APPWINDOW;
}

//---------------------------------------------------------------------------
void TFormDisp::Display(TFrameBuffer *Buffer, bool Src, bool Trans, bool Persons) {
	ImageControlSRC->Image = NULL;
  ImageControlTR->Image = NULL;
  ImageControlP1->Image = NULL;
  ImageControlP2->Image = NULL;
  ImageControlP3->Image = NULL;
  ImageControlP4->Image = NULL;

	if (this->Buffer)
  	delete this->Buffer;
	this->Buffer = Buffer;

  if (Buffer) {
    if (Src)                                                    
      ImageControlSRC->Image = Buffer->Image2;
                                                 
    if (Trans)
      ImageControlTR->Image = Buffer->Trans;

    if (Persons) {
      ImageControlP1->Image = Buffer->Persons[0];
      ImageControlP2->Image = Buffer->Persons[1];
      ImageControlP3->Image = Buffer->Persons[2];
      ImageControlP4->Image = Buffer->Persons[3];
    }
  }
}

//---------------------------------------------------------------------------
void TFormDisp::SetChannel(int Channel) {
  this->Channel = Channel;
  PanelP1->Color = (Channel == 0) ? ActiveSpeakerColor : InactiveSpeakerColor;
  PanelP2->Color = (Channel == 1) ? ActiveSpeakerColor : InactiveSpeakerColor;
  PanelP3->Color = (Channel == 2) ? ActiveSpeakerColor : InactiveSpeakerColor;
  PanelP4->Color = (Channel == 3) ? ActiveSpeakerColor : InactiveSpeakerColor;
  StatusBar->Panels->Items[1]->Text = "Active speaker: ";
  if (Channel < 0)
    StatusBar->Panels->Items[1]->Text += "none";
  else
    StatusBar->Panels->Items[1]->Text += IntToStr(Channel + 1);
}

//---------------------------------------------------------------------------
void TFormDisp::ShowKeyword(AnsiString Keyword) {
  if (Channel >= 0 && Channel < PERSON_COUNT) {
    KWComps[Channel].Label->Caption = Keyword;
    std::map<AnsiString, AnsiString>::iterator i = ImageFiles.find(Keyword);
    if (i != ImageFiles.end()) {
      try {
        KWComps[Channel].Image->Picture->LoadFromFile(i->second);
      }
      catch (...) {
        KWComps[Channel].Image->Picture->Assign(NULL);
      }
    } else
      KWComps[Channel].Image->Picture->Assign(NULL);
    KWComps[Channel].Last = clock();
    UpdateKeywords();
    StatusBar->Panels->Items[2]->Text = "Last keyword: " + Keyword;
  }
}

//---------------------------------------------------------------------------
void TFormDisp::UpdateKeywords() {
  clock_t Now = clock();
  for (int i = 0; i < PERSON_COUNT; i++) {
    KWComps[i].Panel->Visible = (Now - KWComps[i].Last) < (KeywordTimeout * CLK_TCK) / 1000;
  /*
    KWComps[i].Label->Visible = (Now - KWComps[i].Last) < (KeywordTimeout * CLK_TCK) / 1000;
    KWComps[i].Image->Visible = KWComps[i].Label->Visible;
  */
  }
}

//---------------------------------------------------------------------------
void __fastcall TFormDisp::Timer1Timer(TObject *Sender) {
  UpdateKeywords();
}

//---------------------------------------------------------------------------
void __fastcall TFormDisp::Panel3Resize(TObject *Sender) {
  TPanel *Panel = (TPanel*)Sender;
  int w = Panel->Width / Panel->ControlCount;
  Panel->Height = w / PersonRatio;
  Panel->Top = ClientHeight - Panel->Height - StatusBar->Height;
  for (int i = 0; i < Panel->ControlCount; i++) {
    Panel->Controls[i]->Width = w;
    Panel->Controls[i]->Left = i * w;
    Panel->Controls[i]->Top = 0;
    Panel->Controls[i]->Height = Panel->Height;
  }
}

//---------------------------------------------------------------------------
void __fastcall TFormDisp::Panel4Resize(TObject *Sender) {
  TPanel *Panel = (TPanel*)Sender;
  int w = Panel->Width / Panel->ControlCount;
  Panel->Top = Panel3->Top - Panel4->Height;
  for (int i = 0; i < Panel->ControlCount; i++) {
    Panel->Controls[i]->Width = w;
    Panel->Controls[i]->Left = i * w;
    Panel->Controls[i]->Top = 0;
    Panel->Controls[i]->Height = Panel->Height;
  }
}

//---------------------------------------------------------------------------
void __fastcall TFormDisp::Panel5Resize(TObject *Sender) {
  TPanel *Panel = (TPanel*)Sender;
  Panel->Top = 0;
  Panel->Left = 0;
  Panel1->Width = Panel->Height;
  Panel1->Height = Panel->Height;

  Panel2->Left = Panel1->Width;
  Panel2->Width = Panel->Width - Panel2->Left;
  Panel2->Height = Panel2->Width / (2.0 * M_PI);
  if (Panel2->Height + PanelAbout->Constraints->MinHeight > Panel->Height)
    Panel2->Height = Panel->Height - PanelAbout->Constraints->MinHeight;
  Panel2->Top = Panel->Height - Panel2->Height;

  PanelAbout->Top = 0;
  PanelAbout->Left = Panel1->Width;
  PanelAbout->Width = Panel->Width - PanelAbout->Left;
  PanelAbout->Height = Panel2->Top;
}
                                   
//---------------------------------------------------------------------------
void __fastcall TFormDisp::FormResize(TObject *Sender) {
  StatusBar->Left = 0;
  StatusBar->Top = ClientHeight - StatusBar->Height; 
  StatusBar->Width = ClientWidth;

  Panel3->Left = 0;
  Panel4->Left = 0;
  Panel5->Left = 0;
  Panel3->Width = ClientWidth;
  Panel3->OnResize(Panel3);
  Panel4->Width = ClientWidth;
  Panel4->OnResize(Panel4);
  Panel5->Width = ClientWidth;
  Panel5->OnResize(Panel5);
  Panel5->Top = 0;
  Panel5->Height = Panel4->Top;
}

//---------------------------------------------------------------------------
void __fastcall TFormDisp::ImageControlP1Paint(TObject *Sender) {
  TDDImageControl *ImageControl = (TDDImageControl*)Sender;
  TCanvas *Canvas = ImageControl->Canvas;
  if (ImageControl->Tag >= 0 && ImageControl->Tag < PERSON_COUNT && Buffer && Buffer->Persons[ImageControl->Tag]) {
    for (int i = 0; i < Buffer->TrackerObjectsCount[ImageControl->Tag]; i++) {
      TResult &Result = Buffer->TrackerObjects[ImageControl->Tag][i];
      float xr = (float)ImageControl->Width / Buffer->Persons[ImageControl->Tag]->XSize;
      float yr = (float)ImageControl->Height / Buffer->Persons[ImageControl->Tag]->YSize;

      TRect r = Rect(xr * Result.posX - xr * Result.sizeX / 2, yr * Result.posY - yr * Result.sizeY / 2, xr * Result.posX + xr * Result.sizeX / 2, yr * Result.posY + yr * Result.sizeY / 2);
      Canvas->Brush->Style = bsClear;
      Canvas->Pen->Width = 5;
      Canvas->Pen->Color = clWhite;
      Canvas->Rectangle(r);
      Canvas->Pen->Width = 3;
//      Canvas->Pen->Color = clBlack;
      float v = sqrt(Result.velocityX * Result.velocityX + Result.velocityY * Result.velocityY);
      Canvas->Pen->Color = RGB(255.0 * std::min(1.0, v / 0.1), 0, 0);
      Canvas->Rectangle(r);
    }
  }
}

//---------------------------------------------------------------------------
void __fastcall TFormDisp::ImageControlP1Click(TObject *Sender) {
  TDDImageControl *ImageControl = (TDDImageControl*)Sender;
  if (ImageControl->Tag >= 0 && ImageControl->Tag < PERSON_COUNT && Buffer && Buffer->Persons[ImageControl->Tag]) {
    float xr = (float)ImageControl->Width / Buffer->Persons[ImageControl->Tag]->XSize;
    float yr = (float)ImageControl->Height / Buffer->Persons[ImageControl->Tag]->YSize;
    TPoint p = ImageControl->ScreenToClient(Mouse->CursorPos);
    int x = p.x / xr;
    int y = p.y / yr;
    SkinModel.getSamples(Buffer->Persons[ImageControl->Tag], x, y, x + 1, y + 1);
  }
}

//---------------------------------------------------------------------------
void TFormDisp::ClearStatus() {
  for (int i = 0; i < StatusBar->Panels->Count; i++)
    StatusBar->Panels->Items[i]->Text = "";
}

//---------------------------------------------------------------------------
void TFormDisp::SetShowInfo(bool Value) {
	ImageControlSRC->ShowInfo = Value;
  ImageControlTR->ShowInfo = Value;
  ImageControlP1->ShowInfo = Value;
  ImageControlP2->ShowInfo = Value;
  ImageControlP3->ShowInfo = Value;
  ImageControlP4->ShowInfo = Value;
}

