#include "cubicedge.h"
#include <math.h>


// ratio between width and height sides of video
extern float RATIO;
// Spline parametr <-1..0> pro bikubickou interpolaci
const double BI_A   = -0.75;

// Odvozene parametry
const double BI_A2   = BI_A + 2.0;
const double BI_A3   = BI_A + 3.0;
const double BI_2A   = BI_A * 2.0;
const double BI_2A3   = BI_A * 2.0 + 3.0;

float CurveValueY(ImageStruct *Image,float x, int y)
{ // return value from curve lying on y axis
  int ix=(int)x;
  float d = x-ix;
  float dd  = (x-ix)*(x-ix);               // x*x
  float ddd = (x-ix)*dd;                   // x*x*x

  float c0 = (-ddd+3*dd-3*d+1);
  float c1 = (3*ddd-6*dd+4);
  float c2 = (-3*ddd+3*dd+3*d+1);
  float c3 = ddd;

  float value = c3 * Image8Pixel(Image, ix - 1, y)
          + c2 * Image8Pixel(Image, ix, y)
          + c1 * Image8Pixel(Image, ix + 1, y)
          + c0 * Image8Pixel(Image, ix + 2, y);
  return value/6.0;
}

float CurveValueX(ImageStruct *Image,int x, float y)
{ // return value from curve lying on x axis
  int iy=(int)y;
  float der;
  float d = y-iy;
  float dd  = (y-iy)*(y-iy);               // x*x
  float ddd = (y-iy)*dd;                   // x*x*x

  float c0 = (-ddd+3*dd-3*d+1);
  float c1 = (3*ddd-6*dd+4);
  float c2 = (-3*ddd+3*dd+3*d+1);
  float c3 = ddd;
  float value = c3 * Image8Pixel(Image, x, iy-1)
          + c2 * Image8Pixel(Image, x, iy)
          + c1 * Image8Pixel(Image, x, iy+1)
          + c0 * Image8Pixel(Image, x, iy+2);
  return value/6.0;
}

void DrawSpline(float a, float b, float c, float d)
{
  for (int i=0; i<100; i++)
  {
    float y=i/100.0;
    float der;
    float d = y;
    float dd  = y*y;               // x*x
    float ddd = y*dd;              // x*x*x

    float c0 = (-ddd+3*dd-3*d+1)/6;
    float c1 = (3*ddd-6*dd+4)/6;
    float c2 = (-3*ddd+3*dd+3*d+1)/6;
    float c3 = ddd/6;
    float value = c0 * a + c1 * b + c2 * c + c3 * d;
  }

}

float DetectEdge(ImageStruct *Image, float centX, float centY, float radius, float ang, float &xret, float &yret)
{
   float rad=0, value, der=0;
   int hor=1, ver=1;
   float x1,x2,x3,x4;
   float y1,y2,y3,y4;
   // value to describe proper circle, RATIO given by different pixel's aspect ratio
   float x=(float)RATIO*radius*cos(ang)+centX;

   // value to describe proper ellipse
   int Xprop=(float)radius*cos(ang)+centX;
   float y=(float)radius*sin(ang)+centY;
   int ix=(int)x;
   int iy=(int)y;
   /*
   if (!((ix>1) && (iy>1) && (ix<Image->XSize-2) && (iy<Image->YSize-2)))
      return 0;
   */
   if (!((ix>1) && (iy>1) && (ix<Image->XSize-3) && (iy<Image->YSize-3)))
      return 0;
   hor=(ang>M_PI)?(-1):(1);
   ver=((ang<M_PI/2.0) || (ang>3.0*M_PI/2))?(1):(-1);
   while (ang>M_PI) ang-=M_PI;
   // osetreni mezi
   if ((ix<2) || (ix>Image->XSize-3) || (iy<2) || (iy>Image->YSize-3))
     return 0;
   // 45 - 135 stupnu nebo 225 - 315 stupnu
   if ((ang!=0) && (ang!=M_PI))
   if ((ang>(M_PI/4.0)) && (ang<(3*M_PI/4.0)))
   {
     if (ang<M_PI/2)
        ang=M_PI/2-ang;
     else
        ang-=M_PI/2;
     /////////////// compute intersections with y axis ////////////////////////
     // x-coordinate for 1 intersection with curve iy-1
     rad=hor*(iy-1-centY)/cos(ang);
     x1=RATIO*ver*rad*sin(ang)+centX;
     // x-coordinate for 2 intersection with curve iy
     rad=hor*(iy-centY)/cos(ang);
     x2=RATIO*ver*rad*sin(ang)+centX;  float x2prop=ver*rad*sin(ang)+centX;
     // x-coordinate for 3 intersection with curve iy+1
     rad=hor*(iy+1-centY)/cos(ang);
     x3=RATIO*ver*rad*sin(ang)+centX;  float x3prop=ver*rad*sin(ang)+centX;
     // x-coordinate for 4 intersection with curve iy+2
     rad=hor*(iy+2-centY)/cos(ang);
     x4=RATIO*ver*rad*sin(ang)+centX;
     if ((x1<1) || (x1>Image->XSize-3) || (x2<1) || (x2>Image->XSize-3) ||
        (x3<1) || (x3>Image->XSize-3) || (x4<1) || (x4>Image->XSize-3))
        return 0;
     ////////////// compute cubic curves //////////////////////////////////////
     float a=CurveValueY(Image,x1,iy-1);
     float b=CurveValueY(Image,x2,iy);
     float c=CurveValueY(Image,x3,iy+1);
     float d=CurveValueY(Image,x4,iy+2);
     /////////// compute cubic curve in radius direction and value on curve ///
     float k=(-a+3*b-3*c+d);
     if (k==0)
       return 0;
     else
       value = (2*b-a-c)/k;
     if ((value<0) || (value>1)) der=0; else
     der=a*(-value*value+2*value-1)+b*(3*value*value-4*value)+c*(-3*value*value+2*value+1)+d*value*value;
     if (x3>x2)
       xret = tan(ang)*value+x2prop;
     else
       xret = tan(ang)*value+x3prop;
     yret = iy + value;
    // if (hor==-1) der=-der;
   }
   else
   {
     if (ang>(3.0*M_PI/4))
        ang=M_PI-ang;
     // y-coordinate for 1 intersection with curve ix-1
     rad=ver*(ix-1-centX)/cos(ang);
     y1=hor*rad*sin(ang)/RATIO+centY;
     // y-coordinate for 2 intersection with curve ix
     rad=ver*(ix-centX)/cos(ang);
     y2=hor*rad*sin(ang)/RATIO+centY;
     // y-coordinate for 3 intersection with curve ix+1
     rad=ver*(ix+1-centX)/cos(ang);
     y3=hor*rad*sin(ang)/RATIO+centY;
     // y-coordinate for 4 intersection with curve ix+2
     rad=ver*(ix+2-centX)/cos(ang);
     y4=hor*rad*sin(ang)/RATIO+centY;
     /*
     if ((y1<0) || (y1>Image->YSize-1) || (y2<0) || (y2>Image->YSize-1) ||
        (y3<0) || (y3>Image->YSize-1) || (y4<0) || (y4>Image->YSize-1))
        return 0;
     */
     if ((y1<1) || (y1>Image->YSize-3) || (y2<1) || (y2>Image->YSize-3) ||
        (y3<1) || (y3>Image->YSize-3) || (y4<1) || (y4>Image->YSize-3))
        return 0;
////////////// compute cubic curves ///////////////////////////////////////////
     float a=CurveValueX(Image,ix-1,y1);
     float b=CurveValueX(Image,ix,y2);
     float c=CurveValueX(Image,ix+1,y3);
     float d=CurveValueX(Image,ix+2,y4);
////////////// compute cubic curve in radius direction and value on curve /////
     float k=(-a+3*b-3*c+d);
     if (k==0)
       return 0;
     else
       value = (2*b-a-c)/k;
     if ((value<0) || (value>1)) der=0; else
     der=a*(-value*value+2*value-1)/2+b*(3*value*value-4*value)/2+c*(-3*value*value+2*value+1)/2+d*value*value/2;
     if (y3>y2)
       yret = tan(ang)*value+y2;
     else
       yret = tan(ang)*value+y3;
     xret = Xprop + value;
    // if (ver==-1) der=-der;
   }
   return der;
}


