/*****************************************************************************/
/*                       Function for Image processing                       */
/*  Header file : MyImageFun.h                                               */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/
#include "Image.h"
        
void ResizeImageRGB(ImageStruct** Image, int XSize, int YSize);
void ResizeImageFloat(ImageStruct** Image, int XSize, int YSize);
void ResizeImage8(ImageStruct ** Image, int XSize, int YSize);
void DownSampleRGB(const ImageStruct *Input, ImageStruct *Output);
void DownSample(const ImageStruct *Input, ImageStruct *Output);

void GreyScale(ImageStruct *Input, ImageStruct *Output);
void GaussianMask(ImageStruct *Input, ImageStruct *Output);
int  Sobel(ImageStruct *Inp, ImageStruct *Outp);

void bilinear(const ImageStruct *Input, float X, float Y, int &r, int &g, int &b);
int  bilinear8(const ImageStruct *Input, float X, float Y);
