#ifndef _HYPER
#define _HYPER
#include "Image.h"

extern const float C_PRATIO;
extern const float C_NRATIO;
extern const float C_PRATIOHD;
extern const float C_NRATIOHD;
extern float RATIO;


struct vertex
{
  int xw,yw;
};

//void bilinear(const ImageStruct *image, float X, float Y, int &r, int &g, int &b);


struct circle
{
   vertex p1,p2,p3,center;
   int radius;
};
void NormalizeImage(ImageStruct *Input, ImageStruct *Output);
void PartTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0,float R0,float R);
int ChangeImageSize(int Xsize, float R0,float R, int OverLap);
void ThreePointCircle(circle *c);
int CircleIntersection(circle *c1, circle *c2, int down);
float GetPointY(circle *c, int x, int mult);
void CircleTranslation(circle *c1, circle *c2, circle *c3, circle *c4, int Side);
void ResizeImageFloat(ImageStruct ** Image, int XSize, int YSize);
void SimplePartTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0,float R0,float R, int Width, int Position, bool invert);
void SimplePartTransformHalf(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0,float R0,float R, int Width, int Position, bool invert, bool half);
int GetSimplePerspectiveHeight(int width, float alpha);
void PerspectiveTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0,float R0,float R, float offset, float alpha, bool invert);
class Hyperbol
// clas for hyperbolic computation
{
   public:
   float AxisA;                 // hyperbolic axis "second power"
   float AxisB;
   float e;                     // excentricity sqrt(AxisA+AxisB)
   int Distance;                // projection plane distance
   float MirrorWidth;
   float EndAngle, BeginAngle;   // define horizontal image range
   float y1;                    // distance from projection center to the upper mirror part
   float y2;                    // distance from projection center to the camera plane
   float a1,a2;                 // relative offsets from the origin 0-1 (position of the left and right output image border)
   float Ymax, Ymin;            // maximal & minimal y-coordinate on the projection plane regarding to the mirror focus coordinate system
   float GetHyperY(float x);    // return y-coordinate of the point on the hyperbole
   float GetHyperX(float y);    // return x-coordinate of the point on the hyperbole
   float InterSectX(float q);
   float SetPerspectiveProjection(float AxA, float AxB, int Radius, int Inner, int MirrorWidth, int PlaneWidth, float alphaBeg, float alphaEnd);
   void  RayPartTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0, bool invert);
   float SetCylinderProjection(float AxA, float AxB, int Radius, int Inner, int MWidth, int PlaneWidth);
   void  RayTransform(ImageStruct * Output,const ImageStruct * Input, float X0,float Y0, bool invert, float Offset);
   Hyperbol()  {  }

};
#endif //_HYPER
