/*****************************************************************************/
/*                       Image processing functions                          */
/*  Header file : fasttransform.h                                            */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*  Description : fast transformation of the omni-directional image          */
/*                                                                           */
/*  Updates :                                                                */
/*****************************************************************************/


#ifdef DIGILIB
  #include "Image.h"
#endif

class c_OmniTransform
{
   float *XArray;
   float *YArray;               // precomputed coordinates with given X0, Y0, Radius
   float Ratio;                 // ratio of the camera pixel shape
   int Width, Height;           // size of the output image
   int XSize, YSize;            // size of the input image
   float X0, Y0, Radius;
   float R0;                    // Inner radius
   float Offset;                // offset in radians
   bool Reverse;                // Inner part is higher or outer part is higher
   public:
   void SetImageParameters(int InputWidth, int InputHeight, int OutputWidth, int OutputHeight, float ratio);
   void SetTransformParameters(float XCenter, float YCenter, float radius, float InnerRadius, bool reverse, float offset);
   void Init();
#ifdef DIGILIB
   void ImageTransform(ImageStruct *Input, ImageStruct *Output, float X, float Y);
#endif
  c_OmniTransform();
  ~c_OmniTransform();
};
