//---------------------------------------------------------------------------
#ifndef TransformThreadH
#define TransformThreadH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <SyncObjs.hpp>
#include <gl.h>
#include "FrameQueue.h"
#include "Image.h"
#include "TrUt.h"
#include "circledetect.h"
#include "cubiccircle.h"
#include "StFastCircleFitter.h"
#include "FastTransform.h"

#define TTX_ENABLED 1
#define TTX_OPENGL 2 

//---------------------------------------------------------------------------
class TTransformThread : public TThread
{
private:
  int Type, LastType;
  int Count;
  TEvent *Event, *Done;
  bool Initialized;
  bool Mirror, LastMirror, Stabil, Init;
  float Angle, LastAngle;
  TFrameBuffer *Buffer;
  CTrUt *p_tr_ut;

  int DstWidth, DstHeight;
  int LastSrcWidth, LastSrcHeight, LastDstWidth, LastDstHeight;
  float PersonAngle[PERSON_COUNT];
  int PersonWidth;

  HWND Handle;
  HDC hdc;
  HGLRC hrc;
  int PixelFormat;

  float CenterX, CenterY, Radius;
  cdetection CircleDet;
  c_CubicCircle CubicDetect;
  StFastCircleFitter CircleFitter;
  c_OmniTransform *Win;

  void InitGL();
  void DoneGL();

  void InitPosition();
  void Stabilization();

  void TransformSW();
  void TransformGL();
protected:
  void __fastcall Execute();
public:
  __fastcall TTransformThread(bool CreateSuspended, HWND Handle);
  __fastcall ~TTransformThread();

  void Process(TFrameBuffer *Buffer, bool Mirror, bool Stabil, float Angle, float PersonAngle[PERSON_COUNT], float PersonWidth, int Width, bool Init, int Type);
  void Wait();
};
//---------------------------------------------------------------------------
#endif
 