//---------------------------------------------------------------------------
#include "dshow_hack.h"
#include <vcl.h>
#include <math.h>
#include <time.h>
#pragma hdrstop
#include "TransformThread.h"
#include "ImageFun.h"
#include "MyImageFun.h"
#include "Logging.h"
#pragma package(smart_init)
extern float RATIO;

//---------------------------------------------------------------------------
//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:
//
//      void __fastcall TTransformThread::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// pocet bodu pro vypocet subpixelove polohy elipsy
const int C_DETECTEDPOINTS = 200;
// prah pro spusteni globalniho vyhledani pozice elipsy
const int C_DIFFERENCE = 2;

const float InnerRadius = 80;

//---------------------------------------------------------------------------
__fastcall TTransformThread::TTransformThread(bool CreateSuspended, HWND Handle)
  : TThread(CreateSuspended)
{
  this->Handle = Handle;
  Event = new TEvent(NULL, false, false, "");
  Done = new TEvent(NULL, true, true, "");
  Initialized = false;
  p_tr_ut = NULL;
  Buffer = NULL;
  LastSrcWidth = 0;
  LastSrcHeight = 0;
  LastDstWidth = 0;
  LastDstHeight = 0;
  hdc = hrc = 0;
  Win = NULL;
  Init = false;
  Type = LastType = 0;
  Mirror = LastMirror = false;
  Angle = LastAngle = 0; 
}
//---------------------------------------------------------------------------
__fastcall TTransformThread::~TTransformThread() {
  delete Event;
  delete Done;
}

//---------------------------------------------------------------------------
void TTransformThread::InitGL() {
  hdc = GetDC(Handle);
  PIXELFORMATDESCRIPTOR pfd = {
    sizeof(PIXELFORMATDESCRIPTOR),
      1,
      /*PFD_DRAW_TO_WINDOW | */PFD_SUPPORT_OPENGL /*| PFD_DOUBLEBUFFER*/,
      PFD_TYPE_RGBA,
      24,
      0,0,0,0,0,0,
      0,0,
      0,0,0,0,0,
      32,
      0,
      0,
      PFD_MAIN_PLANE,
      0,
      0,0,
  };
  PixelFormat = ChoosePixelFormat(hdc, &pfd);
  SetPixelFormat(hdc, PixelFormat, &pfd);
  hrc = wglCreateContext(hdc);
  if(hrc == NULL)
    ShowMessage(":-)~ hrc == NULL");
  if(wglMakeCurrent(hdc, hrc) == false)
    ShowMessage("Could not MakeCurrent");
}

//---------------------------------------------------------------------------
void TTransformThread::DoneGL() {
  if (hrc) {
    wglMakeCurrent(NULL, NULL);
    wglDeleteContext(hrc);
  }
  if (hdc) {
    ReleaseDC(Handle, hdc);
  }
}

//---------------------------------------------------------------------------
void TTransformThread::InitPosition() {
  CenterX = LastSrcWidth / 2.0;
  CenterY = LastSrcHeight / 2.0;
  Radius = LastSrcHeight / 2.0;
  CircleDet.range = 300;
  CircleDet.xcent = CenterX;
  CircleDet.ycent = CenterY;
  CircleDet.radius = Radius;
  CircleDet.NewDetect(Buffer->Image, CenterX, CenterY, Radius);
  CircleDet.range = 200;
  CircleDet.xcent = CenterX;
  CircleDet.ycent = CenterY;
  CircleDet.radius = Radius;
  CircleDet.NewDetect(Buffer->Image, CenterX, CenterY, Radius);

}

//---------------------------------------------------------------------------
void TTransformThread::Stabilization() {
  if (Stabil) {
    clock_t Start = clock();

    Buffer->Gray = Buffer->AllocImage8(LastSrcWidth, LastSrcHeight);
    if (Buffer->Gray) {
      GreyScale(Buffer->Image, Buffer->Gray);
      /*
      CubicDetect.Distance = 10;
      CubicDetect.CubicDetectOld(Buffer->Gray, CenterX, CenterY, Radius, 200);
      */
      float OldCenterX, OldCenterY, OldRadius;
      OldCenterX = CenterX; OldCenterY = CenterY; OldRadius = Radius;
      CubicDetect.Distance = 40;
      CubicDetect.CubicDetectOld(Buffer->Gray, CenterX, CenterY, Radius, C_DETECTEDPOINTS);
/*      CircleDet.range = 50;
      if (fabs(CenterX - OldCenterX) + fabs(CenterY - OldCenterY) + fabs(Radius - OldRadius) > C_DIFFERENCE) {
        OldCenterX = CenterX; OldCenterY = CenterY; OldRadius = Radius;
        CircleDet.xcent = CenterX;
        CircleDet.ycent = CenterY;
        CircleDet.radius = Radius;
        CircleDet.NewDetect(Buffer->Image, CenterX, CenterY, Radius);
      }
*/
    }

    Log(AnsiString(this->ClassName()).c_str(), "Time: %d Length: %d", int(1000.0 * Start / CLK_TCK), int(1000.0 * (clock() - Start) / CLK_TCK));
  }
}

//---------------------------------------------------------------------------
void TTransformThread::TransformSW() {
  if(!Win ||
     LastSrcWidth != Buffer->Image->XSize || LastSrcHeight != Buffer->Image->YSize ||
     LastDstWidth != DstWidth || LastDstHeight != DstHeight ||
     Init || Type != LastType || Mirror != LastMirror || Angle != LastAngle) {

    if (Win) {
      delete Win;
      Win = NULL;
    }

    Win = new c_OmniTransform();

    LastSrcWidth = Buffer->Image->XSize;
    LastSrcHeight = Buffer->Image->YSize;
    LastDstWidth = DstWidth;
    LastDstHeight = DstHeight;

    InitPosition();

    Win->SetImageParameters(Buffer->Image->XSize, Buffer->Image->YSize, DstWidth, DstHeight, RATIO);
    Win->SetTransformParameters(CenterX, CenterY, Radius, InnerRadius, Mirror, Angle);
    Win->Init();
  }

  Stabilization();

  Win->ImageTransform(Buffer->Image, Buffer->Trans, CenterX, CenterY);
}

//---------------------------------------------------------------------------
void TTransformThread::TransformGL() {
  // Is OpenGL ready?
  if (hdc && hrc) {
    if(!p_tr_ut ||
       LastSrcWidth != Buffer->Image->XSize || LastSrcHeight != Buffer->Image->YSize ||
       LastDstWidth != DstWidth || LastDstHeight != DstHeight || Init || Type != LastType) {

      if (p_tr_ut) {
        p_tr_ut->ShutDown();
        delete p_tr_ut;
        p_tr_ut = NULL;
      }

      p_tr_ut = new CTrUt();
      if(!p_tr_ut->Init(/*tt_Geometrical*/tt_Simple, ipp_SkinDetect, false, Buffer->Image->XSize, Buffer->Image->YSize, DstWidth, DstHeight) ||
         !p_tr_ut->Set_SkindetectParams(0.403f, 0.322f, 4323.0f, 9160.0f, 9160.0f, 36989.0f)) {
         if(p_tr_ut->p_s_ShaderInfoLog())
                MessageBox(0, p_tr_ut->p_s_ShaderInfoLog(), "shader error", MB_OK);
        delete p_tr_ut;
        p_tr_ut = NULL;
      }

      LastSrcWidth = Buffer->Image->XSize;
      LastSrcHeight = Buffer->Image->YSize;
      LastDstWidth = DstWidth;
      LastDstHeight = DstHeight;

      InitPosition();
    }

    if(p_tr_ut) {
      if(!p_tr_ut->Upload_ImageStruct_Async(Buffer->Image)) {
        p_tr_ut->ShutDown();
        delete(p_tr_ut);
        p_tr_ut = NULL;
      }
    }

    Stabilization();

    if(p_tr_ut)
      p_tr_ut->WaitUntil_UploadFinished();

#if 0
    if (Stabil) {
      int NumPoints = 360;
//          if (p_tr_ut->FindEllipse((Radius - 40) / LastSrcWidth, (Radius + 40) / LastSrcWidth, CenterX  / LastSrcWidth, CenterY  / LastSrcHeight, 1.0 / RATIO, .01f, NumPoints)) {
      if (p_tr_ut->FindEllipse(.25f, .45f, .5f, .5f, 1.333f, .02f, 360)) {
        p_tr_ut->WaitUntil_EllipseDetectorFinished();

        unsigned short *Points = new unsigned short[2 * NumPoints];
        if (p_tr_ut->GetEllipsePoints(Points)) {
          CircleFitter.clear();
          for (int i = 0; i < NumPoints; i++) {
            short x_pixels = Points[i * 2] / 65280.0 * LastSrcWidth;
            short y_pixels = (/*1.0f - */Points[i * 2 + 1] / 65280.0) * LastSrcHeight;
            if (x_pixels >= 0 && x_pixels < LastSrcWidth && y_pixels >= 0 && y_pixels < LastSrcHeight) {
              SetImageRGBPixel(Buffer->Image, x_pixels, y_pixels, 255, 255, 255);
              CircleFitter.addPoint(x_pixels, /*LastSrcHeight / 2 - (LastSrcHeight / 2 - */y_pixels/*) / RATIO*/);
//                  CircleFitter.addPoint(LastSrcWidth / 2 - (LastSrcWidth / 2 - x_pixels) * RATIO, y_pixels);
            }
          }
          if (CircleFitter.fit()) {
            double Radius, CenterX, CenterY;
            /*double */Radius = CircleFitter.radius();
            CenterX = CircleFitter.xcenter();
            CenterY = CircleFitter.ycenter();


            for (float f = 0; f < 2 * M_PI; f += M_PI / 1000.0) {
              int x_pixels = (Radius * RATIO) * cos(f) + CenterX;
              int y_pixels = Radius * sin(f) + CenterY;
              if (x_pixels >= 0 && x_pixels < LastSrcWidth && y_pixels >= 0 && y_pixels < LastSrcHeight)
              SetImageRGBPixel(Buffer->Image, x_pixels, y_pixels, 255, 255, 255);
            }

          /*
            Radius = CircleFitter.radius();
            CenterX = CircleFitter.xcenter();
            CenterY = CircleFitter.ycenter();
          */
          }
        }

        delete[] Points;
      }
    }
#endif

    if(p_tr_ut) {
      p_tr_ut->Set_SimpleParams(InnerRadius / LastSrcWidth, Radius / LastSrcWidth, (CenterX) / (float)LastSrcWidth, 1.0 - (CenterY) / (float)LastSrcHeight, 0, 1.0 / RATIO);
//      p_tr_ut->Set_GeomParams(InnerRadius / LastSrcWidth, Radius / LastSrcWidth, (CenterX) / (float)LastSrcWidth, 1.0 - (CenterY) / (float)LastSrcHeight, 0, 1.0 / RATIO, 789.3274f, 548.144f, 60.0f, 1000, -80, 300);
      if(!p_tr_ut->Transform(1, Mirror)) {
        p_tr_ut->ShutDown();
        delete(p_tr_ut);
        p_tr_ut = NULL;
      }
    }

    if(p_tr_ut) {
      if(!p_tr_ut->Download_ImageStruct(Buffer->Trans, Angle, 0)) {
        p_tr_ut->ShutDown();
        delete(p_tr_ut);
        p_tr_ut = NULL;
      }
    }
  }
  if (!p_tr_ut)
    ImageFill(Buffer->Trans, 128);
}

//---------------------------------------------------------------------------
void __fastcall TTransformThread::Execute() {
  InitGL();

  while (!Terminated) {
    if (WaitForSingleObject((HANDLE)Event->Handle, 500) == WAIT_OBJECT_0) {
      DstHeight = int(DstWidth / M_PI) & 0xfffffffc;
      Buffer->Trans = Buffer->AllocImageRGB(DstWidth, DstHeight);
      if (Buffer->Trans) {
        for (int i = 0; i < PERSON_COUNT; i++)
          Buffer->Persons[i] = NewImageReference(Buffer->Trans, PersonAngle[i] * (DstWidth - PersonWidth), 0, PersonWidth  & 0xfffffffc, DstHeight & 0xfffffffc);

        if (Type & TTX_ENABLED) {
          clock_t s = clock();

          if (Type & TTX_OPENGL)
            TransformGL();
          else
            TransformSW();

          clock_t e = clock();
          float f = float(e - s) / CLK_TCK;
          f = f;
        } else
          ImageFill(Buffer->Trans, 128);
      }
      Done->SetEvent();
    }
  }

  if (p_tr_ut) {
    p_tr_ut->ShutDown();
    delete p_tr_ut;
  }

  if (Win)
    delete Win;

  DoneGL();
}

//---------------------------------------------------------------------------
void TTransformThread::Process(TFrameBuffer *Buffer, bool Mirror, bool Stabil, float Angle, float PersonAngle[PERSON_COUNT], float PersonWidth, int Width, bool Init, int Type) {
  WaitForSingleObject((HANDLE)Done->Handle, INFINITE);
  Done->ResetEvent();
  this->Buffer = Buffer;
  LastMirror = this->Mirror;
  this->Mirror = Mirror;
  this->Stabil = Stabil;
  LastAngle = this->Angle;
  this->Angle = Angle;
  for (int i = 0; i < PERSON_COUNT; i++)
  	this->PersonAngle[i] = PersonAngle[i];
  this->PersonWidth = PersonWidth * Width;
  this->DstWidth = Width & 0xfffffffc;
  this->Init = Init;
  LastType = this->Type;
  this->Type = Type;
  Event->SetEvent();
}

//---------------------------------------------------------------------------
void TTransformThread::Wait() {
  WaitForSingleObject((HANDLE)Done->Handle, INFINITE);
}

