/*
								+----------------------------------+
								|                                  |
								|     ***  VBO wrap class  ***     |
								|                                  |
								|   Copyright  -tHE SWINe- 2005   |
								|                                  |
								|      VertexBufferObject.cpp      |
								|                                  |
								+----------------------------------+
*/

#include <crtdbg.h>
#include <windows.h>
#include <malloc.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <gl/gl.h>
#include <vector>

#include "callstack.h"

#include "glext.h"
#include "opengl20.h"
#include "glstate.h"

#include "vertexbufferobject.h"

/*
 *								=== CVertexBufferObject ===
 */

CVertexBufferObject::CVertexBufferObject(GLenum n_target/*= GL_ARRAY_BUFFER_ARB*/)
	:m_n_primary_target(n_target), m_n_buffer_id(0),
	m_b_mapped(false), m_n_size(0), m_n_usage(0/*GL_STATIC_DRAW_ARB*/)
{
	__FuncGuard("CVertexBufferObject::CVertexBufferObject");

	CGLExtensionHandler::n_GetVertexBufferObjectARBFuncPointers();
}

CVertexBufferObject::~CVertexBufferObject()
{
	__FuncGuard("CVertexBufferObject::~CVertexBufferObject");

	if(m_n_buffer_id) {
		if(m_b_mapped)
			UnMap();
		glDeleteBuffersARB(1, &m_n_buffer_id);
		m_n_buffer_id = 0;
		m_n_size = 0;
		m_n_usage = 0; //GL_STATIC_DRAW_ARB?
	}
}

int CVertexBufferObject::b_Supported()
{
	__FuncGuard("CVertexBufferObject::b_Supported");

	return CGLExtensionHandler::b_SupportedExtension("GL_ARB_vertex_buffer_object") &&
		!CGLExtensionHandler::n_GetVertexBufferObjectARBFuncPointers();
}

int CVertexBufferObject::Alloc(int n_size, const void *p_data/*= NULL*/, GLenum n_usage)
{
	__FuncGuard("CVertexBufferObject::Alloc");

	glBufferDataARB(m_n_primary_target, n_size, p_data, n_usage);

	m_n_size = n_size;
	m_n_usage = n_usage;

	return true; // return value is for "software" (non-opengl accelerated)
	// implementations only that may actually alloc something
}

int CVertexBufferObject::Bind()
{
	__FuncGuard("CVertexBufferObject::Bind");

	if(!m_n_buffer_id) {
		glGenBuffersARB(1, &m_n_buffer_id);
		if(!m_n_buffer_id)
			return false;
	}

	glBindBufferARB(m_n_primary_target, m_n_buffer_id);

	return true;
}

int CVertexBufferObject::BindAs(GLenum n_target/*= GL_PIXEL_PACK_BUFFER_ARB*/)
{
	__FuncGuard("CVertexBufferObject::BindAs");

	if(!m_n_buffer_id) {
		glGenBuffersARB(1, &m_n_buffer_id);
		if(!m_n_buffer_id)
			return false;
	}

	glBindBufferARB(m_n_primary_target, m_n_buffer_id);

	return true;
}
// you can copy data using glReadPixels or glGetTexImage with data parameter, returned by calling p_OffsetPointer(0)

// for use in glDrawElements, etc ... !not! for data access!
void *CVertexBufferObject::p_OffsetPointer(int n_offset)
{
	__FuncGuard("CVertexBufferObject::p_OffsetPointer");

	return (void*)((char*)NULL + n_offset);
}

void CVertexBufferObject::BufferSubData(int n_offset, int n_size, const void *p_data)
{
	__FuncGuard("CVertexBufferObject::BufferSubData");

	glBufferSubDataARB(m_n_primary_target, n_offset, n_size, p_data);
}

void CVertexBufferObject::GetBufferSubData(int n_offset, int n_size, void *p_data)
{
	__FuncGuard("CVertexBufferObject::GetBufferSubData");

	glGetBufferSubDataARB(m_n_primary_target, n_offset, n_size, p_data);
}

void *CVertexBufferObject::p_Map(int n_access)
{
	__FuncGuard("CVertexBufferObject::p_Map");

	void *p_result = glMapBufferARB(m_n_primary_target, n_access);

	if(p_result != NULL) {
		m_n_access = n_access;
		m_b_mapped = true;
	}

	return p_result;
}

void *CVertexBufferObject::p_BufferPointer()
{
	__FuncGuard("CVertexBufferObject::p_BufferPointer");

	if(!m_b_mapped) {
		_ASSERTE(!b_Mapped()); // check the ogl state against m_b_mapped
		return 0;
	}

	void *p_ptr;
	glGetBufferPointervARB(m_n_primary_target, GL_BUFFER_MAP_POINTER_ARB, &p_ptr);

	return p_ptr;
} // return pointer only in case it's been mapped

int CVertexBufferObject::UnMap()
{
	__FuncGuard("CVertexBufferObject::UnMap");

	if(!m_b_mapped) {
		_ASSERTE(!b_Mapped()); // check the ogl state against m_b_mapped
		return false;
	}

	m_b_mapped = false;

	return glUnmapBufferARB(m_n_primary_target);
}

int CVertexBufferObject::n_Size()
{
	__FuncGuard("CVertexBufferObject::n_Size");

#ifdef _DEBUG
	int n_size;
	glGetBufferParameterivARB(m_n_primary_target, GL_BUFFER_SIZE_ARB, &n_size);
	_ASSERTE(n_size == m_n_size);
#endif

	return m_n_size;
}

int CVertexBufferObject::n_Usage()
{
	__FuncGuard("CVertexBufferObject::n_Usage");

	if(!m_b_mapped) {
		_ASSERTE(!b_Mapped()); // check the ogl state against m_b_mapped
		return 0;
	}

#ifdef _DEBUG
	int n_usage;
	glGetBufferParameterivARB(m_n_primary_target, GL_BUFFER_USAGE_ARB, &n_usage);
	_ASSERTE(n_usage == m_n_usage);
#endif

	return m_n_usage;
}

int CVertexBufferObject::b_Mapped()
{
	__FuncGuard("CVertexBufferObject::b_Mapped");

#ifdef _DEBUG
	int b_mapped;
	glGetBufferParameterivARB(m_n_primary_target, GL_BUFFER_MAPPED_ARB, &b_mapped);
	_ASSERTE(m_b_mapped == b_mapped);
#endif

	return m_b_mapped;
}

int CVertexBufferObject::n_AccessFlag()
{
	__FuncGuard("CVertexBufferObject::n_AccessFlag");

	if(!m_b_mapped) {
		_ASSERTE(!b_Mapped()); // check the ogl state against m_b_mapped
		return 0;
	}

#ifdef _DEBUG
	int n_access;
	glGetBufferParameterivARB(m_n_primary_target, GL_BUFFER_ACCESS_ARB, &n_access);
	_ASSERTE(m_n_access == n_access);
#endif

	return m_n_access;
}

/*
 *								=== ~CVertexBufferObject ===
 */

/*
 *		-end-of-file-
 */
