/*
								+---------------------------------+
								|                                 |
								|  ***   AMI Transform lib   ***  |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|    TransformLib_GlutTest.cpp    |
								|                                 |
								+---------------------------------+
*/

#include <windows.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <gl/gl.h>
#include <gl/glut.h>
#include <vector>

#define for if(0) {} else for

#define __declspec(x)

#include "trut.h"
// that's all we need form transform-lib

#include "glext.h"
#include "callstack.h"
#include "shader.h"
// more includes for loading proprietary shader

#include "jpeg.h"

static CTrUt *p_tr_ut;
static ImageStruct t_src_image, t_frontline_image;

static const float Pi = 3.1415926535897932384626433832795028841971f;

void Error(const char *p_s_error);
int My_Load_Shaders(std::vector<CShaderInfo*> &r_shader_info_list, const char *p_s_path);
int Save_TrueColor_BMP(char *filename, TBmp *p_bmp);

void PrintRotator()
{
	const char *p_s_rot = "/-\\|";
	static int n_pos = 0;

	printf("working [%c]\r", p_s_rot[n_pos ++ & 3]);
}

class CQPCTimer {
	LARGE_INTEGER m_n_freq;
	//
	unsigned __int64 m_n_time;
	//
	float m_f_time;

public:
	CQPCTimer()
	{
		QueryPerformanceFrequency(&m_n_freq);
		m_n_time = -1;
	}

	void ResetTimer()
	{
		m_f_time = 0;
	}

	float f_Time()
	{
		LARGE_INTEGER n_cur_time;

		QueryPerformanceCounter(&n_cur_time);
		if(m_n_time == -1)
			m_f_time = 0;
		else
			m_f_time += (float)((signed)(n_cur_time.QuadPart - m_n_time)) / m_n_freq.QuadPart;
		m_n_time = n_cur_time.QuadPart;

		return m_f_time;
	}
};

void Render()
{
	static CQPCTimer timer;
	float f_time = timer.f_Time();
	static float f_prev_time = 1.0f;
	static int n_frame_counter = 0;
	static float f_transform_time = 0.0f;
	static float f_interpret_time = 0.0f;

	n_frame_counter ++;
	if(f_time >= f_prev_time) {
		float f_fps = (float)n_frame_counter / (f_time - f_prev_time + 1.0f);

		printf("%f FPS, %f sec over detection, %f sec over interpretation\n",
			f_fps, f_transform_time / n_frame_counter, f_interpret_time / n_frame_counter);

		f_transform_time = 0.0f;
		f_interpret_time = 0.0f;
		n_frame_counter = 0;
		f_prev_time = f_time + 1.0f;
	}

	if(!p_tr_ut->Upload_ImageStruct_Async(&t_src_image))
		Error("uploading image");

	glClear(GL_COLOR_BUFFER_BIT);

	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
	glColor3f(1, 1, 1);

	if(glGetError() != GL_NO_ERROR)
		return;

	static float f = 0;
	f += .01f;
	glBegin(GL_POINTS);
	glVertex2f(f, 0);
	glEnd();

	p_tr_ut->WaitUntil_UploadFinished();

	f_time = timer.f_Time();

	float f_center_x = .5f;
	float f_center_y = .5f;
	float f_inner_radius = .35f;
	float f_radius = .45f;
	float f_pixel_ratio = 1.333f;
	float f_image_ratio = 1.333f;
	// assumed position of ellipse (center, radius range)

	const int n_points = 360; // (1 .. p_tr_ut->n_SourceProcessed_Width())

	/*float f_width_divisor = (float)p_tr_ut->n_SourceProcessed_Width() / (360 / 2 + 2);

	p_tr_ut->Set_Radial_ImageProcParams(2, f_inner_radius,
		f_radius, f_center_x, f_center_y, f_pixel_ratio, .02f);
	// treshold .02 (everything under .05 will be black)
	p_tr_ut->Set_Radial_ImageProcParams(3, f_inner_radius + .01f,
		f_radius - .01f, f_center_x, f_center_y, f_pixel_ratio, f_width_divisor * Pi);
	// +- .01f because there's an edge we need to skip
	// set filters

	glScissor(-5 + (int)((f_center_x - f_radius / f_pixel_ratio) * p_tr_ut->n_SourceProcessed_Width()),
			  -5 + (int)((f_center_y - f_radius * f_image_ratio) * p_tr_ut->n_SourceProcessed_Height()),
			  10 + (int)(f_radius * 2 / f_pixel_ratio * p_tr_ut->n_SourceProcessed_Width()), // .5x.5
			  10 + (int)(f_radius * 2 * f_image_ratio * p_tr_ut->n_SourceProcessed_Height()));
	// -5, 10 ... 5 more pixes at both sides
	glEnable(GL_SCISSOR_TEST);
	for(int i = 0; i < p_tr_ut->n_ImgProc_Num() + 1; i ++) {
		if(i == 1)
			p_tr_ut->Set_Gauss_ImageProcParams(1, 1.0f / (float)p_tr_ut->n_SourceProcessed_Width(), 0.0);
		else if(i == 2)
			p_tr_ut->Set_Gauss_ImageProcParams(1, 0.0, 1.0f / (float)p_tr_ut->n_SourceProcessed_Width());
		else if(i == p_tr_ut->n_ImgProc_Num()) {
			glDisable(GL_SCISSOR_TEST);
			glScissor(0, 0, n_points, 1);
			glEnable(GL_SCISSOR_TEST);
			// the last operation is the raytracer, we want it to plot
			// a line of few fragments with found intersections
		}

		if(p_tr_ut->b_MultipassImgProc())
			p_tr_ut->Swap_ProcessedSource_Textures();
		p_tr_ut->ProcessSourceImage(i - (i > 1), true, (!i)? p_tr_ut->n_SrcTexture_OpenGL_Id() :
			p_tr_ut->n_SrcProcessedAuxTexture_OpenGL_Id());

		if(glGetError() != GL_NO_ERROR)
			return;
	}
	glDisable(GL_SCISSOR_TEST);
	// process image trough all imgproc passes

	p_tr_ut->WaitUntil_SIPFinished();
	
	p_tr_ut->Download_ProcessedSourceImage(&t_frontline_image);*/

	p_tr_ut->FindEllipse(.35f, .45f, .5f, .5f, 1.333f, .02f, 360);
	p_tr_ut->WaitUntil_EllipseDetectorFinished();
	p_tr_ut->GetEllipsePoints((unsigned short*)t_frontline_image.Raster);

	f_transform_time += timer.f_Time() - f_time;

	p_tr_ut->Transform(1);
	// commit transformation, quad is subdivided into 256x256
	// little quads (for purposes of geometric per-vertex transformation)

	if(glGetError() != GL_NO_ERROR)
		return;

	static int b_first_time = true;
	if(b_first_time) {
		b_first_time = false;

		TBmp t_bmp;

		t_bmp.n_width = t_frontline_image.XSize;
		t_bmp.n_height = t_frontline_image.YSize;
		t_bmp.p_buffer = (unsigned __int32*)t_frontline_image.Raster;

		Save_TrueColor_BMP("edge_raytrace.bmp", &t_bmp);

		t_bmp.n_width = p_tr_ut->n_Transform_Width();
		t_bmp.n_height = p_tr_ut->n_Transform_Height();
		t_bmp.b_alpha = false;
		if(!(t_bmp.p_buffer = new unsigned __int32[t_bmp.n_width * t_bmp.n_height])) {
			fprintf(stderr, "not enough memory when testing Download_ImageStruct()");
			exit(-1);
		}
		// create a new bitmap ...

		ImageStruct t_is;

		t_is.XSize = t_bmp.n_width;
		t_is.YSize = t_bmp.n_height;
		t_is.XOffset = 4;
		t_is.YOffset = t_bmp.n_width * 4;
		t_is.PixelType = ImageRGB;
		t_is.Raster = (unsigned char*)t_bmp.p_buffer;

		for(int i = 0; i <= 360; i += 30) {
			char p_s_filename[64];

			sprintf(p_s_filename, "transform_%03d_.bmp", i);

			p_tr_ut->Download_ImageStruct/*_Async*/(&t_is, (float)i / 180 *
				3.1415926535897932384626433832795028841971f, 0);
			// download image-struct

			Save_TrueColor_BMP(p_s_filename, &t_bmp);
		}

		/*int n_image_size = t_bmp.n_width * t_bmp.n_height * 4;
		int n_src_image_size = t_src_image.XSize * t_src_image.YSize * 4;
		const int n_megabytes = 1024 * 1048576;
		int n_num_downloads = n_megabytes / n_image_size + 1;
		float f_megs = (n_num_downloads * n_image_size) / (float)1048576;

		printf("press enter ...");
		getchar();

		printf("\t\t=== data download benchmark ===\n");

		printf("now meassure performance by downloading %f GB of data ...\n", f_megs / 1024);

		long n_time = clock();

		for(int i = 0, n = 0; n < n_num_downloads; i += 31, n ++) {
			p_tr_ut->Download_ImageStruct(&t_is, (float)i / 180 *
				3.1415926535897932384626433832795028841971693993f, 0);
			// download image-struct
			PrintRotator();
		}

		float f_time = (float)(clock() - n_time) / (float)CLOCKS_PER_SEC;

		printf("done ... it took %f secs, yielding transfer rate %f MBpS\n",
			f_time, f_megs / f_time);

		printf("now meassure performance by downloading %f GB of data async ...\n", f_megs / 1024);

		n_time = clock();

		float f_saved_time = 0;

		for(int i = 0, n = 0; n < n_num_downloads; i += 31, n ++) {
			p_tr_ut->Download_ImageStruct_Async(&t_is, (float)i / 180 *
				3.1415926535897932384626433832795028841971693993f, 0);
			// download image-struct (first frame is going to be blank)

			long n_sub_time = clock();

			while(!p_tr_ut->b_DownloadFinished()) {
				PrintRotator();
				p_tr_ut->WaitUntil_DownloadFinished();
				if(!p_tr_ut->b_DownloadFinished())
					printf("!!!");
			}
			// test if it's really async (it really is!)

			f_saved_time += (float)(clock() - n_sub_time) / (float)CLOCKS_PER_SEC;
		}

		f_time = (float)(clock() - n_time) / (float)CLOCKS_PER_SEC;

		printf("done ... it took %f secs, yielding transfer rate %f MBpS\n",
			f_time, f_megs / f_time);
		printf("we saved %f secs, yielding theoretical transfer rate %f MBpS\n",
			f_saved_time, f_megs / (f_time - f_saved_time));

		printf("\n\t\t=== data upload benchmark ===\n");

		n_num_downloads = n_megabytes / n_src_image_size + 1;
		f_megs = (n_num_downloads * n_src_image_size) / (float)1048576;

		printf("now meassure performance by uploading %f GB of data ...\n", f_megs / 1024);

		n_time = clock();

		for(int i = 0, n = 0; n < n_num_downloads; i += 31, n ++) {
			p_tr_ut->Upload_ImageStruct(&t_src_image);
			// upload image-struct
			PrintRotator();
		}

		f_time = (float)(clock() - n_time) / (float)CLOCKS_PER_SEC;

		printf("done ... it took %f secs, yielding transfer rate %f MBpS\n",
			f_time, f_megs / f_time);

		printf("now meassure performance by uploading %f GB of data async ...\n", f_megs / 1024);

		n_time = clock();

		f_saved_time = 0;

		for(int i = 0, n = 0; n < n_num_downloads; i += 31, n ++) {
			p_tr_ut->Upload_ImageStruct_Async(&t_src_image);
			// upload image-struct

			long n_sub_time = clock();

			while(!p_tr_ut->b_UploadFinished()) {
				PrintRotator();
				p_tr_ut->WaitUntil_UploadFinished();
				if(!p_tr_ut->b_UploadFinished())
					printf("!!!");
			}
			// test if it's really async (it really is!)

			f_saved_time += (float)(clock() - n_sub_time) / (float)CLOCKS_PER_SEC;
		}

		f_time = (float)(clock() - n_time) / (float)CLOCKS_PER_SEC;

		printf("done ... it took %f secs, yielding transfer rate %f MBpS\n",
			f_time, f_megs / f_time);
		printf("we saved %f secs, yielding theoretical transfer rate %f MBpS\n",
			f_saved_time, f_megs / (f_time - f_saved_time));*/

		delete[] t_bmp.p_buffer;
	}
	// write a bunch of bitmaps, containing unfolded image, rotated 360 degrees with
	// 30 degree step; 360 inclusive -> first and last one should be the same

	p_tr_ut->ReleaseFramebuffer();
	// NOW release framebuffer, because we were transfering data from it
	// (otherwise we'd be reading contents of our glut window)

	if(glGetError() != GL_NO_ERROR)
		return;

	glViewport(25, 25, 800, 600); // fixed size viewport! window will not react to resize
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	// have to call this before every frame (can skip the matrix stuff in second frame and on)

	glPushMatrix();

	glScalef(1.0f, -1.0f / Pi, 0);
	// scale image so proportions are allright

	glTranslatef(0, -1.5f, 0);

	p_tr_ut->GL_TexturedRect(-1, -1, 0, 0,
							  1,  1, 1, 1, p_tr_ut->n_TransformedTexture_OpenGL_Id());
	// draw a single quad with transformed image

	glTranslatef(0, 3, 0);

	glColor3f(1, 0, 0);
	glBegin(GL_QUADS);
	glVertex2f(-1, 1);
	glVertex2f(1, 1);
	glVertex2f(1, -1);
	glVertex2f(-1, -1);
	glEnd();
	// draw red rect

	glEnable(GL_ALPHA_TEST);
	glAlphaFunc(GL_LESS, .95f);
	// enable alpha-testing, everything with alpha <.95 is drawn

	glColor3f(0, 0, 0);
	p_tr_ut->GL_TexturedRect(-1, -1, 0, 0,
							  1,  1, 1, 1, p_tr_ut->n_TransformedTexture_OpenGL_Id());
	// draw black portions of image where alpha was less

	glDisable(GL_ALPHA_TEST);
	glColor3f(1, 1, 1);
	// disable alpha test, put back white

	glPopMatrix();
	// put the scale back

	//glTranslatef(-1.2f, 0, 0);
	
	//glScalef(2, 2, 0);
	p_tr_ut->GL_TexturedRect(-1, -1, 0, 0,
							  1,  1, 1, 1, p_tr_ut->n_SrcProcessedTexture_OpenGL_Id());

	glEnable(GL_POINT_SMOOTH);
	glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor3f(1, 1, 1);
	glPointSize(2);
	glBegin(GL_POINTS);

	f_time = timer.f_Time();

	float f_x[n_points];
	float f_y[n_points];

	for(int i = 0; i < t_frontline_image.XSize; i ++) {
		f_x[i] = (float)((unsigned short*)t_frontline_image.Raster)[2 * i] / 32640.0f - 1.0;
		f_y[i] = (float)((unsigned short*)t_frontline_image.Raster)[2 * i + 1] / 32640.0f - 1.0;

		f_x[i] *= 1024;
		f_y[i] *= 768;// important to use same scale as image has
	}
	// x, y and scale it to prevent float errors

	for(int n = 0; n < 1; n ++) {
		for(int i = 0; i < t_frontline_image.XSize; i ++) {
			int iprev = (i - 1 + t_frontline_image.XSize) % t_frontline_image.XSize;
			int inext1 = (i + 1) % t_frontline_image.XSize;
			int inext2 = (i + 2) % t_frontline_image.XSize;

			float dxa = f_x[inext1] - f_x[i];
			float dya = f_y[inext1] - f_y[i];
			float inv_len_a = 1.0f / (float)sqrt(dxa * dxa + dya * dya);

			float dxb = f_x[iprev] - f_x[i];
			float dyb = f_y[iprev] - f_y[i];
			float inv_len_b = 1.0f / (float)sqrt(dxb * dxb + dyb * dyb);

			if(n) {
				int num[4] = {iprev, i, inext1, inext2};
				iprev = num[3];
				i = num[2];
				inext1 = num[1];
				inext2 = num[0];
			}
			// flip the order

			float a, b, c;

			a = -dya * inv_len_a;
			b = dxa * inv_len_a;
			c = - a * f_x[i] - b * f_y[i];
			// plane equation

			float ap, bp, cp;

			ap = -dyb * inv_len_b;
			bp = dxb * inv_len_b;
			cp = - ap * f_x[i] - bp * f_y[i];
			// plane equation b

			int eq_a = a * f_x[inext2] + b * f_x[inext2] + c;
			int eq_b = a * f_x[iprev] + b * f_x[iprev] + c;

			int eq_ap = ap * f_x[inext2] + bp * f_x[inext2] + c;
			int eq_bp = ap * f_x[iprev] + bp * f_x[iprev] + c;

			int sa = (eq_a > 0)? 1.0f : -1.0f;
			int sb = (eq_b > 0)? 1.0f : -1.0f;

			const float f_epsilon = 80.5f;

			if(eq_a > -f_epsilon) {
				if(eq_ap < -f_epsilon) {
					f_x[i] = (f_x[iprev] + f_x[inext1]) * .5f;
					f_y[i] = (f_y[iprev] + f_y[inext1]) * .5f;
				} else {
					f_x[inext1] = (f_x[i] + f_x[inext2]) * .5f;
					f_y[inext1] = (f_y[i] + f_y[inext2]) * .5f;
				}
			}
			if(eq_b > -f_epsilon) {
				f_x[i] = (f_x[iprev] + f_x[inext1]) * .5f;
				f_y[i] = (f_y[iprev] + f_y[inext1]) * .5f;
			}

			if(n)
				i = inext1;
			// flip the order again
		}
	}
	// filter values

	f_interpret_time += timer.f_Time() - f_time;

	for(int i = 0; i < t_frontline_image.XSize; i ++) {
		if(!((unsigned __int32*)t_frontline_image.Raster)[i])
			continue;
		// not-found points marked as all zeros

		float x = (float)((unsigned short*)t_frontline_image.Raster)[2 * i] / 32640.0f - 1.0;
		float y = (float)((unsigned short*)t_frontline_image.Raster)[2 * i + 1] / 32640.0f - 1.0;

		glVertex2f(f_x[i] / 1024, f_y[i] / 768);
	}
	glEnd();

	glDisable(GL_BLEND);

	glScalef(.4f, .4f, 0);
	glTranslatef(2.4f, 0, 0);
	p_tr_ut->GL_TexturedRect(-1, -1, 0, 0,
							  1,  1, 1, 1, p_tr_ut->n_SrcTexture_OpenGL_Id());
	// draw a single quad with transformed image

	if(glGetError() != GL_NO_ERROR)
		return;

	glutSwapBuffers(); // don't use p_tr_ut->GL_PageFlip(); when using glut
}

char *p_s_ReadFile(const char *p_s_filename)
{
	FILE *p_fr;

	if(!(p_fr = fopen(p_s_filename, "rb")))
		return 0;
	fseek(p_fr, 0, SEEK_END);
	int n_len = ftell(p_fr);
	char *p_s_buffer;
	if(!(p_s_buffer = new char[n_len + 1])) {
		fclose(p_fr);
		return 0;
	}
	fseek(p_fr, 0, SEEK_SET);
	fread(p_s_buffer, n_len, sizeof(char), p_fr);
	p_s_buffer[n_len] = 0;
	fclose(p_fr);

	return p_s_buffer;
}

static char *p_s_shader_file = 0;
//static int (*std_load_sh_function)(std::vector<CShaderInfo*>&, const char*);

int main(int argc, char **argv)
{
	int n_transform_type;

	printf("TransformLib example\n"
		   "call with such a parameters:\n"
		   "transformlib_test_glut.exe TT IPP <F>\n"
		   "where TT is transform type (either -simple, -geom or -polynet)\n"
		   "you may also pass IPP (either -none, -skin or -gray)\n"
		   "you may also pass external shader filename F\n"
		   "(shader must correspond with TT, IPP must be passed as well)\n"
		   "\n"
		   "Example will create 800x600 glut window, load jpeg image\n"
		   "and begin loop with transformations. In the first frame, it\n"
		   "creates \'transform_000_.bmp\' - \'transform_360_.bmp\' with purpose\n"
		   "to test image downloading. Then it displays unfolded image via OpenGL\n\n");

	if(argc < 2 || !strcmp(argv[1], "-simple"))
		n_transform_type = tt_Simple;
	else if(argc < 2 || !strcmp(argv[1], "-geom"))
		n_transform_type = tt_Geometrical;
	else if(argc < 2 || !strcmp(argv[1], "-polynet"))
		n_transform_type = tt_Geom_Polynet;
	else {
		fprintf(stderr, "first parameter must be either -simple, -geom or -polynet\n");
		return -1;
	}
	// parse params

	int n_ipp_type;

	if(argc < 3 || !strcmp(argv[2], "-none"))
		n_ipp_type = ipp_None;
	else if(argc < 3 || !strcmp(argv[2], "-skin"))
		n_ipp_type = ipp_SkinDetect;
	else if(argc < 3 || !strcmp(argv[2], "-gray"))
		n_ipp_type = ipp_CalcGrayscale;
	else {
		fprintf(stderr, "second parameter must be either either -none, -skin or -gray\n");
		return -1;
	}
	// parse params

	char *p_s_par1[] = {"-simple", "-geom", "-polynet"};
	char *p_s_par2[] = {"-none", "-skin", "-gray"};
	printf("you've chosen %s %s .. moderate choice!\n\n",
		p_s_par1[n_transform_type], p_s_par2[n_ipp_type]);

	if(argc >= 4)
		p_s_shader_file = argv[2];
	// shader file

    glutInit(&argc, argv);
    glutInitWindowSize(850, 650);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
    glutCreateWindow("Very simple TransformLib demo");

	// ---

	CTrUt my_transform_util;
	p_tr_ut = &my_transform_util;

	tImage *p_bmp;
	if(n_transform_type == tt_Simple)
		p_bmp = LoadJPG("mirror_new.jpg");
	else
		p_bmp = LoadJPG("mirror_h3g.jpg");
	if(!p_bmp) {
		fprintf(stderr, "error loading source image, make sure mirror_new.jpg\n"
						"or mirror_h3g.jpg is in the same folder as .exe\n");
		return -1;
	}
	memset(&t_src_image, 0, sizeof(t_src_image));
	t_src_image.PixelType = ImageRGB;
	if(p_bmp->channels != 4) {
		fprintf(stderr, "source image doesn't have four channels (RGBx)\n"
						"no conversion was implemented .. quitting though\n");
		return -1;
	}
	t_src_image.Raster = p_bmp->data;
	t_src_image.XSize = p_bmp->sizeX;
	t_src_image.YSize = p_bmp->sizeY;
	t_src_image.XOffset = 4;
	t_src_image.YOffset = p_bmp->sizeX * 4;
	delete p_bmp;
	// load source image from jpeg

	int p_sip_list[] = {sip_Gray, sip_Gauss5_Mono,
		sip_Sobel_RadialCutoffMono, sip_RaytraceFrontline};
	// we want grayscale filter, gauss filter, radial sobel filter and raytracer

	//std_load_sh_function = my_transform_util.std_Load_Shaders;
	if(!my_transform_util.Init(n_transform_type, n_ipp_type, true,
		t_src_image.XSize, t_src_image.YSize,
	   t_src_image.XSize * Pi / (1 + (n_transform_type == tt_Simple)), t_src_image.XSize / 2,
	   0, 0, false, /*or "p_sip_list, sizeof(p_sip_list) / sizeof(p_sip_list[0]), true,"*/
	   GL_BGRA, GL_UNSIGNED_BYTE, GL_BGRA, GL_UNSIGNED_BYTE,
	   my_transform_util.std_Load_RenderPaths, (!p_s_shader_file)?
	   my_transform_util.std_Load_Shaders : My_Load_Shaders))
		Error("initializing");
	// call init (it's important so image type is RGBA ... size of buffer for asynchronous
	// copying is determined from this)

	memset(&t_frontline_image, 0, sizeof(t_frontline_image));
	t_frontline_image.PixelType = ImageRGB;
	t_frontline_image.XSize = my_transform_util.n_SourceProcessed_Width() / 4;
	t_frontline_image.Raster = new unsigned char[t_frontline_image.XSize * 4];
	t_frontline_image.YSize = 1;
	t_frontline_image.XOffset = 4;
	t_frontline_image.YOffset = t_frontline_image.XSize * 4;
	// create bitmap for storing "frontline" - output from edge raytracer

	if(n_ipp_type == ipp_SkinDetect) {
		if(!my_transform_util.Set_SkindetectParams(20.172f / 50.0f, 15.379f / 50.0f))
			Error("setting skin-detection params");
	}
	// set skin-detection params

	if(n_transform_type == tt_Simple) {
		if(!my_transform_util.Set_SimpleParams(.02f,
			416 / 1440.0f, 690 / 1440.0f, 1.0f - 533 / 1080.0f, 0, 1.333f))
			Error("setting transformation params");
		// 416 is radius of the mirror, meassured in vertical direction,
		// 1440 is width, 690 is center-x, 533 is center-y, 1080 is image height
	} else {
		if(!my_transform_util.Set_GeomParams(.033f, .400f, .508f, .487f, 0, 1.1f,
		   789.3274f, 548.1440f, 30.0f, 1000.0f, -750, 4000))
			Error("setting transformation params"); // -8.7, 55.0
	}

	// --- ~init open-gl

	glutIdleFunc(Render);
	glutDisplayFunc(Render);
    glutMainLoop();

	delete[] t_frontline_image.Raster;

    return 0;
}

void Error(const char *p_s_error)
{
	switch(p_tr_ut->n_GetLastError()) {
	case trut_Ok:
		fprintf(stderr, "no error");
		break;
	case trut_Error:
		fprintf(stderr, "generic error - trut kaput");
		break;
	case trut_BadParams:
		fprintf(stderr, "invalid parameters");
		break;
	case trut_NoPaths:
		fprintf(stderr, "no supported paths found");
		break;
	case trut_NoShaders:
		fprintf(stderr, "no shaders found");
		break;
	case trut_NoRenderBuffer:
		fprintf(stderr, "no offscreen render buffers supported");
		break;
	case trut_NoMemory:
		fprintf(stderr, "not enough memory");
		break;
	case trut_GLError:
		fprintf(stderr, "OpenGL error");
		break;
	case trut_NoGL13:
		fprintf(stderr, "need at lest OpenGL 1.3");
		break;
	case trut_NoMultitextureExt:
		fprintf(stderr, "need multitexture extension");
		break;
	case trut_NoShaderExt:
		fprintf(stderr, "need shaders");
		break;
	case trut_BadPixelType:
		fprintf(stderr, "unsupported pixel type");
		break;
	case trut_ShCompileError:
		fprintf(stderr, "shader compile error");
		if(p_tr_ut->p_s_ShaderInfoLog())
			fprintf(stderr, " - see error log:\n%s\n ..", p_tr_ut->p_s_ShaderInfoLog());
		break;
	}

	if(p_s_error)
		fprintf(stderr, " when %s\n", p_s_error);
	else
		fprintf(stderr, "\n");

	exit(-1);
}

int My_Load_Shaders(std::vector<CShaderInfo*> &r_shader_info_list, const char *p_s_path)
{
	if(p_s_shader_file) {
		char *p_s_source = p_s_ReadFile(p_s_shader_file);
		if(!p_s_source)
			return false;

		CShaderInfo *p_shader_info;

		if(!(p_shader_info = new CShaderInfo(p_s_shader_file,
		   sh_lang_HighLevel, sh_type_Fragment)))
			return false;
		// create new shader info, shader name is simple_unwrap,
		// it's gefault language is high level shading language
		// and it is fragment shader (i.e. it's processing pixels)

		TShaderInfo simple_unwrap_glsl_shader;
		char *p_params = "texture"; // texture sampler (automatically set to unit 0 in CGLProgramObject::BindGL)
		simple_unwrap_glsl_shader.n_param_num = 1;
		simple_unwrap_glsl_shader.p_param_name_array = &p_params;
		simple_unwrap_glsl_shader.p_s_code = p_s_source;

		if(!p_shader_info->SetHighLevel_Code(simple_unwrap_glsl_shader)) {
			delete p_shader_info;
			return false;
		}
		// copy shader info into our shader

		r_shader_info_list.push_back(p_shader_info);
		if(!r_shader_info_list.size()) {
			delete p_shader_info;
			return false;
		}
		// put our shader info into the list

		delete[] p_s_source;
		// don't need this any more
	}
	// load shader in file

	/*if(!std_load_sh_function(r_shader_info_list, p_s_path))
		return false;*/
	// load std shader - DON'T do that!! it's mixing pointers created in
	// transformlib.dll and here .. and it doesn't seem to be good

	return true;
}

int Save_TrueColor_BMP(char *filename, TBmp *p_bmp)
{
	unsigned int n_scanline_size;
	unsigned char *p_buffer;
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	FILE *p_fw;
	int i, j;

	n_scanline_size = ((3 * p_bmp->n_width + 3) >> 2) << 2;
	if(!(p_buffer =  new unsigned char[n_scanline_size]))
		return false;
	// compute lenght of line-buffer

	if(!(p_fw = fopen(filename, "wb")))
		return false;
	// open file

	bmih.biSize = sizeof(BITMAPINFOHEADER);
	bmih.biWidth = p_bmp->n_width;
	bmih.biHeight = p_bmp->n_height;
	bmih.biPlanes = 1;
	bmih.biBitCount = 24;
	bmih.biCompression = BI_RGB;
	bmih.biSizeImage = p_bmp->n_width * p_bmp->n_height * 3;
	bmih.biXPelsPerMeter = 96;
	bmih.biYPelsPerMeter = 96;
	bmih.biClrUsed = 0;
	bmih.biClrImportant = 0;
	//
	bmfh.bfType = ('B' | ('M' << 8));
	bmfh.bfSize = sizeof(BITMAPFILEHEADER) + bmih.biSizeImage +
				  sizeof(BITMAPINFOHEADER);
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = sizeof(BITMAPFILEHEADER) +
					 sizeof(BITMAPINFOHEADER);
	// create header

	fwrite(&bmfh, sizeof(BITMAPFILEHEADER), 1, p_fw);
	fwrite(&bmih, sizeof(BITMAPINFOHEADER), 1, p_fw);
	// writing header

	for(i = p_bmp->n_height - 1; i >= 0; i --) {
		for(j = 0; j < p_bmp->n_width; j ++) {
			p_buffer[j * 3] = (char)((p_bmp->p_buffer[i * p_bmp->n_width + j] >> 16) & 0xff);
			p_buffer[j * 3 + 1] = (char)((p_bmp->p_buffer[i * p_bmp->n_width + j] >> 8) & 0xff);
			p_buffer[j * 3 + 2] = (char)(p_bmp->p_buffer[i * p_bmp->n_width + j] & 0xff);
			// saved in BGR, not RGB
		}

		if(fwrite(p_buffer, 1, n_scanline_size, p_fw) != n_scanline_size) {
			delete[] p_buffer;
			fclose(p_fw);

			return false;
		}
	}

	fclose(p_fw);
	delete[] p_buffer;

	return true;
}

/*
 *		-end-of-file-
 */
