/*
								+---------------------------------+
								|                                 |
								|  ***   AMI Transform lib   ***  |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|           Transform.h           |
								|                                 |
								+---------------------------------+
*/

#ifndef __AMI_TRANSFORM_INCLUDED
#define __AMI_TRANSFORM_INCLUDED

class __declspec(dllexport) COmniDirectionalTransform {
protected:
	std::vector<TPath*> m_path_list;
	std::vector<CShaderInfo*> m_shader_list; // all available shaders

	int m_n_chosen_path;
	int m_n_chosen_lang;
	int m_n_chosen_shader;

	TGLShaderParam *m_p_shader_param;
	int m_n_shader_param_num;
	CGLProgramObject *m_p_shader;

	CVertexBufferObject m_vertex_buffer;
	int m_n_tesselation, m_n_texcoords_offset;

public:
	COmniDirectionalTransform();
	~COmniDirectionalTransform();

	int b_Have_LowLevel_ShadingLanguage() const;
	// return true if card does support low level sl
	int b_Have_HighLevel_ShadingLanguage() const;
	// return true if card does support high level sl

	int LoadPaths(int (*Load_RenderPaths)(std::vector<TPath*>&));

	int n_CompatibleRenderPath_Num() const;
	const TPath *p_CompatibleRenderPath(int n_index) const;
	int ChooseRenderPath(int n_index);

	int LoadShaders(int (*load_sh_function)(std::vector<CShaderInfo*>&, const char*)); // can be called after render path was chosen

	int UseShadingLanguage(int b_high_level);

	int n_Shader_Num();
	const char *p_s_ShaderName(int n_index);
	// list of shaders available in chosen language
	// shaders for no unwrapping will begin with "imgproc_"
	// shaders for simple unwrapping will begin with "simple_"
	// shaders for geometric unwrapping will begin with "geom_"
	// shaders for geometric unwrapping will begin with "polynet_"
	// next there's immediate post processing type (alpa channel contents)
	// "noipp_" for none (i.e. defined by source texture)
	// "skin_" for skin detection
	// "gray_" for grayscale generation
	// (it's convention, i followed when writing shader sources (currently in shaderdata.h),
	// also COmniDirectionalTransform::CompileShader relies on it, because it needs to know
	// how much and what kind of shader params it needs to create)
	int ChooseShader(int n_index);
	int n_ChosenShader();

	int CompileShader(char *&r_p_error_message); // compile chosen shader
	int FreeShader();

	void FreeShadersPaths();
	// free shader and path lists, when we chose shader and have it compiled

	float &f_MirrorCenter_x();
	float &f_MirrorCenter_y();
	// center of mirror in texture space (typically 0.5, 0.5)

	float &f_SideRatio();
	// width/height of image in pixels (assuming it's 1x1 in texture space, have to do
	// some extra calculations if your card doesn't support non power of two textures)

	float &f_OuterRadius();
	// mirror radius in texture space (could be 0.5 if mirror occupied the whole image,
	// but it's going to be less in practise)

	float &f_InnerRadius();
	// inner radius in texture space ()

	float &f_AngularOffset();
	// angle where we begin with unwrapping

	float &f_Pixel_Height();
	float &f_Pixel_Width();
	// output pixel width and height in texture coords, i.e. 1.0 / output resloution

	float &f_MirrorGeom(int n_component);
	float &f_MirrorGeom2(int n_component);
	// access to mirror_geom and mirror_geom2 parameters
	// (call when using geometric transformation ONLY)

	float &f_Bottom_Y();
	float &f_Cyl_Height(); // contains top_y - bottom_y
	// projection cylinder bounds
	// (call when using geometric transformation ONLY)

	float &f_Covariant(int n_i, int n_j); // k(ij), i, j = <0, 1>
	float &f_AvgComponents(int n_index);
	// n_index 0 ~ R, 1 ~ G; enter values in range <0, 1> not <0, 255>
	// skin detection parameters

	float &f_GaussDir(int n_coord);

	void DrawUniformFullscreenQuad(unsigned int n_source_texture, CGLState *p_state);
	// draw fullscreen quad with shader bound, causing transform to compute
	// unlike the next two functions, here texture coordinates aren't multiplied by
	// transformation parameters

	void DrawFullscreenQuad(unsigned int n_source_texture, CGLState *p_state);
	// draw fullscreen quad with shader bound, causing transform to compute

	int DrawFullscreenQuad(unsigned int n_source_texture, int n_tesselation, CGLState *p_state);
	// draw fullscreen quad-network with shader bound, causing transform to compute
	// n_tesselation is number of quads horizontally and vertically

protected:
	float *p_ParamVector(const char *p_s_param_name);
};

#endif //__AMI_TRANSFORM_INCLUDED

/*
 *		-end-of-file-
 */
