/*
								+---------------------------------+
								|                                 |
								|      ***   OpenGL2.0   ***      |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|             Shader.h            |
								|                                 |
								+---------------------------------+
*/

#ifndef __GL_SHADER_INCLUDED
#define __GL_SHADER_INCLUDED

/*

material {
	.
	.
	.

    shader {
		p_s_vertex_shader = "shader_name"/"NULL";
		p_s_fragment_shader = "shader_name"/"NULL";

		params { // params by mon mly bt sp v materilu ..? jo. pro kompatibilitu s low-level shaderem sm bt parametry jen float a jen do velikosti vec4f (cokoliv vtho mus nastavovat skript a jen v shaderu, kde low-level verze nen. - a mlo by tam bt napsan e low-level verze bt nesm)
			param[0] { p_s_name = "time"; p_s_value = "#t"; };
			param[1] { p_s_name = "local_time"; p_s_value = "#local_t"; };
			param[2] { p_s_name = "delta_time"; p_s_value = "#dt"; };
			param[3] { p_s_name = "constant"; f_value = 3.14; /* vec3f_value = {0.0, 3.1, 1.2}; * / };
			// f_value, vec2f_value, vec3f_value, vec4f_value

			param[4] { p_s_name = "oscillator"; p_s_value = "#osc sin 2.5 4.7 0.0 0"; }; // freq, amp, dc offset, runonce
			// vdy globln as :(

			param[5] { p_s_name = "by_script"; p_s_script = "__extern void glUniform1f(int, float); int main() { return 0; } void SetUniform(int n_location) { glUniform1f(n_location, 5.5); } "; };
			// void SetUniform(int n_location); !!! pouvat v glsl-only shaderech !!!

			param[6] { p_s_name = "sys_var"; p_s_value = "#sys f_time"; };
			// shaderu se ped pointer na promnnou, promnn mus zstat platn tak dlouho, dokud se povrch kresl!
		};
	};

	.
	.
	.
};

shadery jsou ve formtu:

enum {
    sh_lang_HighLevel = 1, // GLSL
	sh_lang_LowLevel = 0 // asm
};

enum {
	sh_type_vertex = 0,
	sh_type_fragment = 1
};

shader {
	p_s_name = "shader_name";
	n_default_lang = sh_lang_HighLevel;
	n_shader_type = sh_type_vertex;

	high_level_shader {
		// t_odo - uniforms (may contain constants / time / local time / delta time / oscillators / scripts / sys variables)

		p_param_names = {"diffuse",
						 "normalmap",
						 0 /*fixme - chci nkdy peskakovat texture unity?* /,
						 "bdrf_map"}; // !!!! jmna sampler, ne parametr, jen chci aby se to nahrvalo stejnm kdem!

		p_s_code = "void main() { ... }"; // f_ixme - budeme ukazovat na dal soubor, nebo zdrojk bude pmo tady ?? zatm bude zdrojk tady, protoe shadery by nemly obsahovat dn zludn znaky, aby nm to dalo njak velkou prci pesypat
	};

	low_level_shader { // pokud nem obsahovat low-level, mus chybt cel sekce. pokud bude nekompletn / przdn, dojde k chyb pi nahrvn
		p_param_names = {"env time 0", "env local_time 1", "env delta_time 2",
						 "local constant 0", "local oscillator 1", "local by_script 2",
						 "env sys_var 3"};
		// pojmenovn jednotlivch registr s parametry (poad = index registr)
		// tak, aby souhlasily s uniformy v glsl (podle specifikace je jich min. 32,
		// engine sice bude kontrolovat kolik jich karta zvldne, ale zkuste se do
		// 32 vdycky vejt (co by nemlo bt vbec tk))

		p_s_code = "!!arbvp1.0 ...";
	};
};

*/

enum {
	sh_lang_None = -1, // use for setting no preferred lang can't be used in material definition
	sh_lang_LowLevel = 0, // asm
	sh_lang_HighLevel = 1 // GLSL
};

enum {
	sh_type_Vertex = 0,
	sh_type_Fragment = 1
};

struct TShaderInfo {
	int n_param_num;
	char **p_param_name_array;

	char *p_s_code;

	TShaderInfo()
		:n_param_num(0),
		p_param_name_array(0),
		p_s_code(0)
	{ }

	int operator =(const TShaderInfo &r_info) // return true/false, meaning if there was enough memory
	{
		Free();

		_ASSERTE(r_info.p_s_code);
		if(!(p_s_code = new char[strlen(r_info.p_s_code) + 1]))
			return false;
		strcpy(p_s_code, r_info.p_s_code);
		// copy code

		n_param_num = r_info.n_param_num;
		if(!(p_param_name_array = new char*[r_info.n_param_num])) {
			delete[] p_s_code;
			return false;
		}
		for(int i = 0; i < r_info.n_param_num; i ++) {
			_ASSERTE(r_info.p_param_name_array);
			_ASSERTE(r_info.p_param_name_array[i]);
			if(!(p_param_name_array[i] = new char[strlen(r_info.p_param_name_array[i]) + 1])) {
				for(int j = i - 1; j >= 0; j --)
					delete[] p_param_name_array[j];
				delete[] p_param_name_array;
				delete[] p_s_code;
				return false;
			}
			strcpy(p_param_name_array[i], r_info.p_param_name_array[i]);
		}
		// copy params

		return true;
	}

	void Free()
	{
		if(p_s_code) {
			delete[] p_s_code;
			p_s_code = 0;
		}
		if(p_param_name_array) {
			for(int i = 0; i < n_param_num; i ++) {
				if(p_param_name_array[i])
					delete[] p_param_name_array[i];
			}
			delete[] p_param_name_array;
			p_param_name_array = 0;
		}
	}
};

class __declspec(dllexport) CShaderInfo {
protected:
	int m_n_id;
	char *m_p_s_name;

	static int m_n_id_space;

	int m_n_default_lang;
	int m_n_use_lang;

	int m_n_type;

	int m_b_high_level_presented;
	int m_b_low_level_presented;

	TShaderInfo m_t_low_level;
	TShaderInfo m_t_high_level;

public:
	CShaderInfo(const char *p_s_name, int n_default_lang, int n_type);
	~CShaderInfo();

	int SetHighLevel_Code(const TShaderInfo &r_code);
	int SetLowLevel_Code(const TShaderInfo &r_code);

	int n_Id() const { return m_n_id; }
	const char *p_s_Name() const { return m_p_s_name; }

	void PreferLanguage(int n_language); // ekne shaderu e by bylo dobr pout tenhle jazyk
	int n_Language() const; // vrt jazyk, se kterm se shader bude nakonec kompilovat

	int b_CanBeLinkedWith(CShaderInfo &r_shader); // vrt true, pokud je to vertex a fragment shader a pokud maj zkompilovateln stejn jazyky (oba glsl / oba asm), v ppad e kad shader m vybran jin jazyk, druh shader si ho pehod

	void Free(); // pln smae strukturu

	int n_ShaderType() const;

	int n_Sampler_Num() const;
	const char *p_s_Sampler(int n_index) const; // pstup ke jmnm sampler pro program object

	int n_Param_Num() const;
	const char *p_s_Param(int n_index) const;

	const char *p_s_Shader_Code() const;
};

enum {
	sh_param_float1,
	sh_param_float2,
	sh_param_float3,
	sh_param_float4, // konstanta
	sh_param_time, // as
	sh_param_local_time, // as v rmci existence objektu, kter se zrovna kresl
	sh_param_delta_time, // delta asu (1/FPS)
	sh_param_eye_pos, // pozice kamery
	sh_param_eye_vel, // rychlost kamery
	sh_param_eye_dir, // smr, kterm se kamera dv
	sh_param_tex_width,
	sh_param_tex_height, // rozmry textury (s parametrem)
	sh_param_texel_width,
	sh_param_texel_height, // rozmry pixelu v souadnicch textury (s parametrem)
};

//extern const int n_sh_param_size[];// = {1, 2, 3, 4, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 2, 3, 4, 1, 2, 3, 4, 4};

enum {
	shader_param_Uniform, // ARB_*_shader unifrom
	shader_param_Parameter_Env, // ARB_*_program env param
	shader_param_Parameter_Local_VP, // ARB_vertex_program local param
	shader_param_Parameter_Local_FP // ARB_fragment_program local param
};

struct TGLShaderParam {
	char *p_s_name;
	int n_type;
	int b_skip; // pointer f_value ukazuje na hodnoty pedchozho parametru
	TGLShaderParam *p_previous;

	int n_gl_location; // index of register on gpu, param is located in
	int n_gl_type; // param type (shader_param_*)

	float *f_value; // sem se ulo hodnota, kter se m nastavit
	int n_size;

	TGLShaderParam();
	void Free();
};

class __declspec(dllexport) CGLProgram {
protected:
	const char *m_p_s_vertex_shader;
	const char *m_p_s_fragment_shader;

	static CGLProgram *m_p_bound_program;

public:
	CGLProgram(const char *p_s_vertex_shader, const char *p_s_fragment_shader)
		:m_p_s_vertex_shader(p_s_vertex_shader),
		m_p_s_fragment_shader(p_s_fragment_shader)
	{ }
	~CGLProgram() { if(m_p_bound_program == this) m_p_bound_program = 0; }

	virtual int Compile(char *&p_s_info_log) = 0;
	virtual int SetParam4fv(int n_param_type, int n_location, const float *p_value) = 0;
	virtual void Bind()
	{
		if(m_p_bound_program && m_p_bound_program->n_Api() != n_Api())
			m_p_bound_program->UnBind();
		m_p_bound_program = this;
	}

	virtual void UnBind()
	{
		if(m_p_bound_program && m_p_bound_program != this)
			m_p_bound_program->UnBind();
		m_p_bound_program = 0;
	}

	virtual void GL_Free() = 0;
	virtual int n_Api() const = 0;
};

class __declspec(dllexport) CGLShaderUnBinder : public CGLProgram {
public:
	static void UnBind()
	{
		if(m_p_bound_program) {
			m_p_bound_program->UnBind();
			m_p_bound_program = 0;
		}
	}
};

class __declspec(dllexport) CGLShader : public CGLProgram {
public:
	CGLShader(const char *p_s_vertex_shader, const char *p_s_fragment_shader)
		:CGLProgram(p_s_vertex_shader, p_s_fragment_shader)
	{ }

	virtual int BindAttribLocation(int n_location, const char *p_s_attrib_name) = 0;
	virtual int Link(char *&p_s_info_log) = 0;
	virtual int GetUniformLocation(const char *p_s_uniform_name) const = 0;
	virtual int SetParam1fv(int n_param_type, int n_location, const float *p_value) = 0;
	virtual int SetParam2fv(int n_param_type, int n_location, const float *p_value) = 0;
	virtual int SetParam3fv(int n_param_type, int n_location, const float *p_value) = 0;

	virtual int SetParam1i(int n_location, int n_value) = 0; // texture units
};

enum {
	api_Unsupported = 0,
	api_ARB_program = 1,
	api_ARB_shader = 2,
	api_Core_shader = 4 // OpenGL20
};

class __declspec(dllexport) CGL_ARB_program : public CGLProgram {
protected:
	int m_b_compiled;
	int m_b_linked;

	unsigned int m_n_vs_object;
	unsigned int m_n_fs_object;

public:
	CGL_ARB_program(const char *p_s_vertex_shader, const char *p_s_fragment_shader);
	~CGL_ARB_program();

	virtual int Compile(char *&r_p_s_info_log);
	virtual int SetParam4fv(int n_param_type, int n_location, const float *p_value);
	virtual void Bind();
	virtual void UnBind();
	virtual void GL_Free();
	virtual int n_Api() const;
};

class __declspec(dllexport) CGL_ARB_shader : public CGLShader {
protected:
	int m_b_compiled;
	int m_b_linked;

	GLhandleARB m_n_program_object;
	GLhandleARB m_n_vs_object;
	GLhandleARB m_n_fs_object;

public:
	CGL_ARB_shader(const char *p_s_vertex_shader, const char *p_s_fragment_shader);
	~CGL_ARB_shader();

	virtual int Compile(char *&r_p_s_info_log);
	virtual int BindAttribLocation(int n_location, const char *p_s_attrib_name);
	virtual int Link(char *&r_p_s_info_log);
	virtual int GetUniformLocation(const char *p_s_uniform_name) const;
	virtual int SetParam1fv(int n_param_type, int n_location, const float *p_value);
	virtual int SetParam2fv(int n_param_type, int n_location, const float *p_value);
	virtual int SetParam3fv(int n_param_type, int n_location, const float *p_value);
	virtual int SetParam4fv(int n_param_type, int n_location, const float *p_value);
	virtual int SetParam1i(int n_location, int n_value);
	virtual void Bind();
	virtual void UnBind();
	virtual void GL_Free();
	virtual int n_Api() const;
};

class __declspec(dllexport) CGL_Core_shader : public CGLShader {
protected:
	int m_b_compiled;
	int m_b_linked;

	unsigned int m_n_program_object;
	unsigned int m_n_vs_object;
	unsigned int m_n_fs_object;

public:
	CGL_Core_shader(const char *p_s_vertex_shader, const char *p_s_fragment_shader);
	~CGL_Core_shader();

	virtual int Compile(char *&r_p_s_info_log);
	virtual int BindAttribLocation(int n_location, const char *p_s_attrib_name);
	virtual int Link(char *&r_p_s_info_log);
	virtual int GetUniformLocation(const char *p_s_uniform_name) const;
	virtual int SetParam1fv(int n_param_type, int n_location, const float *p_value);
	virtual int SetParam2fv(int n_param_type, int n_location, const float *p_value);
	virtual int SetParam3fv(int n_param_type, int n_location, const float *p_value);
	virtual int SetParam4fv(int n_param_type, int n_location, const float *p_value);
	virtual int SetParam1i(int n_location, int n_value);
	virtual void Bind();
	virtual void UnBind();
	virtual void GL_Free();
	virtual int n_Api() const;
};
// available shader interfaces ...
// note that low-level language doesn't have vertex attrib binding and uniform locations
// (both is hard-coded in program source)

struct TSamplerLoc {
	const char *p_s_sampler_name;
	unsigned int n_sampler_location;
};

class __declspec(dllexport) CGLProgramObject {
protected:
	int m_n_id;

	static int m_n_id_space;

	CShaderInfo *m_p_vertex_shader_info;
	CShaderInfo *m_p_fragment_shader_info;

	CGLProgram *m_p_shader;

	int m_b_ready;

	std::vector<TSamplerLoc> m_sampler_list; // (samplers are glsl only)

	int m_n_reference_num;

#ifdef _DEBUG
	std::vector<int> m_referencer_id_list;
#endif

	int m_n_preferred_shading_lang;

public:
	CGLProgramObject();
	~CGLProgramObject();

	int BindShaders(CShaderInfo *p_vertex_shader, CShaderInfo *p_s_fragment_shader);
	const char *p_s_VertexShader_Name();
	const char *p_s_FragmentShader_Name();

	int AddReference(int n_referencer_id);
	int RemoveReference(int n_referencer_id);
	int n_ReferenceCounter();

	void PreferLang(int b_high_level);
	int b_HaveCompatibleShaders();
	int n_PreferredLang();

	int CompileGLShaders(char *&r_p_s_compile_log);
	int LinkGLShaders(char *&r_p_s_link_log);
	// logs have to be freed! (check for 0 in case of low memory)

	int ResolveUniforms();
	int FindParams(TGLShaderParam *p_param, int n_param_num);
	// find uniform variables & samplers

	int b_Ready() { return m_b_ready; }

	void FreeGLShaders();
	void Free(); // call FreeGLShaders()

	int BindGL(); // nastav shader jako aktivn ...
	int n_UsedApi(); // vrt pouit typ api
	int ReleaseGL(); // uvoln shader ... (pouvat pokud se pepn mezi shadery s rozdlnm api)

	int SetGLShaderParams(const TGLShaderParam *p_param, int n_param_num); // nastav parametry shaderu

	int n_Id() const { return m_n_id; }

protected:
};

#endif //__GL_SHADER_INCLUDED

/*
 *		-end-of-file-
 */
