/*
								+---------------------------------+
								|                                 |
								|   ***   Rendering paths   ***   |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|          RenderPath.h           |
								|                                 |
								+---------------------------------+
*/

#ifndef __RENDERING_PATH_SYSTEM_INCLUDED
#define __RENDERING_PATH_SYSTEM_INCLUDED

class __declspec(dllexport) CWildcatStringComparer {
protected:
	static int strincmp(const char *p_s_str_a, const char *p_s_str_b, int n_len);
	static const char *strinstr(const char *p_s_str, const char *p_s_substr, int n_substr_len);
	static const char *stristr(const char *p_s_str, const char *p_s_substr);

public:
	static int b_wildcat_stricmp(const char *p_s_wildcat, const char *p_s_str);
};
// wildcat string comparer

struct __declspec(dllexport) TPath {
	std::vector<char*> *p_extension_list;
	std::vector<char*> *p_vendor_list;
	std::vector<char*> *p_card_list;
	char *p_s_path_name;

	TPath();
	int Create(const char *p_s_name, const char *p_s_extensions,
		const char *p_s_vendors, const char *p_s_models);
	int b_IsSupportedByHW() const;
	int b_HasCorrectVendor(int b_exact) const; // pokud je b_exact true, ignoruje hvzdiku
	int b_IsCorrectModel() const; // karty jsou ve formtu "[+/-]card name" ("\"+GeForce 6800 GT\"")
	int b_IsIncorrectModel() const; // karty jsou ve formtu "[+/-]card name" ("\"-GeForce 6800 GT\"")
	void Free();

	// pass is 0 or 1, in pass 0 only paths with exact vendor validates,
	// in pass 1 paths with vendor "*" = any validates
	int b_ValidPath(int n_pass);

	const char *p_s_ScanString(const char *p_s_str, char *p_s_dest_buffer);
	std::vector<char*> *p_ParseStrList(const char *p_s_list);
};
// rendering path

#endif //__RENDERING_PATH_SYSTEM_INCLUDED

/*
 *		-end-of-file-
 */
