/*
								+---------------------------------+
								|                                 |
								|      ***   OpenGlDrv   ***      |
								|                                 |
								|  Copyright   -tHE SWINe- 2002  |
								|                                 |
								|          OpenGlDrv.cpp          |
								|                                 |
								+---------------------------------+
*/

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <GL/gl.h>

#include "OpenGlDrv.h"

#include <vector>
#include "callstack.h"

COpenGL_Driver::COpenGL_Driver()
	:m_b_status(false)
{
	__FuncGuard("COpenGL_Driver::COpenGL_Driver");
}

COpenGL_Driver::~COpenGL_Driver()
{
	__FuncGuard("COpenGL_Driver::~COpenGL_Driver");

    if(m_b_status)
        Terminate();
}

// vytvori gl kontext pro nase okno
int COpenGL_Driver::Init(HWND m_h_wnd, int n_New_Width, int n_New_Height, int n_Bpp, int n_DepthBpp, int n_StencilBpp, int b_Fullscreen)
{
	__FuncGuard("COpenGL_Driver::Init");

    PIXELFORMATDESCRIPTOR pixelformat;
    DEVMODE dmScreenSettings;
    GLuint PixelFormat;

    Terminate();

    if(b_Fullscreen) {
        memset(&dmScreenSettings, 0, sizeof(dmScreenSettings));
        dmScreenSettings.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
        dmScreenSettings.dmSize = sizeof(dmScreenSettings);
        dmScreenSettings.dmPelsWidth = n_New_Width;
        dmScreenSettings.dmPelsHeight = n_New_Height;
        dmScreenSettings.dmBitsPerPel = n_Bpp;
        // nastavi rozliseni (pokud fullscreen)

        if(ChangeDisplaySettings(&dmScreenSettings, 4) != DISP_CHANGE_SUCCESSFUL) {
            if(MessageBox(NULL, "Unable to set fullscreen mode.\n"
               "Use windowed mode instead?","Fullscreen", MB_YESNO | MB_ICONEXCLAMATION) == IDYES)
                m_b_fullscreen = 0;
            else
                return false;
        }
        // zkusi prepnout, pokud to nejde, zepta
        // se a pak skonci nebo zustane v okne

        ShowCursor(FALSE);
    }

    memset(&pixelformat, 0, sizeof(PIXELFORMATDESCRIPTOR));
    pixelformat.nSize = sizeof(PIXELFORMATDESCRIPTOR);
    pixelformat.nVersion = 1;
    pixelformat.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
    pixelformat.dwLayerMask = PFD_MAIN_PLANE;
    pixelformat.iPixelType = PFD_TYPE_RGBA;
    pixelformat.cColorBits = n_Bpp;
    pixelformat.cDepthBits = n_DepthBpp;
    pixelformat.cAccumBits = 0;
    pixelformat.cStencilBits = n_StencilBpp;
    // nastavi pixel format descriptor

    if(!(m_h_dc = GetDC(m_h_wnd))) {
        MessageBox(NULL, "Unable to create a GL device context.", "GL_Drv", MB_OK);
        return false;
    }
    if(!(PixelFormat = ChoosePixelFormat(m_h_dc, &pixelformat))) {
        MessageBox(NULL, "Unable to find a suitable pixelformat.", "GL_Drv", MB_OK);
        return false;
    }
    if(!SetPixelFormat(m_h_dc, PixelFormat, &pixelformat)) {
        MessageBox(NULL, "Unable to set the pixelformat.", "GL_Drv", MB_OK);
        return false;
    }
    if(!(m_h_glrc = wglCreateContext(m_h_dc))) {
        MessageBox(NULL, "Unable to create a GL rendering context.", "GL_Drv", MB_OK);
        return false;
    }
    if(!wglMakeCurrent(m_h_dc, m_h_glrc)) {
        MessageBox(NULL, "Unable to activate the GL rendering context.", "GL_Drv", MB_OK);
        return false;
    }
    // vytvori OpenGl kontext

    glViewport(0, 0, n_New_Width, n_New_Height);
    // nastavi nase okno

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    //gluPerspective(90, (GLfloat)n_New_Width / (GLfloat)n_New_Height, 0.5, 900);
    // nastvi projekci

    m_n_width = n_New_Width;
    m_n_height = n_New_Height;
    m_b_status = true;
    m_b_fullscreen = b_Fullscreen;
    // nastavi class

	glDepthFunc(GL_LEQUAL);
	glCullFace(GL_FRONT);
	glEnable(GL_CULL_FACE);
	glEnable(GL_DEPTH_TEST);
	glShadeModel(GL_FLAT);
	glMatrixMode(GL_PROJECTION);
	glEnable(GL_TEXTURE_2D);
	// set rules

    return true;
}

// ukonci praci s gl
int COpenGL_Driver::Terminate()
{
	__FuncGuard("COpenGL_Driver::Terminate");

	if(!m_b_status)
		return true;

    int n_result = true;

    m_b_status = false;

    if(m_b_fullscreen) {
        ChangeDisplaySettings(NULL, 0);
        ShowCursor(TRUE);
    }
    // pokud bylo fullscreen, vrati zpatky

    if(m_h_glrc) {
        if(!wglMakeCurrent(NULL, NULL)) {
            MessageBox(NULL, "Release of DC and RC failed.", "GL_Drv", MB_OK);
            n_result = false;
        }
        if(!wglDeleteContext(m_h_glrc)) {
            MessageBox(NULL, "Release rendering context failed.", "GL_Drv", MB_OK);
            m_h_glrc = NULL;
            n_result = false;
        }
    }

    if(m_h_dc && !ReleaseDC(m_h_wnd, m_h_dc)) {
        m_h_dc = NULL;
        n_result = false;
    }

    return n_result;
}

// ukonci kresleni, zobrazi vysledek
void COpenGL_Driver::PageFlip() const
{
	__FuncGuard("COpenGL_Driver::Blit");

    glFlush();
    glFinish();
    SwapBuffers(m_h_dc);
}

void COpenGL_Driver::Context_SetCurrent() const
{
	if(m_h_dc != wglGetCurrentDC() || m_h_glrc != wglGetCurrentContext())
		wglMakeCurrent(m_h_dc, m_h_glrc);
	// switch to current context if necessary
}

/*
 *		-end-of-file-
 */
