/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*     Image.h - Image Functions - Windows version (c) 1998-2002 PEZIK      */
/*                                                                          */
/*                                                                          */
/****************************************************************************/

#ifndef _IMAGE
#define _IMAGE

typedef unsigned char Image8Value;
typedef short Image16Value;
typedef long Image32Value;
typedef float ImageFloatValue;
typedef unsigned char ImageRGBValue;
typedef unsigned long ImageRGBValueRGB;
typedef struct { float Re; float Im; } ImageComplexValue;

typedef struct ImageStruct {
  unsigned char * Raster;
  char * Info;
  void * BinInfo;
  int BinInfoSize;
  void *ExtraInfo;
  int XSize;
  int YSize;
  int XOffset;
  int YOffset;
  int InfoSize;
  short PixelType;
  short ImageType;
  int References;
  union {
    struct {
      void (* Free)(void *);
    } Regular;
    struct {
      void (* Free)(void *);
      struct ImageStruct * Referenced;
    } Reference;
    struct {
      void (* Free)(void *);
      void (* FreeData)(void *);
      void * Data;
    } External;
  } Optional;
} ImageStruct;

/* Pixel Type Definitions */

#define Image8                 ((short)(0x0010|sizeof(Image8Value)))
#define Image8Linear           ((short)(0x0030|sizeof(Image8Value)))
#define Image16                ((short)(0x0040|sizeof(Image16Value)))
#define Image16Linear          ((short)(0x00C0|sizeof(Image16Value)))
#define Image32                ((short)(0x0100|sizeof(Image32Value)))
#define Image32Linear          ((short)(0x0300|sizeof(Image32Value)))
#define ImageFloat             ((short)(0x0400|sizeof(ImageFloatValue)))
#define ImageFloatLinear       ((short)(0x0C00|sizeof(ImageFloatValue)))
#define ImageRGB               ((short)(0x1000|sizeof(ImageRGBValueRGB)))
#define ImageRGBLinear         ((short)(0x3000|sizeof(ImageRGBValueRGB)))
#define ImageComplex           ((short)(0x4000|sizeof(ImageComplexValue)))
#define ImageComplexLinear     ((short)(0xC000|sizeof(ImageComplexValue)))

#define ImageLinearMask        ((short)(0xAAA0))
#define ImageValueMask         0xF

/* Image Type Definitions */

#define RegularImage           0x01
#define ReferenceImage         0x02
#define ExternalImage          0x04
#define TempImage              0x08

/* Info Definitions */

#define DefaultInfoSize        768

#endif

