/*
								+---------------------------------+
								|                                 |
								|   ***   OGL state guard   ***   |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|            GlState.h            |
								|                                 |
								+---------------------------------+
*/

#ifndef __GLSTATE_INCLUDED
#define __GLSTATE_INCLUDED

struct __declspec(dllexport) TGLState {
	HGLRC h_glrc;
	// rendering context state is attached to

	int n_references;
	// nomber of references to this state

	unsigned char n_color[4];
	float f_color[4];
	// color

	float f_clr_color[4];
	// clear color

	float f_clr_depth;
	// clear depth

	int b_blend;
	int n_blend_func[2]; // src, dest
	// blending

	int n_front_face;
	int b_cull_face;
	int n_cull_face;
	// face culling

	int b_alpha_test;
	int n_alpha_func;
	float f_alpha_tresh;
	// alpha test

	int b_depth_test;
	int n_depth_func;
	// depth test

	int b_texture1d_enabled[32];
	int b_texture2d_enabled[32];
	int b_texture3d_enabled[32];
	int b_texture_cubemap_enabled[32];
	//
	int n_active_tex_unit;
	int n_max_texture_units;
	//
	int n_texture1d[32];
	int n_texture2d[32];
	int n_texture3d[32];
	int n_texture_cubemap[32];
	// texture units

	int n_max_lights;
	int b_lighting;
	int b_light[32];
	//
	struct {
		float f_ambient[4];
		float f_diffuse[4];
		float f_specular[4];
		float f_position[4];
		float f_spot_direction[3];
		float f_spot_exponent;
		float f_spot_cutoff;
		float f_constant_attenuation;
		float f_linear_attenuation;
		float f_quadratic_attenuation;
	} t_light_data[32];
	// lights

	int b_fog;
	int n_fog_type;
	float f_fog_color[4];
	float f_fog_density;
	float f_fog_start;
	float f_fog_end;
	// fog

	int n_shade_model;
	// shade model

	int n_polygon_mode[2];
	float f_line_width;
	float f_point_size;
	// polygon mode / line width

	int b_texgen_enabled[32][4];
	int n_texgen_mode[32][4];
	float f_texgen_eye_plane[32][4][4]; // posledn index jsou data, pedposledn je texcoord a prvn je texture unit
	float f_texgen_object_plane[32][4][4];
	// texgen

	int b_depth_write;
	int b_color_write[4];
	// write masks

	int b_polygon_offset_support;
	int b_polygon_offset;
	float f_polygon_offset_bias;
	float f_polygon_offset_factor;
	// polygon offset
};

class __declspec(dllexport) CGLState {
protected:
	static std::vector<TGLState*> *m_p_state;
	static int m_n_state_refs;
	//
	TGLState *m_p_cur_state;
	//
	int m_b_init;
	//
	HDC m_h_dc;
	HGLRC m_h_glrc;

public:
	CGLState(HDC h_dc, HGLRC h_glrc);
	~CGLState();

	void Update_States();

	HDC h_DeviceContext();
	HGLRC h_RenderingContext();

	const TGLState *p_State() { return m_p_cur_state; }

	void __fastcall Enable(int n_value);
	void __fastcall Disable(int n_value);

	void __fastcall LineWidth(float f_width);
	void __fastcall PointSize(float f_size);
	void __fastcall PolygonMode(int n_side, int n_mode);
	// raster props

	void __fastcall EnableFog();
	void __fastcall DisableFog();
	//
	void __fastcall FogMode(int n_value);
	void __fastcall FogDensity(float f_value);
	void __fastcall FogStart(float f_value);
	void __fastcall FogEnd(float f_value);
	void __fastcall FogColor(const float *p_color);
	// fog

	void __fastcall EnableLighting();
	void __fastcall DisableLighting();
	void __fastcall EnableLight(int n_light); // 0 - 8
	void __fastcall DisableLight(int n_light); // 0 - 8
	//
	void __fastcall ShadeModel(int n_model);
	//
	void __fastcall LightAmbient(int n_light, const float *p_color);
	void __fastcall LightDiffuse(int n_light, const float *p_color);
	void __fastcall LightSpecular(int n_light, const float *p_color);
	void __fastcall LightPosition(int n_light, const float *p_position);
	void __fastcall LightSpotDirection(int n_light, const float *p_direction);
	void __fastcall LightSpotExponent(int n_light, float f_value);
	void __fastcall LightSpotCutoff(int n_light, float f_value);
	void __fastcall LightConstantAttenuation(int n_light, float f_value);
	void __fastcall LightLinearAttenuation(int n_light, float f_value);
	void __fastcall LightQuadraticAttenuation(int n_light, float f_value);
	// lighting

	void __fastcall EnableBlend();
	void __fastcall DisableBlend();
	//
	void __fastcall BlendFunc(int n_src_op, int n_dest_op);
	// blending

	void __fastcall EnableDepthTest();
	void __fastcall DisableDepthTest();
	//
	void __fastcall DepthFunc(int n_op);
	// depth test

	void __fastcall EnableAlphaTest();
	void __fastcall DisableAlphaTest();
	//
	void __fastcall AlphaFunc(int n_op, float f_tresh);
	// alpha test

	void __fastcall DisableAllTextures();
	void __fastcall DisableAllTexture1D();
	void __fastcall DisableAllTexture2D();
	void __fastcall DisableAllTexture3D();
	void __fastcall DisableAllTextureCubeMap();
	void __fastcall DisableAllTexture(int n_type);
	//
	void __fastcall EnableTexture1D();
	void __fastcall EnableTexture2D();
	void __fastcall EnableTexture3D();
	void __fastcall EnableTextureCubeMap();
	void __fastcall EnableTexture(int n_type);
	//
	void __fastcall DisableTexture1D();
	void __fastcall DisableTexture2D();
	void __fastcall DisableTexture3D();
	void __fastcall DisableTextureCubeMap();
	void __fastcall DisableTexture(int n_type);
	//
	void __fastcall ActiveTextureUnit(int n_unit); // 0 - 31
	int __fastcall n_TexUnit_Num();
	//
	void __fastcall BindTexture1D(int n_texture);
	void __fastcall BindTexture2D(int n_texture);
	void __fastcall BindTexture3D(int n_texture);
	void __fastcall BindTextureCubeMap(int n_texture);
	void __fastcall BindTexture(int n_type, int n_texture);
	// textures

	void __fastcall Color3f(float r, float g, float b);
	void __fastcall Color4f(float f, float g, float b, float a);
	//
	void __fastcall Color3b(unsigned char r, unsigned char g, unsigned char b);
	void __fastcall Color4b(unsigned char f, unsigned char g,
							unsigned char b, unsigned char a);
	// color

	void __fastcall ClearColor4f(float f, float g, float b, float a);
	void __fastcall ClearDepth(float d);
	// clear attribs

	void __fastcall EnableCullFace();
	void __fastcall DisableCullFace();
	//
	void __fastcall CullFace(int n_mode);
	void __fastcall FrontFace(int n_mode);
	// cull face

	void __fastcall Enable_STRQ_TexGen();
	void __fastcall Disable_STRQ_Texgen();
	//
	void __fastcall Enable_S_TexGen();
	void __fastcall Enable_T_TexGen();
	void __fastcall Enable_R_TexGen();
	void __fastcall Enable_Q_TexGen();
	void __fastcall Disable_S_TexGen();
	void __fastcall Disable_T_TexGen();
	void __fastcall Disable_R_TexGen();
	void __fastcall Disable_Q_TexGen();
	//
	void __fastcall Enable_ST_TexGen();
	void __fastcall Disable_ST_TexGen();
	void __fastcall Enable_STR_TexGen();
	void __fastcall Disable_STR_TexGen();
	void __fastcall EnableTexGen(int n_coord); // 0 = S, 1 = T, 2 = R, 3 = Q
	void __fastcall DisableTexGen(int n_coord); // 0 = S, 1 = T, 2 = R, 3 = Q
	//
	void __fastcall TexGen_STRQ_fv(int n_name, float *p_param); // name must be one of object plane or eye plane
	void __fastcall TexGen_STR_fv(int n_name, float *p_param); // name must be one of object plane or eye plane
	void __fastcall TexGen_S_fv(int n_name, float *p_param); // name must be one of object plane or eye plane
	void __fastcall TexGen_T_fv(int n_name, float *p_param); // name must be one of object plane or eye plane
	void __fastcall TexGen_R_fv(int n_name, float *p_param); // name must be one of object plane or eye plane
	void __fastcall TexGen_Q_fv(int n_name, float *p_param); // name must be one of object plane or eye plane
	void __fastcall TexGen_ST_fv(int n_name, float *p_param); // name must be one of object plane or eye plane
	void __fastcall TexGenfv(int n_coord, int n_name, float *p_param); // name must be one of object plane or eye plane
	//
	void __fastcall TexGen_STRQ_Mode(int n_name, int n_param);
	void __fastcall TexGen_STR_Mode(int n_name, int n_param);
	void __fastcall TexGen_S_Mode(int n_name, int n_param);
	void __fastcall TexGen_T_Mode(int n_name, int n_param);
	void __fastcall TexGen_R_Mode(int n_name, int n_param);
	void __fastcall TexGen_Q_Mode(int n_name, int n_param);
	void __fastcall TexGen_ST_Mode(int n_name, int n_param);
	void __fastcall TexGenMode(int n_coord, int n_param);
	// texture generation mode

	void __fastcall ColorMask(int b_r, int b_g, int b_b, int b_a);
	void __fastcall DepthMask(int b_d);
	// write masks

	void __fastcall EnablePolygonOffset();
	void __fastcall DisablePolygonOffset();
	void __fastcall PolygonOffset(float f_factor, float f_bias);
	// polygon offset
};

#endif //__GLSTATE_INCLUDED

/*
 *		-end-of-file-
 */
