/*
								+---------------------------------+
								|                                 |
								|   ***   Call stack guard  ***   |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|           CallStack.h           |
								|                                 |
								+---------------------------------+
*/

#ifndef __CALL_STACK_GUARD_INCLUDED
#define __CALL_STACK_GUARD_INCLUDED 

#if defined(_MSC_VER) && !defined(__MWERKS__) // msvc
#pragma warning(4:4251)
// switch-off warning c4251 ("this class needs to have dll interface to be used by other calss clients")
#endif

#define _CALL_STACK_TRACKING_FILE "call_stack_debug.txt"
//#define _TRACK_CALL_STACK
//#define _TRACK_CALL_STACK_EXITTING
// you can permanently write call stack on any function entered / exit
// (note that this would propably be a significant performance hit)

class __declspec(dllexport) CCallStackGuard {
protected:
	static std::vector<const char*> m_call_stack;

public:
	CCallStackGuard(const char *p_s_parent_function);
	~CCallStackGuard();

	static const std::vector<const char*> *p_CallStack();
	static char *p_s_CallStack(const char *p_s_separator, const char *p_s_pro = 0,
		const char *p_s_epi = 0);

	static void Assert_Win(const char *p_s_expr, int n_line, const char *p_s_file);
	static void Assert_Dos(const char *p_s_expr, int n_line, const char *p_s_file);

protected:
#ifdef _TRACK_CALL_STACK
	void file_printf(int b_over);
#endif
};

#ifdef _DONT_USE_STACK_GUARD
#define __FuncGuard(func_name)
#else
#define __FuncGuard(func_name) CCallStackGuard guard(func_name)
#endif

// write __FuncGuard("function_name"); into beginning of every your function

#ifdef _ASSERTE
#undef _ASSERTE
#endif

#ifndef _DEBUG
#define _ASSERTE(exp)
#else //_DEBUG
#ifdef _WINDOWS
#define _ASSERTE(exp)	do { if(!(exp)) CCallStackGuard::Assert_Win(#exp, __LINE__, __FILE__); } while(0)
#else //_WINDOWS
#define _ASSERTE(exp)	do { if(!(exp)) CCallStackGuard::Assert_Dos(#exp, __LINE__, __FILE__); } while(0)
#endif //_WINDOWS
#endif //_DEBUG

#endif //__CALL_STACK_GUARD_INCLUDED

/*
 *		-end-of-file-
 */
