/*
								+---------------------------------+
								|                                 |
								|   ***   Call stack guard  ***   |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|          CallStack.cpp          |
								|                                 |
								+---------------------------------+
*/

#include <windows.h>
#include <crtdbg.h>
#include <stdio.h>
#include <vector>
#include "callstack.h"

#if defined(_MSC_VER) && !defined(__MWERKS__) // msvc
#ifndef for
#define for if(0) {} else for
#endif
// msvc error with variable scoping in for loops
// (for(int i = 0; i < 10; i ++) { } if(i == 10) { } was allright in msvc)
#endif

/*
 *								=== CCallStackGuard ===
 */

std::vector<const char*> CCallStackGuard::m_call_stack;

/*
 *	CCallStackGuard::CCallStackGuard(const char *p_s_parent_function)
 *		- default constructor, insert pointer to parent function name into the list
 */
CCallStackGuard::CCallStackGuard(const char *p_s_parent_function)
{
	m_call_stack.push_back(p_s_parent_function);
	_ASSERTE(m_call_stack.size());
#ifdef _TRACK_CALL_STACK
	file_printf(false);
#endif
}

/*
 *	CCallStackGuard::~CCallStackGuard()
 *		- default destructor, remove last pointer
 */
CCallStackGuard::~CCallStackGuard()
{
#ifdef _TRACK_CALL_STACK_EXITTING
	file_printf(true);
#endif
	m_call_stack.erase(&m_call_stack.back());
}

/*
 *	const std::vector<const char*> *CCallStackGuard::p_CallStack()
 *		- return current state of call stack
 */
const std::vector<const char*> *CCallStackGuard::p_CallStack()
{
	return &m_call_stack;
}

/*
 *	char *CCallStackGuard::p_s_CallStack(const char *p_s_separator,
 *		const char *p_s_pro, const char *p_s_epi)
 *		- return null-terminated string, representing current state of call stack
 *		  with functions, separated by p_s_separator (for example use "->"),
 *		  starting with p_s_pro (can be 0) and ending with p_s_epi (can be 0)
 *		- in case there's not enough memory, return 0
 *		- returned string has to be freed
 */
char *CCallStackGuard::p_s_CallStack(const char *p_s_separator,
	const char *p_s_pro, const char *p_s_epi)
{
	int n_length = 1;
	if(p_s_pro)
		n_length += strlen(p_s_pro);
	if(p_s_epi)
		n_length += strlen(p_s_epi);
	for(int i = 0; i < m_call_stack.size(); i ++)
		n_length += strlen(m_call_stack[i]);
	n_length += (m_call_stack.size() - 1) * strlen(p_s_separator);
	// calc length

	char *p_s_call_stack;
	if(!(p_s_call_stack = new char[n_length]))
		return 0;
	*p_s_call_stack = 0;
	// alloc string and empty it

	if(p_s_pro)
		strcat(p_s_call_stack, p_s_pro);
	for(int i = 0; i < m_call_stack.size(); i ++) {
		if(i)
			strcat(p_s_call_stack, p_s_separator);
		strcat(p_s_call_stack, m_call_stack[i]);
	}
	if(p_s_epi)
		strcat(p_s_call_stack, p_s_epi);
	// concat strings ...

	return p_s_call_stack;
}

/*
 *	void CCallStackGuard::Assert_Win(const char *p_s_expr, int n_line, const char *p_s_file)
 *		- function, called when assertion failed
 *		- p_s_expr is expression that failed, n_line is line in source code expression lies on
 *		  and p_s_file is filename of source code
 *		- displays message box with description what and where happened and exits with code -1
 */
void CCallStackGuard::Assert_Win(const char *p_s_expr, int n_line, const char *p_s_file)
{
	char *p_s_str;
	char *p_s_pro;

	if(!(p_s_pro = new char[strlen("expression = '%s'\nfile = "
	   "'%s'\nline = %d\n\ncall stack:\n\n") + strlen(p_s_expr) + strlen(p_s_file) + 10]) ||
	   sprintf(p_s_pro, "expression = '%s'\nfile = '%s'\nline = %d\n\ncall stack:\n\n",
	   p_s_expr, p_s_file, n_line) == -1 || !(p_s_str = p_s_CallStack("->", p_s_pro))) {
		char p_s_msg[256];

		if(p_s_pro)
			delete[] p_s_pro;

		sprintf(p_s_msg, "not enough memory for call stack printout\n"
					     "file = '%s'\nline = %d", p_s_file, n_line);
		MessageBox(0, p_s_msg, "Assertion failed", MB_OK | MB_ICONERROR);
	} else {
		delete[] p_s_pro;
		MessageBox(0, p_s_str, "Assertion failed", MB_OK | MB_ICONERROR);
		delete[] p_s_str;
	}

	exit(-1);
}

/*
 *	void CCallStackGuard::Assert_Win(const char *p_s_expr, int n_line, const char *p_s_file)
 *		- function, called when assertion failed
 *		- p_s_expr is expression that failed, n_line is line in source code expression lies on
 *		  and p_s_file is filename of source code
 *		- creates output into stderr, describing what and where happened and exits with code -1
 */
void CCallStackGuard::Assert_Dos(const char *p_s_expr, int n_line, const char *p_s_file)
{
	char *p_s_str;
	char *p_s_pro;

	if(!(p_s_pro = new char[strlen("expression = '%s'\nfile = "
	   "'%s'\nline = %d\n\ncall stack:\n\n") + strlen(p_s_expr) + strlen(p_s_file) + 10]) ||
	   sprintf(p_s_pro, "expression = '%s'\nfile = '%s'\nline = %d\n\ncall stack:\n\n",
	   p_s_expr, p_s_file, n_line) == -1 || !(p_s_str = p_s_CallStack("->", p_s_pro))) {
		char p_s_msg[256];

		if(p_s_pro)
			delete[] p_s_pro;

		sprintf(p_s_msg, "not enough memory for call stack printout\n"
					     "file = '%s'\nline = %d", p_s_file, n_line);
		fprintf(stderr, "=== Assertion failed ===\n%s\n", p_s_msg);
	} else {
		delete[] p_s_pro;
		fprintf(stderr, "=== Assertion failed ===\n%s\n", p_s_str);
		delete[] p_s_str;
	}

	exit(-1);
}

#ifdef _TRACK_CALL_STACK
/*
 *	void CCallStackGuard::file_printf(int b_over)
 *		- write last function as single line into file _CALL_STACK_TRACKING_FILE
 *		- indent 4 spaces per recursion
 *		- empty file when called first
 */
void CCallStackGuard::file_printf(int b_over)
{
	static int m_b_first_time = true;
	FILE *p_fw = fopen(_CALL_STACK_TRACKING_FILE, (m_b_first_time)? "w" : "a");
	_ASSERTE(p_fw);
	if(p_fw) {
		m_b_first_time = false;
		for(int i = 1; i < m_call_stack.size(); i ++)
			fprintf(p_fw, "    ");
		fprintf(p_fw, (b_over)? "exitting %s\n" : "%s\n", m_call_stack.back());
		fclose(p_fw);
	}
}
#endif

/*
 *								=== ~CCallStackGuard ===
 */

/*
 *		-end-of-file-
 */
