//---------------------------------------------------------------------------
#ifndef TrackerThreadSerializedH
#define TrackerThreadSerializedH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <SyncObjs.hpp>
#include "FrameQueue.h"
#include "Image.h"
#ifdef TRACKER_DLL
#include "MountDllTracker.h"
#else
#include "tracker.h"
#endif

//---------------------------------------------------------------------------
class TTrackerThreadSerialized : public TThread {
private:
  static int Counter;

  struct TTrackerParams {
    int ID;
    int LastWidth, LastHeight;
  };

  TTrackerParams TrackerParams[PERSON_COUNT]; 
  TEvent *Event, *Done;
  AnsiString SkinModelFile, TrackerFile;

  TFrameBuffer *Buffer;
  bool Restart;
protected:
  void __fastcall Execute();
public:
  __fastcall TTrackerThreadSerialized(bool CreateSuspended);
  __fastcall ~TTrackerThreadSerialized();

  void Process(TFrameBuffer *Buffer, bool Restart);
  void SetModelFile(AnsiString SkinModelFile);
  void SetTrackerFile(AnsiString TrackerFile);
  void Wait();
};
//---------------------------------------------------------------------------
#endif
