//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "TrackerThreadSerialized.h"
#pragma package(smart_init)

//---------------------------------------------------------------------------
//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:
//
//      void __fastcall TTrackerThread::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
int TTrackerThreadSerialized::Counter = 0;

//---------------------------------------------------------------------------
__fastcall TTrackerThreadSerialized::TTrackerThreadSerialized(bool CreateSuspended)
  : TThread(CreateSuspended)
{
  Event = new TEvent(NULL, false, false, "");
  Done = new TEvent(NULL, true, true, "");
  for (int i = 0; i < PERSON_COUNT; i++) {
    TrackerParams[i].ID = -1;
    TrackerParams[i].LastWidth = 0;
    TrackerParams[i].LastHeight = 0;
  }
#ifdef TRACKER_DLL
  if (Counter == 0)
    LoadTrackerProceduresFromDLL();
#endif
  Counter++;
}
//---------------------------------------------------------------------------
__fastcall TTrackerThreadSerialized::~TTrackerThreadSerialized() {
  delete Event;
  delete Done;
  Counter--;
#ifdef TRACKER_DLL
  if (Counter == 0)
    freeTrackerDll();
#endif
}
//---------------------------------------------------------------------------
void __fastcall TTrackerThreadSerialized::Execute() {
  while (!Terminated) {
    if (WaitForSingleObject((HANDLE)Event->Handle, 500) == WAIT_OBJECT_0) {
      for (int i = 0; i < PERSON_COUNT; i++)
        if (Buffer->Persons[i]) {
          if (TrackerParams[i].ID < 0 || Buffer->Persons[i]->XSize != TrackerParams[i].LastWidth || Buffer->Persons[i]->YSize != TrackerParams[i].LastHeight || Restart) {
            if (TrackerParams[i].ID >= 0)
              finalizeTracker(TrackerParams[i].ID);
            try {
              TrackerParams[i].ID = initTracker(Buffer->Persons[i]->XSize, Buffer->Persons[i]->YSize, SkinModelFile.c_str());
              TrackerParams[i].LastWidth = Buffer->Persons[i]->XSize;
              TrackerParams[i].LastHeight = Buffer->Persons[i]->YSize;
              loadConfiguration(TrackerParams[i].ID, TrackerFile.c_str());
            }
            catch (...) {
              TrackerParams[i].ID = -1;
            }
          }
          if (TrackerParams[i].ID >= 0)
            Buffer->TrackerObjectsCount[i] = nextImage(TrackerParams[i].ID, Buffer->Persons[i], Buffer->Time, TRACKER_OBJECT_COUNT, Buffer->TrackerObjects[i]);
        }
      Done->SetEvent();
    }
  }

  for (int i = 0; i < PERSON_COUNT; i++)
    if (TrackerParams[i].ID >= 0)
      finalizeTracker(TrackerParams[i].ID);
}
//---------------------------------------------------------------------------
void TTrackerThreadSerialized::Process(TFrameBuffer *Buffer, bool Restart) {
  WaitForSingleObject((HANDLE)Done->Handle, INFINITE);
  Done->ResetEvent();
  this->Buffer = Buffer;
  this->Restart = Restart;
  Event->SetEvent();
}
//---------------------------------------------------------------------------
void TTrackerThreadSerialized::Wait() {
  WaitForSingleObject((HANDLE)Done->Handle, INFINITE);
}

//---------------------------------------------------------------------------
void TTrackerThreadSerialized::SetModelFile(AnsiString SkinModelFile) {
  this->SkinModelFile = SkinModelFile;
}

//---------------------------------------------------------------------------
void TTrackerThreadSerialized::SetTrackerFile(AnsiString TrackerFile) {
	this->TrackerFile = TrackerFile;
}

