//---------------------------------------------------------------------------
#ifndef TrackerThreadH
#define TrackerThreadH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <SyncObjs.hpp>
#include "Image.h"
#ifdef TRACKER_DLL
#include "MountDllTracker.h"
#else
#include "tracker.h"
#endif

//---------------------------------------------------------------------------
class TTrackerThread : public TThread
{
private:
  ImageStruct *Image;
  int Time;
  static TCriticalSection *CS;
  TEvent *Event, *Done;
  int ID;
  int LastWidth, LastHeight;
  bool Restart;
  TResult *Results;
  int ResultsSize;
  int *ResultsCount;
  AnsiString SkinModelFile;
protected:
  void __fastcall Execute();
public:
  __fastcall TTrackerThread(bool CreateSuspended);
  __fastcall ~TTrackerThread();

  void Process(ImageStruct *Image, int Time, bool Restart, TResult *Results, int ResultsSize, int *ResultsCount);
  void SetModel(AnsiString SkinModelFile);
  void Wait();
};
//---------------------------------------------------------------------------
#endif
 