//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "TrackerThread.h"
#pragma package(smart_init)

//---------------------------------------------------------------------------
//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:
//
//      void __fastcall TTrackerThread::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------

TCriticalSection *TTrackerThread::CS = NULL;

__fastcall TTrackerThread::TTrackerThread(bool CreateSuspended)
  : TThread(CreateSuspended)
{
  Event = new TEvent(NULL, false, false, "");
  Done = new TEvent(NULL, true, true, "");
  ID = -1;
  Image = NULL;
  LastWidth = 0;
  LastHeight = 0;
  Results = NULL;
  ResultsSize = 0;
  if (!CS)
    CS = new TCriticalSection();
}
//---------------------------------------------------------------------------
__fastcall TTrackerThread::~TTrackerThread() {
  delete Event;
  delete Done;
}
//---------------------------------------------------------------------------
void __fastcall TTrackerThread::Execute() {
  while (!Terminated) {
    if (WaitForSingleObject((HANDLE)Event->Handle, 500) == WAIT_OBJECT_0) {
      if (ID < 0 || Image->XSize != LastWidth || Image->YSize != LastHeight || Restart) {
        CS->Enter();
        if (ID >= 0)
          finalizeTracker(ID);
        ID = initTracker(Image->XSize, Image->YSize, SkinModelFile.c_str());
        CS->Leave();
        LastWidth = Image->XSize;
        LastHeight = Image->YSize;
      }

      CS->Enter();
      try {
        *ResultsCount = nextImage(ID, Image, Time, ResultsSize, Results);
      }
      catch (...) {
        ShowMessage("!!!");
      }
      CS->Leave();

      Done->SetEvent();
    }
  }

  if (ID >= 0) {
    CS->Enter();
    finalizeTracker(ID);
    CS->Leave();
  }
}
//---------------------------------------------------------------------------
void TTrackerThread::Process(ImageStruct *Image, int Time, bool Restart, TResult *Results, int ResultsSize, int *ResultsCount) {
  WaitForSingleObject((HANDLE)Done->Handle, INFINITE);
  Done->ResetEvent();
  this->Image = Image;
  this->Time = Time;
  this->Restart = Restart;
  this->Results = Results;
  this->ResultsSize = ResultsSize;
  this->ResultsCount = ResultsCount;
  Event->SetEvent();
}
//---------------------------------------------------------------------------
void TTrackerThread::Wait() {
  WaitForSingleObject((HANDLE)Done->Handle, INFINITE);
}

//---------------------------------------------------------------------------
void TTrackerThread::SetModel(AnsiString SkinModelFile) {
  this->SkinModelFile = SkinModelFile;
}
