//---------------------------------------------------------------------------

#ifndef KLTTrackingH
#define KLTTrackingH

#include "klt\klt.h"
#include "Image.h"
#include "Vector2D.h"
#include <mem.h>




class KLTTracker{
    static const int inactiveBorder = 0;
    static const int movementReserve = 10;

    iVector2D initialSize;

    KLT_TrackingContext trackingContext;
    KLT_FeatureList featureList;

    bool interlaced;

    void prepareForInterlaced();
    void restoreFromInterlaced();

    int actualMaxFeatureCount;

    fVector2D * temporaryFeaturePositions;
public:
    KLT_PixelType * lastImage;

    KLT_PixelType * imageToTrack;

    float sumVelocity;
    fVector2D velocity;
    fVector2D acceleration;
    fVector2D position;
    int posX, posY;
    int sizeX, sizeY;
    int lostFeatures;

  /*  KLTTracker( const int _featureNumber):
        imageToTrack(0), interlaced( false), temporaryFeaturePositions(0),
        lastImage( 0), sizeX( 0), sizeY(0), posX(0), posY(0){

        sumVelocity = 0;
        trackingContext = KLTCreateTrackingContext();
        featureList = KLTCreateFeatureList( _featureNumber);
        KLTSetVerbosity( 0);
    }    */

    KLTTracker( const int _featureNumber, KLT_TrackingContext context, bool _interlaced):
        imageToTrack(0), temporaryFeaturePositions(0),
        lastImage( 0), sizeX( 0), sizeY(0), posX(0), posY(0){

        sumVelocity = 0;
        interlaced = _interlaced;

        trackingContext = context;
        
        featureList = KLTCreateFeatureList( _featureNumber);
        KLTSetVerbosity( 0);
        
    }

    int selectFeatures( ImageStruct * image, const int _posX, const int _posY, const int _sizeX, const int _sizeY);

    int reselectLostFeatures( );

    int nextImage( ImageStruct * image);

    int actualFeatureCount();

    void clearFeatures();

    fVector2D getFeatureCenter();

    KLT_FeatureList getFeatures( ){
        return featureList;
    }

    const KLT_TrackingContext getContext(){
        return trackingContext;
    }

    void resizeFeatureList( const int _featureNumber){
        KLTFreeFeatureList( featureList);
        featureList = KLTCreateFeatureList( _featureNumber);
        if( temporaryFeaturePositions){
            delete[] temporaryFeaturePositions;
        }
        temporaryFeaturePositions = new fVector2D[ featureList->nFeatures];
    }

    void getMinMax( int &minX, int &minY, int &maxX, int &maxY);

    ~KLTTracker(){
        if( lastImage){
            delete[] lastImage;
        }
        if( imageToTrack){
            delete[] imageToTrack;
        }
   //     KLTFreeTrackingContext( trackingContext);
        KLTFreeFeatureList( featureList);
    }

    void setInterlaced( ImageStruct * image, const bool _interlaced);
};
//---------------------------------------------------------------------------
#endif
