//---------------------------------------------------------------------------

#ifndef trackerH
#define trackerH
//---------------------------------------------------------------------------

#include "KLTTracking.h"
#include "skinColor.h"
#include "headDetection.h"
#include <vector>

#if BUILDING_DLL
#define DLL_API __stdcall __declspec(dllexport)
#else
#define DLL_API 
#endif


#define DRAW_TRACKER 0

struct TResult{
    TResult( int _posX, int _posY, int _sizeX, int _sizeY, float _velocityX, float _velocityY ):
       posX( _posX), posY( _posY), sizeX( _sizeX), sizeY( _sizeY), velocityX( _velocityX), velocityY( _velocityY) {};

    TResult( ):
       posX( 0), posY( 0), sizeX( 0), sizeY( 0), velocityX( 0), velocityY( 0){};

    int posX, posY, sizeX, sizeY;
    float velocityX, velocityY;
};

DLL_API void myInitCriticalSection();
DLL_API void myDeleteCriticalSection();

DLL_API int initTracker(int _sizeX, int _sizeY, const char * skinColorModelFile);

DLL_API void addTracker( int t, ImageStruct * image, int X, int Y);

DLL_API int nextImage( int t, ImageStruct *image, float imageTime, int bufferSize, TResult buffer[]);

DLL_API void drawTrackerRGB( int t, ImageStruct * image, KLTTracker * tracker);
DLL_API void setInterlaced( int t, bool interlaced);

DLL_API void finalizeTracker( int t);

DLL_API void clearAllTrackers( int t);
DLL_API void suspendAllTrackers( int t);

DLL_API void setTrackerSize( int t, int _trackerSizeX, int _trackerSizeY);
DLL_API void setParticleCount( int t, int _particleCount);
DLL_API int loadConfiguration( int t, char *);

DLL_API void setHeadSizeRatio( int tracker, float rx, float ry);
DLL_API float getHeadSizeRatioX( int tracker);
DLL_API float getHeadSizeRatioY( int tracker);
DLL_API void setMinimumComponentSizeRatio( int tracker, float ratio);
DLL_API float getMinimumComponentSizeRatio( int tracker);
DLL_API void setHeadDetectionScale( int tracker, int scale);
DLL_API int getHeadDetectionScale( int tracker );

class TTracker{
    float minimumComponentSizeRatio;
    int headDetectionScale;

    KLT_TrackingContext trackingContext;

    const static int historyLength = 10;
    
    SkinColor *skinModel;

    std::vector< float *> velocityHistory;
    std::vector< int *> lostHistory;
    std::vector<bool> workingTrackers;
    std::vector<KLTTracker *> trackers;
    std::vector<int *> trackerColor;

    int sizeX, sizeY;

    float headSizeRatioX, headSizeRatioY;
    int trackerSizeX, trackerSizeY;

    int processedImageCount;

    float trackerColorModelTresholdRatio;
    float trackerDiscardRatio;

    bool isInterlaced;

    ImageStruct * tempImage;

    float lastImageTime;

    string skinColorModelFile;

    void restoreTracker( ImageStruct * image, int trackerID, int posX, int posY);
    

public:
    bool useLearnedModelToDiscardParticles;
    bool useSkinColorModelToDiscardParticles;
    bool useBackgrounSubtraction;

    float staticTrackerTreshold;
    
    THeadDetector * headDetector;
    int particleCount;


    TTracker( KLT_TrackingContext _trackingContext, int _sizeX, int _sizeY, string skinColorModelFile);
    int loadConfiguration( string configurationFile);
    int saveConfiguration( string configurationFile);

    void addTracker( ImageStruct * image, int X, int Y);

    std::vector<TResult> nextImage( ImageStruct *image, float imageTime);

    void drawTrackerRGB( ImageStruct * image, KLTTracker * tracker);
    void setInterlaced( bool interlaced);

    ~TTracker();

    void clearAllTrackers();
    void suspendAllTrackers();
    
    void setHeadSizeRatio( float x, float y);
    float getHeadSizeRatioX();
    float getHeadSizeRatioY();

    void setMinimumComponentSizeRatio( float ratio);
    float getMinimumComponentSizeRatio( );

    void setHeadDetectionScale( int scale);
    int getHeadDetectionScale();

    void setTrackerSize( int _trackerSizeX, int _trackerSizeY);
    void setParticleCount( int _particleCount);
};



#endif
