//---------------------------------------------------------------------------

#include "tracker.h"

#include "tools.h"
#include <math.h>
#include <windows.h>
#include <map>
#include <iostream> 
#include <fstream>
//---------------------------------------------------------------------------
  
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 ) 
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}

using namespace std;

// Global variable
CRITICAL_SECTION CriticalSection; 

map< int ,TTracker *> trackers;

int trackerCount = 0;

static void enter(){
   // Request ownership of the critical section.
   // EnterCriticalSection(&CriticalSection);
}

static void leave(){
    // Release ownership of the critical section.
//    LeaveCriticalSection(&CriticalSection);
}
    
DLL_API void myInitCriticalSection(){
    //if (!InitializeCriticalSectionAndSpinCount(&CriticalSection, 50000))
      //  throw "Unable to Initialize Critical Section";
}

DLL_API void myDeleteCriticalSection(){
     // Release resources used by the critical section object.
    //DeleteCriticalSection(&CriticalSection);
}  

DLL_API int initTracker( int _sizeX, int _sizeY, const char * _skinColorModelFile){
    KLT_TrackingContext _trackingContext = KLTCreateTrackingContext();

    enter();
    int trackerID = trackerCount++;
    trackers[ trackerID] = new TTracker( _trackingContext, _sizeX, _sizeY, _skinColorModelFile);
    leave();
    return trackerID;
}

DLL_API void addTracker( int tracker, ImageStruct * image, int X, int Y){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->addTracker( image, X, Y);
}

DLL_API int nextImage( int tracker, ImageStruct *image, float imageTime, int bufferSize, TResult buffer[]){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t) {
        vector<TResult> result;
        result = t->nextImage( image, imageTime);
        for( int x = 0; x < result.size() && x < bufferSize; x++){
            buffer[x] = result[x];
        }
        return (result.size() < bufferSize) ? ( result.size()) : ( bufferSize);
    }
}

DLL_API void setInterlaced( int tracker, bool interlaced){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->setInterlaced(  interlaced);
}

DLL_API void finalizeTracker( int tracker){
    enter();
    TTracker *t = trackers[ tracker];
    if( t){
        delete t;
        trackers.erase( trackers.find( tracker));
    }

    leave();
}

DLL_API void clearAllTrackers( int tracker){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->clearAllTrackers();
}

DLL_API void suspendAllTrackers( int tracker){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->suspendAllTrackers( );
}

DLL_API void setTrackerSize( int tracker, int _trackerSizeX, int _trackerSizeY){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->setTrackerSize( _trackerSizeX, _trackerSizeY);
}

DLL_API void setParticleCount( int tracker,  int _particleCount){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->setParticleCount( _particleCount);
}

DLL_API int loadConfiguration( int tracker, char *configurationFile){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        return t->loadConfiguration( configurationFile) ;
}

void setHeadSizeRatio( int tracker, float rx, float ry){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->setHeadSizeRatio( rx, ry);
}

float getHeadSizeRatioX( int tracker){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        return t->getHeadSizeRatioX( );
}
float getHeadSizeRatioY( int tracker){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        return t->getHeadSizeRatioY( );
}

void setMinimumComponentSizeRatio( int tracker, float ratio){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->setMinimumComponentSizeRatio( ratio);
}

float getMinimumComponentSizeRatio( int tracker){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        return t->getMinimumComponentSizeRatio( );
}

void setHeadDetectionScale( int tracker, int scale){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        t->setHeadDetectionScale( scale);
}

int getHeadDetectionScale( int tracker ){
    enter();
    TTracker *t = trackers[ tracker];
    leave();
    if( t)
        return t->getHeadDetectionScale( );
}

TTracker::TTracker( KLT_TrackingContext _trackingContext, int _sizeX, int _sizeY, string _skinColorModelFile){
    skinColorModelFile = _skinColorModelFile;

    staticTrackerTreshold = 0.52;
    
    sizeX = _sizeX;
    sizeY = _sizeY;
    trackingContext = _trackingContext;
    headDetectionScale = 4;
    minimumComponentSizeRatio = 0.875;
    headSizeRatioX = 0.1;
    headSizeRatioY = 0.1;
    headDetector = new THeadDetector( sizeX, sizeY, headDetectionScale, skinColorModelFile);
    setHeadSizeRatio( headSizeRatioX, headSizeRatioY);

    trackerColorModelTresholdRatio = 1.2;
    trackerDiscardRatio = 0.45;

    //    headDetector->useImageAlphaAsSkin = true;
    skinModel = new SkinColor( skinColorModelFile);
    tempImage = NewImage8( sizeX, sizeY);
    isInterlaced = false;
    particleCount = 40;
    useLearnedModelToDiscardParticles = true;
    useSkinColorModelToDiscardParticles = false;
    useBackgrounSubtraction = false;
    processedImageCount = 0;
}

TTracker::~TTracker(){
    clearAllTrackers();

    if( headDetector){
        delete headDetector;
    }

    if( skinModel){
        delete skinModel;
        skinModel = 0;
    }
    if( tempImage){
        DeleteImage( tempImage);
    }
}


std::vector<TResult> TTracker::nextImage( ImageStruct *image, float imageTime){
    static unsigned long randomNumber;

    std::vector<TResult> result;
    if( fabs(imageTime - lastImageTime) < 0.00001)
        return result;

    float timeInterval = imageTime - lastImageTime;
    lastImageTime = imageTime;

    if( image->XSize != sizeX || image->YSize != sizeY)
        throw "Image size does not match initialization size";

    if(  headDetector){ // detekce hlav v obraze
        if( processedImageCount++ % 4 && useBackgrounSubtraction){ //obnova pozadi
         //  headDetector->update( image);
        }

        vector<iVector2D> heads;
        if( useBackgrounSubtraction){
         //   heads = headDetector->process( image);
        } else {
            heads = headDetector->process1( image); // bez background subtraction
        }

        int trackerCount = trackers.size();
        // nahodne generovani trackeru
        /*randomNumber += 7873;
        for( int x= 0; x <  1; x++){
            randomNumber += 7873;
            int sx = randomNumber % image->XSize ;
            randomNumber += 7873;
            int sy = randomNumber % image->YSize;
            heads.push_back( iVector2D( sx / 4, sy / 4));
        } */

        for( int i = 0; i < heads.size(); i++){
            int x = heads[i].x()*4;
            int y = heads[i].y()*4;

            bool found = false;
            float minimumDistance = (trackerSizeX + trackerSizeY) / 2 * 1.2;
            for( int track = 0; track < trackers.size(); track++){// hleda tracker v okoli nove nalezene hlavy
                if( workingTrackers[ track] ){
                    int sx = trackers[ track]->posX + trackers[ track]->sizeX / 2;
                    int sy = trackers[ track]->posY + trackers[ track]->sizeY / 2;
                    found = found || sqrt(pow( float(x - sx), 2) + pow( float(y - sy), 2)) < minimumDistance;
                }
            }
            if( !found){
                int id;
                found = false; //zjisteni, zda na danem miste nekdy v minulosti zmizel tracker
                int minDistance = int(minimumDistance + 10);
                for( int track = 0; track < trackers.size(); track++){
                    if( !workingTrackers[ track] ){
                        int sx = trackers[ track]->posX + trackers[ track]->sizeX / 2;
                        int sy = trackers[ track]->posY + trackers[ track]->sizeY / 2;
                        if( minDistance > sqrt(pow( float(x - sx), 2) + pow( float( y - sy), 2))){ //vyberu ten nejblizsi
                            minDistance = int( sqrt(pow( float(x - sx), 2) + pow( float( y - sy), 2)));
                            found = true;
                            id = track;
                        }
                    }
                }
                if( found){
                    restoreTracker( image, id, x, y);
                } else {
                    addTracker( image, x, y);
                }
            }
        }
    }


    RGBToIntensity( image, tempImage);

    for( int i = 0; i < trackers.size(); i++){
        if( !workingTrackers[i])
            continue;

        float lastFeatureCount = trackers[i]->actualFeatureCount();
        if( !lastFeatureCount){
            workingTrackers[i] = false;
            continue;
        }

        trackers[i]->nextImage( tempImage, timeInterval);

        if( trackers[i]->actualFeatureCount() == 0){
            workingTrackers[i] = false;
            continue;
        }
        int minX, minY, maxX, maxY;
        trackers[i]->getMinMax( minX, minY, maxX, maxY);

        minX += trackers[i]->posX;        //ruseni trackovacich oken pri opousteni obrazu
        minY += trackers[i]->posY;
        maxX += trackers[i]->posX;
        maxY += trackers[i]->posY;
        int kraj = 10;
        if( minX < kraj || minY < kraj ||
            maxX >= image->XSize - kraj ||
            maxY >= image->YSize - kraj){

            if( trackers[i]->lostFeatures / lastFeatureCount >= 0.1){
                workingTrackers[i] = false;
            }
        }

//==============================================================================
//==============================================================================
        if( useLearnedModelToDiscardParticles){
            KLT_FeatureList features = trackers[i]->getFeatures();
            for( int k = 0; k < features->nFeatures; k++){     //vyhazovani featuru, ktere nelezi na ski color trackeru
                int psX = int( trackers[i]->posX + features->feature[k]->x);
                int psY = int( trackers[i]->posY + features->feature[k]->y);
                if( psX < 2 || psX + 2 > tempImage->XSize ||
                    psY < 2 || psY + 2 >  tempImage->YSize){
                    features->feature[k]->val = -1;
                } else {
                    int r = ImageRGBLinearPixelR( image, psX, psY);
                    int g = ImageRGBLinearPixelG( image, psX, psY);
                    int b = ImageRGBLinearPixelB( image, psX, psY);
                    int R1 = (r * 256)  /(r+g+b+1);
                    int G1 = (g * 256)  /(r+g+b+1);
                    r = ImageRGBLinearPixelR( image, psX+1, psY);
                    g = ImageRGBLinearPixelG( image, psX+1, psY);
                    b = ImageRGBLinearPixelB( image, psX+1, psY);
                    int R2 = (r * 256)  /(r+g+b+1);
                    int G2 = (g * 256)  /(r+g+b+1);
                    r = ImageRGBLinearPixelR( image, psX, psY-1);
                    g = ImageRGBLinearPixelG( image, psX, psY-1);
                    b = ImageRGBLinearPixelB( image, psX, psY-1);
                    int R3 = (r * 256)  /(r+g+b+1);
                    int G3 = (g * 256)  /(r+g+b+1);
                    r = ImageRGBLinearPixelR( image, psX, psY+1);
                    g = ImageRGBLinearPixelG( image, psX, psY+1);
                    b = ImageRGBLinearPixelB( image, psX, psY+1);
                    int R4 = (r * 256)  /(r+g+b+1);
                    int G4 = (g * 256)  /(r+g+b+1);


                    if( !trackerColor[i][ R1 + (G1 << 8)] && !trackerColor[i][ R2 + (G2 << 8)]
                        && !trackerColor[i][ R3 + (G3 << 8)] && !trackerColor[i][ R4 + (G4 << 8)]){
                        features->feature[k]->val = -1;
                    }
                }
            }
        }
//==============================================================================
//==============================================================================

        if( trackers[i]->actualFeatureCount() > 0){
          /*  for( int y = 0; y < 256; y++){
                for( int x = 0; x < 256; x++){
                    ImageRGBLinearPixelR( image, x, y) = trackerColor[i][ x + (y << 8)] >> 1;
                    ImageRGBLinearPixelG( image, x, y) = trackerColor[i][ x + (y << 8)] >> 1;
                    ImageRGBLinearPixelB( image, x, y) = trackerColor[i][ x + (y << 8)] >> 1;
                }
            }    */

            int count = 0;
            int totalCount = 0;                   //trochu zlepsuje vysledky
            int px = int( trackers[i]->getFeatureCenter().x() + trackers[i]->posX);
            int py = int( trackers[i]->getFeatureCenter().y() + trackers[i]->posY);
            int sx = int( trackerSizeX * 0.75 / 2);
            int sy = int( trackerSizeY * 0.75 / 2);
            for( int x = px - sx; x <= px + sx;  x += 2){   // pocita, kolik pixelu na soucasne pozici trackeru odpovida pocatecnimu rg-color modelu
                for( int y = py - sy; y <= py + sy;  y += 2){
                    if( x >= 0 && y >= 0 && x < image->XSize && y < image->YSize){
                        int r = ImageRGBLinearPixelR( image, x, y);
                        int g = ImageRGBLinearPixelG( image, x, y);
                        int b = ImageRGBLinearPixelB( image, x, y);
                        int R = (r * 256)  /(r+g+b+1);     // vypocet normalizovane red
                        int G = (g * 256)  /(r+g+b+1);     // vypocet normalizovane green

                       /*ImageRGBLinearPixelR( image, R, G) = 255;
                        ImageRGBLinearPixelG( image, R, G) = 255;
                        ImageRGBLinearPixelB( image, R, G) = 255;*/

                        totalCount++;
                        if( trackerColor[i][ R + (G << 8)])
                            count++;
                    }
                }
            }
            if( float(count) / float( totalCount) < trackerDiscardRatio){ //zruseni trackeru, pokud se pod nim nenaleza barva jako na zacatku
                workingTrackers[i] = false;        //urcite procento plochy musi mit puvodni barvu
            }

        } else {
            workingTrackers[i] = false;        
        }



        float sumVelocity = trackers[i]->sumVelocity;
        for( int k = historyLength -1; k > 0; k--){ // posunuti fronty a suma
            velocityHistory[ i][ k] = velocityHistory[ i][ k-1];
            sumVelocity += velocityHistory[ i][k];
        }
        velocityHistory[ i][ 0] = trackers[i]->sumVelocity;
        if( sumVelocity < staticTrackerTreshold){
            workingTrackers[i] = false;
        }    

        for( int k = historyLength - 1; k > 0; k--){ // posunuti fronty a suma
            lostHistory[ i][ k] = lostHistory[ i][ k-1];
        }
        lostHistory[ i][ 0] = trackers[i]->lostFeatures;


        int sx = (minX + maxX) / 2;
        int sy = (minY + maxY) / 2;
        
        // zaznamenani trackeru do vystupu
       // result.push_back( TResult( sx, sy, int( trackerSizeX * 1.45), int( trackerSizeY * 1.45), trackers[i]->velocity.x(), trackers[i]->velocity.y()));
    }
    
    
    int spotX = sizeX / 2;
    int spotY = sizeY / 3;
    float bestDistance = 1000000;
    int best = -1;
    
    for( int i = 0; i < trackers.size(); i++){
         if( workingTrackers[i]){
             int iPosX = trackers[i]->posX + trackers[i]->sizeX / 2;
             int iPosY = trackers[i]->posY + trackers[i]->sizeY / 2;
             if( (iPosX - spotX) * (iPosX - spotX) + (iPosY - spotY) * (iPosY - spotY) < bestDistance){
                 best = i;
                 bestDistance = (iPosX - spotX) * (iPosX - spotX) + (iPosY - spotY) * (iPosY - spotY);
             }
         }
    }
    
    for( int i = 0; i < trackers.size(); i++){
         if( i != best){
             workingTrackers[i] = false;
         }
    }
    
    if( best > -1){
        int minX, minY, maxX, maxY;
        trackers[best]->getMinMax( minX, minY, maxX, maxY);
        minX += trackers[best]->posX;        
        minY += trackers[best]->posY;
        maxX += trackers[best]->posX;
        maxY += trackers[best]->posY;
        int sx = (minX + maxX) / 2;
        int sy = (minY + maxY) / 2;
    
        result.push_back( TResult( sx, sy, int( trackerSizeX * 1.45), int( trackerSizeY * 1.45), trackers[best]->velocity.x(), trackers[best]->velocity.y()));
    }
    
    
    
    
    for( unsigned int i = 0; i < trackers.size(); i++){     //vypousteni trackeru, ktere jsou prilis blizko u sebe
        for( unsigned int j = i + 1; j < trackers.size(); j++){ // vypusti se ty, u kterych je vetsi pravdepodobnost
            if( workingTrackers[i] && workingTrackers[j]){ //ze sjou stale na setejnem objektu
                int iPosX = trackers[i]->posX + trackers[i]->sizeX / 2;
                int iPosY = trackers[i]->posY + trackers[i]->sizeY / 2;
                int jPosX = trackers[j]->posX + trackers[j]->sizeX / 2;
                int jPosY = trackers[j]->posY + trackers[j]->sizeY / 2;
                if( sqrt((iPosX - jPosX) * (iPosX - jPosX) + (iPosY - jPosY) * (iPosY - jPosY)) < 40){
                    int iLost = 0;
                    int jLost = 0;
                    for( int k = 0; k < historyLength; k++){
                        iLost += lostHistory[ i][ k];
                        jLost += lostHistory[ j][ k];
                    }
                    if( iLost < jLost){
                        workingTrackers[j] = false;
                    } else {
                        workingTrackers[i] = false;
                    }
                }
            }
        }
    }

    unsigned long color = 0x00FF0000;

    for( int i = 0; i < trackers.size(); i++){
        if( !workingTrackers[i])
            continue;
            
        KLTTracker * tracker = trackers[i];

        int minX, maxX, minY, maxY;  
        tracker->getMinMax( minX, minY, maxX, maxY);

//==============================================================================
//==============================================================================
       if( useSkinColorModelToDiscardParticles){ // vyuziti skin color
            KLT_FeatureList features = tracker->getFeatures();

            skinModel->getSkinProbability( image, tempImage,
                 tracker->posX + minX - 2, tracker->posY + minY - 2,
                 tracker->posX + maxX + 2, tracker->posY + maxY + 2);

            for( int x = 0; x < features->nFeatures; x++){
                int px = tracker->posX + int(features->feature[x]->x);
                int py = tracker->posY + int(features->feature[x]->y);

                if( px < 2 || px + 2 > tempImage->XSize ||   //vyhazovani featuru, ktere nelezi na ski color
                    py < 2 || py + 2 >  tempImage->YSize){
                    features->feature[x]->val = -1;
                } else {
                     int sum = Image8LinearPixel( tempImage, tracker->posX + int(features->feature[x]->x), tracker->posY + int(features->feature[x]->y));
                     sum += Image8LinearPixel( tempImage, tracker->posX + int(features->feature[x]->x) - 1, tracker->posY + int(features->feature[x]->y));
                     sum += Image8LinearPixel( tempImage, tracker->posX + int(features->feature[x]->x) + 1, tracker->posY + int(features->feature[x]->y));
                     sum += Image8LinearPixel( tempImage, tracker->posX + int(features->feature[x]->x), tracker->posY + int(features->feature[x]->y) - 1);
                     sum += Image8LinearPixel( tempImage, tracker->posX + int(features->feature[x]->x), tracker->posY + int(features->feature[x]->y) + 1);
                     if( sum < 250){
                        features->feature[x]->val = -1;
                     }
                }
            }
        }      
//==============================================================================
//==============================================================================
        
    }
    if( DRAW_TRACKER){
        for( int i = 0; i < trackers.size(); i++){
            if( !workingTrackers[i])
                continue;
            drawTrackerRGB( image, trackers[i]);
        }
    }
    return result;
}

void TTracker::restoreTracker( ImageStruct * image, int trackerID, int posX, int posY){
    if( image->XSize != sizeX || image->YSize != sizeY){
        throw "Image size does not match initialization size";
    }

    if( trackerID < 0 || trackerID >= trackers.size()){
        throw "Tracker ID out of range";
    }

    posX -= trackerSizeX / 2;
    posY -= trackerSizeY / 2;
    
    KLTTracker * tracker = trackers[ trackerID];
    tracker->clearFeatures();
    tracker->selectFeatures( tempImage, posX, posY, trackerSizeX, trackerSizeY);

    int * colors = trackerColor[ trackerID];
    memset( colors, 0, 256*256*sizeof( int));

    int pixelCount = 0;
    int skip = 0;
    for( int y = posY + skip; y < posY + trackerSizeY - skip; y++){  // zjisteni barev pod trackerem
        for( int x = posX + skip; x < posX + trackerSizeX- skip; x++){
            if( x >= 0 && y >= 0 && x < sizeX && y < sizeY){
                pixelCount++;
                int r = ImageRGBLinearPixelR( image, x, y);
                int g = ImageRGBLinearPixelG( image, x, y);
                int b = ImageRGBLinearPixelB( image, x, y);
                int R = (r * 256)  /(r+g+b+1);
                int G = (g * 256)  /(r+g+b+1);


                int size = 3;
                for( int j = G - size; j < G + size; j++){
                    for( int i = R - size; i < R + size; i++){
                        if( i >= 0 && j >= 0 && i < 256 && j < 256){
                            colors[i + (j << 8)]++;
                        }
                    }
                }
            }
        }
    }

    int count = 0;
    int sum = 1;
    for( int y = 0; y < 256; y++){
        for( int x = 0; x < 256; x++){
            if( colors[ x + (y << 8)] > 0){
               sum += colors[ x + (y << 8)];
               count++;
            }
        }
    }
    sum /= count;
    sum = int (sum * trackerColorModelTresholdRatio);

    for( int y = 0; y < 256; y++){
        for( int x = 0; x < 256; x++){
            if( colors[ x + (y << 8)] > sum)
                colors[ x + (y << 8)] = 255;
            else
                colors[ x + (y << 8)] = 0;

        }
    }

    if( pixelCount > 100){
        for( int i = 0; i < historyLength; i++){
            velocityHistory[ trackerID][i] = 1000;
        }
        for( int i = 0; i < historyLength; i++){
            lostHistory[ trackerID][i] = 0;
        }
        workingTrackers[ trackerID] = true;
    } else {
        workingTrackers[ trackerID] = false;
    }

} 

void TTracker::addTracker( ImageStruct * image, int posX, int posY){
    if( image->XSize != sizeX || image->YSize != sizeY)
        throw "Image size does not match initialization size";  
 
    for( int i = 0; i < workingTrackers.size(); i++){
        if( !workingTrackers[i]){

            delete trackers[i];
            delete[] trackerColor[i];
            std::vector<KLTTracker *>::iterator t1 = trackers.begin() + i;
            trackers.erase( t1);
            std::vector<int *>::iterator t2 = trackerColor.begin() + i;
            trackerColor.erase( t2);
            std::vector<bool>::iterator t3 = workingTrackers.begin() + i;
            workingTrackers.erase( t3);
            
            delete[] velocityHistory[i];
            std::vector< float *>::iterator t4 = velocityHistory.begin() + i;
            velocityHistory.erase( t4);

            delete[] lostHistory[i];
            std::vector< int *>::iterator t5 = lostHistory.begin() + i;
            lostHistory.erase( t5);
            
            i--;
        }
    }

    posX -= trackerSizeX / 2;
    posY -= trackerSizeY / 2;

    KLTTracker * tracker = new KLTTracker( particleCount, trackingContext, isInterlaced);

//    RGBToIntensity( image, tempImage);

    tracker->selectFeatures( tempImage, posX, posY, trackerSizeX, trackerSizeY);


    int * colors = new int[256*256];
    memset( colors, 0, 256*256*sizeof( int));
    int pixelCount = 0;
    int skip = 2;
    for( int y = posY + skip; y < posY + trackerSizeY - skip; y++){
        for( int x = posX + skip; x < posX + trackerSizeX- skip; x++){
            if( x >= 0 && y >= 0 && x < sizeX && y < sizeY){
                pixelCount++;
                int r = ImageRGBLinearPixelR( image, x, y);
                int g = ImageRGBLinearPixelG( image, x, y);
                int b = ImageRGBLinearPixelB( image, x, y);
                int R = (r * 256)  /(r+g+b+1);
                int G = (g * 256)  /(r+g+b+1);


                int size = 3;
                for( int j = G - size; j < G + size; j++){
                    for( int i = R - size; i < R + size; i++){
                        if( i >= 0 && j >= 0 && i < 256 && j < 256){
                            colors[i + (j << 8)]++;
                        }
                    }
                }
            }
        }
    }

    int count = 0;
    int sum = 1;
    for( int y = 0; y < 256; y++){
        for( int x = 0; x < 256; x++){
            if( colors[ x + (y << 8)] > 0){
               sum += colors[ x + (y << 8)];
               count++;
            }
        }
    }
    sum /= count;

    for( int y = 0; y < 256; y++){
        for( int x = 0; x < 256; x++){
            if( colors[ x + (y << 8)] > sum)
                colors[ x + (y << 8)] = 255;
            else
                colors[ x + (y << 8)] = 0;

        }
    }

    if( pixelCount > 1){
        velocityHistory.push_back( new float[ historyLength]);
        for( int i = 0; i < historyLength; i++){
            velocityHistory[ velocityHistory.size() - 1][i] = 1000;
        }
        lostHistory.push_back( new int[ historyLength]);
        for( int i = 0; i < historyLength; i++){
            lostHistory[ lostHistory.size() - 1][i] = 0;
        }
        trackers.push_back( tracker);
        workingTrackers.push_back( true);
        trackerColor.push_back( colors);
    } else {
        delete tracker;
        delete[] colors;
    }
}

void TTracker::drawTrackerRGB( ImageStruct * image, KLTTracker * tracker){
    if( !tracker || !image)
        return;

    if( image->XSize != sizeX || image->YSize != sizeY)
        throw "Image size does not match initialization size";


    unsigned long color = 0x00FF0000;

    int minX, maxX, minY, maxY;  // vykresleni obdelniku tesne kolem featuru
    tracker->getMinMax( minX, minY, maxX, maxY);

    KLT_FeatureList features = tracker->getFeatures();

    for( int x = 0; x < tracker->sizeX; x++){ // vykresleni horizontalnich car kolem okna trackeru
        if( tracker->posX + x >= 0 &&
            tracker->posX + x <  image->XSize &&
            tracker->posY >= 0 &&
            tracker->posY + tracker->sizeY - 1 < image->YSize){
                ImageRGBLinearPixelRGB( image, tracker->posX + x, tracker->posY) = color;
                ImageRGBLinearPixelRGB( image, tracker->posX + x, tracker->posY + tracker->sizeY - 1) = color;
        }
    }
    
    for( int y = 0; y < tracker->sizeY; y++){ // vykresleni vertikalnich car kolem okna trackeru
        if( tracker->posX >= 0 &&
            tracker->posX + tracker->sizeX - 1 < image->XSize &&
            tracker->posY + y >= 0 &&
            tracker->posY + y < image->YSize) {
                ImageRGBLinearPixelRGB( image, tracker->posX, tracker->posY + y) = color;
                ImageRGBLinearPixelRGB( image, tracker->posX + tracker->sizeX - 1, tracker->posY + y ) = color;
        }
    }

    if( tracker->actualFeatureCount()){
        if( minX + tracker->posX < 0 ||  // ctverecek kolem aktivnich features
            minY + tracker->posY < 0 ||
            maxX + tracker->posX >= image->XSize ||
            maxY + tracker->posY >= image->YSize) {
                int tx = tracker->posX;
                int ty = tracker->posY;
                int sx = image->XSize;
                int sy = image->YSize;

                assert( 0);

        } else {
            for( int x = minX; x < maxX; x++){
                ImageRGBLinearPixelRGB( image, tracker->posX + x, tracker->posY + minY) = 0x0000FF00;
                ImageRGBLinearPixelRGB( image, tracker->posX + x, tracker->posY + maxY) = 0x0000FF00;
            }
            for( int y = minY; y < maxY; y++){
                ImageRGBLinearPixelRGB( image, tracker->posX + minX, tracker->posY + y) = 0x0000FF00;
                ImageRGBLinearPixelRGB( image, tracker->posX + maxX, tracker->posY + y ) = 0x0000FF00;
            }
        }


        
        for( int x = minX; x < maxX; x++){    //vykresleni odhadovane pozice
            if( tracker->posX + x + tracker->velocity.x() + tracker->acceleration.x() < image->XSize &&
                tracker->posX + x + tracker->velocity.x() + tracker->acceleration.x() >= 0 &&
                tracker->posY + minY + tracker->velocity.y() + tracker->acceleration.y() >= 0 &&
                tracker->posY + maxY + tracker->velocity.y() + tracker->acceleration.y() < image->YSize){

                    ImageRGBLinearPixelRGB( image, tracker->posX + x + int(tracker->velocity.x() + tracker->acceleration.x()), tracker->posY + minY + int(tracker->velocity.y() + tracker->acceleration.y())) = 0x000000FF;
                    ImageRGBLinearPixelRGB( image, tracker->posX + x + int(tracker->velocity.x() + tracker->acceleration.x()), tracker->posY + maxY + int(tracker->velocity.y() + tracker->acceleration.y())) = 0x000000FF;
            }
        }
        for( int y = minY; y < maxY; y++){ //vykresleni odhadovane pozice
            if( tracker->posY + y + tracker->velocity.y() + tracker->acceleration.y() < image->YSize &&
                tracker->posY + y + tracker->velocity.y() + tracker->acceleration.y() >= 0 &&
                tracker->posX + minX + tracker->velocity.x() + tracker->acceleration.x() >= 0 &&
                tracker->posX + maxX + tracker->velocity.x() + tracker->acceleration.x() < image->XSize){
                    ImageRGBLinearPixelRGB( image, tracker->posX + minX + int(tracker->velocity.x() + tracker->acceleration.x()), tracker->posY + y + int(tracker->velocity.y() + tracker->acceleration.y())) = 0x000000FF;
                    ImageRGBLinearPixelRGB( image, tracker->posX + maxX + int(tracker->velocity.x() + tracker->acceleration.x()), tracker->posY + y + int(tracker->velocity.y() + tracker->acceleration.y())) = 0x000000FF;
            }
        }
    }

    int count = 0;
    KLT_FeatureList featureList = tracker->getFeatures();
    for( int x = 0; x < featureList->nFeatures; x++){       //vykresleni castic
        if( featureList->feature[x]->val >= 0){
            ImageRGBLinearPixelRGB(
                image, int( tracker->posX + featureList->feature[x]->x), int( tracker->posY + featureList->feature[x]->y))
                    = color;
            count++;
        }
    }

    if( count > 0){
        fVector2D temp = tracker->getFeatureCenter();
        int avgX = int(temp.x() + tracker->posX);
        int avgY = int(temp.y() + tracker->posY);
        for( int y = -8; y < 8; y++){  // vykresleni prumerne pozice castic
            for( int x = -8; x < 8; x++){
                if( avgX + x >= 0 &&
                    avgX + x < image->XSize &&
                    avgY + y >= 0 &&
                    avgY + y < image->YSize){
                        ImageRGBLinearPixelRGB( image, avgX + x, avgY + y) = 0x0000FF00;
                }
            }
        }
    }
}

void TTracker::setInterlaced( bool interlaced){
    if( isInterlaced != interlaced){
        isInterlaced = interlaced;
        for( int i = 0; i < trackers.size(); i++){
            if( workingTrackers[i])
                trackers[i]->setInterlaced( tempImage, isInterlaced);
        }
    }
}

void TTracker::clearAllTrackers(){
    for( int i = 0; i < trackers.size(); i++){
        delete trackers[i];
        delete[] trackerColor[i];
    }
    trackers.clear();
    trackerColor.clear();
    workingTrackers.clear();
    for( int i = 0; i < velocityHistory.size(); i++){
        delete[] velocityHistory[i];
    }
    velocityHistory.clear();

    for( int i = 0; i < lostHistory.size(); i++){
        delete[] lostHistory[i];
    }
    lostHistory.clear();
}

void TTracker::suspendAllTrackers(){
    for( int i = 0; i < workingTrackers.size(); i++){
        workingTrackers[i] = false;
    }
}

void TTracker::setTrackerSize( int _trackerSizeX, int _trackerSizeY){
    trackerSizeX = _trackerSizeX;
    trackerSizeY = _trackerSizeY;
    headSizeRatioX = sizeX / trackerSizeX;
    headSizeRatioY = sizeY / trackerSizeY;
    headDetector->minComponentSize = int( minimumComponentSizeRatio * (trackerSizeX * trackerSizeY) / (headDetectionScale * headDetectionScale));
}

void TTracker::setParticleCount( int _particleCount){
    particleCount = _particleCount;
}

void TTracker::setHeadSizeRatio( float x, float y){
    headSizeRatioX = x;
    headSizeRatioY = y;
    trackerSizeX = int( sizeX * headSizeRatioX);
    trackerSizeY = int( sizeY * headSizeRatioY);
    headDetector->minComponentSize = int( minimumComponentSizeRatio * (trackerSizeX * trackerSizeY) / (headDetectionScale * headDetectionScale));
}

float TTracker::getHeadSizeRatioX( ){
    return headSizeRatioX;
}
float TTracker::getHeadSizeRatioY( ){
    return headSizeRatioY;
}

void TTracker::setMinimumComponentSizeRatio( float ratio){
    minimumComponentSizeRatio = ratio;
    headDetector->minComponentSize = int( minimumComponentSizeRatio * (trackerSizeX * trackerSizeY) / (headDetectionScale * headDetectionScale));
}

float TTracker::getMinimumComponentSizeRatio( ){
    return minimumComponentSizeRatio;
}

void TTracker::setHeadDetectionScale( int scale){
    if( headDetectionScale){
        delete headDetector;
    }
    headDetector = new THeadDetector( sizeX, sizeY, headDetectionScale, skinColorModelFile);
    headDetector->minComponentSize = int( minimumComponentSizeRatio * (trackerSizeX * trackerSizeY) / (headDetectionScale * headDetectionScale));
}

int TTracker::getHeadDetectionScale(){
    return headDetectionScale;
}

int TTracker::loadConfiguration( string configurationFile) {
    fstream inFile( configurationFile.data());
    if( ! inFile){
        throw "Unable to open configuration file";
    }

    while( inFile){
        string s;
        inFile >> s;
        
        
        if( s == "staticTrackerTreshold"){
            inFile >> staticTrackerTreshold;
        }

        if( s == "trackerColorModelTresholdRatio"){
            inFile >> trackerColorModelTresholdRatio;
        }

        if( s == "trackerDiscardRatio"){
            inFile >> trackerDiscardRatio;
        }

        if( s == "headSizeRatioX"){
            inFile >> headSizeRatioX;
            setHeadSizeRatio( headSizeRatioX, headSizeRatioY);
        }

        if( s == "headSizeRatioY"){
            inFile >> headSizeRatioY;
            setHeadSizeRatio( headSizeRatioX, headSizeRatioY);
        }

        if( s == "minimumComponentSizeRatio"){
            inFile >> minimumComponentSizeRatio;
            setMinimumComponentSizeRatio( minimumComponentSizeRatio);
        }

        if( s == "headDetectionScale"){
            inFile >> headDetectionScale;
            setHeadDetectionScale( headDetectionScale);
        }


        if( s == "useLearnedModelToDiscardParticles"){
            inFile >> useLearnedModelToDiscardParticles;
        }

        if( s == "useSkinColorModelToDiscardParticles"){
            inFile >> useSkinColorModelToDiscardParticles;
        }

        if( s == "particleCount"){
            inFile >> particleCount;
        }

        if( s == "interlacedVideo"){
            inFile >> isInterlaced;
        }

        if( s == "minCompactness"){
            inFile >> headDetector->minCompactness;
        }

        if( s == "minAspectRatio"){
            inFile >> headDetector->minAspectRatio;
        }

        if( s == "maxAspectRatio"){
            inFile >> headDetector->maxAspectRatio;
        }

        if( s == "skinProbabilityTreshold"){
            inFile >> headDetector->skinProbabilityTreshold;
        }

        if( s == "useBackgroundSubtraction"){
            inFile >> useBackgrounSubtraction;
        }

        if( s == "mindist"){
            inFile >> trackingContext->mindist;
        }

        if( s == "window_width"){
            inFile >> trackingContext->window_width;
        }

        if( s == "window_height"){
            inFile >> trackingContext->window_height;
        }

        if( s == "min_eigenvalue"){
            inFile >> trackingContext->min_eigenvalue;
        }

        if( s == "max_iterations"){
            inFile >> trackingContext->max_iterations;
        }

        if( s == "nSkippedPixels"){
            inFile >> trackingContext->nSkippedPixels;
        }

        if( s == "nPyramidLevels"){
            inFile >> trackingContext->nPyramidLevels;
        }

        if( s == "subsampling"){
            inFile >> trackingContext->subsampling;
        }

        if( s == "smoothBeforeSelecting"){
            inFile >> trackingContext->smoothBeforeSelecting;
        }

        if( s == "writeInternalImages"){
            inFile >> trackingContext->writeInternalImages;
        }

        if( s == "lighting_insensitive"){
            inFile >> trackingContext->lighting_insensitive;
        }

        if( s == "min_determinant"){
            inFile >> trackingContext->min_determinant;
        }

        if( s == "min_displacement"){
            inFile >> trackingContext->min_displacement;
        }

        if( s == "max_residue"){
            inFile >> trackingContext->max_residue;
        }

        if( s == "grad_sigma"){
            inFile >> trackingContext->grad_sigma;
        }

        if( s == "smooth_sigma_fact"){
            inFile >> trackingContext->smooth_sigma_fact;
        }
        
        if( s == "pyramid_sigma_fact"){
            inFile >> trackingContext->pyramid_sigma_fact;
        }
    }
    inFile.close();
}

int TTracker::saveConfiguration( string configurationFile) {

    ofstream outFile( configurationFile.data());
    if( ! outFile){
        throw "Unable to open configuration file";
    }

    outFile << "staticTrackerTreshold ";
    outFile << staticTrackerTreshold;
    outFile << endl;
    
    outFile << "minimumComponentSizeRatio ";
    outFile << minimumComponentSizeRatio;
    outFile << endl;

    outFile << "headDetectionScale ";
    outFile << headDetectionScale;
    outFile << endl;

    outFile << "headSizeRatioX ";
    outFile << headSizeRatioX;
    outFile << endl;

    outFile << "headSizeRatioY ";
    outFile << headSizeRatioY;
    outFile << endl;
    
    outFile << "useLearnedModelToDiscardParticles ";
    outFile << useLearnedModelToDiscardParticles;
    outFile << endl;
    
    outFile <<  "useSkinColorModelToDiscardParticles ";
    outFile << useSkinColorModelToDiscardParticles;
    outFile << endl;
    
    outFile <<  "particleCount ";
    outFile << particleCount;
    outFile << endl;
    
    outFile <<  "interlacedVideo ";
    outFile << isInterlaced;
    outFile << endl;
    
    outFile <<  "minCompactness ";
    outFile << headDetector->minCompactness;
    outFile << endl;
    
    outFile <<  "minAspectRatio ";
    outFile << headDetector->minAspectRatio;
    outFile << endl;
    
    outFile <<  "maxAspectRatio ";
    outFile << headDetector->maxAspectRatio;
    outFile << endl;
    
    outFile <<  "skinProbabilityTreshold ";
    outFile << headDetector->skinProbabilityTreshold;
    outFile << endl;

    outFile <<  "backgroundTreshold ";
    outFile << headDetector->bg->backgroundTreshold;
    outFile << endl;

    outFile <<  "useBackgroundSubtraction ";
    outFile << useBackgrounSubtraction;
    outFile << endl;

    outFile <<  "mindist ";
    outFile << trackingContext->mindist;
    outFile << endl;

    outFile <<  "window_width ";
    outFile << trackingContext->window_width;
    outFile << endl;

    outFile <<  "window_height ";
    outFile << trackingContext->window_height;
    outFile << endl;

    outFile <<  "min_eigenvalue ";
    outFile << trackingContext->min_eigenvalue;
    outFile << endl;

    outFile <<  "max_iterations ";
    outFile << trackingContext->max_iterations;
    outFile << endl;

    outFile <<  "nSkippedPixels ";
    outFile << trackingContext->nSkippedPixels;
    outFile << endl;

    outFile <<  "nPyramidLevels ";
    outFile << trackingContext->nPyramidLevels;
    outFile << endl;

    outFile <<  "subsampling ";
    outFile << trackingContext->subsampling;
    outFile << endl;

    outFile <<  "smoothBeforeSelecting ";
    outFile << trackingContext->smoothBeforeSelecting;
    outFile << endl;

    outFile <<  "writeInternalImages ";
    outFile << trackingContext->writeInternalImages;
    outFile << endl;

    outFile <<  "lighting_insensitive ";
    outFile << trackingContext->lighting_insensitive;
    outFile << endl;

    outFile <<  "min_determinant ";
    outFile << trackingContext->min_determinant;
    outFile << endl;

    outFile <<  "min_displacement ";
    outFile << trackingContext->min_displacement;
    outFile << endl;

    outFile <<  "max_residue ";
    outFile << trackingContext->max_residue;
    outFile << endl;

    outFile <<  "grad_sigma ";
    outFile << trackingContext->grad_sigma;
    outFile << endl;

    outFile <<  "smooth_sigma_fact ";
    outFile << trackingContext->smooth_sigma_fact;
    outFile << endl;

    outFile <<  "pyramid_sigma_fact ";
    outFile << trackingContext->pyramid_sigma_fact;
    outFile << endl;

    outFile << "trackerColorModelTresholdRatio ";
    outFile << trackerColorModelTresholdRatio;
    outFile << endl;

    outFile <<  "trackerDiscardRatio ";
    outFile << trackerDiscardRatio;
    outFile << endl;

    outFile.close();
}
